import * as React from 'react';
import * as ReactModal from 'react-modal';
import { AlignItems, ButtonIcon, ButtonIconSize, Display, FlexDirection, JustifyContent, Layout, SVGAsset } from 'twitch-core-ui';

export interface PublicProps {
    title: string;
    isOpen: boolean;
    onClose: () => void;
    styleOverrides?: { content?: {}, ovelay?: {} };
}

type Props = PublicProps;

export class CustomModal extends React.Component<Props> {
    public render() {
        return (
            <ReactModal
                closeTimeoutMS={200}
                isOpen={this.props.isOpen}
                contentLabel={'Create'}
                onRequestClose={this.props.onClose}
                ariaHideApp={false}
                style={{
                    content: {
                        maxWidth: '80rem',
                        margin: '0 auto',
                        top: '50%',
                        left: '50%',
                        right: 'auto',
                        bottom: 'auto',
                        marginRight: '-50%',
                        transform: 'translate(-50%, -50%)',
                        ...this.props.styleOverrides && this.props.styleOverrides.content,
                    },
                    overlay: {
                        backgroundColor: 'rgba(50, 50, 50, 0.7)',
                        ...this.props.styleOverrides && this.props.styleOverrides!.ovelay,
                    },
                }}
            >
                <Layout
                    margin={{ bottom: 3 }}
                    display={Display.Flex}
                    flexDirection={FlexDirection.Row}
                    alignItems={AlignItems.Center}
                    justifyContent={JustifyContent.Between}
                >
                    <h3>{this.props.title}</h3>
                    <ButtonIcon onClick={this.props.onClose} icon={SVGAsset.Close} size={ButtonIconSize.Small} aria-label={'Close'}/>
                </Layout>
                {this.props.children}
            </ReactModal>
        );
    }
}
