import * as React from 'react';
import {
  AlignItems,
  Color,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  SVG,
  SVGAsset,
  TextType,
} from 'twitch-core-ui';

export const NotFound = () => {
  return (
    <Layout
      padding={1}
      display={Display.Flex}
      alignItems={AlignItems.Center}
      flexDirection={FlexDirection.Column}
    >
      <Layout padding={1}>
        <SVG asset={SVGAsset.DeadGlitch} />
      </Layout>
      <Layout padding={1}>
        <CoreText fontSize={FontSize.Size4} color={Color.Alt2}>
          Not found
        </CoreText>
      </Layout>
      <Layout>
        <Layout padding={1} alignItems={AlignItems.Center}>
          <CoreText type={TextType.P} color={Color.Alt2}>
            The resource either doesn't exist or was removed
          </CoreText>
        </Layout>
      </Layout>
    </Layout>
  );
};
