import { DefaultRootRouter } from 'dashboard/core/components/default-root-router';
import { TopNav } from 'dashboard/core/components/top-nav';
import { BannerContextProvider } from 'dashboard/core/contexts/banners';
import {
  ModalContextProvider,
  ModalRoot,
} from 'dashboard/core/contexts/modals';
import * as React from 'react';
import {
  CoreUIRoot,
  Layout,
  ResponsiveWrapper,
} from 'twitch-core-ui';
import './main.scss';

export class Root extends React.Component {
  public render() {
    return (
      <Layout>
        <CoreUIRoot theme="light">
          <ModalContextProvider>
            <BannerContextProvider>
              <ModalRoot />
              <TopNav />
              <Layout className="page-wrapper">
                <ResponsiveWrapper centered>
                  <DefaultRootRouter />
                </ResponsiveWrapper>
              </Layout>
            </BannerContextProvider>
          </ModalContextProvider>
        </CoreUIRoot>
      </Layout>
    );
  }
}
