import { Banner } from 'dashboard/core/contexts/banners';
import { CurrentUser, useCurrentUser } from 'dashboard/core/utils/ldap';
import * as React from 'react';
import {
  AlignItems,
  Background,
  CoreLink,
  CoreLinkType,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  LoadingSpinner,
  Position,
  SVG,
  SVGAsset,
  SVGType,
  ZIndex,
} from 'twitch-core-ui';

export const TopNav = () => {
  const { user, loading, errored } = useCurrentUser();

  return (
    <Layout
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      position={Position.Fixed}
      zIndex={ZIndex.Above}
      attachTop
      attachLeft
      attachRight
      fullWidth
    >
      <Layout
        className="top-nav"
        padding={{ x: 4 }}
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
        background={Background.Accent}
        alignItems={AlignItems.Center}
      >
        <Layout padding={{ x: 1 }}>
          <SVG
            asset={SVGAsset.HypeTrain}
            height={36}
            width={36}
            type={SVGType.Inherit}
          />
        </Layout>
        <Layout padding={{ right: 4 }}>
          <CoreText fontSize={FontSize.Size4}>EventBus</CoreText>
        </Layout>
        <Layout padding={{ x: 2 }}>
          <CoreText fontSize={FontSize.Size5}>
            <CoreLink type={CoreLinkType.Inherit} linkTo="/services">
              My Services
            </CoreLink>
          </CoreText>
        </Layout>
        <Layout padding={{ x: 2 }}>
          <CoreText fontSize={FontSize.Size5}>
            <CoreLink type={CoreLinkType.Inherit} linkTo="/events">
              Event Catalog
            </CoreLink>
          </CoreText>
        </Layout>
        <Layout padding={{ x: 2 }}>
          <CoreLink
            type={CoreLinkType.Inherit}
            linkTo="https://git.xarth.tv/pages/eventbus/docs/"
          >
            <Layout
              display={Display.Flex}
              flexDirection={FlexDirection.Row}
              alignItems={AlignItems.Baseline}
            >
              <Layout>
                <CoreText fontSize={FontSize.Size5}>Docs</CoreText>
              </Layout>
              <Layout>
                <SVG
                  asset={SVGAsset.Popout}
                  type={SVGType.Inherit}
                  height={15}
                />
              </Layout>
            </Layout>
          </CoreLink>
        </Layout>
        <Layout padding={{ x: 2 }}>
          <CoreLink
            type={CoreLinkType.Inherit}
            linkTo="https://grafana.xarth.tv/d/NdIRdTmZz/eventbus-overview"
          >
            <Layout
              display={Display.Flex}
              flexDirection={FlexDirection.Row}
              alignItems={AlignItems.Baseline}
            >
              <Layout>
                <CoreText fontSize={FontSize.Size5}>Metrics</CoreText>
              </Layout>
              <Layout>
                <SVG
                  asset={SVGAsset.Popout}
                  type={SVGType.Inherit}
                  height={15}
                />
              </Layout>
            </Layout>
          </CoreLink>
        </Layout>
        <Layout padding={{ x: 2 }} flexGrow={1}>
          <CoreLink
            type={CoreLinkType.Inherit}
            linkTo="https://twitch.slack.com/app_redirect?channel=CB742918S"
          >
            <Layout
              display={Display.Flex}
              flexDirection={FlexDirection.Row}
              alignItems={AlignItems.Baseline}
            >
              <Layout>
                <CoreText fontSize={FontSize.Size5}>#event-bus</CoreText>
              </Layout>
              <Layout>
                <SVG
                  asset={SVGAsset.Popout}
                  type={SVGType.Inherit}
                  height={15}
                />
              </Layout>
            </Layout>
          </CoreLink>
        </Layout>
        <Layout>
          <UserInfo user={user} loading={loading} errored={errored} />
        </Layout>
      </Layout>
      <Layout zIndex={ZIndex.Below}>
        <Banner />
      </Layout>
    </Layout>
  );
};

const UserInfo = ({ user, loading, errored }: CurrentUser) => {
  if (loading) {
    return <LoadingSpinner inheritColor />;
  } else if (errored) {
    return (
      <Layout display={Display.Flex} flexDirection={FlexDirection.Row}>
        <Layout margin={{ x: 0.5 }}>
          <CoreText fontSize={FontSize.Size5}>Error reading user info</CoreText>
        </Layout>
        <Layout>
          <SVG asset={SVGAsset.DeadGlitch} type={SVGType.Inherit} />
        </Layout>
      </Layout>
    );
  } else {
    return <CoreText fontSize={FontSize.Size5}>Logged in as: {user}</CoreText>;
  }
};
