import { code } from 'dashboard/generated/controlplane';
import twirp = code.justin.tv.eventbus.controlplane;

import { generateJira } from './jira';

it('generates a JIRA ticket', () => {
  const event: twirp.EventStream = new twirp.EventStream({
    eventType: 'eventType',
  });
  const authorizedField: twirp.AuthorizedField = new twirp.AuthorizedField({
    messageName: 'messageName',
    fieldName: 'fieldName',
  });
  const expectedValue = 'https://jira.twitch.com/secure/CreateIssueDetails!init.jspa?pid=26238&issuetype=16603&priority=6&labels=auth-field-grant-request&summary=Authorized%20Field%20Request%20(eventType%7CProduction%7CmessageName%7CfieldName)&description=Please%20fill%20out%20the%20following%20information.%0A%0A*Service%20Information*%0A---%0A_EventBus%20Service%20ID_:%201%0A_IAM%20Role_:%20iamRole%0A%0A%0A*Authorized%20Field%20Information*%0A---%0A_Event%20Type_:%20eventType%0A_Environment_:%20Production%0A_Protobuf%20Message%20Name_:%20messageName%0A_Protobuf%20Field%20Name_:%20fieldName%0A%0A*Contact%20Information*%0A---%0A_Slack_:%0A_Point%20of%20Contact%20Person_:%0A%0A%0ABy%20submitting%20this%20issue%20to%20the%20ASYNC%20team%20for%20processing%20you%20acknowledge%20that%20you%20have%20read%20and%20understand%20the%20%5BTwitch%20Data%20Classification%20and%20Handling%20Standards%7Chttps://wiki.twitch.com/display/SEC/Twitch+Data+Handling+Standard%5D,%20and%20that%20the%20service%20involved%20in%20this%20request%20complies%20with%20those%20standards%20as%20it%20applies%20to%20the%20classification%20of%20the%20data%20being%20requested&reporter=natwilla';
  const res = generateJira('1', 'iamRole', event, 'Production', authorizedField, 'natwilla');
  expect(res).toEqual(expectedValue);
});
