import { code } from 'dashboard/generated/controlplane';
import twirp = code.justin.tv.eventbus.controlplane;

export function generateJira(
  serviceID: string,
  iamRole: string,
  event: twirp.IEventStream,
  environment: string,
  authorizedField: twirp.AuthorizedField,
  reporter: string,
) {
  const pid = 26238;
  const issueType = 16603;
  const priority = 6;
  const labels = 'auth-field-grant-request';
  const summary = `Authorized Field Request (${event.eventType}|${environment}|${authorizedField.messageName}|${authorizedField.fieldName})`;

  const description = `Please fill out the following information.

*Service Information*
---
_EventBus Service ID_: ${serviceID}
_IAM Role_: ${iamRole}


*Authorized Field Information*
---
_Event Type_: ${event.eventType}
_Environment_: ${environment}
_Protobuf Message Name_: ${authorizedField.messageName}
_Protobuf Field Name_: ${authorizedField.fieldName}

*Contact Information*
---
_Slack_:
_Point of Contact Person_:


By submitting this issue to the ASYNC team for processing you acknowledge that you have read and understand the [Twitch Data Classification and Handling Standards|https://wiki.twitch.com/display/SEC/Twitch+Data+Handling+Standard], and that the service involved in this request complies with those standards as it applies to the classification of the data being requested`;

  return encodeURI(
    `https://jira.twitch.com/secure/CreateIssueDetails!init.jspa?pid=${pid}&issuetype=${issueType}&priority=${priority}&labels=${labels}&summary=${summary}&description=${description}&reporter=${reporter}`,
  );
}
