import * as FetchMock from 'fetch-mock';

import { getCurrentUser } from './ldap';

it('gets current user', async () => {
  FetchMock.mock('/api/current-user', '"natwilla"');
  const currentUser = await getCurrentUser();
  expect(currentUser).toEqual('natwilla');

  FetchMock.restore();
});

it('uses cache', async () => {
  // The cache is set by the previous test.
  FetchMock.mock('/api/current-user', '"somebodyelse"');
  const currentUser = await getCurrentUser();
  expect(currentUser).toEqual('natwilla');
  FetchMock.restore();
});
