import * as $protobuf from "protobufjs";
/** Namespace code. */
export namespace code {

    /** Namespace justin. */
    namespace justin {

        /** Namespace tv. */
        namespace tv {

            /** Namespace eventbus. */
            namespace eventbus {

                /** Namespace controlplane. */
                namespace controlplane {

                    /** Represents an AuditLogs */
                    class AuditLogs extends $protobuf.rpc.Service {

                        /**
                         * Constructs a new AuditLogs service.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         */
                        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                        /**
                         * Creates new AuditLogs service using the specified rpc implementation.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         * @returns RPC service. Useful where requests and/or responses are streamed.
                         */
                        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): AuditLogs;

                        /**
                         * Calls GetAuditLogsForService.
                         * @param request GetAuditLogsForServiceReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and GetAuditLogsForServiceResp
                         */
                        public getAuditLogsForService(request: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq, callback: code.justin.tv.eventbus.controlplane.AuditLogs.GetAuditLogsForServiceCallback): void;

                        /**
                         * Calls GetAuditLogsForService.
                         * @param request GetAuditLogsForServiceReq message or plain object
                         * @returns Promise
                         */
                        public getAuditLogsForService(request: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq): Promise<code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp>;
                    }

                    namespace AuditLogs {

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.AuditLogs#getAuditLogsForService}.
                         * @param error Error, if any
                         * @param [response] GetAuditLogsForServiceResp
                         */
                        type GetAuditLogsForServiceCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp) => void;
                    }

                    /** Properties of a GetAuditLogsForServiceReq. */
                    interface IGetAuditLogsForServiceReq {

                        /** GetAuditLogsForServiceReq serviceId */
                        serviceId?: (string|null);
                    }

                    /** Represents a GetAuditLogsForServiceReq. */
                    class GetAuditLogsForServiceReq implements IGetAuditLogsForServiceReq {

                        /**
                         * Constructs a new GetAuditLogsForServiceReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq);

                        /** GetAuditLogsForServiceReq serviceId. */
                        public serviceId: string;

                        /**
                         * Creates a new GetAuditLogsForServiceReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetAuditLogsForServiceReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq;

                        /**
                         * Encodes the specified GetAuditLogsForServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq.verify|verify} messages.
                         * @param message GetAuditLogsForServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetAuditLogsForServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq.verify|verify} messages.
                         * @param message GetAuditLogsForServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetAuditLogsForServiceReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetAuditLogsForServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq;

                        /**
                         * Decodes a GetAuditLogsForServiceReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetAuditLogsForServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq;

                        /**
                         * Verifies a GetAuditLogsForServiceReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetAuditLogsForServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetAuditLogsForServiceReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq;

                        /**
                         * Creates a plain object from a GetAuditLogsForServiceReq message. Also converts values to other types if specified.
                         * @param message GetAuditLogsForServiceReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetAuditLogsForServiceReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an AuditLog. */
                    interface IAuditLog {

                        /** AuditLog serviceId */
                        serviceId?: (string|null);

                        /** AuditLog userName */
                        userName?: (string|null);

                        /** AuditLog resourceType */
                        resourceType?: (string|null);

                        /** AuditLog resourceName */
                        resourceName?: (string|null);

                        /** AuditLog result */
                        result?: (string|null);

                        /** AuditLog action */
                        action?: (string|null);

                        /** AuditLog timestamp */
                        timestamp?: (google.protobuf.ITimestamp|null);

                        /** AuditLog before */
                        before?: (string|null);

                        /** AuditLog after */
                        after?: (string|null);
                    }

                    /** Represents an AuditLog. */
                    class AuditLog implements IAuditLog {

                        /**
                         * Constructs a new AuditLog.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IAuditLog);

                        /** AuditLog serviceId. */
                        public serviceId: string;

                        /** AuditLog userName. */
                        public userName: string;

                        /** AuditLog resourceType. */
                        public resourceType: string;

                        /** AuditLog resourceName. */
                        public resourceName: string;

                        /** AuditLog result. */
                        public result: string;

                        /** AuditLog action. */
                        public action: string;

                        /** AuditLog timestamp. */
                        public timestamp?: (google.protobuf.ITimestamp|null);

                        /** AuditLog before. */
                        public before: string;

                        /** AuditLog after. */
                        public after: string;

                        /**
                         * Creates a new AuditLog instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns AuditLog instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IAuditLog): code.justin.tv.eventbus.controlplane.AuditLog;

                        /**
                         * Encodes the specified AuditLog message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuditLog.verify|verify} messages.
                         * @param message AuditLog message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IAuditLog, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified AuditLog message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuditLog.verify|verify} messages.
                         * @param message AuditLog message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IAuditLog, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an AuditLog message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns AuditLog
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.AuditLog;

                        /**
                         * Decodes an AuditLog message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns AuditLog
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.AuditLog;

                        /**
                         * Verifies an AuditLog message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an AuditLog message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns AuditLog
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.AuditLog;

                        /**
                         * Creates a plain object from an AuditLog message. Also converts values to other types if specified.
                         * @param message AuditLog
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.AuditLog, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this AuditLog to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetAuditLogsForServiceResp. */
                    interface IGetAuditLogsForServiceResp {

                        /** GetAuditLogsForServiceResp auditLogs */
                        auditLogs?: (code.justin.tv.eventbus.controlplane.IAuditLog[]|null);
                    }

                    /** Represents a GetAuditLogsForServiceResp. */
                    class GetAuditLogsForServiceResp implements IGetAuditLogsForServiceResp {

                        /**
                         * Constructs a new GetAuditLogsForServiceResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp);

                        /** GetAuditLogsForServiceResp auditLogs. */
                        public auditLogs: code.justin.tv.eventbus.controlplane.IAuditLog[];

                        /**
                         * Creates a new GetAuditLogsForServiceResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetAuditLogsForServiceResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp;

                        /**
                         * Encodes the specified GetAuditLogsForServiceResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp.verify|verify} messages.
                         * @param message GetAuditLogsForServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetAuditLogsForServiceResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp.verify|verify} messages.
                         * @param message GetAuditLogsForServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetAuditLogsForServiceResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetAuditLogsForServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp;

                        /**
                         * Decodes a GetAuditLogsForServiceResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetAuditLogsForServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp;

                        /**
                         * Verifies a GetAuditLogsForServiceResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetAuditLogsForServiceResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetAuditLogsForServiceResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp;

                        /**
                         * Creates a plain object from a GetAuditLogsForServiceResp message. Also converts values to other types if specified.
                         * @param message GetAuditLogsForServiceResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetAuditLogsForServiceResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Represents an EventStreams */
                    class EventStreams extends $protobuf.rpc.Service {

                        /**
                         * Constructs a new EventStreams service.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         */
                        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                        /**
                         * Creates new EventStreams service using the specified rpc implementation.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         * @returns RPC service. Useful where requests and/or responses are streamed.
                         */
                        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): EventStreams;

                        /**
                         * Calls List.
                         * @param request ListEventStreamsReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ListEventStreamsResp
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListEventStreamsReq, callback: code.justin.tv.eventbus.controlplane.EventStreams.ListCallback): void;

                        /**
                         * Calls List.
                         * @param request ListEventStreamsReq message or plain object
                         * @returns Promise
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListEventStreamsReq): Promise<code.justin.tv.eventbus.controlplane.ListEventStreamsResp>;

                        /**
                         * Calls Get.
                         * @param request GetEventStreamReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and EventStream
                         */
                        public get(request: code.justin.tv.eventbus.controlplane.IGetEventStreamReq, callback: code.justin.tv.eventbus.controlplane.EventStreams.GetCallback): void;

                        /**
                         * Calls Get.
                         * @param request GetEventStreamReq message or plain object
                         * @returns Promise
                         */
                        public get(request: code.justin.tv.eventbus.controlplane.IGetEventStreamReq): Promise<code.justin.tv.eventbus.controlplane.EventStream>;

                        /**
                         * Calls GetStats.
                         * @param request GetEventStreamStatsReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and EventStreamStats
                         */
                        public getStats(request: code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq, callback: code.justin.tv.eventbus.controlplane.EventStreams.GetStatsCallback): void;

                        /**
                         * Calls GetStats.
                         * @param request GetEventStreamStatsReq message or plain object
                         * @returns Promise
                         */
                        public getStats(request: code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq): Promise<code.justin.tv.eventbus.controlplane.EventStreamStats>;
                    }

                    namespace EventStreams {

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventStreams#list}.
                         * @param error Error, if any
                         * @param [response] ListEventStreamsResp
                         */
                        type ListCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ListEventStreamsResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventStreams#get}.
                         * @param error Error, if any
                         * @param [response] EventStream
                         */
                        type GetCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.EventStream) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventStreams#getStats}.
                         * @param error Error, if any
                         * @param [response] EventStreamStats
                         */
                        type GetStatsCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.EventStreamStats) => void;
                    }

                    /** Represents an EventTypes */
                    class EventTypes extends $protobuf.rpc.Service {

                        /**
                         * Constructs a new EventTypes service.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         */
                        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                        /**
                         * Creates new EventTypes service using the specified rpc implementation.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         * @returns RPC service. Useful where requests and/or responses are streamed.
                         */
                        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): EventTypes;

                        /**
                         * Calls List.
                         * @param request ListEventTypesReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ListEventTypesResp
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListEventTypesReq, callback: code.justin.tv.eventbus.controlplane.EventTypes.ListCallback): void;

                        /**
                         * Calls List.
                         * @param request ListEventTypesReq message or plain object
                         * @returns Promise
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListEventTypesReq): Promise<code.justin.tv.eventbus.controlplane.ListEventTypesResp>;

                        /**
                         * Calls ListAuthorizedFieldSubscriberGrantsByEventType.
                         * @param request ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         */
                        public listAuthorizedFieldSubscriberGrantsByEventType(request: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq, callback: code.justin.tv.eventbus.controlplane.EventTypes.ListAuthorizedFieldSubscriberGrantsByEventTypeCallback): void;

                        /**
                         * Calls ListAuthorizedFieldSubscriberGrantsByEventType.
                         * @param request ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object
                         * @returns Promise
                         */
                        public listAuthorizedFieldSubscriberGrantsByEventType(request: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq): Promise<code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp>;

                        /**
                         * Calls ListAuthorizedFieldPublisherGrantsByEventType.
                         * @param request ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         */
                        public listAuthorizedFieldPublisherGrantsByEventType(request: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq, callback: code.justin.tv.eventbus.controlplane.EventTypes.ListAuthorizedFieldPublisherGrantsByEventTypeCallback): void;

                        /**
                         * Calls ListAuthorizedFieldPublisherGrantsByEventType.
                         * @param request ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object
                         * @returns Promise
                         */
                        public listAuthorizedFieldPublisherGrantsByEventType(request: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq): Promise<code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp>;
                    }

                    namespace EventTypes {

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventTypes#list}.
                         * @param error Error, if any
                         * @param [response] ListEventTypesResp
                         */
                        type ListCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ListEventTypesResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventTypes#listAuthorizedFieldSubscriberGrantsByEventType}.
                         * @param error Error, if any
                         * @param [response] ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         */
                        type ListAuthorizedFieldSubscriberGrantsByEventTypeCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventTypes#listAuthorizedFieldPublisherGrantsByEventType}.
                         * @param error Error, if any
                         * @param [response] ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         */
                        type ListAuthorizedFieldPublisherGrantsByEventTypeCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp) => void;
                    }

                    /** Properties of a ListAuthorizedFieldSubscriberGrantsByEventTypeReq. */
                    interface IListAuthorizedFieldSubscriberGrantsByEventTypeReq {

                        /** ListAuthorizedFieldSubscriberGrantsByEventTypeReq eventTypeName */
                        eventTypeName?: (string|null);
                    }

                    /** Represents a ListAuthorizedFieldSubscriberGrantsByEventTypeReq. */
                    class ListAuthorizedFieldSubscriberGrantsByEventTypeReq implements IListAuthorizedFieldSubscriberGrantsByEventTypeReq {

                        /**
                         * Constructs a new ListAuthorizedFieldSubscriberGrantsByEventTypeReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq);

                        /** ListAuthorizedFieldSubscriberGrantsByEventTypeReq eventTypeName. */
                        public eventTypeName: string;

                        /**
                         * Creates a new ListAuthorizedFieldSubscriberGrantsByEventTypeReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq;

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq.verify|verify} messages.
                         * @param message ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq.verify|verify} messages.
                         * @param message ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq;

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq;

                        /**
                         * Verifies a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq;

                        /**
                         * Creates a plain object from a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message. Also converts values to other types if specified.
                         * @param message ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListAuthorizedFieldSubscriberGrantsByEventTypeReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListAuthorizedFieldSubscriberGrantsByEventTypeResp. */
                    interface IListAuthorizedFieldSubscriberGrantsByEventTypeResp {

                        /** ListAuthorizedFieldSubscriberGrantsByEventTypeResp grants */
                        grants?: (code.justin.tv.eventbus.controlplane.IGrant[]|null);
                    }

                    /** Represents a ListAuthorizedFieldSubscriberGrantsByEventTypeResp. */
                    class ListAuthorizedFieldSubscriberGrantsByEventTypeResp implements IListAuthorizedFieldSubscriberGrantsByEventTypeResp {

                        /**
                         * Constructs a new ListAuthorizedFieldSubscriberGrantsByEventTypeResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp);

                        /** ListAuthorizedFieldSubscriberGrantsByEventTypeResp grants. */
                        public grants: code.justin.tv.eventbus.controlplane.IGrant[];

                        /**
                         * Creates a new ListAuthorizedFieldSubscriberGrantsByEventTypeResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp;

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp.verify|verify} messages.
                         * @param message ListAuthorizedFieldSubscriberGrantsByEventTypeResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp.verify|verify} messages.
                         * @param message ListAuthorizedFieldSubscriberGrantsByEventTypeResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp;

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp;

                        /**
                         * Verifies a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp;

                        /**
                         * Creates a plain object from a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message. Also converts values to other types if specified.
                         * @param message ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListAuthorizedFieldSubscriberGrantsByEventTypeResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListAuthorizedFieldPublisherGrantsByEventTypeReq. */
                    interface IListAuthorizedFieldPublisherGrantsByEventTypeReq {

                        /** ListAuthorizedFieldPublisherGrantsByEventTypeReq eventTypeName */
                        eventTypeName?: (string|null);
                    }

                    /** Represents a ListAuthorizedFieldPublisherGrantsByEventTypeReq. */
                    class ListAuthorizedFieldPublisherGrantsByEventTypeReq implements IListAuthorizedFieldPublisherGrantsByEventTypeReq {

                        /**
                         * Constructs a new ListAuthorizedFieldPublisherGrantsByEventTypeReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq);

                        /** ListAuthorizedFieldPublisherGrantsByEventTypeReq eventTypeName. */
                        public eventTypeName: string;

                        /**
                         * Creates a new ListAuthorizedFieldPublisherGrantsByEventTypeReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq;

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq.verify|verify} messages.
                         * @param message ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq.verify|verify} messages.
                         * @param message ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq;

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq;

                        /**
                         * Verifies a ListAuthorizedFieldPublisherGrantsByEventTypeReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListAuthorizedFieldPublisherGrantsByEventTypeReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq;

                        /**
                         * Creates a plain object from a ListAuthorizedFieldPublisherGrantsByEventTypeReq message. Also converts values to other types if specified.
                         * @param message ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListAuthorizedFieldPublisherGrantsByEventTypeReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListAuthorizedFieldPublisherGrantsByEventTypeResp. */
                    interface IListAuthorizedFieldPublisherGrantsByEventTypeResp {

                        /** ListAuthorizedFieldPublisherGrantsByEventTypeResp grants */
                        grants?: (code.justin.tv.eventbus.controlplane.IPublisherGrant[]|null);
                    }

                    /** Represents a ListAuthorizedFieldPublisherGrantsByEventTypeResp. */
                    class ListAuthorizedFieldPublisherGrantsByEventTypeResp implements IListAuthorizedFieldPublisherGrantsByEventTypeResp {

                        /**
                         * Constructs a new ListAuthorizedFieldPublisherGrantsByEventTypeResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp);

                        /** ListAuthorizedFieldPublisherGrantsByEventTypeResp grants. */
                        public grants: code.justin.tv.eventbus.controlplane.IPublisherGrant[];

                        /**
                         * Creates a new ListAuthorizedFieldPublisherGrantsByEventTypeResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp;

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp.verify|verify} messages.
                         * @param message ListAuthorizedFieldPublisherGrantsByEventTypeResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp.verify|verify} messages.
                         * @param message ListAuthorizedFieldPublisherGrantsByEventTypeResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp;

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp;

                        /**
                         * Verifies a ListAuthorizedFieldPublisherGrantsByEventTypeResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListAuthorizedFieldPublisherGrantsByEventTypeResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp;

                        /**
                         * Creates a plain object from a ListAuthorizedFieldPublisherGrantsByEventTypeResp message. Also converts values to other types if specified.
                         * @param message ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListAuthorizedFieldPublisherGrantsByEventTypeResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a Grant. */
                    interface IGrant {

                        /** Grant iamRoleArn */
                        iamRoleArn?: (string|null);

                        /** Grant serviceName */
                        serviceName?: (string|null);

                        /** Grant fieldName */
                        fieldName?: (string|null);

                        /** Grant messageName */
                        messageName?: (string|null);

                        /** Grant environment */
                        environment?: (string|null);
                    }

                    /** Represents a Grant. */
                    class Grant implements IGrant {

                        /**
                         * Constructs a new Grant.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGrant);

                        /** Grant iamRoleArn. */
                        public iamRoleArn: string;

                        /** Grant serviceName. */
                        public serviceName: string;

                        /** Grant fieldName. */
                        public fieldName: string;

                        /** Grant messageName. */
                        public messageName: string;

                        /** Grant environment. */
                        public environment: string;

                        /**
                         * Creates a new Grant instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Grant instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGrant): code.justin.tv.eventbus.controlplane.Grant;

                        /**
                         * Encodes the specified Grant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Grant.verify|verify} messages.
                         * @param message Grant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Grant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Grant.verify|verify} messages.
                         * @param message Grant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Grant message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Grant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.Grant;

                        /**
                         * Decodes a Grant message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Grant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.Grant;

                        /**
                         * Verifies a Grant message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Grant message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Grant
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.Grant;

                        /**
                         * Creates a plain object from a Grant message. Also converts values to other types if specified.
                         * @param message Grant
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.Grant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Grant to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a PublisherGrant. */
                    interface IPublisherGrant {

                        /** PublisherGrant iamRoleArn */
                        iamRoleArn?: (string|null);

                        /** PublisherGrant serviceName */
                        serviceName?: (string|null);

                        /** PublisherGrant environment */
                        environment?: (string|null);
                    }

                    /** Represents a PublisherGrant. */
                    class PublisherGrant implements IPublisherGrant {

                        /**
                         * Constructs a new PublisherGrant.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IPublisherGrant);

                        /** PublisherGrant iamRoleArn. */
                        public iamRoleArn: string;

                        /** PublisherGrant serviceName. */
                        public serviceName: string;

                        /** PublisherGrant environment. */
                        public environment: string;

                        /**
                         * Creates a new PublisherGrant instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns PublisherGrant instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IPublisherGrant): code.justin.tv.eventbus.controlplane.PublisherGrant;

                        /**
                         * Encodes the specified PublisherGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherGrant.verify|verify} messages.
                         * @param message PublisherGrant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IPublisherGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified PublisherGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherGrant.verify|verify} messages.
                         * @param message PublisherGrant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IPublisherGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a PublisherGrant message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns PublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.PublisherGrant;

                        /**
                         * Decodes a PublisherGrant message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns PublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.PublisherGrant;

                        /**
                         * Verifies a PublisherGrant message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a PublisherGrant message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns PublisherGrant
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.PublisherGrant;

                        /**
                         * Creates a plain object from a PublisherGrant message. Also converts values to other types if specified.
                         * @param message PublisherGrant
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.PublisherGrant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this PublisherGrant to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an EventType. */
                    interface IEventType {

                        /** EventType id */
                        id?: (string|null);

                        /** EventType name */
                        name?: (string|null);

                        /** EventType description */
                        description?: (string|null);

                        /** EventType repoFilepath */
                        repoFilepath?: (string|null);

                        /** EventType deprecated */
                        deprecated?: (boolean|null);

                        /** EventType ldapGroup */
                        ldapGroup?: (string|null);
                    }

                    /** Represents an EventType. */
                    class EventType implements IEventType {

                        /**
                         * Constructs a new EventType.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IEventType);

                        /** EventType id. */
                        public id: string;

                        /** EventType name. */
                        public name: string;

                        /** EventType description. */
                        public description: string;

                        /** EventType repoFilepath. */
                        public repoFilepath: string;

                        /** EventType deprecated. */
                        public deprecated: boolean;

                        /** EventType ldapGroup. */
                        public ldapGroup: string;

                        /**
                         * Creates a new EventType instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns EventType instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IEventType): code.justin.tv.eventbus.controlplane.EventType;

                        /**
                         * Encodes the specified EventType message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventType.verify|verify} messages.
                         * @param message EventType message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IEventType, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified EventType message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventType.verify|verify} messages.
                         * @param message EventType message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IEventType, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an EventType message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns EventType
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.EventType;

                        /**
                         * Decodes an EventType message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns EventType
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.EventType;

                        /**
                         * Verifies an EventType message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an EventType message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns EventType
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.EventType;

                        /**
                         * Creates a plain object from an EventType message. Also converts values to other types if specified.
                         * @param message EventType
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.EventType, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this EventType to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListEventTypesReq. */
                    interface IListEventTypesReq {

                        /** ListEventTypesReq ldapGroup */
                        ldapGroup?: (string|null);
                    }

                    /** Represents a ListEventTypesReq. */
                    class ListEventTypesReq implements IListEventTypesReq {

                        /**
                         * Constructs a new ListEventTypesReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListEventTypesReq);

                        /** ListEventTypesReq ldapGroup. */
                        public ldapGroup: string;

                        /**
                         * Creates a new ListEventTypesReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListEventTypesReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListEventTypesReq): code.justin.tv.eventbus.controlplane.ListEventTypesReq;

                        /**
                         * Encodes the specified ListEventTypesReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesReq.verify|verify} messages.
                         * @param message ListEventTypesReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListEventTypesReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListEventTypesReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesReq.verify|verify} messages.
                         * @param message ListEventTypesReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListEventTypesReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListEventTypesReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListEventTypesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListEventTypesReq;

                        /**
                         * Decodes a ListEventTypesReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListEventTypesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListEventTypesReq;

                        /**
                         * Verifies a ListEventTypesReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListEventTypesReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListEventTypesReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListEventTypesReq;

                        /**
                         * Creates a plain object from a ListEventTypesReq message. Also converts values to other types if specified.
                         * @param message ListEventTypesReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListEventTypesReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListEventTypesReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListEventTypesResp. */
                    interface IListEventTypesResp {

                        /** ListEventTypesResp eventTypes */
                        eventTypes?: (code.justin.tv.eventbus.controlplane.IEventType[]|null);
                    }

                    /** Represents a ListEventTypesResp. */
                    class ListEventTypesResp implements IListEventTypesResp {

                        /**
                         * Constructs a new ListEventTypesResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListEventTypesResp);

                        /** ListEventTypesResp eventTypes. */
                        public eventTypes: code.justin.tv.eventbus.controlplane.IEventType[];

                        /**
                         * Creates a new ListEventTypesResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListEventTypesResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListEventTypesResp): code.justin.tv.eventbus.controlplane.ListEventTypesResp;

                        /**
                         * Encodes the specified ListEventTypesResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesResp.verify|verify} messages.
                         * @param message ListEventTypesResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListEventTypesResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListEventTypesResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesResp.verify|verify} messages.
                         * @param message ListEventTypesResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListEventTypesResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListEventTypesResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListEventTypesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListEventTypesResp;

                        /**
                         * Decodes a ListEventTypesResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListEventTypesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListEventTypesResp;

                        /**
                         * Verifies a ListEventTypesResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListEventTypesResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListEventTypesResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListEventTypesResp;

                        /**
                         * Creates a plain object from a ListEventTypesResp message. Also converts values to other types if specified.
                         * @param message ListEventTypesResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListEventTypesResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListEventTypesResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListEventStreamsReq. */
                    interface IListEventStreamsReq {

                        /** ListEventStreamsReq cursor */
                        cursor?: (string|null);

                        /** ListEventStreamsReq eventTypeName */
                        eventTypeName?: (string|null);
                    }

                    /** Represents a ListEventStreamsReq. */
                    class ListEventStreamsReq implements IListEventStreamsReq {

                        /**
                         * Constructs a new ListEventStreamsReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListEventStreamsReq);

                        /** ListEventStreamsReq cursor. */
                        public cursor: string;

                        /** ListEventStreamsReq eventTypeName. */
                        public eventTypeName: string;

                        /**
                         * Creates a new ListEventStreamsReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListEventStreamsReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListEventStreamsReq): code.justin.tv.eventbus.controlplane.ListEventStreamsReq;

                        /**
                         * Encodes the specified ListEventStreamsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsReq.verify|verify} messages.
                         * @param message ListEventStreamsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListEventStreamsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListEventStreamsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsReq.verify|verify} messages.
                         * @param message ListEventStreamsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListEventStreamsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListEventStreamsReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListEventStreamsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListEventStreamsReq;

                        /**
                         * Decodes a ListEventStreamsReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListEventStreamsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListEventStreamsReq;

                        /**
                         * Verifies a ListEventStreamsReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListEventStreamsReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListEventStreamsReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListEventStreamsReq;

                        /**
                         * Creates a plain object from a ListEventStreamsReq message. Also converts values to other types if specified.
                         * @param message ListEventStreamsReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListEventStreamsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListEventStreamsReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListEventStreamsResp. */
                    interface IListEventStreamsResp {

                        /** ListEventStreamsResp eventStreams */
                        eventStreams?: (code.justin.tv.eventbus.controlplane.IEventStream[]|null);

                        /** ListEventStreamsResp nextCursor */
                        nextCursor?: (string|null);
                    }

                    /** Represents a ListEventStreamsResp. */
                    class ListEventStreamsResp implements IListEventStreamsResp {

                        /**
                         * Constructs a new ListEventStreamsResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListEventStreamsResp);

                        /** ListEventStreamsResp eventStreams. */
                        public eventStreams: code.justin.tv.eventbus.controlplane.IEventStream[];

                        /** ListEventStreamsResp nextCursor. */
                        public nextCursor: string;

                        /**
                         * Creates a new ListEventStreamsResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListEventStreamsResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListEventStreamsResp): code.justin.tv.eventbus.controlplane.ListEventStreamsResp;

                        /**
                         * Encodes the specified ListEventStreamsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsResp.verify|verify} messages.
                         * @param message ListEventStreamsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListEventStreamsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListEventStreamsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsResp.verify|verify} messages.
                         * @param message ListEventStreamsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListEventStreamsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListEventStreamsResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListEventStreamsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListEventStreamsResp;

                        /**
                         * Decodes a ListEventStreamsResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListEventStreamsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListEventStreamsResp;

                        /**
                         * Verifies a ListEventStreamsResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListEventStreamsResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListEventStreamsResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListEventStreamsResp;

                        /**
                         * Creates a plain object from a ListEventStreamsResp message. Also converts values to other types if specified.
                         * @param message ListEventStreamsResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListEventStreamsResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListEventStreamsResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetEventStreamReq. */
                    interface IGetEventStreamReq {

                        /** GetEventStreamReq eventType */
                        eventType?: (string|null);

                        /** GetEventStreamReq environment */
                        environment?: (string|null);
                    }

                    /** Represents a GetEventStreamReq. */
                    class GetEventStreamReq implements IGetEventStreamReq {

                        /**
                         * Constructs a new GetEventStreamReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetEventStreamReq);

                        /** GetEventStreamReq eventType. */
                        public eventType: string;

                        /** GetEventStreamReq environment. */
                        public environment: string;

                        /**
                         * Creates a new GetEventStreamReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetEventStreamReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetEventStreamReq): code.justin.tv.eventbus.controlplane.GetEventStreamReq;

                        /**
                         * Encodes the specified GetEventStreamReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamReq.verify|verify} messages.
                         * @param message GetEventStreamReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetEventStreamReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetEventStreamReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamReq.verify|verify} messages.
                         * @param message GetEventStreamReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetEventStreamReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetEventStreamReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetEventStreamReq;

                        /**
                         * Decodes a GetEventStreamReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetEventStreamReq;

                        /**
                         * Verifies a GetEventStreamReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetEventStreamReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetEventStreamReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetEventStreamReq;

                        /**
                         * Creates a plain object from a GetEventStreamReq message. Also converts values to other types if specified.
                         * @param message GetEventStreamReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetEventStreamReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetEventStreamReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetEventStreamStatsReq. */
                    interface IGetEventStreamStatsReq {

                        /** GetEventStreamStatsReq eventType */
                        eventType?: (string|null);

                        /** GetEventStreamStatsReq environment */
                        environment?: (string|null);
                    }

                    /** Represents a GetEventStreamStatsReq. */
                    class GetEventStreamStatsReq implements IGetEventStreamStatsReq {

                        /**
                         * Constructs a new GetEventStreamStatsReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq);

                        /** GetEventStreamStatsReq eventType. */
                        public eventType: string;

                        /** GetEventStreamStatsReq environment. */
                        public environment: string;

                        /**
                         * Creates a new GetEventStreamStatsReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetEventStreamStatsReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq): code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq;

                        /**
                         * Encodes the specified GetEventStreamStatsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq.verify|verify} messages.
                         * @param message GetEventStreamStatsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetEventStreamStatsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq.verify|verify} messages.
                         * @param message GetEventStreamStatsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetEventStreamStatsReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetEventStreamStatsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq;

                        /**
                         * Decodes a GetEventStreamStatsReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetEventStreamStatsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq;

                        /**
                         * Verifies a GetEventStreamStatsReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetEventStreamStatsReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetEventStreamStatsReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq;

                        /**
                         * Creates a plain object from a GetEventStreamStatsReq message. Also converts values to other types if specified.
                         * @param message GetEventStreamStatsReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetEventStreamStatsReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an EventStream. */
                    interface IEventStream {

                        /** EventStream eventType */
                        eventType?: (string|null);

                        /** EventStream environment */
                        environment?: (string|null);

                        /** EventStream displayName */
                        displayName?: (string|null);

                        /** EventStream shortDescription */
                        shortDescription?: (string|null);

                        /** EventStream activeSince */
                        activeSince?: (google.protobuf.ITimestamp|null);

                        /** EventStream description */
                        description?: (string|null);

                        /** EventStream stats */
                        stats?: (code.justin.tv.eventbus.controlplane.IEventStreamStats|null);

                        /** EventStream schema */
                        schema?: (string|null);

                        /** EventStream repoFilepath */
                        repoFilepath?: (string|null);

                        /** EventStream authorizedFields */
                        authorizedFields?: (code.justin.tv.eventbus.controlplane.IAuthorizedField[]|null);

                        /** EventStream deprecated */
                        deprecated?: (boolean|null);

                        /** EventStream ldapGroup */
                        ldapGroup?: (string|null);
                    }

                    /** Represents an EventStream. */
                    class EventStream implements IEventStream {

                        /**
                         * Constructs a new EventStream.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IEventStream);

                        /** EventStream eventType. */
                        public eventType: string;

                        /** EventStream environment. */
                        public environment: string;

                        /** EventStream displayName. */
                        public displayName: string;

                        /** EventStream shortDescription. */
                        public shortDescription: string;

                        /** EventStream activeSince. */
                        public activeSince?: (google.protobuf.ITimestamp|null);

                        /** EventStream description. */
                        public description: string;

                        /** EventStream stats. */
                        public stats?: (code.justin.tv.eventbus.controlplane.IEventStreamStats|null);

                        /** EventStream schema. */
                        public schema: string;

                        /** EventStream repoFilepath. */
                        public repoFilepath: string;

                        /** EventStream authorizedFields. */
                        public authorizedFields: code.justin.tv.eventbus.controlplane.IAuthorizedField[];

                        /** EventStream deprecated. */
                        public deprecated: boolean;

                        /** EventStream ldapGroup. */
                        public ldapGroup: string;

                        /**
                         * Creates a new EventStream instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns EventStream instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IEventStream): code.justin.tv.eventbus.controlplane.EventStream;

                        /**
                         * Encodes the specified EventStream message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStream.verify|verify} messages.
                         * @param message EventStream message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IEventStream, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified EventStream message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStream.verify|verify} messages.
                         * @param message EventStream message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IEventStream, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an EventStream message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns EventStream
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.EventStream;

                        /**
                         * Decodes an EventStream message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns EventStream
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.EventStream;

                        /**
                         * Verifies an EventStream message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an EventStream message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns EventStream
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.EventStream;

                        /**
                         * Creates a plain object from an EventStream message. Also converts values to other types if specified.
                         * @param message EventStream
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.EventStream, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this EventStream to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an EventStreamStats. */
                    interface IEventStreamStats {

                        /** EventStreamStats tpsMean */
                        tpsMean?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats tps_95th */
                        tps_95th?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats meanEventsPerMinute */
                        meanEventsPerMinute?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats maxEventsPerMinute */
                        maxEventsPerMinute?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats minEventsPerMinute */
                        minEventsPerMinute?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats meanEventPayloadSize */
                        meanEventPayloadSize?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats publisherCount */
                        publisherCount?: (number|null);

                        /** EventStreamStats subscriberCount */
                        subscriberCount?: (number|null);

                        /** EventStreamStats publishers */
                        publishers?: (code.justin.tv.eventbus.controlplane.IPublisherServiceInfo[]|null);
                    }

                    /** Represents an EventStreamStats. */
                    class EventStreamStats implements IEventStreamStats {

                        /**
                         * Constructs a new EventStreamStats.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IEventStreamStats);

                        /** EventStreamStats tpsMean. */
                        public tpsMean?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats tps_95th. */
                        public tps_95th?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats meanEventsPerMinute. */
                        public meanEventsPerMinute?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats maxEventsPerMinute. */
                        public maxEventsPerMinute?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats minEventsPerMinute. */
                        public minEventsPerMinute?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats meanEventPayloadSize. */
                        public meanEventPayloadSize?: (google.protobuf.IDoubleValue|null);

                        /** EventStreamStats publisherCount. */
                        public publisherCount: number;

                        /** EventStreamStats subscriberCount. */
                        public subscriberCount: number;

                        /** EventStreamStats publishers. */
                        public publishers: code.justin.tv.eventbus.controlplane.IPublisherServiceInfo[];

                        /**
                         * Creates a new EventStreamStats instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns EventStreamStats instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IEventStreamStats): code.justin.tv.eventbus.controlplane.EventStreamStats;

                        /**
                         * Encodes the specified EventStreamStats message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStreamStats.verify|verify} messages.
                         * @param message EventStreamStats message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IEventStreamStats, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified EventStreamStats message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStreamStats.verify|verify} messages.
                         * @param message EventStreamStats message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IEventStreamStats, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an EventStreamStats message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns EventStreamStats
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.EventStreamStats;

                        /**
                         * Decodes an EventStreamStats message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns EventStreamStats
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.EventStreamStats;

                        /**
                         * Verifies an EventStreamStats message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an EventStreamStats message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns EventStreamStats
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.EventStreamStats;

                        /**
                         * Creates a plain object from an EventStreamStats message. Also converts values to other types if specified.
                         * @param message EventStreamStats
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.EventStreamStats, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this EventStreamStats to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a PublisherServiceInfo. */
                    interface IPublisherServiceInfo {

                        /** PublisherServiceInfo name */
                        name?: (string|null);

                        /** PublisherServiceInfo serviceCatalogUrl */
                        serviceCatalogUrl?: (string|null);
                    }

                    /** Represents a PublisherServiceInfo. */
                    class PublisherServiceInfo implements IPublisherServiceInfo {

                        /**
                         * Constructs a new PublisherServiceInfo.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IPublisherServiceInfo);

                        /** PublisherServiceInfo name. */
                        public name: string;

                        /** PublisherServiceInfo serviceCatalogUrl. */
                        public serviceCatalogUrl: string;

                        /**
                         * Creates a new PublisherServiceInfo instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns PublisherServiceInfo instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IPublisherServiceInfo): code.justin.tv.eventbus.controlplane.PublisherServiceInfo;

                        /**
                         * Encodes the specified PublisherServiceInfo message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherServiceInfo.verify|verify} messages.
                         * @param message PublisherServiceInfo message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IPublisherServiceInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified PublisherServiceInfo message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherServiceInfo.verify|verify} messages.
                         * @param message PublisherServiceInfo message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IPublisherServiceInfo, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a PublisherServiceInfo message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns PublisherServiceInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.PublisherServiceInfo;

                        /**
                         * Decodes a PublisherServiceInfo message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns PublisherServiceInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.PublisherServiceInfo;

                        /**
                         * Verifies a PublisherServiceInfo message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a PublisherServiceInfo message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns PublisherServiceInfo
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.PublisherServiceInfo;

                        /**
                         * Creates a plain object from a PublisherServiceInfo message. Also converts values to other types if specified.
                         * @param message PublisherServiceInfo
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.PublisherServiceInfo, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this PublisherServiceInfo to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an AuthorizedField. */
                    interface IAuthorizedField {

                        /** AuthorizedField messageName */
                        messageName?: (string|null);

                        /** AuthorizedField fieldName */
                        fieldName?: (string|null);
                    }

                    /** Represents an AuthorizedField. */
                    class AuthorizedField implements IAuthorizedField {

                        /**
                         * Constructs a new AuthorizedField.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IAuthorizedField);

                        /** AuthorizedField messageName. */
                        public messageName: string;

                        /** AuthorizedField fieldName. */
                        public fieldName: string;

                        /**
                         * Creates a new AuthorizedField instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns AuthorizedField instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IAuthorizedField): code.justin.tv.eventbus.controlplane.AuthorizedField;

                        /**
                         * Encodes the specified AuthorizedField message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedField.verify|verify} messages.
                         * @param message AuthorizedField message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IAuthorizedField, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified AuthorizedField message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedField.verify|verify} messages.
                         * @param message AuthorizedField message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IAuthorizedField, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an AuthorizedField message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns AuthorizedField
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.AuthorizedField;

                        /**
                         * Decodes an AuthorizedField message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns AuthorizedField
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.AuthorizedField;

                        /**
                         * Verifies an AuthorizedField message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an AuthorizedField message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns AuthorizedField
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.AuthorizedField;

                        /**
                         * Creates a plain object from an AuthorizedField message. Also converts values to other types if specified.
                         * @param message AuthorizedField
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.AuthorizedField, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this AuthorizedField to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Represents a FeatureFlags */
                    class FeatureFlags extends $protobuf.rpc.Service {

                        /**
                         * Constructs a new FeatureFlags service.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         */
                        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                        /**
                         * Creates new FeatureFlags service using the specified rpc implementation.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         * @returns RPC service. Useful where requests and/or responses are streamed.
                         */
                        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): FeatureFlags;

                        /**
                         * Calls IsEnabled.
                         * @param request IsEnabledReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and IsEnabledResp
                         */
                        public isEnabled(request: code.justin.tv.eventbus.controlplane.IIsEnabledReq, callback: code.justin.tv.eventbus.controlplane.FeatureFlags.IsEnabledCallback): void;

                        /**
                         * Calls IsEnabled.
                         * @param request IsEnabledReq message or plain object
                         * @returns Promise
                         */
                        public isEnabled(request: code.justin.tv.eventbus.controlplane.IIsEnabledReq): Promise<code.justin.tv.eventbus.controlplane.IsEnabledResp>;

                        /**
                         * Calls Enable.
                         * @param request EnableReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and EnableResp
                         */
                        public enable(request: code.justin.tv.eventbus.controlplane.IEnableReq, callback: code.justin.tv.eventbus.controlplane.FeatureFlags.EnableCallback): void;

                        /**
                         * Calls Enable.
                         * @param request EnableReq message or plain object
                         * @returns Promise
                         */
                        public enable(request: code.justin.tv.eventbus.controlplane.IEnableReq): Promise<code.justin.tv.eventbus.controlplane.EnableResp>;

                        /**
                         * Calls Disable.
                         * @param request DisableReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and DisableResp
                         */
                        public disable(request: code.justin.tv.eventbus.controlplane.IDisableReq, callback: code.justin.tv.eventbus.controlplane.FeatureFlags.DisableCallback): void;

                        /**
                         * Calls Disable.
                         * @param request DisableReq message or plain object
                         * @returns Promise
                         */
                        public disable(request: code.justin.tv.eventbus.controlplane.IDisableReq): Promise<code.justin.tv.eventbus.controlplane.DisableResp>;

                        /**
                         * Calls List.
                         * @param request ListFeatureFlagsReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ListFeatureFlagsResp
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq, callback: code.justin.tv.eventbus.controlplane.FeatureFlags.ListCallback): void;

                        /**
                         * Calls List.
                         * @param request ListFeatureFlagsReq message or plain object
                         * @returns Promise
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq): Promise<code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp>;

                        /**
                         * Calls Create.
                         * @param request CreateFeatureFlagsReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and CreateFeatureFlagsResp
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq, callback: code.justin.tv.eventbus.controlplane.FeatureFlags.CreateCallback): void;

                        /**
                         * Calls Create.
                         * @param request CreateFeatureFlagsReq message or plain object
                         * @returns Promise
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq): Promise<code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp>;

                        /**
                         * Calls Delete.
                         * @param request DeleteFeatureFlagsReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and DeleteFeatureFlagsResp
                         */
                        public delete(request: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq, callback: code.justin.tv.eventbus.controlplane.FeatureFlags.DeleteCallback): void;

                        /**
                         * Calls Delete.
                         * @param request DeleteFeatureFlagsReq message or plain object
                         * @returns Promise
                         */
                        public delete(request: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq): Promise<code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp>;
                    }

                    namespace FeatureFlags {

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#isEnabled}.
                         * @param error Error, if any
                         * @param [response] IsEnabledResp
                         */
                        type IsEnabledCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.IsEnabledResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#enable}.
                         * @param error Error, if any
                         * @param [response] EnableResp
                         */
                        type EnableCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.EnableResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#disable}.
                         * @param error Error, if any
                         * @param [response] DisableResp
                         */
                        type DisableCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.DisableResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#list}.
                         * @param error Error, if any
                         * @param [response] ListFeatureFlagsResp
                         */
                        type ListCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#create}.
                         * @param error Error, if any
                         * @param [response] CreateFeatureFlagsResp
                         */
                        type CreateCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#delete_}.
                         * @param error Error, if any
                         * @param [response] DeleteFeatureFlagsResp
                         */
                        type DeleteCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp) => void;
                    }

                    /** Properties of an IsEnabledReq. */
                    interface IIsEnabledReq {

                        /** IsEnabledReq name */
                        name?: (string|null);
                    }

                    /** Represents an IsEnabledReq. */
                    class IsEnabledReq implements IIsEnabledReq {

                        /**
                         * Constructs a new IsEnabledReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IIsEnabledReq);

                        /** IsEnabledReq name. */
                        public name: string;

                        /**
                         * Creates a new IsEnabledReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns IsEnabledReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IIsEnabledReq): code.justin.tv.eventbus.controlplane.IsEnabledReq;

                        /**
                         * Encodes the specified IsEnabledReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledReq.verify|verify} messages.
                         * @param message IsEnabledReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IIsEnabledReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified IsEnabledReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledReq.verify|verify} messages.
                         * @param message IsEnabledReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IIsEnabledReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an IsEnabledReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns IsEnabledReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.IsEnabledReq;

                        /**
                         * Decodes an IsEnabledReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns IsEnabledReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.IsEnabledReq;

                        /**
                         * Verifies an IsEnabledReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an IsEnabledReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns IsEnabledReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.IsEnabledReq;

                        /**
                         * Creates a plain object from an IsEnabledReq message. Also converts values to other types if specified.
                         * @param message IsEnabledReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.IsEnabledReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this IsEnabledReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an IsEnabledResp. */
                    interface IIsEnabledResp {

                        /** IsEnabledResp isEnabled */
                        isEnabled?: (boolean|null);
                    }

                    /** Represents an IsEnabledResp. */
                    class IsEnabledResp implements IIsEnabledResp {

                        /**
                         * Constructs a new IsEnabledResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IIsEnabledResp);

                        /** IsEnabledResp isEnabled. */
                        public isEnabled: boolean;

                        /**
                         * Creates a new IsEnabledResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns IsEnabledResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IIsEnabledResp): code.justin.tv.eventbus.controlplane.IsEnabledResp;

                        /**
                         * Encodes the specified IsEnabledResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledResp.verify|verify} messages.
                         * @param message IsEnabledResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IIsEnabledResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified IsEnabledResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledResp.verify|verify} messages.
                         * @param message IsEnabledResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IIsEnabledResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an IsEnabledResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns IsEnabledResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.IsEnabledResp;

                        /**
                         * Decodes an IsEnabledResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns IsEnabledResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.IsEnabledResp;

                        /**
                         * Verifies an IsEnabledResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an IsEnabledResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns IsEnabledResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.IsEnabledResp;

                        /**
                         * Creates a plain object from an IsEnabledResp message. Also converts values to other types if specified.
                         * @param message IsEnabledResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.IsEnabledResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this IsEnabledResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an EnableReq. */
                    interface IEnableReq {

                        /** EnableReq name */
                        name?: (string|null);
                    }

                    /** Represents an EnableReq. */
                    class EnableReq implements IEnableReq {

                        /**
                         * Constructs a new EnableReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IEnableReq);

                        /** EnableReq name. */
                        public name: string;

                        /**
                         * Creates a new EnableReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns EnableReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IEnableReq): code.justin.tv.eventbus.controlplane.EnableReq;

                        /**
                         * Encodes the specified EnableReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableReq.verify|verify} messages.
                         * @param message EnableReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IEnableReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified EnableReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableReq.verify|verify} messages.
                         * @param message EnableReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IEnableReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an EnableReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns EnableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.EnableReq;

                        /**
                         * Decodes an EnableReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns EnableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.EnableReq;

                        /**
                         * Verifies an EnableReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an EnableReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns EnableReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.EnableReq;

                        /**
                         * Creates a plain object from an EnableReq message. Also converts values to other types if specified.
                         * @param message EnableReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.EnableReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this EnableReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an EnableResp. */
                    interface IEnableResp {
                    }

                    /** Represents an EnableResp. */
                    class EnableResp implements IEnableResp {

                        /**
                         * Constructs a new EnableResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IEnableResp);

                        /**
                         * Creates a new EnableResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns EnableResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IEnableResp): code.justin.tv.eventbus.controlplane.EnableResp;

                        /**
                         * Encodes the specified EnableResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableResp.verify|verify} messages.
                         * @param message EnableResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IEnableResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified EnableResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableResp.verify|verify} messages.
                         * @param message EnableResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IEnableResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an EnableResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns EnableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.EnableResp;

                        /**
                         * Decodes an EnableResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns EnableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.EnableResp;

                        /**
                         * Verifies an EnableResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an EnableResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns EnableResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.EnableResp;

                        /**
                         * Creates a plain object from an EnableResp message. Also converts values to other types if specified.
                         * @param message EnableResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.EnableResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this EnableResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DisableReq. */
                    interface IDisableReq {

                        /** DisableReq name */
                        name?: (string|null);
                    }

                    /** Represents a DisableReq. */
                    class DisableReq implements IDisableReq {

                        /**
                         * Constructs a new DisableReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDisableReq);

                        /** DisableReq name. */
                        public name: string;

                        /**
                         * Creates a new DisableReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DisableReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDisableReq): code.justin.tv.eventbus.controlplane.DisableReq;

                        /**
                         * Encodes the specified DisableReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableReq.verify|verify} messages.
                         * @param message DisableReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDisableReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DisableReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableReq.verify|verify} messages.
                         * @param message DisableReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDisableReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DisableReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DisableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DisableReq;

                        /**
                         * Decodes a DisableReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DisableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DisableReq;

                        /**
                         * Verifies a DisableReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DisableReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DisableReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DisableReq;

                        /**
                         * Creates a plain object from a DisableReq message. Also converts values to other types if specified.
                         * @param message DisableReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DisableReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DisableReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DisableResp. */
                    interface IDisableResp {
                    }

                    /** Represents a DisableResp. */
                    class DisableResp implements IDisableResp {

                        /**
                         * Constructs a new DisableResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDisableResp);

                        /**
                         * Creates a new DisableResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DisableResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDisableResp): code.justin.tv.eventbus.controlplane.DisableResp;

                        /**
                         * Encodes the specified DisableResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableResp.verify|verify} messages.
                         * @param message DisableResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDisableResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DisableResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableResp.verify|verify} messages.
                         * @param message DisableResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDisableResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DisableResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DisableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DisableResp;

                        /**
                         * Decodes a DisableResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DisableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DisableResp;

                        /**
                         * Verifies a DisableResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DisableResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DisableResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DisableResp;

                        /**
                         * Creates a plain object from a DisableResp message. Also converts values to other types if specified.
                         * @param message DisableResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DisableResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DisableResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a FeatureFlag. */
                    interface IFeatureFlag {

                        /** FeatureFlag name */
                        name?: (string|null);

                        /** FeatureFlag isEnabled */
                        isEnabled?: (boolean|null);
                    }

                    /** Represents a FeatureFlag. */
                    class FeatureFlag implements IFeatureFlag {

                        /**
                         * Constructs a new FeatureFlag.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IFeatureFlag);

                        /** FeatureFlag name. */
                        public name: string;

                        /** FeatureFlag isEnabled. */
                        public isEnabled: boolean;

                        /**
                         * Creates a new FeatureFlag instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns FeatureFlag instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IFeatureFlag): code.justin.tv.eventbus.controlplane.FeatureFlag;

                        /**
                         * Encodes the specified FeatureFlag message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.FeatureFlag.verify|verify} messages.
                         * @param message FeatureFlag message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IFeatureFlag, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified FeatureFlag message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.FeatureFlag.verify|verify} messages.
                         * @param message FeatureFlag message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IFeatureFlag, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a FeatureFlag message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns FeatureFlag
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.FeatureFlag;

                        /**
                         * Decodes a FeatureFlag message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns FeatureFlag
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.FeatureFlag;

                        /**
                         * Verifies a FeatureFlag message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a FeatureFlag message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns FeatureFlag
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.FeatureFlag;

                        /**
                         * Creates a plain object from a FeatureFlag message. Also converts values to other types if specified.
                         * @param message FeatureFlag
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.FeatureFlag, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this FeatureFlag to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListFeatureFlagsReq. */
                    interface IListFeatureFlagsReq {
                    }

                    /** Represents a ListFeatureFlagsReq. */
                    class ListFeatureFlagsReq implements IListFeatureFlagsReq {

                        /**
                         * Constructs a new ListFeatureFlagsReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq);

                        /**
                         * Creates a new ListFeatureFlagsReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListFeatureFlagsReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq): code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq;

                        /**
                         * Encodes the specified ListFeatureFlagsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq.verify|verify} messages.
                         * @param message ListFeatureFlagsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListFeatureFlagsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq.verify|verify} messages.
                         * @param message ListFeatureFlagsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListFeatureFlagsReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq;

                        /**
                         * Decodes a ListFeatureFlagsReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq;

                        /**
                         * Verifies a ListFeatureFlagsReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListFeatureFlagsReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListFeatureFlagsReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq;

                        /**
                         * Creates a plain object from a ListFeatureFlagsReq message. Also converts values to other types if specified.
                         * @param message ListFeatureFlagsReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListFeatureFlagsReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListFeatureFlagsResp. */
                    interface IListFeatureFlagsResp {

                        /** ListFeatureFlagsResp featureFlags */
                        featureFlags?: (code.justin.tv.eventbus.controlplane.IFeatureFlag[]|null);
                    }

                    /** Represents a ListFeatureFlagsResp. */
                    class ListFeatureFlagsResp implements IListFeatureFlagsResp {

                        /**
                         * Constructs a new ListFeatureFlagsResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp);

                        /** ListFeatureFlagsResp featureFlags. */
                        public featureFlags: code.justin.tv.eventbus.controlplane.IFeatureFlag[];

                        /**
                         * Creates a new ListFeatureFlagsResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListFeatureFlagsResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp): code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp;

                        /**
                         * Encodes the specified ListFeatureFlagsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp.verify|verify} messages.
                         * @param message ListFeatureFlagsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListFeatureFlagsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp.verify|verify} messages.
                         * @param message ListFeatureFlagsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListFeatureFlagsResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp;

                        /**
                         * Decodes a ListFeatureFlagsResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp;

                        /**
                         * Verifies a ListFeatureFlagsResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListFeatureFlagsResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListFeatureFlagsResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp;

                        /**
                         * Creates a plain object from a ListFeatureFlagsResp message. Also converts values to other types if specified.
                         * @param message ListFeatureFlagsResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListFeatureFlagsResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateFeatureFlagsReq. */
                    interface ICreateFeatureFlagsReq {

                        /** CreateFeatureFlagsReq featureFlag */
                        featureFlag?: (code.justin.tv.eventbus.controlplane.IFeatureFlag|null);
                    }

                    /** Represents a CreateFeatureFlagsReq. */
                    class CreateFeatureFlagsReq implements ICreateFeatureFlagsReq {

                        /**
                         * Constructs a new CreateFeatureFlagsReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq);

                        /** CreateFeatureFlagsReq featureFlag. */
                        public featureFlag?: (code.justin.tv.eventbus.controlplane.IFeatureFlag|null);

                        /**
                         * Creates a new CreateFeatureFlagsReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateFeatureFlagsReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq;

                        /**
                         * Encodes the specified CreateFeatureFlagsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq.verify|verify} messages.
                         * @param message CreateFeatureFlagsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateFeatureFlagsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq.verify|verify} messages.
                         * @param message CreateFeatureFlagsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateFeatureFlagsReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq;

                        /**
                         * Decodes a CreateFeatureFlagsReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq;

                        /**
                         * Verifies a CreateFeatureFlagsReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateFeatureFlagsReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateFeatureFlagsReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq;

                        /**
                         * Creates a plain object from a CreateFeatureFlagsReq message. Also converts values to other types if specified.
                         * @param message CreateFeatureFlagsReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateFeatureFlagsReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateFeatureFlagsResp. */
                    interface ICreateFeatureFlagsResp {

                        /** CreateFeatureFlagsResp id */
                        id?: (string|null);
                    }

                    /** Represents a CreateFeatureFlagsResp. */
                    class CreateFeatureFlagsResp implements ICreateFeatureFlagsResp {

                        /**
                         * Constructs a new CreateFeatureFlagsResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp);

                        /** CreateFeatureFlagsResp id. */
                        public id: string;

                        /**
                         * Creates a new CreateFeatureFlagsResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateFeatureFlagsResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp;

                        /**
                         * Encodes the specified CreateFeatureFlagsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp.verify|verify} messages.
                         * @param message CreateFeatureFlagsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateFeatureFlagsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp.verify|verify} messages.
                         * @param message CreateFeatureFlagsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateFeatureFlagsResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp;

                        /**
                         * Decodes a CreateFeatureFlagsResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp;

                        /**
                         * Verifies a CreateFeatureFlagsResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateFeatureFlagsResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateFeatureFlagsResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp;

                        /**
                         * Creates a plain object from a CreateFeatureFlagsResp message. Also converts values to other types if specified.
                         * @param message CreateFeatureFlagsResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateFeatureFlagsResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteFeatureFlagsReq. */
                    interface IDeleteFeatureFlagsReq {

                        /** DeleteFeatureFlagsReq name */
                        name?: (string|null);
                    }

                    /** Represents a DeleteFeatureFlagsReq. */
                    class DeleteFeatureFlagsReq implements IDeleteFeatureFlagsReq {

                        /**
                         * Constructs a new DeleteFeatureFlagsReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq);

                        /** DeleteFeatureFlagsReq name. */
                        public name: string;

                        /**
                         * Creates a new DeleteFeatureFlagsReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteFeatureFlagsReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq;

                        /**
                         * Encodes the specified DeleteFeatureFlagsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq.verify|verify} messages.
                         * @param message DeleteFeatureFlagsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteFeatureFlagsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq.verify|verify} messages.
                         * @param message DeleteFeatureFlagsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteFeatureFlagsReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq;

                        /**
                         * Decodes a DeleteFeatureFlagsReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq;

                        /**
                         * Verifies a DeleteFeatureFlagsReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteFeatureFlagsReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteFeatureFlagsReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq;

                        /**
                         * Creates a plain object from a DeleteFeatureFlagsReq message. Also converts values to other types if specified.
                         * @param message DeleteFeatureFlagsReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteFeatureFlagsReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteFeatureFlagsResp. */
                    interface IDeleteFeatureFlagsResp {
                    }

                    /** Represents a DeleteFeatureFlagsResp. */
                    class DeleteFeatureFlagsResp implements IDeleteFeatureFlagsResp {

                        /**
                         * Constructs a new DeleteFeatureFlagsResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp);

                        /**
                         * Creates a new DeleteFeatureFlagsResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteFeatureFlagsResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp;

                        /**
                         * Encodes the specified DeleteFeatureFlagsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp.verify|verify} messages.
                         * @param message DeleteFeatureFlagsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteFeatureFlagsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp.verify|verify} messages.
                         * @param message DeleteFeatureFlagsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteFeatureFlagsResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp;

                        /**
                         * Decodes a DeleteFeatureFlagsResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp;

                        /**
                         * Verifies a DeleteFeatureFlagsResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteFeatureFlagsResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteFeatureFlagsResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp;

                        /**
                         * Creates a plain object from a DeleteFeatureFlagsResp message. Also converts values to other types if specified.
                         * @param message DeleteFeatureFlagsResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteFeatureFlagsResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Represents a Services */
                    class Services extends $protobuf.rpc.Service {

                        /**
                         * Constructs a new Services service.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         */
                        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                        /**
                         * Creates new Services service using the specified rpc implementation.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         * @returns RPC service. Useful where requests and/or responses are streamed.
                         */
                        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Services;

                        /**
                         * Calls List.
                         * @param request ListServicesReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ListServicesResp
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListServicesReq, callback: code.justin.tv.eventbus.controlplane.Services.ListCallback): void;

                        /**
                         * Calls List.
                         * @param request ListServicesReq message or plain object
                         * @returns Promise
                         */
                        public list(request: code.justin.tv.eventbus.controlplane.IListServicesReq): Promise<code.justin.tv.eventbus.controlplane.ListServicesResp>;

                        /**
                         * Calls Get.
                         * @param request GetServiceReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and Service
                         */
                        public get(request: code.justin.tv.eventbus.controlplane.IGetServiceReq, callback: code.justin.tv.eventbus.controlplane.Services.GetCallback): void;

                        /**
                         * Calls Get.
                         * @param request GetServiceReq message or plain object
                         * @returns Promise
                         */
                        public get(request: code.justin.tv.eventbus.controlplane.IGetServiceReq): Promise<code.justin.tv.eventbus.controlplane.Service>;

                        /**
                         * Calls Create.
                         * @param request CreateServiceReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and CreateServiceResp
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateServiceReq, callback: code.justin.tv.eventbus.controlplane.Services.CreateCallback): void;

                        /**
                         * Calls Create.
                         * @param request CreateServiceReq message or plain object
                         * @returns Promise
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateServiceReq): Promise<code.justin.tv.eventbus.controlplane.CreateServiceResp>;

                        /**
                         * Calls Update.
                         * @param request UpdateServiceReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and UpdateServiceResp
                         */
                        public update(request: code.justin.tv.eventbus.controlplane.IUpdateServiceReq, callback: code.justin.tv.eventbus.controlplane.Services.UpdateCallback): void;

                        /**
                         * Calls Update.
                         * @param request UpdateServiceReq message or plain object
                         * @returns Promise
                         */
                        public update(request: code.justin.tv.eventbus.controlplane.IUpdateServiceReq): Promise<code.justin.tv.eventbus.controlplane.UpdateServiceResp>;

                        /**
                         * Calls GetAuthorizedFieldGrants.
                         * @param request GetAuthorizedFieldGrantsReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and GetAuthorizedFieldGrantsResp
                         */
                        public getAuthorizedFieldGrants(request: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq, callback: code.justin.tv.eventbus.controlplane.Services.GetAuthorizedFieldGrantsCallback): void;

                        /**
                         * Calls GetAuthorizedFieldGrants.
                         * @param request GetAuthorizedFieldGrantsReq message or plain object
                         * @returns Promise
                         */
                        public getAuthorizedFieldGrants(request: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq): Promise<code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp>;

                        /**
                         * Calls RequestorLDAPGroups.
                         * @param request RequestorLDAPGroupsReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and RequestorLDAPGroupsResp
                         */
                        public requestorLDAPGroups(request: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq, callback: code.justin.tv.eventbus.controlplane.Services.RequestorLDAPGroupsCallback): void;

                        /**
                         * Calls RequestorLDAPGroups.
                         * @param request RequestorLDAPGroupsReq message or plain object
                         * @returns Promise
                         */
                        public requestorLDAPGroups(request: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq): Promise<code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp>;

                        /**
                         * Calls ResolveLDAPGroupUsers.
                         * @param request ResolveLDAPGroupUsersReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ResolveLDAPGroupUsersResp
                         */
                        public resolveLDAPGroupUsers(request: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq, callback: code.justin.tv.eventbus.controlplane.Services.ResolveLDAPGroupUsersCallback): void;

                        /**
                         * Calls ResolveLDAPGroupUsers.
                         * @param request ResolveLDAPGroupUsersReq message or plain object
                         * @returns Promise
                         */
                        public resolveLDAPGroupUsers(request: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq): Promise<code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp>;

                        /**
                         * Calls DeleteIAMRole.
                         * @param request DeleteIAMRoleReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and DeleteIAMRoleResp
                         */
                        public deleteIAMRole(request: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq, callback: code.justin.tv.eventbus.controlplane.Services.DeleteIAMRoleCallback): void;

                        /**
                         * Calls DeleteIAMRole.
                         * @param request DeleteIAMRoleReq message or plain object
                         * @returns Promise
                         */
                        public deleteIAMRole(request: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq): Promise<code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp>;

                        /**
                         * Calls GetServicesForEventStream.
                         * @param request GetServicesForEventStreamReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and GetServicesForEventStreamResp
                         */
                        public getServicesForEventStream(request: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq, callback: code.justin.tv.eventbus.controlplane.Services.GetServicesForEventStreamCallback): void;

                        /**
                         * Calls GetServicesForEventStream.
                         * @param request GetServicesForEventStreamReq message or plain object
                         * @returns Promise
                         */
                        public getServicesForEventStream(request: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq): Promise<code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp>;

                        /**
                         * Calls GetCloudFormationVersion.
                         * @param request GetCloudFormationVersionReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and GetCloudFormationVersionResp
                         */
                        public getCloudFormationVersion(request: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq, callback: code.justin.tv.eventbus.controlplane.Services.GetCloudFormationVersionCallback): void;

                        /**
                         * Calls GetCloudFormationVersion.
                         * @param request GetCloudFormationVersionReq message or plain object
                         * @returns Promise
                         */
                        public getCloudFormationVersion(request: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq): Promise<code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp>;

                        /**
                         * Calls CreateIAMRole.
                         * @param request CreateIAMRoleReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and CreateIAMRoleResp
                         */
                        public createIAMRole(request: code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq, callback: code.justin.tv.eventbus.controlplane.Services.CreateIAMRoleCallback): void;

                        /**
                         * Calls CreateIAMRole.
                         * @param request CreateIAMRoleReq message or plain object
                         * @returns Promise
                         */
                        public createIAMRole(request: code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq): Promise<code.justin.tv.eventbus.controlplane.CreateIAMRoleResp>;

                        /**
                         * Calls UpdateIAMRoleLabel.
                         * @param request UpdateIAMRoleLabelReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and UpdateIAMRoleLabelResp
                         */
                        public updateIAMRoleLabel(request: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq, callback: code.justin.tv.eventbus.controlplane.Services.UpdateIAMRoleLabelCallback): void;

                        /**
                         * Calls UpdateIAMRoleLabel.
                         * @param request UpdateIAMRoleLabelReq message or plain object
                         * @returns Promise
                         */
                        public updateIAMRoleLabel(request: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq): Promise<code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp>;

                        /**
                         * Calls ValidateIAMRole.
                         * @param request ValidateIAMRoleReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ValidateIAMRoleResp
                         */
                        public validateIAMRole(request: code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq, callback: code.justin.tv.eventbus.controlplane.Services.ValidateIAMRoleCallback): void;

                        /**
                         * Calls ValidateIAMRole.
                         * @param request ValidateIAMRoleReq message or plain object
                         * @returns Promise
                         */
                        public validateIAMRole(request: code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq): Promise<code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp>;
                    }

                    namespace Services {

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#list}.
                         * @param error Error, if any
                         * @param [response] ListServicesResp
                         */
                        type ListCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ListServicesResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#get}.
                         * @param error Error, if any
                         * @param [response] Service
                         */
                        type GetCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.Service) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#create}.
                         * @param error Error, if any
                         * @param [response] CreateServiceResp
                         */
                        type CreateCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.CreateServiceResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#update}.
                         * @param error Error, if any
                         * @param [response] UpdateServiceResp
                         */
                        type UpdateCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.UpdateServiceResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#getAuthorizedFieldGrants}.
                         * @param error Error, if any
                         * @param [response] GetAuthorizedFieldGrantsResp
                         */
                        type GetAuthorizedFieldGrantsCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#requestorLDAPGroups}.
                         * @param error Error, if any
                         * @param [response] RequestorLDAPGroupsResp
                         */
                        type RequestorLDAPGroupsCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#resolveLDAPGroupUsers}.
                         * @param error Error, if any
                         * @param [response] ResolveLDAPGroupUsersResp
                         */
                        type ResolveLDAPGroupUsersCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#deleteIAMRole}.
                         * @param error Error, if any
                         * @param [response] DeleteIAMRoleResp
                         */
                        type DeleteIAMRoleCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#getServicesForEventStream}.
                         * @param error Error, if any
                         * @param [response] GetServicesForEventStreamResp
                         */
                        type GetServicesForEventStreamCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#getCloudFormationVersion}.
                         * @param error Error, if any
                         * @param [response] GetCloudFormationVersionResp
                         */
                        type GetCloudFormationVersionCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#createIAMRole}.
                         * @param error Error, if any
                         * @param [response] CreateIAMRoleResp
                         */
                        type CreateIAMRoleCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.CreateIAMRoleResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#updateIAMRoleLabel}.
                         * @param error Error, if any
                         * @param [response] UpdateIAMRoleLabelResp
                         */
                        type UpdateIAMRoleLabelCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#validateIAMRole}.
                         * @param error Error, if any
                         * @param [response] ValidateIAMRoleResp
                         */
                        type ValidateIAMRoleCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp) => void;
                    }

                    /** Properties of a ListServicesReq. */
                    interface IListServicesReq {
                    }

                    /** Represents a ListServicesReq. */
                    class ListServicesReq implements IListServicesReq {

                        /**
                         * Constructs a new ListServicesReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListServicesReq);

                        /**
                         * Creates a new ListServicesReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListServicesReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListServicesReq): code.justin.tv.eventbus.controlplane.ListServicesReq;

                        /**
                         * Encodes the specified ListServicesReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesReq.verify|verify} messages.
                         * @param message ListServicesReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListServicesReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListServicesReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesReq.verify|verify} messages.
                         * @param message ListServicesReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListServicesReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListServicesReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListServicesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListServicesReq;

                        /**
                         * Decodes a ListServicesReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListServicesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListServicesReq;

                        /**
                         * Verifies a ListServicesReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListServicesReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListServicesReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListServicesReq;

                        /**
                         * Creates a plain object from a ListServicesReq message. Also converts values to other types if specified.
                         * @param message ListServicesReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListServicesReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListServicesReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ListServicesResp. */
                    interface IListServicesResp {

                        /** ListServicesResp services */
                        services?: (code.justin.tv.eventbus.controlplane.IService[]|null);
                    }

                    /** Represents a ListServicesResp. */
                    class ListServicesResp implements IListServicesResp {

                        /**
                         * Constructs a new ListServicesResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IListServicesResp);

                        /** ListServicesResp services. */
                        public services: code.justin.tv.eventbus.controlplane.IService[];

                        /**
                         * Creates a new ListServicesResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ListServicesResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IListServicesResp): code.justin.tv.eventbus.controlplane.ListServicesResp;

                        /**
                         * Encodes the specified ListServicesResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesResp.verify|verify} messages.
                         * @param message ListServicesResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IListServicesResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ListServicesResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesResp.verify|verify} messages.
                         * @param message ListServicesResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IListServicesResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ListServicesResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ListServicesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ListServicesResp;

                        /**
                         * Decodes a ListServicesResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ListServicesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ListServicesResp;

                        /**
                         * Verifies a ListServicesResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ListServicesResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ListServicesResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ListServicesResp;

                        /**
                         * Creates a plain object from a ListServicesResp message. Also converts values to other types if specified.
                         * @param message ListServicesResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ListServicesResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ListServicesResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetServiceReq. */
                    interface IGetServiceReq {

                        /** GetServiceReq id */
                        id?: (string|null);
                    }

                    /** Represents a GetServiceReq. */
                    class GetServiceReq implements IGetServiceReq {

                        /**
                         * Constructs a new GetServiceReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetServiceReq);

                        /** GetServiceReq id. */
                        public id: string;

                        /**
                         * Creates a new GetServiceReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetServiceReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetServiceReq): code.justin.tv.eventbus.controlplane.GetServiceReq;

                        /**
                         * Encodes the specified GetServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServiceReq.verify|verify} messages.
                         * @param message GetServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServiceReq.verify|verify} messages.
                         * @param message GetServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetServiceReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetServiceReq;

                        /**
                         * Decodes a GetServiceReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetServiceReq;

                        /**
                         * Verifies a GetServiceReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetServiceReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetServiceReq;

                        /**
                         * Creates a plain object from a GetServiceReq message. Also converts values to other types if specified.
                         * @param message GetServiceReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetServiceReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetServiceReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateServiceReq. */
                    interface ICreateServiceReq {

                        /** CreateServiceReq service */
                        service?: (code.justin.tv.eventbus.controlplane.IService|null);
                    }

                    /** Represents a CreateServiceReq. */
                    class CreateServiceReq implements ICreateServiceReq {

                        /**
                         * Constructs a new CreateServiceReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateServiceReq);

                        /** CreateServiceReq service. */
                        public service?: (code.justin.tv.eventbus.controlplane.IService|null);

                        /**
                         * Creates a new CreateServiceReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateServiceReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateServiceReq): code.justin.tv.eventbus.controlplane.CreateServiceReq;

                        /**
                         * Encodes the specified CreateServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceReq.verify|verify} messages.
                         * @param message CreateServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceReq.verify|verify} messages.
                         * @param message CreateServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateServiceReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateServiceReq;

                        /**
                         * Decodes a CreateServiceReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateServiceReq;

                        /**
                         * Verifies a CreateServiceReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateServiceReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateServiceReq;

                        /**
                         * Creates a plain object from a CreateServiceReq message. Also converts values to other types if specified.
                         * @param message CreateServiceReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateServiceReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateServiceReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateServiceResp. */
                    interface ICreateServiceResp {

                        /** CreateServiceResp service */
                        service?: (code.justin.tv.eventbus.controlplane.IService|null);
                    }

                    /** Represents a CreateServiceResp. */
                    class CreateServiceResp implements ICreateServiceResp {

                        /**
                         * Constructs a new CreateServiceResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateServiceResp);

                        /** CreateServiceResp service. */
                        public service?: (code.justin.tv.eventbus.controlplane.IService|null);

                        /**
                         * Creates a new CreateServiceResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateServiceResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateServiceResp): code.justin.tv.eventbus.controlplane.CreateServiceResp;

                        /**
                         * Encodes the specified CreateServiceResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceResp.verify|verify} messages.
                         * @param message CreateServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateServiceResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceResp.verify|verify} messages.
                         * @param message CreateServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateServiceResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateServiceResp;

                        /**
                         * Decodes a CreateServiceResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateServiceResp;

                        /**
                         * Verifies a CreateServiceResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateServiceResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateServiceResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateServiceResp;

                        /**
                         * Creates a plain object from a CreateServiceResp message. Also converts values to other types if specified.
                         * @param message CreateServiceResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateServiceResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateServiceResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an UpdateServiceReq. */
                    interface IUpdateServiceReq {

                        /** UpdateServiceReq service */
                        service?: (code.justin.tv.eventbus.controlplane.IService|null);
                    }

                    /** Represents an UpdateServiceReq. */
                    class UpdateServiceReq implements IUpdateServiceReq {

                        /**
                         * Constructs a new UpdateServiceReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IUpdateServiceReq);

                        /** UpdateServiceReq service. */
                        public service?: (code.justin.tv.eventbus.controlplane.IService|null);

                        /**
                         * Creates a new UpdateServiceReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns UpdateServiceReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IUpdateServiceReq): code.justin.tv.eventbus.controlplane.UpdateServiceReq;

                        /**
                         * Encodes the specified UpdateServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceReq.verify|verify} messages.
                         * @param message UpdateServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IUpdateServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified UpdateServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceReq.verify|verify} messages.
                         * @param message UpdateServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IUpdateServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an UpdateServiceReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns UpdateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.UpdateServiceReq;

                        /**
                         * Decodes an UpdateServiceReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns UpdateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.UpdateServiceReq;

                        /**
                         * Verifies an UpdateServiceReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an UpdateServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns UpdateServiceReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.UpdateServiceReq;

                        /**
                         * Creates a plain object from an UpdateServiceReq message. Also converts values to other types if specified.
                         * @param message UpdateServiceReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.UpdateServiceReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this UpdateServiceReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an UpdateServiceResp. */
                    interface IUpdateServiceResp {

                        /** UpdateServiceResp service */
                        service?: (code.justin.tv.eventbus.controlplane.IService|null);
                    }

                    /** Represents an UpdateServiceResp. */
                    class UpdateServiceResp implements IUpdateServiceResp {

                        /**
                         * Constructs a new UpdateServiceResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IUpdateServiceResp);

                        /** UpdateServiceResp service. */
                        public service?: (code.justin.tv.eventbus.controlplane.IService|null);

                        /**
                         * Creates a new UpdateServiceResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns UpdateServiceResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IUpdateServiceResp): code.justin.tv.eventbus.controlplane.UpdateServiceResp;

                        /**
                         * Encodes the specified UpdateServiceResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceResp.verify|verify} messages.
                         * @param message UpdateServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IUpdateServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified UpdateServiceResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceResp.verify|verify} messages.
                         * @param message UpdateServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IUpdateServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an UpdateServiceResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns UpdateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.UpdateServiceResp;

                        /**
                         * Decodes an UpdateServiceResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns UpdateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.UpdateServiceResp;

                        /**
                         * Verifies an UpdateServiceResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an UpdateServiceResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns UpdateServiceResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.UpdateServiceResp;

                        /**
                         * Creates a plain object from an UpdateServiceResp message. Also converts values to other types if specified.
                         * @param message UpdateServiceResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.UpdateServiceResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this UpdateServiceResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a Service. */
                    interface IService {

                        /** Service id */
                        id?: (string|null);

                        /** Service name */
                        name?: (string|null);

                        /** Service serviceCatalogUrl */
                        serviceCatalogUrl?: (string|null);

                        /** Service description */
                        description?: (string|null);

                        /** Service accounts */
                        accounts?: (code.justin.tv.eventbus.controlplane.IAccount[]|null);

                        /** Service ldapGroup */
                        ldapGroup?: (string|null);

                        /** Service iamRoles */
                        iamRoles?: (code.justin.tv.eventbus.controlplane.IIAMRole[]|null);
                    }

                    /** Represents a Service. */
                    class Service implements IService {

                        /**
                         * Constructs a new Service.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IService);

                        /** Service id. */
                        public id: string;

                        /** Service name. */
                        public name: string;

                        /** Service serviceCatalogUrl. */
                        public serviceCatalogUrl: string;

                        /** Service description. */
                        public description: string;

                        /** Service accounts. */
                        public accounts: code.justin.tv.eventbus.controlplane.IAccount[];

                        /** Service ldapGroup. */
                        public ldapGroup: string;

                        /** Service iamRoles. */
                        public iamRoles: code.justin.tv.eventbus.controlplane.IIAMRole[];

                        /**
                         * Creates a new Service instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Service instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IService): code.justin.tv.eventbus.controlplane.Service;

                        /**
                         * Encodes the specified Service message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Service.verify|verify} messages.
                         * @param message Service message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IService, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Service message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Service.verify|verify} messages.
                         * @param message Service message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IService, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Service message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Service
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.Service;

                        /**
                         * Decodes a Service message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Service
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.Service;

                        /**
                         * Verifies a Service message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Service message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Service
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.Service;

                        /**
                         * Creates a plain object from a Service message. Also converts values to other types if specified.
                         * @param message Service
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.Service, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Service to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an Account. */
                    interface IAccount {

                        /** Account id */
                        id?: (string|null);

                        /** Account label */
                        label?: (string|null);

                        /** Account cloudformationStatus */
                        cloudformationStatus?: (string|null);
                    }

                    /** Represents an Account. */
                    class Account implements IAccount {

                        /**
                         * Constructs a new Account.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IAccount);

                        /** Account id. */
                        public id: string;

                        /** Account label. */
                        public label: string;

                        /** Account cloudformationStatus. */
                        public cloudformationStatus: string;

                        /**
                         * Creates a new Account instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Account instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IAccount): code.justin.tv.eventbus.controlplane.Account;

                        /**
                         * Encodes the specified Account message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Account.verify|verify} messages.
                         * @param message Account message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IAccount, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Account message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Account.verify|verify} messages.
                         * @param message Account message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IAccount, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an Account message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Account
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.Account;

                        /**
                         * Decodes an Account message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Account
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.Account;

                        /**
                         * Verifies an Account message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an Account message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Account
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.Account;

                        /**
                         * Creates a plain object from an Account message. Also converts values to other types if specified.
                         * @param message Account
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.Account, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Account to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a RequestorLDAPGroupsReq. */
                    interface IRequestorLDAPGroupsReq {
                    }

                    /** Represents a RequestorLDAPGroupsReq. */
                    class RequestorLDAPGroupsReq implements IRequestorLDAPGroupsReq {

                        /**
                         * Constructs a new RequestorLDAPGroupsReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq);

                        /**
                         * Creates a new RequestorLDAPGroupsReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns RequestorLDAPGroupsReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq;

                        /**
                         * Encodes the specified RequestorLDAPGroupsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq.verify|verify} messages.
                         * @param message RequestorLDAPGroupsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified RequestorLDAPGroupsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq.verify|verify} messages.
                         * @param message RequestorLDAPGroupsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a RequestorLDAPGroupsReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns RequestorLDAPGroupsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq;

                        /**
                         * Decodes a RequestorLDAPGroupsReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns RequestorLDAPGroupsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq;

                        /**
                         * Verifies a RequestorLDAPGroupsReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a RequestorLDAPGroupsReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns RequestorLDAPGroupsReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq;

                        /**
                         * Creates a plain object from a RequestorLDAPGroupsReq message. Also converts values to other types if specified.
                         * @param message RequestorLDAPGroupsReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this RequestorLDAPGroupsReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a RequestorLDAPGroupsResp. */
                    interface IRequestorLDAPGroupsResp {

                        /** RequestorLDAPGroupsResp ldapGroups */
                        ldapGroups?: (string[]|null);
                    }

                    /** Represents a RequestorLDAPGroupsResp. */
                    class RequestorLDAPGroupsResp implements IRequestorLDAPGroupsResp {

                        /**
                         * Constructs a new RequestorLDAPGroupsResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp);

                        /** RequestorLDAPGroupsResp ldapGroups. */
                        public ldapGroups: string[];

                        /**
                         * Creates a new RequestorLDAPGroupsResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns RequestorLDAPGroupsResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp;

                        /**
                         * Encodes the specified RequestorLDAPGroupsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp.verify|verify} messages.
                         * @param message RequestorLDAPGroupsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified RequestorLDAPGroupsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp.verify|verify} messages.
                         * @param message RequestorLDAPGroupsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a RequestorLDAPGroupsResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns RequestorLDAPGroupsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp;

                        /**
                         * Decodes a RequestorLDAPGroupsResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns RequestorLDAPGroupsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp;

                        /**
                         * Verifies a RequestorLDAPGroupsResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a RequestorLDAPGroupsResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns RequestorLDAPGroupsResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp;

                        /**
                         * Creates a plain object from a RequestorLDAPGroupsResp message. Also converts values to other types if specified.
                         * @param message RequestorLDAPGroupsResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this RequestorLDAPGroupsResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ResolveLDAPGroupUsersReq. */
                    interface IResolveLDAPGroupUsersReq {

                        /** ResolveLDAPGroupUsersReq ldapGroup */
                        ldapGroup?: (string|null);
                    }

                    /** Represents a ResolveLDAPGroupUsersReq. */
                    class ResolveLDAPGroupUsersReq implements IResolveLDAPGroupUsersReq {

                        /**
                         * Constructs a new ResolveLDAPGroupUsersReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq);

                        /** ResolveLDAPGroupUsersReq ldapGroup. */
                        public ldapGroup: string;

                        /**
                         * Creates a new ResolveLDAPGroupUsersReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ResolveLDAPGroupUsersReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq;

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq.verify|verify} messages.
                         * @param message ResolveLDAPGroupUsersReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq.verify|verify} messages.
                         * @param message ResolveLDAPGroupUsersReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ResolveLDAPGroupUsersReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ResolveLDAPGroupUsersReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq;

                        /**
                         * Decodes a ResolveLDAPGroupUsersReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ResolveLDAPGroupUsersReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq;

                        /**
                         * Verifies a ResolveLDAPGroupUsersReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ResolveLDAPGroupUsersReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ResolveLDAPGroupUsersReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq;

                        /**
                         * Creates a plain object from a ResolveLDAPGroupUsersReq message. Also converts values to other types if specified.
                         * @param message ResolveLDAPGroupUsersReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ResolveLDAPGroupUsersReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ResolveLDAPGroupUsersResp. */
                    interface IResolveLDAPGroupUsersResp {

                        /** ResolveLDAPGroupUsersResp ldapEntries */
                        ldapEntries?: (code.justin.tv.eventbus.controlplane.ILDAPEntry[]|null);
                    }

                    /** Represents a ResolveLDAPGroupUsersResp. */
                    class ResolveLDAPGroupUsersResp implements IResolveLDAPGroupUsersResp {

                        /**
                         * Constructs a new ResolveLDAPGroupUsersResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp);

                        /** ResolveLDAPGroupUsersResp ldapEntries. */
                        public ldapEntries: code.justin.tv.eventbus.controlplane.ILDAPEntry[];

                        /**
                         * Creates a new ResolveLDAPGroupUsersResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ResolveLDAPGroupUsersResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp;

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp.verify|verify} messages.
                         * @param message ResolveLDAPGroupUsersResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp.verify|verify} messages.
                         * @param message ResolveLDAPGroupUsersResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ResolveLDAPGroupUsersResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ResolveLDAPGroupUsersResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp;

                        /**
                         * Decodes a ResolveLDAPGroupUsersResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ResolveLDAPGroupUsersResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp;

                        /**
                         * Verifies a ResolveLDAPGroupUsersResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ResolveLDAPGroupUsersResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ResolveLDAPGroupUsersResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp;

                        /**
                         * Creates a plain object from a ResolveLDAPGroupUsersResp message. Also converts values to other types if specified.
                         * @param message ResolveLDAPGroupUsersResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ResolveLDAPGroupUsersResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a LDAPEntry. */
                    interface ILDAPEntry {

                        /** LDAPEntry commonName */
                        commonName?: (string|null);

                        /** LDAPEntry uid */
                        uid?: (string|null);
                    }

                    /** Represents a LDAPEntry. */
                    class LDAPEntry implements ILDAPEntry {

                        /**
                         * Constructs a new LDAPEntry.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ILDAPEntry);

                        /** LDAPEntry commonName. */
                        public commonName: string;

                        /** LDAPEntry uid. */
                        public uid: string;

                        /**
                         * Creates a new LDAPEntry instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns LDAPEntry instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ILDAPEntry): code.justin.tv.eventbus.controlplane.LDAPEntry;

                        /**
                         * Encodes the specified LDAPEntry message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.LDAPEntry.verify|verify} messages.
                         * @param message LDAPEntry message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ILDAPEntry, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified LDAPEntry message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.LDAPEntry.verify|verify} messages.
                         * @param message LDAPEntry message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ILDAPEntry, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a LDAPEntry message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns LDAPEntry
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.LDAPEntry;

                        /**
                         * Decodes a LDAPEntry message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns LDAPEntry
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.LDAPEntry;

                        /**
                         * Verifies a LDAPEntry message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a LDAPEntry message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns LDAPEntry
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.LDAPEntry;

                        /**
                         * Creates a plain object from a LDAPEntry message. Also converts values to other types if specified.
                         * @param message LDAPEntry
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.LDAPEntry, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this LDAPEntry to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetAuthorizedFieldGrantsReq. */
                    interface IGetAuthorizedFieldGrantsReq {

                        /** GetAuthorizedFieldGrantsReq serviceId */
                        serviceId?: (string|null);
                    }

                    /** Represents a GetAuthorizedFieldGrantsReq. */
                    class GetAuthorizedFieldGrantsReq implements IGetAuthorizedFieldGrantsReq {

                        /**
                         * Constructs a new GetAuthorizedFieldGrantsReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq);

                        /** GetAuthorizedFieldGrantsReq serviceId. */
                        public serviceId: string;

                        /**
                         * Creates a new GetAuthorizedFieldGrantsReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetAuthorizedFieldGrantsReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq;

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq.verify|verify} messages.
                         * @param message GetAuthorizedFieldGrantsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq.verify|verify} messages.
                         * @param message GetAuthorizedFieldGrantsReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetAuthorizedFieldGrantsReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetAuthorizedFieldGrantsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq;

                        /**
                         * Decodes a GetAuthorizedFieldGrantsReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetAuthorizedFieldGrantsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq;

                        /**
                         * Verifies a GetAuthorizedFieldGrantsReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetAuthorizedFieldGrantsReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetAuthorizedFieldGrantsReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq;

                        /**
                         * Creates a plain object from a GetAuthorizedFieldGrantsReq message. Also converts values to other types if specified.
                         * @param message GetAuthorizedFieldGrantsReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetAuthorizedFieldGrantsReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetAuthorizedFieldGrantsResp. */
                    interface IGetAuthorizedFieldGrantsResp {

                        /** GetAuthorizedFieldGrantsResp subscriberGrants */
                        subscriberGrants?: (code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant[]|null);

                        /** GetAuthorizedFieldGrantsResp publisherGrants */
                        publisherGrants?: (code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant[]|null);
                    }

                    /** Represents a GetAuthorizedFieldGrantsResp. */
                    class GetAuthorizedFieldGrantsResp implements IGetAuthorizedFieldGrantsResp {

                        /**
                         * Constructs a new GetAuthorizedFieldGrantsResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp);

                        /** GetAuthorizedFieldGrantsResp subscriberGrants. */
                        public subscriberGrants: code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant[];

                        /** GetAuthorizedFieldGrantsResp publisherGrants. */
                        public publisherGrants: code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant[];

                        /**
                         * Creates a new GetAuthorizedFieldGrantsResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetAuthorizedFieldGrantsResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp;

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.verify|verify} messages.
                         * @param message GetAuthorizedFieldGrantsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.verify|verify} messages.
                         * @param message GetAuthorizedFieldGrantsResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetAuthorizedFieldGrantsResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetAuthorizedFieldGrantsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp;

                        /**
                         * Decodes a GetAuthorizedFieldGrantsResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetAuthorizedFieldGrantsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp;

                        /**
                         * Verifies a GetAuthorizedFieldGrantsResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetAuthorizedFieldGrantsResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetAuthorizedFieldGrantsResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp;

                        /**
                         * Creates a plain object from a GetAuthorizedFieldGrantsResp message. Also converts values to other types if specified.
                         * @param message GetAuthorizedFieldGrantsResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetAuthorizedFieldGrantsResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an AuthorizedFieldPublisherGrant. */
                    interface IAuthorizedFieldPublisherGrant {

                        /** AuthorizedFieldPublisherGrant iamRole */
                        iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);

                        /** AuthorizedFieldPublisherGrant eventType */
                        eventType?: (string|null);

                        /** AuthorizedFieldPublisherGrant environment */
                        environment?: (string|null);
                    }

                    /** Represents an AuthorizedFieldPublisherGrant. */
                    class AuthorizedFieldPublisherGrant implements IAuthorizedFieldPublisherGrant {

                        /**
                         * Constructs a new AuthorizedFieldPublisherGrant.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant);

                        /** AuthorizedFieldPublisherGrant iamRole. */
                        public iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);

                        /** AuthorizedFieldPublisherGrant eventType. */
                        public eventType: string;

                        /** AuthorizedFieldPublisherGrant environment. */
                        public environment: string;

                        /**
                         * Creates a new AuthorizedFieldPublisherGrant instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns AuthorizedFieldPublisherGrant instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant): code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant;

                        /**
                         * Encodes the specified AuthorizedFieldPublisherGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.verify|verify} messages.
                         * @param message AuthorizedFieldPublisherGrant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified AuthorizedFieldPublisherGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.verify|verify} messages.
                         * @param message AuthorizedFieldPublisherGrant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an AuthorizedFieldPublisherGrant message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns AuthorizedFieldPublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant;

                        /**
                         * Decodes an AuthorizedFieldPublisherGrant message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns AuthorizedFieldPublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant;

                        /**
                         * Verifies an AuthorizedFieldPublisherGrant message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an AuthorizedFieldPublisherGrant message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns AuthorizedFieldPublisherGrant
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant;

                        /**
                         * Creates a plain object from an AuthorizedFieldPublisherGrant message. Also converts values to other types if specified.
                         * @param message AuthorizedFieldPublisherGrant
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this AuthorizedFieldPublisherGrant to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteIAMRoleReq. */
                    interface IDeleteIAMRoleReq {

                        /** DeleteIAMRoleReq arn */
                        arn?: (string|null);
                    }

                    /** Represents a DeleteIAMRoleReq. */
                    class DeleteIAMRoleReq implements IDeleteIAMRoleReq {

                        /**
                         * Constructs a new DeleteIAMRoleReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq);

                        /** DeleteIAMRoleReq arn. */
                        public arn: string;

                        /**
                         * Creates a new DeleteIAMRoleReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteIAMRoleReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq): code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq;

                        /**
                         * Encodes the specified DeleteIAMRoleReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq.verify|verify} messages.
                         * @param message DeleteIAMRoleReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteIAMRoleReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq.verify|verify} messages.
                         * @param message DeleteIAMRoleReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteIAMRoleReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq;

                        /**
                         * Decodes a DeleteIAMRoleReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq;

                        /**
                         * Verifies a DeleteIAMRoleReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteIAMRoleReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteIAMRoleReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq;

                        /**
                         * Creates a plain object from a DeleteIAMRoleReq message. Also converts values to other types if specified.
                         * @param message DeleteIAMRoleReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteIAMRoleReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteIAMRoleResp. */
                    interface IDeleteIAMRoleResp {
                    }

                    /** Represents a DeleteIAMRoleResp. */
                    class DeleteIAMRoleResp implements IDeleteIAMRoleResp {

                        /**
                         * Constructs a new DeleteIAMRoleResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp);

                        /**
                         * Creates a new DeleteIAMRoleResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteIAMRoleResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp): code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp;

                        /**
                         * Encodes the specified DeleteIAMRoleResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp.verify|verify} messages.
                         * @param message DeleteIAMRoleResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteIAMRoleResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp.verify|verify} messages.
                         * @param message DeleteIAMRoleResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteIAMRoleResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp;

                        /**
                         * Decodes a DeleteIAMRoleResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp;

                        /**
                         * Verifies a DeleteIAMRoleResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteIAMRoleResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteIAMRoleResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp;

                        /**
                         * Creates a plain object from a DeleteIAMRoleResp message. Also converts values to other types if specified.
                         * @param message DeleteIAMRoleResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteIAMRoleResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetServicesForEventStreamReq. */
                    interface IGetServicesForEventStreamReq {

                        /** GetServicesForEventStreamReq eventType */
                        eventType?: (string|null);
                    }

                    /** Represents a GetServicesForEventStreamReq. */
                    class GetServicesForEventStreamReq implements IGetServicesForEventStreamReq {

                        /**
                         * Constructs a new GetServicesForEventStreamReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq);

                        /** GetServicesForEventStreamReq eventType. */
                        public eventType: string;

                        /**
                         * Creates a new GetServicesForEventStreamReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetServicesForEventStreamReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq;

                        /**
                         * Encodes the specified GetServicesForEventStreamReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq.verify|verify} messages.
                         * @param message GetServicesForEventStreamReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetServicesForEventStreamReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq.verify|verify} messages.
                         * @param message GetServicesForEventStreamReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetServicesForEventStreamReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetServicesForEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq;

                        /**
                         * Decodes a GetServicesForEventStreamReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetServicesForEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq;

                        /**
                         * Verifies a GetServicesForEventStreamReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetServicesForEventStreamReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetServicesForEventStreamReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq;

                        /**
                         * Creates a plain object from a GetServicesForEventStreamReq message. Also converts values to other types if specified.
                         * @param message GetServicesForEventStreamReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetServicesForEventStreamReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetServicesForEventStreamResp. */
                    interface IGetServicesForEventStreamResp {

                        /** GetServicesForEventStreamResp services */
                        services?: (code.justin.tv.eventbus.controlplane.IService[]|null);
                    }

                    /** Represents a GetServicesForEventStreamResp. */
                    class GetServicesForEventStreamResp implements IGetServicesForEventStreamResp {

                        /**
                         * Constructs a new GetServicesForEventStreamResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp);

                        /** GetServicesForEventStreamResp services. */
                        public services: code.justin.tv.eventbus.controlplane.IService[];

                        /**
                         * Creates a new GetServicesForEventStreamResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetServicesForEventStreamResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp;

                        /**
                         * Encodes the specified GetServicesForEventStreamResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp.verify|verify} messages.
                         * @param message GetServicesForEventStreamResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetServicesForEventStreamResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp.verify|verify} messages.
                         * @param message GetServicesForEventStreamResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetServicesForEventStreamResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetServicesForEventStreamResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp;

                        /**
                         * Decodes a GetServicesForEventStreamResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetServicesForEventStreamResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp;

                        /**
                         * Verifies a GetServicesForEventStreamResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetServicesForEventStreamResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetServicesForEventStreamResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp;

                        /**
                         * Creates a plain object from a GetServicesForEventStreamResp message. Also converts values to other types if specified.
                         * @param message GetServicesForEventStreamResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetServicesForEventStreamResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetCloudFormationVersionReq. */
                    interface IGetCloudFormationVersionReq {

                        /** GetCloudFormationVersionReq iamRole */
                        iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);
                    }

                    /** Represents a GetCloudFormationVersionReq. */
                    class GetCloudFormationVersionReq implements IGetCloudFormationVersionReq {

                        /**
                         * Constructs a new GetCloudFormationVersionReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq);

                        /** GetCloudFormationVersionReq iamRole. */
                        public iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);

                        /**
                         * Creates a new GetCloudFormationVersionReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetCloudFormationVersionReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq;

                        /**
                         * Encodes the specified GetCloudFormationVersionReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq.verify|verify} messages.
                         * @param message GetCloudFormationVersionReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetCloudFormationVersionReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq.verify|verify} messages.
                         * @param message GetCloudFormationVersionReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetCloudFormationVersionReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetCloudFormationVersionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq;

                        /**
                         * Decodes a GetCloudFormationVersionReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetCloudFormationVersionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq;

                        /**
                         * Verifies a GetCloudFormationVersionReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetCloudFormationVersionReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetCloudFormationVersionReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq;

                        /**
                         * Creates a plain object from a GetCloudFormationVersionReq message. Also converts values to other types if specified.
                         * @param message GetCloudFormationVersionReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetCloudFormationVersionReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetCloudFormationVersionResp. */
                    interface IGetCloudFormationVersionResp {

                        /** GetCloudFormationVersionResp version */
                        version?: (string|null);
                    }

                    /** Represents a GetCloudFormationVersionResp. */
                    class GetCloudFormationVersionResp implements IGetCloudFormationVersionResp {

                        /**
                         * Constructs a new GetCloudFormationVersionResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp);

                        /** GetCloudFormationVersionResp version. */
                        public version: string;

                        /**
                         * Creates a new GetCloudFormationVersionResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetCloudFormationVersionResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp;

                        /**
                         * Encodes the specified GetCloudFormationVersionResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp.verify|verify} messages.
                         * @param message GetCloudFormationVersionResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetCloudFormationVersionResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp.verify|verify} messages.
                         * @param message GetCloudFormationVersionResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetCloudFormationVersionResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetCloudFormationVersionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp;

                        /**
                         * Decodes a GetCloudFormationVersionResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetCloudFormationVersionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp;

                        /**
                         * Verifies a GetCloudFormationVersionResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetCloudFormationVersionResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetCloudFormationVersionResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp;

                        /**
                         * Creates a plain object from a GetCloudFormationVersionResp message. Also converts values to other types if specified.
                         * @param message GetCloudFormationVersionResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetCloudFormationVersionResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateIAMRoleReq. */
                    interface ICreateIAMRoleReq {

                        /** CreateIAMRoleReq serviceId */
                        serviceId?: (string|null);

                        /** CreateIAMRoleReq iamRole */
                        iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);
                    }

                    /** Represents a CreateIAMRoleReq. */
                    class CreateIAMRoleReq implements ICreateIAMRoleReq {

                        /**
                         * Constructs a new CreateIAMRoleReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq);

                        /** CreateIAMRoleReq serviceId. */
                        public serviceId: string;

                        /** CreateIAMRoleReq iamRole. */
                        public iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);

                        /**
                         * Creates a new CreateIAMRoleReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateIAMRoleReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq): code.justin.tv.eventbus.controlplane.CreateIAMRoleReq;

                        /**
                         * Encodes the specified CreateIAMRoleReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleReq.verify|verify} messages.
                         * @param message CreateIAMRoleReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateIAMRoleReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleReq.verify|verify} messages.
                         * @param message CreateIAMRoleReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateIAMRoleReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateIAMRoleReq;

                        /**
                         * Decodes a CreateIAMRoleReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateIAMRoleReq;

                        /**
                         * Verifies a CreateIAMRoleReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateIAMRoleReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateIAMRoleReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateIAMRoleReq;

                        /**
                         * Creates a plain object from a CreateIAMRoleReq message. Also converts values to other types if specified.
                         * @param message CreateIAMRoleReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateIAMRoleReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateIAMRoleReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateIAMRoleResp. */
                    interface ICreateIAMRoleResp {

                        /** CreateIAMRoleResp iamRole */
                        iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);
                    }

                    /** Represents a CreateIAMRoleResp. */
                    class CreateIAMRoleResp implements ICreateIAMRoleResp {

                        /**
                         * Constructs a new CreateIAMRoleResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp);

                        /** CreateIAMRoleResp iamRole. */
                        public iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);

                        /**
                         * Creates a new CreateIAMRoleResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateIAMRoleResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp): code.justin.tv.eventbus.controlplane.CreateIAMRoleResp;

                        /**
                         * Encodes the specified CreateIAMRoleResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleResp.verify|verify} messages.
                         * @param message CreateIAMRoleResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateIAMRoleResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleResp.verify|verify} messages.
                         * @param message CreateIAMRoleResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateIAMRoleResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateIAMRoleResp;

                        /**
                         * Decodes a CreateIAMRoleResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateIAMRoleResp;

                        /**
                         * Verifies a CreateIAMRoleResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateIAMRoleResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateIAMRoleResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateIAMRoleResp;

                        /**
                         * Creates a plain object from a CreateIAMRoleResp message. Also converts values to other types if specified.
                         * @param message CreateIAMRoleResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateIAMRoleResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateIAMRoleResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an UpdateIAMRoleLabelReq. */
                    interface IUpdateIAMRoleLabelReq {

                        /** UpdateIAMRoleLabelReq arn */
                        arn?: (string|null);

                        /** UpdateIAMRoleLabelReq label */
                        label?: (string|null);
                    }

                    /** Represents an UpdateIAMRoleLabelReq. */
                    class UpdateIAMRoleLabelReq implements IUpdateIAMRoleLabelReq {

                        /**
                         * Constructs a new UpdateIAMRoleLabelReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq);

                        /** UpdateIAMRoleLabelReq arn. */
                        public arn: string;

                        /** UpdateIAMRoleLabelReq label. */
                        public label: string;

                        /**
                         * Creates a new UpdateIAMRoleLabelReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns UpdateIAMRoleLabelReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq;

                        /**
                         * Encodes the specified UpdateIAMRoleLabelReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq.verify|verify} messages.
                         * @param message UpdateIAMRoleLabelReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified UpdateIAMRoleLabelReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq.verify|verify} messages.
                         * @param message UpdateIAMRoleLabelReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an UpdateIAMRoleLabelReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns UpdateIAMRoleLabelReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq;

                        /**
                         * Decodes an UpdateIAMRoleLabelReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns UpdateIAMRoleLabelReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq;

                        /**
                         * Verifies an UpdateIAMRoleLabelReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an UpdateIAMRoleLabelReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns UpdateIAMRoleLabelReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq;

                        /**
                         * Creates a plain object from an UpdateIAMRoleLabelReq message. Also converts values to other types if specified.
                         * @param message UpdateIAMRoleLabelReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this UpdateIAMRoleLabelReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an UpdateIAMRoleLabelResp. */
                    interface IUpdateIAMRoleLabelResp {

                        /** UpdateIAMRoleLabelResp arn */
                        arn?: (string|null);

                        /** UpdateIAMRoleLabelResp label */
                        label?: (string|null);
                    }

                    /** Represents an UpdateIAMRoleLabelResp. */
                    class UpdateIAMRoleLabelResp implements IUpdateIAMRoleLabelResp {

                        /**
                         * Constructs a new UpdateIAMRoleLabelResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp);

                        /** UpdateIAMRoleLabelResp arn. */
                        public arn: string;

                        /** UpdateIAMRoleLabelResp label. */
                        public label: string;

                        /**
                         * Creates a new UpdateIAMRoleLabelResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns UpdateIAMRoleLabelResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp;

                        /**
                         * Encodes the specified UpdateIAMRoleLabelResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp.verify|verify} messages.
                         * @param message UpdateIAMRoleLabelResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified UpdateIAMRoleLabelResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp.verify|verify} messages.
                         * @param message UpdateIAMRoleLabelResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an UpdateIAMRoleLabelResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns UpdateIAMRoleLabelResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp;

                        /**
                         * Decodes an UpdateIAMRoleLabelResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns UpdateIAMRoleLabelResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp;

                        /**
                         * Verifies an UpdateIAMRoleLabelResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an UpdateIAMRoleLabelResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns UpdateIAMRoleLabelResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp;

                        /**
                         * Creates a plain object from an UpdateIAMRoleLabelResp message. Also converts values to other types if specified.
                         * @param message UpdateIAMRoleLabelResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this UpdateIAMRoleLabelResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ValidateIAMRoleReq. */
                    interface IValidateIAMRoleReq {

                        /** ValidateIAMRoleReq arn */
                        arn?: (string|null);
                    }

                    /** Represents a ValidateIAMRoleReq. */
                    class ValidateIAMRoleReq implements IValidateIAMRoleReq {

                        /**
                         * Constructs a new ValidateIAMRoleReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq);

                        /** ValidateIAMRoleReq arn. */
                        public arn: string;

                        /**
                         * Creates a new ValidateIAMRoleReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ValidateIAMRoleReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq): code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq;

                        /**
                         * Encodes the specified ValidateIAMRoleReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq.verify|verify} messages.
                         * @param message ValidateIAMRoleReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ValidateIAMRoleReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq.verify|verify} messages.
                         * @param message ValidateIAMRoleReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ValidateIAMRoleReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ValidateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq;

                        /**
                         * Decodes a ValidateIAMRoleReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ValidateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq;

                        /**
                         * Verifies a ValidateIAMRoleReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ValidateIAMRoleReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ValidateIAMRoleReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq;

                        /**
                         * Creates a plain object from a ValidateIAMRoleReq message. Also converts values to other types if specified.
                         * @param message ValidateIAMRoleReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ValidateIAMRoleReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ValidateIAMRoleResp. */
                    interface IValidateIAMRoleResp {

                        /** ValidateIAMRoleResp isValid */
                        isValid?: (boolean|null);

                        /** ValidateIAMRoleResp message */
                        message?: (string|null);
                    }

                    /** Represents a ValidateIAMRoleResp. */
                    class ValidateIAMRoleResp implements IValidateIAMRoleResp {

                        /**
                         * Constructs a new ValidateIAMRoleResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp);

                        /** ValidateIAMRoleResp isValid. */
                        public isValid: boolean;

                        /** ValidateIAMRoleResp message. */
                        public message: string;

                        /**
                         * Creates a new ValidateIAMRoleResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ValidateIAMRoleResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp): code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp;

                        /**
                         * Encodes the specified ValidateIAMRoleResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp.verify|verify} messages.
                         * @param message ValidateIAMRoleResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ValidateIAMRoleResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp.verify|verify} messages.
                         * @param message ValidateIAMRoleResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ValidateIAMRoleResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ValidateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp;

                        /**
                         * Decodes a ValidateIAMRoleResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ValidateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp;

                        /**
                         * Verifies a ValidateIAMRoleResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ValidateIAMRoleResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ValidateIAMRoleResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp;

                        /**
                         * Creates a plain object from a ValidateIAMRoleResp message. Also converts values to other types if specified.
                         * @param message ValidateIAMRoleResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ValidateIAMRoleResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a IAMRole. */
                    interface IIAMRole {

                        /** IAMRole arn */
                        arn?: (string|null);

                        /** IAMRole label */
                        label?: (string|null);

                        /** IAMRole cloudformationStatus */
                        cloudformationStatus?: (string|null);

                        /** IAMRole id */
                        id?: (string|null);
                    }

                    /** Represents a IAMRole. */
                    class IAMRole implements IIAMRole {

                        /**
                         * Constructs a new IAMRole.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IIAMRole);

                        /** IAMRole arn. */
                        public arn: string;

                        /** IAMRole label. */
                        public label: string;

                        /** IAMRole cloudformationStatus. */
                        public cloudformationStatus: string;

                        /** IAMRole id. */
                        public id: string;

                        /**
                         * Creates a new IAMRole instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns IAMRole instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IIAMRole): code.justin.tv.eventbus.controlplane.IAMRole;

                        /**
                         * Encodes the specified IAMRole message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IAMRole.verify|verify} messages.
                         * @param message IAMRole message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IIAMRole, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified IAMRole message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IAMRole.verify|verify} messages.
                         * @param message IAMRole message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IIAMRole, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a IAMRole message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns IAMRole
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.IAMRole;

                        /**
                         * Decodes a IAMRole message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns IAMRole
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.IAMRole;

                        /**
                         * Verifies a IAMRole message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a IAMRole message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns IAMRole
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.IAMRole;

                        /**
                         * Creates a plain object from a IAMRole message. Also converts values to other types if specified.
                         * @param message IAMRole
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.IAMRole, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this IAMRole to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of an AuthorizedFieldSubscriberGrant. */
                    interface IAuthorizedFieldSubscriberGrant {

                        /** AuthorizedFieldSubscriberGrant iamRole */
                        iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);

                        /** AuthorizedFieldSubscriberGrant eventType */
                        eventType?: (string|null);

                        /** AuthorizedFieldSubscriberGrant environment */
                        environment?: (string|null);

                        /** AuthorizedFieldSubscriberGrant authorizedField */
                        authorizedField?: (code.justin.tv.eventbus.controlplane.IAuthorizedField|null);
                    }

                    /** Represents an AuthorizedFieldSubscriberGrant. */
                    class AuthorizedFieldSubscriberGrant implements IAuthorizedFieldSubscriberGrant {

                        /**
                         * Constructs a new AuthorizedFieldSubscriberGrant.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant);

                        /** AuthorizedFieldSubscriberGrant iamRole. */
                        public iamRole?: (code.justin.tv.eventbus.controlplane.IIAMRole|null);

                        /** AuthorizedFieldSubscriberGrant eventType. */
                        public eventType: string;

                        /** AuthorizedFieldSubscriberGrant environment. */
                        public environment: string;

                        /** AuthorizedFieldSubscriberGrant authorizedField. */
                        public authorizedField?: (code.justin.tv.eventbus.controlplane.IAuthorizedField|null);

                        /**
                         * Creates a new AuthorizedFieldSubscriberGrant instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns AuthorizedFieldSubscriberGrant instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant): code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant;

                        /**
                         * Encodes the specified AuthorizedFieldSubscriberGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.verify|verify} messages.
                         * @param message AuthorizedFieldSubscriberGrant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified AuthorizedFieldSubscriberGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.verify|verify} messages.
                         * @param message AuthorizedFieldSubscriberGrant message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes an AuthorizedFieldSubscriberGrant message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns AuthorizedFieldSubscriberGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant;

                        /**
                         * Decodes an AuthorizedFieldSubscriberGrant message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns AuthorizedFieldSubscriberGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant;

                        /**
                         * Verifies an AuthorizedFieldSubscriberGrant message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates an AuthorizedFieldSubscriberGrant message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns AuthorizedFieldSubscriberGrant
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant;

                        /**
                         * Creates a plain object from an AuthorizedFieldSubscriberGrant message. Also converts values to other types if specified.
                         * @param message AuthorizedFieldSubscriberGrant
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this AuthorizedFieldSubscriberGrant to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Represents a Subscriptions */
                    class Subscriptions extends $protobuf.rpc.Service {

                        /**
                         * Constructs a new Subscriptions service.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         */
                        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                        /**
                         * Creates new Subscriptions service using the specified rpc implementation.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         * @returns RPC service. Useful where requests and/or responses are streamed.
                         */
                        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Subscriptions;

                        /**
                         * Calls Create.
                         * @param request CreateSubscriptionReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and CreateSubscriptionResp
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq, callback: code.justin.tv.eventbus.controlplane.Subscriptions.CreateCallback): void;

                        /**
                         * Calls Create.
                         * @param request CreateSubscriptionReq message or plain object
                         * @returns Promise
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq): Promise<code.justin.tv.eventbus.controlplane.CreateSubscriptionResp>;

                        /**
                         * Calls Delete.
                         * @param request DeleteSubscriptionReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and DeleteSubscriptionResp
                         */
                        public delete(request: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq, callback: code.justin.tv.eventbus.controlplane.Subscriptions.DeleteCallback): void;

                        /**
                         * Calls Delete.
                         * @param request DeleteSubscriptionReq message or plain object
                         * @returns Promise
                         */
                        public delete(request: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq): Promise<code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp>;

                        /**
                         * Calls GetSubscriptionsForTarget.
                         * @param request GetSubscriptionsForTargetReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and GetSubscriptionsForTargetResp
                         */
                        public getSubscriptionsForTarget(request: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq, callback: code.justin.tv.eventbus.controlplane.Subscriptions.GetSubscriptionsForTargetCallback): void;

                        /**
                         * Calls GetSubscriptionsForTarget.
                         * @param request GetSubscriptionsForTargetReq message or plain object
                         * @returns Promise
                         */
                        public getSubscriptionsForTarget(request: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq): Promise<code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp>;
                    }

                    namespace Subscriptions {

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Subscriptions#create}.
                         * @param error Error, if any
                         * @param [response] CreateSubscriptionResp
                         */
                        type CreateCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.CreateSubscriptionResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Subscriptions#delete_}.
                         * @param error Error, if any
                         * @param [response] DeleteSubscriptionResp
                         */
                        type DeleteCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Subscriptions#getSubscriptionsForTarget}.
                         * @param error Error, if any
                         * @param [response] GetSubscriptionsForTargetResp
                         */
                        type GetSubscriptionsForTargetCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp) => void;
                    }

                    /** Properties of a Subscription. */
                    interface ISubscription {

                        /** Subscription targetId */
                        targetId?: (string|null);

                        /** Subscription eventType */
                        eventType?: (string|null);

                        /** Subscription id */
                        id?: (string|null);

                        /** Subscription status */
                        status?: (code.justin.tv.eventbus.controlplane.SubscriptionStatus|null);

                        /** Subscription message */
                        message?: (string|null);

                        /** Subscription environment */
                        environment?: (string|null);
                    }

                    /** Represents a Subscription. */
                    class Subscription implements ISubscription {

                        /**
                         * Constructs a new Subscription.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ISubscription);

                        /** Subscription targetId. */
                        public targetId: string;

                        /** Subscription eventType. */
                        public eventType: string;

                        /** Subscription id. */
                        public id: string;

                        /** Subscription status. */
                        public status: code.justin.tv.eventbus.controlplane.SubscriptionStatus;

                        /** Subscription message. */
                        public message: string;

                        /** Subscription environment. */
                        public environment: string;

                        /**
                         * Creates a new Subscription instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Subscription instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ISubscription): code.justin.tv.eventbus.controlplane.Subscription;

                        /**
                         * Encodes the specified Subscription message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Subscription.verify|verify} messages.
                         * @param message Subscription message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ISubscription, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Subscription message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Subscription.verify|verify} messages.
                         * @param message Subscription message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ISubscription, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Subscription message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Subscription
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.Subscription;

                        /**
                         * Decodes a Subscription message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Subscription
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.Subscription;

                        /**
                         * Verifies a Subscription message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Subscription message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Subscription
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.Subscription;

                        /**
                         * Creates a plain object from a Subscription message. Also converts values to other types if specified.
                         * @param message Subscription
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.Subscription, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Subscription to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateSubscriptionReq. */
                    interface ICreateSubscriptionReq {

                        /** CreateSubscriptionReq targetId */
                        targetId?: (string|null);

                        /** CreateSubscriptionReq eventType */
                        eventType?: (string|null);

                        /** CreateSubscriptionReq environment */
                        environment?: (string|null);
                    }

                    /** Represents a CreateSubscriptionReq. */
                    class CreateSubscriptionReq implements ICreateSubscriptionReq {

                        /**
                         * Constructs a new CreateSubscriptionReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq);

                        /** CreateSubscriptionReq targetId. */
                        public targetId: string;

                        /** CreateSubscriptionReq eventType. */
                        public eventType: string;

                        /** CreateSubscriptionReq environment. */
                        public environment: string;

                        /**
                         * Creates a new CreateSubscriptionReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateSubscriptionReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq): code.justin.tv.eventbus.controlplane.CreateSubscriptionReq;

                        /**
                         * Encodes the specified CreateSubscriptionReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionReq.verify|verify} messages.
                         * @param message CreateSubscriptionReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateSubscriptionReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionReq.verify|verify} messages.
                         * @param message CreateSubscriptionReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateSubscriptionReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateSubscriptionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateSubscriptionReq;

                        /**
                         * Decodes a CreateSubscriptionReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateSubscriptionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateSubscriptionReq;

                        /**
                         * Verifies a CreateSubscriptionReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateSubscriptionReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateSubscriptionReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateSubscriptionReq;

                        /**
                         * Creates a plain object from a CreateSubscriptionReq message. Also converts values to other types if specified.
                         * @param message CreateSubscriptionReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateSubscriptionReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateSubscriptionReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateSubscriptionResp. */
                    interface ICreateSubscriptionResp {

                        /** CreateSubscriptionResp subscription */
                        subscription?: (code.justin.tv.eventbus.controlplane.ISubscription|null);
                    }

                    /** Represents a CreateSubscriptionResp. */
                    class CreateSubscriptionResp implements ICreateSubscriptionResp {

                        /**
                         * Constructs a new CreateSubscriptionResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp);

                        /** CreateSubscriptionResp subscription. */
                        public subscription?: (code.justin.tv.eventbus.controlplane.ISubscription|null);

                        /**
                         * Creates a new CreateSubscriptionResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateSubscriptionResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp): code.justin.tv.eventbus.controlplane.CreateSubscriptionResp;

                        /**
                         * Encodes the specified CreateSubscriptionResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionResp.verify|verify} messages.
                         * @param message CreateSubscriptionResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateSubscriptionResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionResp.verify|verify} messages.
                         * @param message CreateSubscriptionResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateSubscriptionResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateSubscriptionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateSubscriptionResp;

                        /**
                         * Decodes a CreateSubscriptionResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateSubscriptionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateSubscriptionResp;

                        /**
                         * Verifies a CreateSubscriptionResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateSubscriptionResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateSubscriptionResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateSubscriptionResp;

                        /**
                         * Creates a plain object from a CreateSubscriptionResp message. Also converts values to other types if specified.
                         * @param message CreateSubscriptionResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateSubscriptionResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateSubscriptionResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteSubscriptionReq. */
                    interface IDeleteSubscriptionReq {

                        /** DeleteSubscriptionReq targetId */
                        targetId?: (string|null);

                        /** DeleteSubscriptionReq eventType */
                        eventType?: (string|null);

                        /** DeleteSubscriptionReq environment */
                        environment?: (string|null);
                    }

                    /** Represents a DeleteSubscriptionReq. */
                    class DeleteSubscriptionReq implements IDeleteSubscriptionReq {

                        /**
                         * Constructs a new DeleteSubscriptionReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq);

                        /** DeleteSubscriptionReq targetId. */
                        public targetId: string;

                        /** DeleteSubscriptionReq eventType. */
                        public eventType: string;

                        /** DeleteSubscriptionReq environment. */
                        public environment: string;

                        /**
                         * Creates a new DeleteSubscriptionReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteSubscriptionReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq): code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq;

                        /**
                         * Encodes the specified DeleteSubscriptionReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq.verify|verify} messages.
                         * @param message DeleteSubscriptionReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteSubscriptionReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq.verify|verify} messages.
                         * @param message DeleteSubscriptionReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteSubscriptionReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteSubscriptionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq;

                        /**
                         * Decodes a DeleteSubscriptionReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteSubscriptionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq;

                        /**
                         * Verifies a DeleteSubscriptionReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteSubscriptionReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteSubscriptionReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq;

                        /**
                         * Creates a plain object from a DeleteSubscriptionReq message. Also converts values to other types if specified.
                         * @param message DeleteSubscriptionReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteSubscriptionReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteSubscriptionResp. */
                    interface IDeleteSubscriptionResp {
                    }

                    /** Represents a DeleteSubscriptionResp. */
                    class DeleteSubscriptionResp implements IDeleteSubscriptionResp {

                        /**
                         * Constructs a new DeleteSubscriptionResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionResp);

                        /**
                         * Creates a new DeleteSubscriptionResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteSubscriptionResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionResp): code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp;

                        /**
                         * Encodes the specified DeleteSubscriptionResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp.verify|verify} messages.
                         * @param message DeleteSubscriptionResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteSubscriptionResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp.verify|verify} messages.
                         * @param message DeleteSubscriptionResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteSubscriptionResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteSubscriptionResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteSubscriptionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp;

                        /**
                         * Decodes a DeleteSubscriptionResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteSubscriptionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp;

                        /**
                         * Verifies a DeleteSubscriptionResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteSubscriptionResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteSubscriptionResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp;

                        /**
                         * Creates a plain object from a DeleteSubscriptionResp message. Also converts values to other types if specified.
                         * @param message DeleteSubscriptionResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteSubscriptionResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetSubscriptionsForTargetReq. */
                    interface IGetSubscriptionsForTargetReq {

                        /** GetSubscriptionsForTargetReq targetId */
                        targetId?: (string|null);
                    }

                    /** Represents a GetSubscriptionsForTargetReq. */
                    class GetSubscriptionsForTargetReq implements IGetSubscriptionsForTargetReq {

                        /**
                         * Constructs a new GetSubscriptionsForTargetReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq);

                        /** GetSubscriptionsForTargetReq targetId. */
                        public targetId: string;

                        /**
                         * Creates a new GetSubscriptionsForTargetReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetSubscriptionsForTargetReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq;

                        /**
                         * Encodes the specified GetSubscriptionsForTargetReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq.verify|verify} messages.
                         * @param message GetSubscriptionsForTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetSubscriptionsForTargetReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq.verify|verify} messages.
                         * @param message GetSubscriptionsForTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetSubscriptionsForTargetReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetSubscriptionsForTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq;

                        /**
                         * Decodes a GetSubscriptionsForTargetReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetSubscriptionsForTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq;

                        /**
                         * Verifies a GetSubscriptionsForTargetReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetSubscriptionsForTargetReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetSubscriptionsForTargetReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq;

                        /**
                         * Creates a plain object from a GetSubscriptionsForTargetReq message. Also converts values to other types if specified.
                         * @param message GetSubscriptionsForTargetReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetSubscriptionsForTargetReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetSubscriptionsForTargetResp. */
                    interface IGetSubscriptionsForTargetResp {

                        /** GetSubscriptionsForTargetResp subscriptions */
                        subscriptions?: (code.justin.tv.eventbus.controlplane.ISubscription[]|null);
                    }

                    /** Represents a GetSubscriptionsForTargetResp. */
                    class GetSubscriptionsForTargetResp implements IGetSubscriptionsForTargetResp {

                        /**
                         * Constructs a new GetSubscriptionsForTargetResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetResp);

                        /** GetSubscriptionsForTargetResp subscriptions. */
                        public subscriptions: code.justin.tv.eventbus.controlplane.ISubscription[];

                        /**
                         * Creates a new GetSubscriptionsForTargetResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetSubscriptionsForTargetResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetResp): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp;

                        /**
                         * Encodes the specified GetSubscriptionsForTargetResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp.verify|verify} messages.
                         * @param message GetSubscriptionsForTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetSubscriptionsForTargetResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp.verify|verify} messages.
                         * @param message GetSubscriptionsForTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetSubscriptionsForTargetResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetSubscriptionsForTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp;

                        /**
                         * Decodes a GetSubscriptionsForTargetResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetSubscriptionsForTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp;

                        /**
                         * Verifies a GetSubscriptionsForTargetResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetSubscriptionsForTargetResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetSubscriptionsForTargetResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp;

                        /**
                         * Creates a plain object from a GetSubscriptionsForTargetResp message. Also converts values to other types if specified.
                         * @param message GetSubscriptionsForTargetResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetSubscriptionsForTargetResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** SubscriptionStatus enum. */
                    enum SubscriptionStatus {
                        SUBSCRIPTION_STATUS_UNKNOWN = 0,
                        SUBSCRIPTION_STATUS_DISABLED = 1,
                        SUBSCRIPTION_STATUS_ENABLED = 2,
                        SUBSCRIPTION_STATUS_PENDING_DISABLE = 3,
                        SUBSCRIPTION_STATUS_PENDING_ENABLE = 4,
                        SUBSCRIPTION_STATUS_ERROR_DISABLE = 5,
                        SUBSCRIPTION_STATUS_ERROR_ENABLE = 6,
                        SUBSCRIPTION_STATUS_ERROR_CREATE = 7,
                        SUBSCRIPTION_STATUS_PENDING_DELETE = 8,
                        SUBSCRIPTION_STATUS_ERROR_DELETE = 9
                    }

                    /** Represents a Targets */
                    class Targets extends $protobuf.rpc.Service {

                        /**
                         * Constructs a new Targets service.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         */
                        constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                        /**
                         * Creates new Targets service using the specified rpc implementation.
                         * @param rpcImpl RPC implementation
                         * @param [requestDelimited=false] Whether requests are length-delimited
                         * @param [responseDelimited=false] Whether responses are length-delimited
                         * @returns RPC service. Useful where requests and/or responses are streamed.
                         */
                        public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Targets;

                        /**
                         * Calls Create.
                         * @param request CreateTargetReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and CreateTargetResp
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateTargetReq, callback: code.justin.tv.eventbus.controlplane.Targets.CreateCallback): void;

                        /**
                         * Calls Create.
                         * @param request CreateTargetReq message or plain object
                         * @returns Promise
                         */
                        public create(request: code.justin.tv.eventbus.controlplane.ICreateTargetReq): Promise<code.justin.tv.eventbus.controlplane.CreateTargetResp>;

                        /**
                         * Calls GetTargetsForService.
                         * @param request GetTargetsForServiceReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and GetTargetsForServiceResp
                         */
                        public getTargetsForService(request: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceReq, callback: code.justin.tv.eventbus.controlplane.Targets.GetTargetsForServiceCallback): void;

                        /**
                         * Calls GetTargetsForService.
                         * @param request GetTargetsForServiceReq message or plain object
                         * @returns Promise
                         */
                        public getTargetsForService(request: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceReq): Promise<code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp>;

                        /**
                         * Calls Delete.
                         * @param request DeleteTargetReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and DeleteTargetResp
                         */
                        public delete(request: code.justin.tv.eventbus.controlplane.IDeleteTargetReq, callback: code.justin.tv.eventbus.controlplane.Targets.DeleteCallback): void;

                        /**
                         * Calls Delete.
                         * @param request DeleteTargetReq message or plain object
                         * @returns Promise
                         */
                        public delete(request: code.justin.tv.eventbus.controlplane.IDeleteTargetReq): Promise<code.justin.tv.eventbus.controlplane.DeleteTargetResp>;

                        /**
                         * Calls Validate.
                         * @param request ValidateTargetReq message or plain object
                         * @param callback Node-style callback called with the error, if any, and ValidateTargetResp
                         */
                        public validate(request: code.justin.tv.eventbus.controlplane.IValidateTargetReq, callback: code.justin.tv.eventbus.controlplane.Targets.ValidateCallback): void;

                        /**
                         * Calls Validate.
                         * @param request ValidateTargetReq message or plain object
                         * @returns Promise
                         */
                        public validate(request: code.justin.tv.eventbus.controlplane.IValidateTargetReq): Promise<code.justin.tv.eventbus.controlplane.ValidateTargetResp>;
                    }

                    namespace Targets {

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Targets#create}.
                         * @param error Error, if any
                         * @param [response] CreateTargetResp
                         */
                        type CreateCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.CreateTargetResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Targets#getTargetsForService}.
                         * @param error Error, if any
                         * @param [response] GetTargetsForServiceResp
                         */
                        type GetTargetsForServiceCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Targets#delete_}.
                         * @param error Error, if any
                         * @param [response] DeleteTargetResp
                         */
                        type DeleteCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.DeleteTargetResp) => void;

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Targets#validate}.
                         * @param error Error, if any
                         * @param [response] ValidateTargetResp
                         */
                        type ValidateCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.ValidateTargetResp) => void;
                    }

                    /** Properties of a Target. */
                    interface ITarget {

                        /** Target id */
                        id?: (string|null);

                        /** Target serviceId */
                        serviceId?: (string|null);

                        /** Target sqs */
                        sqs?: (code.justin.tv.eventbus.controlplane.ISQSDetails|null);

                        /** Target http */
                        http?: (code.justin.tv.eventbus.controlplane.IHTTPDetails|null);

                        /** Target lambda */
                        lambda?: (code.justin.tv.eventbus.controlplane.ILambdaDetails|null);

                        /** Target name */
                        name?: (string|null);

                        /** Target awsAccountId */
                        awsAccountId?: (string|null);
                    }

                    /** Represents a Target. */
                    class Target implements ITarget {

                        /**
                         * Constructs a new Target.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ITarget);

                        /** Target id. */
                        public id: string;

                        /** Target serviceId. */
                        public serviceId: string;

                        /** Target sqs. */
                        public sqs?: (code.justin.tv.eventbus.controlplane.ISQSDetails|null);

                        /** Target http. */
                        public http?: (code.justin.tv.eventbus.controlplane.IHTTPDetails|null);

                        /** Target lambda. */
                        public lambda?: (code.justin.tv.eventbus.controlplane.ILambdaDetails|null);

                        /** Target name. */
                        public name: string;

                        /** Target awsAccountId. */
                        public awsAccountId: string;

                        /** Target details. */
                        public details?: ("sqs"|"http"|"lambda");

                        /**
                         * Creates a new Target instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns Target instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ITarget): code.justin.tv.eventbus.controlplane.Target;

                        /**
                         * Encodes the specified Target message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Target.verify|verify} messages.
                         * @param message Target message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ITarget, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified Target message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Target.verify|verify} messages.
                         * @param message Target message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ITarget, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a Target message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns Target
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.Target;

                        /**
                         * Decodes a Target message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns Target
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.Target;

                        /**
                         * Verifies a Target message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a Target message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns Target
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.Target;

                        /**
                         * Creates a plain object from a Target message. Also converts values to other types if specified.
                         * @param message Target
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.Target, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this Target to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateTargetReq. */
                    interface ICreateTargetReq {

                        /** CreateTargetReq serviceId */
                        serviceId?: (string|null);

                        /** CreateTargetReq name */
                        name?: (string|null);

                        /** CreateTargetReq type */
                        type?: (code.justin.tv.eventbus.controlplane.TargetType|null);

                        /** CreateTargetReq httpEndpoint */
                        httpEndpoint?: (string|null);

                        /** CreateTargetReq lambdaFunctionArn */
                        lambdaFunctionArn?: (string|null);

                        /** CreateTargetReq sqs */
                        sqs?: (code.justin.tv.eventbus.controlplane.ISQSDetails|null);
                    }

                    /** Represents a CreateTargetReq. */
                    class CreateTargetReq implements ICreateTargetReq {

                        /**
                         * Constructs a new CreateTargetReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateTargetReq);

                        /** CreateTargetReq serviceId. */
                        public serviceId: string;

                        /** CreateTargetReq name. */
                        public name: string;

                        /** CreateTargetReq type. */
                        public type: code.justin.tv.eventbus.controlplane.TargetType;

                        /** CreateTargetReq httpEndpoint. */
                        public httpEndpoint: string;

                        /** CreateTargetReq lambdaFunctionArn. */
                        public lambdaFunctionArn: string;

                        /** CreateTargetReq sqs. */
                        public sqs?: (code.justin.tv.eventbus.controlplane.ISQSDetails|null);

                        /** CreateTargetReq details. */
                        public details?: "sqs";

                        /**
                         * Creates a new CreateTargetReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateTargetReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateTargetReq): code.justin.tv.eventbus.controlplane.CreateTargetReq;

                        /**
                         * Encodes the specified CreateTargetReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateTargetReq.verify|verify} messages.
                         * @param message CreateTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateTargetReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateTargetReq.verify|verify} messages.
                         * @param message CreateTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateTargetReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateTargetReq;

                        /**
                         * Decodes a CreateTargetReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateTargetReq;

                        /**
                         * Verifies a CreateTargetReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateTargetReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateTargetReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateTargetReq;

                        /**
                         * Creates a plain object from a CreateTargetReq message. Also converts values to other types if specified.
                         * @param message CreateTargetReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateTargetReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateTargetReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a CreateTargetResp. */
                    interface ICreateTargetResp {

                        /** CreateTargetResp target */
                        target?: (code.justin.tv.eventbus.controlplane.ITarget|null);
                    }

                    /** Represents a CreateTargetResp. */
                    class CreateTargetResp implements ICreateTargetResp {

                        /**
                         * Constructs a new CreateTargetResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ICreateTargetResp);

                        /** CreateTargetResp target. */
                        public target?: (code.justin.tv.eventbus.controlplane.ITarget|null);

                        /**
                         * Creates a new CreateTargetResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns CreateTargetResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ICreateTargetResp): code.justin.tv.eventbus.controlplane.CreateTargetResp;

                        /**
                         * Encodes the specified CreateTargetResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateTargetResp.verify|verify} messages.
                         * @param message CreateTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ICreateTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified CreateTargetResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateTargetResp.verify|verify} messages.
                         * @param message CreateTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ICreateTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a CreateTargetResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns CreateTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.CreateTargetResp;

                        /**
                         * Decodes a CreateTargetResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns CreateTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.CreateTargetResp;

                        /**
                         * Verifies a CreateTargetResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a CreateTargetResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns CreateTargetResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.CreateTargetResp;

                        /**
                         * Creates a plain object from a CreateTargetResp message. Also converts values to other types if specified.
                         * @param message CreateTargetResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.CreateTargetResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this CreateTargetResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteTargetReq. */
                    interface IDeleteTargetReq {

                        /** DeleteTargetReq subscriptionTargetId */
                        subscriptionTargetId?: (string|null);
                    }

                    /** Represents a DeleteTargetReq. */
                    class DeleteTargetReq implements IDeleteTargetReq {

                        /**
                         * Constructs a new DeleteTargetReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteTargetReq);

                        /** DeleteTargetReq subscriptionTargetId. */
                        public subscriptionTargetId: string;

                        /**
                         * Creates a new DeleteTargetReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteTargetReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteTargetReq): code.justin.tv.eventbus.controlplane.DeleteTargetReq;

                        /**
                         * Encodes the specified DeleteTargetReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteTargetReq.verify|verify} messages.
                         * @param message DeleteTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteTargetReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteTargetReq.verify|verify} messages.
                         * @param message DeleteTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteTargetReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteTargetReq;

                        /**
                         * Decodes a DeleteTargetReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteTargetReq;

                        /**
                         * Verifies a DeleteTargetReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteTargetReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteTargetReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteTargetReq;

                        /**
                         * Creates a plain object from a DeleteTargetReq message. Also converts values to other types if specified.
                         * @param message DeleteTargetReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteTargetReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteTargetReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a DeleteTargetResp. */
                    interface IDeleteTargetResp {

                        /** DeleteTargetResp subscriptionTargetId */
                        subscriptionTargetId?: (string|null);
                    }

                    /** Represents a DeleteTargetResp. */
                    class DeleteTargetResp implements IDeleteTargetResp {

                        /**
                         * Constructs a new DeleteTargetResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IDeleteTargetResp);

                        /** DeleteTargetResp subscriptionTargetId. */
                        public subscriptionTargetId: string;

                        /**
                         * Creates a new DeleteTargetResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns DeleteTargetResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IDeleteTargetResp): code.justin.tv.eventbus.controlplane.DeleteTargetResp;

                        /**
                         * Encodes the specified DeleteTargetResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteTargetResp.verify|verify} messages.
                         * @param message DeleteTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IDeleteTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified DeleteTargetResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteTargetResp.verify|verify} messages.
                         * @param message DeleteTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IDeleteTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a DeleteTargetResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns DeleteTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.DeleteTargetResp;

                        /**
                         * Decodes a DeleteTargetResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns DeleteTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.DeleteTargetResp;

                        /**
                         * Verifies a DeleteTargetResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a DeleteTargetResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns DeleteTargetResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.DeleteTargetResp;

                        /**
                         * Creates a plain object from a DeleteTargetResp message. Also converts values to other types if specified.
                         * @param message DeleteTargetResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.DeleteTargetResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this DeleteTargetResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetTargetsForServiceReq. */
                    interface IGetTargetsForServiceReq {

                        /** GetTargetsForServiceReq serviceId */
                        serviceId?: (string|null);
                    }

                    /** Represents a GetTargetsForServiceReq. */
                    class GetTargetsForServiceReq implements IGetTargetsForServiceReq {

                        /**
                         * Constructs a new GetTargetsForServiceReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceReq);

                        /** GetTargetsForServiceReq serviceId. */
                        public serviceId: string;

                        /**
                         * Creates a new GetTargetsForServiceReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetTargetsForServiceReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceReq): code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq;

                        /**
                         * Encodes the specified GetTargetsForServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq.verify|verify} messages.
                         * @param message GetTargetsForServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetTargetsForServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq.verify|verify} messages.
                         * @param message GetTargetsForServiceReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetTargetsForServiceReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetTargetsForServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq;

                        /**
                         * Decodes a GetTargetsForServiceReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetTargetsForServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq;

                        /**
                         * Verifies a GetTargetsForServiceReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetTargetsForServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetTargetsForServiceReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq;

                        /**
                         * Creates a plain object from a GetTargetsForServiceReq message. Also converts values to other types if specified.
                         * @param message GetTargetsForServiceReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetTargetsForServiceReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a GetTargetsForServiceResp. */
                    interface IGetTargetsForServiceResp {

                        /** GetTargetsForServiceResp serviceId */
                        serviceId?: (string|null);

                        /** GetTargetsForServiceResp targets */
                        targets?: (code.justin.tv.eventbus.controlplane.ITarget[]|null);
                    }

                    /** Represents a GetTargetsForServiceResp. */
                    class GetTargetsForServiceResp implements IGetTargetsForServiceResp {

                        /**
                         * Constructs a new GetTargetsForServiceResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceResp);

                        /** GetTargetsForServiceResp serviceId. */
                        public serviceId: string;

                        /** GetTargetsForServiceResp targets. */
                        public targets: code.justin.tv.eventbus.controlplane.ITarget[];

                        /**
                         * Creates a new GetTargetsForServiceResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns GetTargetsForServiceResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceResp): code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp;

                        /**
                         * Encodes the specified GetTargetsForServiceResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp.verify|verify} messages.
                         * @param message GetTargetsForServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified GetTargetsForServiceResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp.verify|verify} messages.
                         * @param message GetTargetsForServiceResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IGetTargetsForServiceResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a GetTargetsForServiceResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns GetTargetsForServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp;

                        /**
                         * Decodes a GetTargetsForServiceResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns GetTargetsForServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp;

                        /**
                         * Verifies a GetTargetsForServiceResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a GetTargetsForServiceResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns GetTargetsForServiceResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp;

                        /**
                         * Creates a plain object from a GetTargetsForServiceResp message. Also converts values to other types if specified.
                         * @param message GetTargetsForServiceResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this GetTargetsForServiceResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ValidateTargetReq. */
                    interface IValidateTargetReq {

                        /** ValidateTargetReq sqsQueueUrl */
                        sqsQueueUrl?: (string|null);
                    }

                    /** Represents a ValidateTargetReq. */
                    class ValidateTargetReq implements IValidateTargetReq {

                        /**
                         * Constructs a new ValidateTargetReq.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IValidateTargetReq);

                        /** ValidateTargetReq sqsQueueUrl. */
                        public sqsQueueUrl: string;

                        /**
                         * Creates a new ValidateTargetReq instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ValidateTargetReq instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IValidateTargetReq): code.justin.tv.eventbus.controlplane.ValidateTargetReq;

                        /**
                         * Encodes the specified ValidateTargetReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateTargetReq.verify|verify} messages.
                         * @param message ValidateTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IValidateTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ValidateTargetReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateTargetReq.verify|verify} messages.
                         * @param message ValidateTargetReq message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IValidateTargetReq, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ValidateTargetReq message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ValidateTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ValidateTargetReq;

                        /**
                         * Decodes a ValidateTargetReq message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ValidateTargetReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ValidateTargetReq;

                        /**
                         * Verifies a ValidateTargetReq message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ValidateTargetReq message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ValidateTargetReq
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ValidateTargetReq;

                        /**
                         * Creates a plain object from a ValidateTargetReq message. Also converts values to other types if specified.
                         * @param message ValidateTargetReq
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ValidateTargetReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ValidateTargetReq to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a ValidateTargetResp. */
                    interface IValidateTargetResp {

                        /** ValidateTargetResp isValid */
                        isValid?: (boolean|null);

                        /** ValidateTargetResp message */
                        message?: (string|null);
                    }

                    /** Represents a ValidateTargetResp. */
                    class ValidateTargetResp implements IValidateTargetResp {

                        /**
                         * Constructs a new ValidateTargetResp.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IValidateTargetResp);

                        /** ValidateTargetResp isValid. */
                        public isValid: boolean;

                        /** ValidateTargetResp message. */
                        public message: string;

                        /**
                         * Creates a new ValidateTargetResp instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns ValidateTargetResp instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IValidateTargetResp): code.justin.tv.eventbus.controlplane.ValidateTargetResp;

                        /**
                         * Encodes the specified ValidateTargetResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateTargetResp.verify|verify} messages.
                         * @param message ValidateTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IValidateTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified ValidateTargetResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateTargetResp.verify|verify} messages.
                         * @param message ValidateTargetResp message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IValidateTargetResp, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a ValidateTargetResp message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns ValidateTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.ValidateTargetResp;

                        /**
                         * Decodes a ValidateTargetResp message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns ValidateTargetResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.ValidateTargetResp;

                        /**
                         * Verifies a ValidateTargetResp message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a ValidateTargetResp message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns ValidateTargetResp
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.ValidateTargetResp;

                        /**
                         * Creates a plain object from a ValidateTargetResp message. Also converts values to other types if specified.
                         * @param message ValidateTargetResp
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.ValidateTargetResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this ValidateTargetResp to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a SQSDetails. */
                    interface ISQSDetails {

                        /** SQSDetails assumeRoleArn */
                        assumeRoleArn?: (string|null);

                        /** SQSDetails queueArn */
                        queueArn?: (string|null);

                        /** SQSDetails sqsStatus */
                        sqsStatus?: (code.justin.tv.eventbus.controlplane.SQSStatus|null);

                        /** SQSDetails statusMessage */
                        statusMessage?: (string|null);

                        /** SQSDetails queueUrl */
                        queueUrl?: (string|null);

                        /** SQSDetails deadletterQueueArn */
                        deadletterQueueArn?: (string|null);

                        /** SQSDetails deadletterQueueUrl */
                        deadletterQueueUrl?: (string|null);
                    }

                    /** Represents a SQSDetails. */
                    class SQSDetails implements ISQSDetails {

                        /**
                         * Constructs a new SQSDetails.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ISQSDetails);

                        /** SQSDetails assumeRoleArn. */
                        public assumeRoleArn: string;

                        /** SQSDetails queueArn. */
                        public queueArn: string;

                        /** SQSDetails sqsStatus. */
                        public sqsStatus: code.justin.tv.eventbus.controlplane.SQSStatus;

                        /** SQSDetails statusMessage. */
                        public statusMessage: string;

                        /** SQSDetails queueUrl. */
                        public queueUrl: string;

                        /** SQSDetails deadletterQueueArn. */
                        public deadletterQueueArn: string;

                        /** SQSDetails deadletterQueueUrl. */
                        public deadletterQueueUrl: string;

                        /**
                         * Creates a new SQSDetails instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns SQSDetails instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ISQSDetails): code.justin.tv.eventbus.controlplane.SQSDetails;

                        /**
                         * Encodes the specified SQSDetails message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.SQSDetails.verify|verify} messages.
                         * @param message SQSDetails message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ISQSDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified SQSDetails message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.SQSDetails.verify|verify} messages.
                         * @param message SQSDetails message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ISQSDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a SQSDetails message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns SQSDetails
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.SQSDetails;

                        /**
                         * Decodes a SQSDetails message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns SQSDetails
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.SQSDetails;

                        /**
                         * Verifies a SQSDetails message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a SQSDetails message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns SQSDetails
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.SQSDetails;

                        /**
                         * Creates a plain object from a SQSDetails message. Also converts values to other types if specified.
                         * @param message SQSDetails
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.SQSDetails, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this SQSDetails to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a HTTPDetails. */
                    interface IHTTPDetails {

                        /** HTTPDetails endpoint */
                        endpoint?: (string|null);
                    }

                    /** Represents a HTTPDetails. */
                    class HTTPDetails implements IHTTPDetails {

                        /**
                         * Constructs a new HTTPDetails.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.IHTTPDetails);

                        /** HTTPDetails endpoint. */
                        public endpoint: string;

                        /**
                         * Creates a new HTTPDetails instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns HTTPDetails instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.IHTTPDetails): code.justin.tv.eventbus.controlplane.HTTPDetails;

                        /**
                         * Encodes the specified HTTPDetails message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.HTTPDetails.verify|verify} messages.
                         * @param message HTTPDetails message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.IHTTPDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified HTTPDetails message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.HTTPDetails.verify|verify} messages.
                         * @param message HTTPDetails message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.IHTTPDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a HTTPDetails message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns HTTPDetails
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.HTTPDetails;

                        /**
                         * Decodes a HTTPDetails message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns HTTPDetails
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.HTTPDetails;

                        /**
                         * Verifies a HTTPDetails message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a HTTPDetails message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns HTTPDetails
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.HTTPDetails;

                        /**
                         * Creates a plain object from a HTTPDetails message. Also converts values to other types if specified.
                         * @param message HTTPDetails
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.HTTPDetails, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this HTTPDetails to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** Properties of a LambdaDetails. */
                    interface ILambdaDetails {

                        /** LambdaDetails functionArn */
                        functionArn?: (string|null);
                    }

                    /** Represents a LambdaDetails. */
                    class LambdaDetails implements ILambdaDetails {

                        /**
                         * Constructs a new LambdaDetails.
                         * @param [properties] Properties to set
                         */
                        constructor(properties?: code.justin.tv.eventbus.controlplane.ILambdaDetails);

                        /** LambdaDetails functionArn. */
                        public functionArn: string;

                        /**
                         * Creates a new LambdaDetails instance using the specified properties.
                         * @param [properties] Properties to set
                         * @returns LambdaDetails instance
                         */
                        public static create(properties?: code.justin.tv.eventbus.controlplane.ILambdaDetails): code.justin.tv.eventbus.controlplane.LambdaDetails;

                        /**
                         * Encodes the specified LambdaDetails message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.LambdaDetails.verify|verify} messages.
                         * @param message LambdaDetails message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encode(message: code.justin.tv.eventbus.controlplane.ILambdaDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Encodes the specified LambdaDetails message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.LambdaDetails.verify|verify} messages.
                         * @param message LambdaDetails message or plain object to encode
                         * @param [writer] Writer to encode to
                         * @returns Writer
                         */
                        public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.ILambdaDetails, writer?: $protobuf.Writer): $protobuf.Writer;

                        /**
                         * Decodes a LambdaDetails message from the specified reader or buffer.
                         * @param reader Reader or buffer to decode from
                         * @param [length] Message length if known beforehand
                         * @returns LambdaDetails
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.LambdaDetails;

                        /**
                         * Decodes a LambdaDetails message from the specified reader or buffer, length delimited.
                         * @param reader Reader or buffer to decode from
                         * @returns LambdaDetails
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.LambdaDetails;

                        /**
                         * Verifies a LambdaDetails message.
                         * @param message Plain object to verify
                         * @returns `null` if valid, otherwise the reason why it is not
                         */
                        public static verify(message: { [k: string]: any }): (string|null);

                        /**
                         * Creates a LambdaDetails message from a plain object. Also converts values to their respective internal types.
                         * @param object Plain object
                         * @returns LambdaDetails
                         */
                        public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.LambdaDetails;

                        /**
                         * Creates a plain object from a LambdaDetails message. Also converts values to other types if specified.
                         * @param message LambdaDetails
                         * @param [options] Conversion options
                         * @returns Plain object
                         */
                        public static toObject(message: code.justin.tv.eventbus.controlplane.LambdaDetails, options?: $protobuf.IConversionOptions): { [k: string]: any };

                        /**
                         * Converts this LambdaDetails to JSON.
                         * @returns JSON object
                         */
                        public toJSON(): { [k: string]: any };
                    }

                    /** SQSStatus enum. */
                    enum SQSStatus {
                        UNKNOWN = 0,
                        PENDING_CREATE = 1,
                        PENDING_DELETE = 2,
                        CREATED = 3,
                        DELETED = 4,
                        ERROR = 5
                    }

                    /** TargetType enum. */
                    enum TargetType {
                        TARGET_TYPE_UNKNOWN = 0,
                        TARGET_TYPE_SQS = 1,
                        TARGET_TYPE_HTTP = 2,
                        TARGET_TYPE_LAMBDA = 3
                    }

                    /** Namespace infrastructure. */
                    namespace infrastructure {

                        /** Represents an Infrastructure */
                        class Infrastructure extends $protobuf.rpc.Service {

                            /**
                             * Constructs a new Infrastructure service.
                             * @param rpcImpl RPC implementation
                             * @param [requestDelimited=false] Whether requests are length-delimited
                             * @param [responseDelimited=false] Whether responses are length-delimited
                             */
                            constructor(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean);

                            /**
                             * Creates new Infrastructure service using the specified rpc implementation.
                             * @param rpcImpl RPC implementation
                             * @param [requestDelimited=false] Whether requests are length-delimited
                             * @param [responseDelimited=false] Whether responses are length-delimited
                             * @returns RPC service. Useful where requests and/or responses are streamed.
                             */
                            public static create(rpcImpl: $protobuf.RPCImpl, requestDelimited?: boolean, responseDelimited?: boolean): Infrastructure;

                            /**
                             * Calls AllowAccountsPublish.
                             * @param request AllowAccountsPublishReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and AllowAccountsPublishResp
                             */
                            public allowAccountsPublish(request: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.AllowAccountsPublishCallback): void;

                            /**
                             * Calls AllowAccountsPublish.
                             * @param request AllowAccountsPublishReq message or plain object
                             * @returns Promise
                             */
                            public allowAccountsPublish(request: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp>;

                            /**
                             * Calls AllowIAMRolePublish.
                             * @param request AllowIAMRolePublishReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and AllowIAMRolePublishResp
                             */
                            public allowIAMRolePublish(request: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.AllowIAMRolePublishCallback): void;

                            /**
                             * Calls AllowIAMRolePublish.
                             * @param request AllowIAMRolePublishReq message or plain object
                             * @returns Promise
                             */
                            public allowIAMRolePublish(request: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp>;

                            /**
                             * Calls RegisterEventDefinitions.
                             * @param request RegisterEventDefinitionsReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and RegisterEventDefinitionsResp
                             */
                            public registerEventDefinitions(request: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.RegisterEventDefinitionsCallback): void;

                            /**
                             * Calls RegisterEventDefinitions.
                             * @param request RegisterEventDefinitionsReq message or plain object
                             * @returns Promise
                             */
                            public registerEventDefinitions(request: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp>;

                            /**
                             * Calls CreateAuthorizedFieldSubscriberGrant.
                             * @param request CreateAuthorizedFieldSubscriberGrantReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and CreateAuthorizedFieldSubscriberGrantResp
                             */
                            public createAuthorizedFieldSubscriberGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.CreateAuthorizedFieldSubscriberGrantCallback): void;

                            /**
                             * Calls CreateAuthorizedFieldSubscriberGrant.
                             * @param request CreateAuthorizedFieldSubscriberGrantReq message or plain object
                             * @returns Promise
                             */
                            public createAuthorizedFieldSubscriberGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp>;

                            /**
                             * Calls CreateAuthorizedFieldPublisherGrant.
                             * @param request CreateAuthorizedFieldPublisherGrantReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and CreateAuthorizedFieldPublisherGrantResp
                             */
                            public createAuthorizedFieldPublisherGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.CreateAuthorizedFieldPublisherGrantCallback): void;

                            /**
                             * Calls CreateAuthorizedFieldPublisherGrant.
                             * @param request CreateAuthorizedFieldPublisherGrantReq message or plain object
                             * @returns Promise
                             */
                            public createAuthorizedFieldPublisherGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp>;

                            /**
                             * Calls RevokeAuthorizedFieldGrant.
                             * @param request RevokeAuthorizedFieldGrantReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and RevokeAuthorizedFieldGrantResp
                             */
                            public revokeAuthorizedFieldGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.RevokeAuthorizedFieldGrantCallback): void;

                            /**
                             * Calls RevokeAuthorizedFieldGrant.
                             * @param request RevokeAuthorizedFieldGrantReq message or plain object
                             * @returns Promise
                             */
                            public revokeAuthorizedFieldGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp>;

                            /**
                             * Calls DeletePublication.
                             * @param request DeletePublicationReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and DeletePublicationResp
                             */
                            public deletePublication(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.DeletePublicationCallback): void;

                            /**
                             * Calls DeletePublication.
                             * @param request DeletePublicationReq message or plain object
                             * @returns Promise
                             */
                            public deletePublication(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp>;

                            /**
                             * Calls DeleteIAMRolePublication.
                             * @param request DeleteIAMRolePublicationReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and DeleteIAMRolePublicationResp
                             */
                            public deleteIAMRolePublication(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.DeleteIAMRolePublicationCallback): void;

                            /**
                             * Calls DeleteIAMRolePublication.
                             * @param request DeleteIAMRolePublicationReq message or plain object
                             * @returns Promise
                             */
                            public deleteIAMRolePublication(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp>;

                            /**
                             * Calls ListPublicationsByEventStream.
                             * @param request ListPublicationsByEventStreamReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and ListPublicationsByEventStreamResp
                             */
                            public listPublicationsByEventStream(request: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.ListPublicationsByEventStreamCallback): void;

                            /**
                             * Calls ListPublicationsByEventStream.
                             * @param request ListPublicationsByEventStreamReq message or plain object
                             * @returns Promise
                             */
                            public listPublicationsByEventStream(request: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp>;

                            /**
                             * Calls DeleteAuthorizedFieldGrant.
                             * @param request DeleteAuthorizedFieldGrantReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and DeleteAuthorizedFieldGrantResp
                             */
                            public deleteAuthorizedFieldGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.DeleteAuthorizedFieldGrantCallback): void;

                            /**
                             * Calls DeleteAuthorizedFieldGrant.
                             * @param request DeleteAuthorizedFieldGrantReq message or plain object
                             * @returns Promise
                             */
                            public deleteAuthorizedFieldGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp>;

                            /**
                             * Calls DeleteAuthorizedFieldSubscriberGrant.
                             * @param request DeleteAuthorizedFieldSubscriberGrantReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and DeleteAuthorizedFieldSubscriberGrantResp
                             */
                            public deleteAuthorizedFieldSubscriberGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.DeleteAuthorizedFieldSubscriberGrantCallback): void;

                            /**
                             * Calls DeleteAuthorizedFieldSubscriberGrant.
                             * @param request DeleteAuthorizedFieldSubscriberGrantReq message or plain object
                             * @returns Promise
                             */
                            public deleteAuthorizedFieldSubscriberGrant(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp>;

                            /**
                             * Calls DeleteEventType.
                             * @param request DeleteEventTypeReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and DeleteEventTypeResp
                             */
                            public deleteEventType(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.DeleteEventTypeCallback): void;

                            /**
                             * Calls DeleteEventType.
                             * @param request DeleteEventTypeReq message or plain object
                             * @returns Promise
                             */
                            public deleteEventType(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp>;

                            /**
                             * Calls DeleteEventStreamsForEventType.
                             * @param request DeleteEventStreamsForEventTypeReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and DeleteEventStreamsForEventTypeResp
                             */
                            public deleteEventStreamsForEventType(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.DeleteEventStreamsForEventTypeCallback): void;

                            /**
                             * Calls DeleteEventStreamsForEventType.
                             * @param request DeleteEventStreamsForEventTypeReq message or plain object
                             * @returns Promise
                             */
                            public deleteEventStreamsForEventType(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp>;

                            /**
                             * Calls DeleteAuthorizedField.
                             * @param request DeleteAuthorizedFieldReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and DeleteAuthorizedFieldResp
                             */
                            public deleteAuthorizedField(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.DeleteAuthorizedFieldCallback): void;

                            /**
                             * Calls DeleteAuthorizedField.
                             * @param request DeleteAuthorizedFieldReq message or plain object
                             * @returns Promise
                             */
                            public deleteAuthorizedField(request: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp>;

                            /**
                             * Calls ListAuthorizedFieldSubscriberGrantsByAuthorizedField.
                             * @param request ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message or plain object
                             * @param callback Node-style callback called with the error, if any, and ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
                             */
                            public listAuthorizedFieldSubscriberGrantsByAuthorizedField(request: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq, callback: code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldCallback): void;

                            /**
                             * Calls ListAuthorizedFieldSubscriberGrantsByAuthorizedField.
                             * @param request ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message or plain object
                             * @returns Promise
                             */
                            public listAuthorizedFieldSubscriberGrantsByAuthorizedField(request: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq): Promise<code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp>;
                        }

                        namespace Infrastructure {

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#allowAccountsPublish}.
                             * @param error Error, if any
                             * @param [response] AllowAccountsPublishResp
                             */
                            type AllowAccountsPublishCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#allowIAMRolePublish}.
                             * @param error Error, if any
                             * @param [response] AllowIAMRolePublishResp
                             */
                            type AllowIAMRolePublishCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#registerEventDefinitions}.
                             * @param error Error, if any
                             * @param [response] RegisterEventDefinitionsResp
                             */
                            type RegisterEventDefinitionsCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#createAuthorizedFieldSubscriberGrant}.
                             * @param error Error, if any
                             * @param [response] CreateAuthorizedFieldSubscriberGrantResp
                             */
                            type CreateAuthorizedFieldSubscriberGrantCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#createAuthorizedFieldPublisherGrant}.
                             * @param error Error, if any
                             * @param [response] CreateAuthorizedFieldPublisherGrantResp
                             */
                            type CreateAuthorizedFieldPublisherGrantCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#revokeAuthorizedFieldGrant}.
                             * @param error Error, if any
                             * @param [response] RevokeAuthorizedFieldGrantResp
                             */
                            type RevokeAuthorizedFieldGrantCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#deletePublication}.
                             * @param error Error, if any
                             * @param [response] DeletePublicationResp
                             */
                            type DeletePublicationCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#deleteIAMRolePublication}.
                             * @param error Error, if any
                             * @param [response] DeleteIAMRolePublicationResp
                             */
                            type DeleteIAMRolePublicationCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#listPublicationsByEventStream}.
                             * @param error Error, if any
                             * @param [response] ListPublicationsByEventStreamResp
                             */
                            type ListPublicationsByEventStreamCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#deleteAuthorizedFieldGrant}.
                             * @param error Error, if any
                             * @param [response] DeleteAuthorizedFieldGrantResp
                             */
                            type DeleteAuthorizedFieldGrantCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#deleteAuthorizedFieldSubscriberGrant}.
                             * @param error Error, if any
                             * @param [response] DeleteAuthorizedFieldSubscriberGrantResp
                             */
                            type DeleteAuthorizedFieldSubscriberGrantCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#deleteEventType}.
                             * @param error Error, if any
                             * @param [response] DeleteEventTypeResp
                             */
                            type DeleteEventTypeCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#deleteEventStreamsForEventType}.
                             * @param error Error, if any
                             * @param [response] DeleteEventStreamsForEventTypeResp
                             */
                            type DeleteEventStreamsForEventTypeCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#deleteAuthorizedField}.
                             * @param error Error, if any
                             * @param [response] DeleteAuthorizedFieldResp
                             */
                            type DeleteAuthorizedFieldCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp) => void;

                            /**
                             * Callback as used by {@link code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure#listAuthorizedFieldSubscriberGrantsByAuthorizedField}.
                             * @param error Error, if any
                             * @param [response] ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
                             */
                            type ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldCallback = (error: (Error|null), response?: code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp) => void;
                        }

                        /** Properties of an EventDefinition. */
                        interface IEventDefinition {

                            /** EventDefinition eventType */
                            eventType?: (string|null);

                            /** EventDefinition displayName */
                            displayName?: (string|null);

                            /** EventDefinition shortDescription */
                            shortDescription?: (string|null);

                            /** EventDefinition description */
                            description?: (string|null);

                            /** EventDefinition schema */
                            schema?: (string|null);

                            /** EventDefinition repoFilepath */
                            repoFilepath?: (string|null);

                            /** EventDefinition deprecated */
                            deprecated?: (boolean|null);

                            /** EventDefinition authorizedFields */
                            authorizedFields?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField[]|null);

                            /** EventDefinition ldapGroup */
                            ldapGroup?: (string|null);
                        }

                        /** Represents an EventDefinition. */
                        class EventDefinition implements IEventDefinition {

                            /**
                             * Constructs a new EventDefinition.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IEventDefinition);

                            /** EventDefinition eventType. */
                            public eventType: string;

                            /** EventDefinition displayName. */
                            public displayName: string;

                            /** EventDefinition shortDescription. */
                            public shortDescription: string;

                            /** EventDefinition description. */
                            public description: string;

                            /** EventDefinition schema. */
                            public schema: string;

                            /** EventDefinition repoFilepath. */
                            public repoFilepath: string;

                            /** EventDefinition deprecated. */
                            public deprecated: boolean;

                            /** EventDefinition authorizedFields. */
                            public authorizedFields: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField[];

                            /** EventDefinition ldapGroup. */
                            public ldapGroup: string;

                            /**
                             * Creates a new EventDefinition instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns EventDefinition instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IEventDefinition): code.justin.tv.eventbus.controlplane.infrastructure.EventDefinition;

                            /**
                             * Encodes the specified EventDefinition message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.EventDefinition.verify|verify} messages.
                             * @param message EventDefinition message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IEventDefinition, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified EventDefinition message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.EventDefinition.verify|verify} messages.
                             * @param message EventDefinition message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IEventDefinition, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an EventDefinition message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns EventDefinition
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.EventDefinition;

                            /**
                             * Decodes an EventDefinition message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns EventDefinition
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.EventDefinition;

                            /**
                             * Verifies an EventDefinition message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an EventDefinition message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns EventDefinition
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.EventDefinition;

                            /**
                             * Creates a plain object from an EventDefinition message. Also converts values to other types if specified.
                             * @param message EventDefinition
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.EventDefinition, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this EventDefinition to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a RegisterEventDefinitionsReq. */
                        interface IRegisterEventDefinitionsReq {

                            /** RegisterEventDefinitionsReq eventDefinitions */
                            eventDefinitions?: (code.justin.tv.eventbus.controlplane.infrastructure.IEventDefinition[]|null);
                        }

                        /** Represents a RegisterEventDefinitionsReq. */
                        class RegisterEventDefinitionsReq implements IRegisterEventDefinitionsReq {

                            /**
                             * Constructs a new RegisterEventDefinitionsReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsReq);

                            /** RegisterEventDefinitionsReq eventDefinitions. */
                            public eventDefinitions: code.justin.tv.eventbus.controlplane.infrastructure.IEventDefinition[];

                            /**
                             * Creates a new RegisterEventDefinitionsReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns RegisterEventDefinitionsReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsReq): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsReq;

                            /**
                             * Encodes the specified RegisterEventDefinitionsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsReq.verify|verify} messages.
                             * @param message RegisterEventDefinitionsReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified RegisterEventDefinitionsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsReq.verify|verify} messages.
                             * @param message RegisterEventDefinitionsReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a RegisterEventDefinitionsReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns RegisterEventDefinitionsReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsReq;

                            /**
                             * Decodes a RegisterEventDefinitionsReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns RegisterEventDefinitionsReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsReq;

                            /**
                             * Verifies a RegisterEventDefinitionsReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a RegisterEventDefinitionsReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns RegisterEventDefinitionsReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsReq;

                            /**
                             * Creates a plain object from a RegisterEventDefinitionsReq message. Also converts values to other types if specified.
                             * @param message RegisterEventDefinitionsReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this RegisterEventDefinitionsReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a RegisterEventDefinitionsResp. */
                        interface IRegisterEventDefinitionsResp {

                            /** RegisterEventDefinitionsResp results */
                            results?: (code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.IResult[]|null);
                        }

                        /** Represents a RegisterEventDefinitionsResp. */
                        class RegisterEventDefinitionsResp implements IRegisterEventDefinitionsResp {

                            /**
                             * Constructs a new RegisterEventDefinitionsResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsResp);

                            /** RegisterEventDefinitionsResp results. */
                            public results: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.IResult[];

                            /**
                             * Creates a new RegisterEventDefinitionsResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns RegisterEventDefinitionsResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsResp): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp;

                            /**
                             * Encodes the specified RegisterEventDefinitionsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.verify|verify} messages.
                             * @param message RegisterEventDefinitionsResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified RegisterEventDefinitionsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.verify|verify} messages.
                             * @param message RegisterEventDefinitionsResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IRegisterEventDefinitionsResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a RegisterEventDefinitionsResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns RegisterEventDefinitionsResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp;

                            /**
                             * Decodes a RegisterEventDefinitionsResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns RegisterEventDefinitionsResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp;

                            /**
                             * Verifies a RegisterEventDefinitionsResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a RegisterEventDefinitionsResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns RegisterEventDefinitionsResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp;

                            /**
                             * Creates a plain object from a RegisterEventDefinitionsResp message. Also converts values to other types if specified.
                             * @param message RegisterEventDefinitionsResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this RegisterEventDefinitionsResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        namespace RegisterEventDefinitionsResp {

                            /** Properties of a Result. */
                            interface IResult {

                                /** Result created */
                                created?: (boolean|null);

                                /** Result messages */
                                messages?: (string[]|null);

                                /** Result eventType */
                                eventType?: (string|null);

                                /** Result environment */
                                environment?: (string|null);
                            }

                            /** Represents a Result. */
                            class Result implements IResult {

                                /**
                                 * Constructs a new Result.
                                 * @param [properties] Properties to set
                                 */
                                constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.IResult);

                                /** Result created. */
                                public created: boolean;

                                /** Result messages. */
                                public messages: string[];

                                /** Result eventType. */
                                public eventType: string;

                                /** Result environment. */
                                public environment: string;

                                /**
                                 * Creates a new Result instance using the specified properties.
                                 * @param [properties] Properties to set
                                 * @returns Result instance
                                 */
                                public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.IResult): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.Result;

                                /**
                                 * Encodes the specified Result message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.Result.verify|verify} messages.
                                 * @param message Result message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.IResult, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Encodes the specified Result message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.Result.verify|verify} messages.
                                 * @param message Result message or plain object to encode
                                 * @param [writer] Writer to encode to
                                 * @returns Writer
                                 */
                                public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.IResult, writer?: $protobuf.Writer): $protobuf.Writer;

                                /**
                                 * Decodes a Result message from the specified reader or buffer.
                                 * @param reader Reader or buffer to decode from
                                 * @param [length] Message length if known beforehand
                                 * @returns Result
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.Result;

                                /**
                                 * Decodes a Result message from the specified reader or buffer, length delimited.
                                 * @param reader Reader or buffer to decode from
                                 * @returns Result
                                 * @throws {Error} If the payload is not a reader or valid buffer
                                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                                 */
                                public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.Result;

                                /**
                                 * Verifies a Result message.
                                 * @param message Plain object to verify
                                 * @returns `null` if valid, otherwise the reason why it is not
                                 */
                                public static verify(message: { [k: string]: any }): (string|null);

                                /**
                                 * Creates a Result message from a plain object. Also converts values to their respective internal types.
                                 * @param object Plain object
                                 * @returns Result
                                 */
                                public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.Result;

                                /**
                                 * Creates a plain object from a Result message. Also converts values to other types if specified.
                                 * @param message Result
                                 * @param [options] Conversion options
                                 * @returns Plain object
                                 */
                                public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.RegisterEventDefinitionsResp.Result, options?: $protobuf.IConversionOptions): { [k: string]: any };

                                /**
                                 * Converts this Result to JSON.
                                 * @returns JSON object
                                 */
                                public toJSON(): { [k: string]: any };
                            }
                        }

                        /** Properties of an AllowAccountsPublishReq. */
                        interface IAllowAccountsPublishReq {

                            /** AllowAccountsPublishReq eventType */
                            eventType?: (string|null);

                            /** AllowAccountsPublishReq serviceId */
                            serviceId?: (string|null);

                            /** AllowAccountsPublishReq environment */
                            environment?: (string|null);

                            /** AllowAccountsPublishReq awsAccountIds */
                            awsAccountIds?: (string[]|null);
                        }

                        /** Represents an AllowAccountsPublishReq. */
                        class AllowAccountsPublishReq implements IAllowAccountsPublishReq {

                            /**
                             * Constructs a new AllowAccountsPublishReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishReq);

                            /** AllowAccountsPublishReq eventType. */
                            public eventType: string;

                            /** AllowAccountsPublishReq serviceId. */
                            public serviceId: string;

                            /** AllowAccountsPublishReq environment. */
                            public environment: string;

                            /** AllowAccountsPublishReq awsAccountIds. */
                            public awsAccountIds: string[];

                            /**
                             * Creates a new AllowAccountsPublishReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns AllowAccountsPublishReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishReq): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishReq;

                            /**
                             * Encodes the specified AllowAccountsPublishReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishReq.verify|verify} messages.
                             * @param message AllowAccountsPublishReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified AllowAccountsPublishReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishReq.verify|verify} messages.
                             * @param message AllowAccountsPublishReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an AllowAccountsPublishReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns AllowAccountsPublishReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishReq;

                            /**
                             * Decodes an AllowAccountsPublishReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns AllowAccountsPublishReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishReq;

                            /**
                             * Verifies an AllowAccountsPublishReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an AllowAccountsPublishReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns AllowAccountsPublishReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishReq;

                            /**
                             * Creates a plain object from an AllowAccountsPublishReq message. Also converts values to other types if specified.
                             * @param message AllowAccountsPublishReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this AllowAccountsPublishReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of an AllowAccountsPublishResp. */
                        interface IAllowAccountsPublishResp {

                            /** AllowAccountsPublishResp added */
                            added?: (boolean|null);
                        }

                        /** Represents an AllowAccountsPublishResp. */
                        class AllowAccountsPublishResp implements IAllowAccountsPublishResp {

                            /**
                             * Constructs a new AllowAccountsPublishResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishResp);

                            /** AllowAccountsPublishResp added. */
                            public added: boolean;

                            /**
                             * Creates a new AllowAccountsPublishResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns AllowAccountsPublishResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishResp): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp;

                            /**
                             * Encodes the specified AllowAccountsPublishResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp.verify|verify} messages.
                             * @param message AllowAccountsPublishResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified AllowAccountsPublishResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp.verify|verify} messages.
                             * @param message AllowAccountsPublishResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowAccountsPublishResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an AllowAccountsPublishResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns AllowAccountsPublishResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp;

                            /**
                             * Decodes an AllowAccountsPublishResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns AllowAccountsPublishResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp;

                            /**
                             * Verifies an AllowAccountsPublishResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an AllowAccountsPublishResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns AllowAccountsPublishResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp;

                            /**
                             * Creates a plain object from an AllowAccountsPublishResp message. Also converts values to other types if specified.
                             * @param message AllowAccountsPublishResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.AllowAccountsPublishResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this AllowAccountsPublishResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of an AllowIAMRolePublishReq. */
                        interface IAllowIAMRolePublishReq {

                            /** AllowIAMRolePublishReq eventType */
                            eventType?: (string|null);

                            /** AllowIAMRolePublishReq environment */
                            environment?: (string|null);

                            /** AllowIAMRolePublishReq iamRole */
                            iamRole?: (string|null);
                        }

                        /** Represents an AllowIAMRolePublishReq. */
                        class AllowIAMRolePublishReq implements IAllowIAMRolePublishReq {

                            /**
                             * Constructs a new AllowIAMRolePublishReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishReq);

                            /** AllowIAMRolePublishReq eventType. */
                            public eventType: string;

                            /** AllowIAMRolePublishReq environment. */
                            public environment: string;

                            /** AllowIAMRolePublishReq iamRole. */
                            public iamRole: string;

                            /**
                             * Creates a new AllowIAMRolePublishReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns AllowIAMRolePublishReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishReq): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishReq;

                            /**
                             * Encodes the specified AllowIAMRolePublishReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishReq.verify|verify} messages.
                             * @param message AllowIAMRolePublishReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified AllowIAMRolePublishReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishReq.verify|verify} messages.
                             * @param message AllowIAMRolePublishReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an AllowIAMRolePublishReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns AllowIAMRolePublishReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishReq;

                            /**
                             * Decodes an AllowIAMRolePublishReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns AllowIAMRolePublishReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishReq;

                            /**
                             * Verifies an AllowIAMRolePublishReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an AllowIAMRolePublishReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns AllowIAMRolePublishReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishReq;

                            /**
                             * Creates a plain object from an AllowIAMRolePublishReq message. Also converts values to other types if specified.
                             * @param message AllowIAMRolePublishReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this AllowIAMRolePublishReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of an AllowIAMRolePublishResp. */
                        interface IAllowIAMRolePublishResp {

                            /** AllowIAMRolePublishResp created */
                            created?: (boolean|null);
                        }

                        /** Represents an AllowIAMRolePublishResp. */
                        class AllowIAMRolePublishResp implements IAllowIAMRolePublishResp {

                            /**
                             * Constructs a new AllowIAMRolePublishResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishResp);

                            /** AllowIAMRolePublishResp created. */
                            public created: boolean;

                            /**
                             * Creates a new AllowIAMRolePublishResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns AllowIAMRolePublishResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishResp): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp;

                            /**
                             * Encodes the specified AllowIAMRolePublishResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp.verify|verify} messages.
                             * @param message AllowIAMRolePublishResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified AllowIAMRolePublishResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp.verify|verify} messages.
                             * @param message AllowIAMRolePublishResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IAllowIAMRolePublishResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an AllowIAMRolePublishResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns AllowIAMRolePublishResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp;

                            /**
                             * Decodes an AllowIAMRolePublishResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns AllowIAMRolePublishResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp;

                            /**
                             * Verifies an AllowIAMRolePublishResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an AllowIAMRolePublishResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns AllowIAMRolePublishResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp;

                            /**
                             * Creates a plain object from an AllowIAMRolePublishResp message. Also converts values to other types if specified.
                             * @param message AllowIAMRolePublishResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.AllowIAMRolePublishResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this AllowIAMRolePublishResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeletePublicationReq. */
                        interface IDeletePublicationReq {

                            /** DeletePublicationReq eventType */
                            eventType?: (string|null);

                            /** DeletePublicationReq environment */
                            environment?: (string|null);

                            /** DeletePublicationReq serviceId */
                            serviceId?: (string|null);
                        }

                        /** Represents a DeletePublicationReq. */
                        class DeletePublicationReq implements IDeletePublicationReq {

                            /**
                             * Constructs a new DeletePublicationReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationReq);

                            /** DeletePublicationReq eventType. */
                            public eventType: string;

                            /** DeletePublicationReq environment. */
                            public environment: string;

                            /** DeletePublicationReq serviceId. */
                            public serviceId: string;

                            /**
                             * Creates a new DeletePublicationReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeletePublicationReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationReq): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationReq;

                            /**
                             * Encodes the specified DeletePublicationReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationReq.verify|verify} messages.
                             * @param message DeletePublicationReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeletePublicationReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationReq.verify|verify} messages.
                             * @param message DeletePublicationReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeletePublicationReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeletePublicationReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationReq;

                            /**
                             * Decodes a DeletePublicationReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeletePublicationReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationReq;

                            /**
                             * Verifies a DeletePublicationReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeletePublicationReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeletePublicationReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationReq;

                            /**
                             * Creates a plain object from a DeletePublicationReq message. Also converts values to other types if specified.
                             * @param message DeletePublicationReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeletePublicationReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeletePublicationResp. */
                        interface IDeletePublicationResp {

                            /** DeletePublicationResp deleted */
                            deleted?: (boolean|null);
                        }

                        /** Represents a DeletePublicationResp. */
                        class DeletePublicationResp implements IDeletePublicationResp {

                            /**
                             * Constructs a new DeletePublicationResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationResp);

                            /** DeletePublicationResp deleted. */
                            public deleted: boolean;

                            /**
                             * Creates a new DeletePublicationResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeletePublicationResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationResp): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp;

                            /**
                             * Encodes the specified DeletePublicationResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp.verify|verify} messages.
                             * @param message DeletePublicationResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeletePublicationResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp.verify|verify} messages.
                             * @param message DeletePublicationResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeletePublicationResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeletePublicationResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeletePublicationResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp;

                            /**
                             * Decodes a DeletePublicationResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeletePublicationResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp;

                            /**
                             * Verifies a DeletePublicationResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeletePublicationResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeletePublicationResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp;

                            /**
                             * Creates a plain object from a DeletePublicationResp message. Also converts values to other types if specified.
                             * @param message DeletePublicationResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeletePublicationResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeletePublicationResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteIAMRolePublicationReq. */
                        interface IDeleteIAMRolePublicationReq {

                            /** DeleteIAMRolePublicationReq eventType */
                            eventType?: (string|null);

                            /** DeleteIAMRolePublicationReq environment */
                            environment?: (string|null);

                            /** DeleteIAMRolePublicationReq iamRoleArn */
                            iamRoleArn?: (string|null);
                        }

                        /** Represents a DeleteIAMRolePublicationReq. */
                        class DeleteIAMRolePublicationReq implements IDeleteIAMRolePublicationReq {

                            /**
                             * Constructs a new DeleteIAMRolePublicationReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationReq);

                            /** DeleteIAMRolePublicationReq eventType. */
                            public eventType: string;

                            /** DeleteIAMRolePublicationReq environment. */
                            public environment: string;

                            /** DeleteIAMRolePublicationReq iamRoleArn. */
                            public iamRoleArn: string;

                            /**
                             * Creates a new DeleteIAMRolePublicationReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteIAMRolePublicationReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationReq): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationReq;

                            /**
                             * Encodes the specified DeleteIAMRolePublicationReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationReq.verify|verify} messages.
                             * @param message DeleteIAMRolePublicationReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteIAMRolePublicationReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationReq.verify|verify} messages.
                             * @param message DeleteIAMRolePublicationReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteIAMRolePublicationReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteIAMRolePublicationReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationReq;

                            /**
                             * Decodes a DeleteIAMRolePublicationReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteIAMRolePublicationReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationReq;

                            /**
                             * Verifies a DeleteIAMRolePublicationReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteIAMRolePublicationReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteIAMRolePublicationReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationReq;

                            /**
                             * Creates a plain object from a DeleteIAMRolePublicationReq message. Also converts values to other types if specified.
                             * @param message DeleteIAMRolePublicationReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteIAMRolePublicationReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteIAMRolePublicationResp. */
                        interface IDeleteIAMRolePublicationResp {
                        }

                        /** Represents a DeleteIAMRolePublicationResp. */
                        class DeleteIAMRolePublicationResp implements IDeleteIAMRolePublicationResp {

                            /**
                             * Constructs a new DeleteIAMRolePublicationResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationResp);

                            /**
                             * Creates a new DeleteIAMRolePublicationResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteIAMRolePublicationResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationResp): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp;

                            /**
                             * Encodes the specified DeleteIAMRolePublicationResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp.verify|verify} messages.
                             * @param message DeleteIAMRolePublicationResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteIAMRolePublicationResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp.verify|verify} messages.
                             * @param message DeleteIAMRolePublicationResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteIAMRolePublicationResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteIAMRolePublicationResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteIAMRolePublicationResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp;

                            /**
                             * Decodes a DeleteIAMRolePublicationResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteIAMRolePublicationResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp;

                            /**
                             * Verifies a DeleteIAMRolePublicationResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteIAMRolePublicationResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteIAMRolePublicationResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp;

                            /**
                             * Creates a plain object from a DeleteIAMRolePublicationResp message. Also converts values to other types if specified.
                             * @param message DeleteIAMRolePublicationResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteIAMRolePublicationResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteIAMRolePublicationResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a ListPublicationsByEventStreamReq. */
                        interface IListPublicationsByEventStreamReq {

                            /** ListPublicationsByEventStreamReq eventType */
                            eventType?: (string|null);

                            /** ListPublicationsByEventStreamReq environment */
                            environment?: (string|null);
                        }

                        /** Represents a ListPublicationsByEventStreamReq. */
                        class ListPublicationsByEventStreamReq implements IListPublicationsByEventStreamReq {

                            /**
                             * Constructs a new ListPublicationsByEventStreamReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamReq);

                            /** ListPublicationsByEventStreamReq eventType. */
                            public eventType: string;

                            /** ListPublicationsByEventStreamReq environment. */
                            public environment: string;

                            /**
                             * Creates a new ListPublicationsByEventStreamReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns ListPublicationsByEventStreamReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamReq): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamReq;

                            /**
                             * Encodes the specified ListPublicationsByEventStreamReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamReq.verify|verify} messages.
                             * @param message ListPublicationsByEventStreamReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified ListPublicationsByEventStreamReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamReq.verify|verify} messages.
                             * @param message ListPublicationsByEventStreamReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a ListPublicationsByEventStreamReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns ListPublicationsByEventStreamReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamReq;

                            /**
                             * Decodes a ListPublicationsByEventStreamReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns ListPublicationsByEventStreamReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamReq;

                            /**
                             * Verifies a ListPublicationsByEventStreamReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a ListPublicationsByEventStreamReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns ListPublicationsByEventStreamReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamReq;

                            /**
                             * Creates a plain object from a ListPublicationsByEventStreamReq message. Also converts values to other types if specified.
                             * @param message ListPublicationsByEventStreamReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this ListPublicationsByEventStreamReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a ListPublicationsByEventStreamResp. */
                        interface IListPublicationsByEventStreamResp {

                            /** ListPublicationsByEventStreamResp publications */
                            publications?: (code.justin.tv.eventbus.controlplane.infrastructure.IPublication[]|null);
                        }

                        /** Represents a ListPublicationsByEventStreamResp. */
                        class ListPublicationsByEventStreamResp implements IListPublicationsByEventStreamResp {

                            /**
                             * Constructs a new ListPublicationsByEventStreamResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamResp);

                            /** ListPublicationsByEventStreamResp publications. */
                            public publications: code.justin.tv.eventbus.controlplane.infrastructure.IPublication[];

                            /**
                             * Creates a new ListPublicationsByEventStreamResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns ListPublicationsByEventStreamResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamResp): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp;

                            /**
                             * Encodes the specified ListPublicationsByEventStreamResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp.verify|verify} messages.
                             * @param message ListPublicationsByEventStreamResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified ListPublicationsByEventStreamResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp.verify|verify} messages.
                             * @param message ListPublicationsByEventStreamResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IListPublicationsByEventStreamResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a ListPublicationsByEventStreamResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns ListPublicationsByEventStreamResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp;

                            /**
                             * Decodes a ListPublicationsByEventStreamResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns ListPublicationsByEventStreamResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp;

                            /**
                             * Verifies a ListPublicationsByEventStreamResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a ListPublicationsByEventStreamResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns ListPublicationsByEventStreamResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp;

                            /**
                             * Creates a plain object from a ListPublicationsByEventStreamResp message. Also converts values to other types if specified.
                             * @param message ListPublicationsByEventStreamResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.ListPublicationsByEventStreamResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this ListPublicationsByEventStreamResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a CreateAuthorizedFieldSubscriberGrantReq. */
                        interface ICreateAuthorizedFieldSubscriberGrantReq {

                            /** CreateAuthorizedFieldSubscriberGrantReq eventType */
                            eventType?: (string|null);

                            /** CreateAuthorizedFieldSubscriberGrantReq environment */
                            environment?: (string|null);

                            /** CreateAuthorizedFieldSubscriberGrantReq authorizedField */
                            authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);

                            /** CreateAuthorizedFieldSubscriberGrantReq iamRole */
                            iamRole?: (string|null);
                        }

                        /** Represents a CreateAuthorizedFieldSubscriberGrantReq. */
                        class CreateAuthorizedFieldSubscriberGrantReq implements ICreateAuthorizedFieldSubscriberGrantReq {

                            /**
                             * Constructs a new CreateAuthorizedFieldSubscriberGrantReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantReq);

                            /** CreateAuthorizedFieldSubscriberGrantReq eventType. */
                            public eventType: string;

                            /** CreateAuthorizedFieldSubscriberGrantReq environment. */
                            public environment: string;

                            /** CreateAuthorizedFieldSubscriberGrantReq authorizedField. */
                            public authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);

                            /** CreateAuthorizedFieldSubscriberGrantReq iamRole. */
                            public iamRole: string;

                            /**
                             * Creates a new CreateAuthorizedFieldSubscriberGrantReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns CreateAuthorizedFieldSubscriberGrantReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantReq): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Encodes the specified CreateAuthorizedFieldSubscriberGrantReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantReq.verify|verify} messages.
                             * @param message CreateAuthorizedFieldSubscriberGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified CreateAuthorizedFieldSubscriberGrantReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantReq.verify|verify} messages.
                             * @param message CreateAuthorizedFieldSubscriberGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a CreateAuthorizedFieldSubscriberGrantReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns CreateAuthorizedFieldSubscriberGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Decodes a CreateAuthorizedFieldSubscriberGrantReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns CreateAuthorizedFieldSubscriberGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Verifies a CreateAuthorizedFieldSubscriberGrantReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a CreateAuthorizedFieldSubscriberGrantReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns CreateAuthorizedFieldSubscriberGrantReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Creates a plain object from a CreateAuthorizedFieldSubscriberGrantReq message. Also converts values to other types if specified.
                             * @param message CreateAuthorizedFieldSubscriberGrantReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this CreateAuthorizedFieldSubscriberGrantReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a CreateAuthorizedFieldSubscriberGrantResp. */
                        interface ICreateAuthorizedFieldSubscriberGrantResp {
                        }

                        /** Represents a CreateAuthorizedFieldSubscriberGrantResp. */
                        class CreateAuthorizedFieldSubscriberGrantResp implements ICreateAuthorizedFieldSubscriberGrantResp {

                            /**
                             * Constructs a new CreateAuthorizedFieldSubscriberGrantResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantResp);

                            /**
                             * Creates a new CreateAuthorizedFieldSubscriberGrantResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns CreateAuthorizedFieldSubscriberGrantResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantResp): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Encodes the specified CreateAuthorizedFieldSubscriberGrantResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp.verify|verify} messages.
                             * @param message CreateAuthorizedFieldSubscriberGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified CreateAuthorizedFieldSubscriberGrantResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp.verify|verify} messages.
                             * @param message CreateAuthorizedFieldSubscriberGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldSubscriberGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a CreateAuthorizedFieldSubscriberGrantResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns CreateAuthorizedFieldSubscriberGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Decodes a CreateAuthorizedFieldSubscriberGrantResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns CreateAuthorizedFieldSubscriberGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Verifies a CreateAuthorizedFieldSubscriberGrantResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a CreateAuthorizedFieldSubscriberGrantResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns CreateAuthorizedFieldSubscriberGrantResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Creates a plain object from a CreateAuthorizedFieldSubscriberGrantResp message. Also converts values to other types if specified.
                             * @param message CreateAuthorizedFieldSubscriberGrantResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldSubscriberGrantResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this CreateAuthorizedFieldSubscriberGrantResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a CreateAuthorizedFieldPublisherGrantReq. */
                        interface ICreateAuthorizedFieldPublisherGrantReq {

                            /** CreateAuthorizedFieldPublisherGrantReq eventType */
                            eventType?: (string|null);

                            /** CreateAuthorizedFieldPublisherGrantReq environment */
                            environment?: (string|null);

                            /** CreateAuthorizedFieldPublisherGrantReq iamRole */
                            iamRole?: (string|null);
                        }

                        /** Represents a CreateAuthorizedFieldPublisherGrantReq. */
                        class CreateAuthorizedFieldPublisherGrantReq implements ICreateAuthorizedFieldPublisherGrantReq {

                            /**
                             * Constructs a new CreateAuthorizedFieldPublisherGrantReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantReq);

                            /** CreateAuthorizedFieldPublisherGrantReq eventType. */
                            public eventType: string;

                            /** CreateAuthorizedFieldPublisherGrantReq environment. */
                            public environment: string;

                            /** CreateAuthorizedFieldPublisherGrantReq iamRole. */
                            public iamRole: string;

                            /**
                             * Creates a new CreateAuthorizedFieldPublisherGrantReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns CreateAuthorizedFieldPublisherGrantReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantReq): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantReq;

                            /**
                             * Encodes the specified CreateAuthorizedFieldPublisherGrantReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantReq.verify|verify} messages.
                             * @param message CreateAuthorizedFieldPublisherGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified CreateAuthorizedFieldPublisherGrantReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantReq.verify|verify} messages.
                             * @param message CreateAuthorizedFieldPublisherGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a CreateAuthorizedFieldPublisherGrantReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns CreateAuthorizedFieldPublisherGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantReq;

                            /**
                             * Decodes a CreateAuthorizedFieldPublisherGrantReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns CreateAuthorizedFieldPublisherGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantReq;

                            /**
                             * Verifies a CreateAuthorizedFieldPublisherGrantReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a CreateAuthorizedFieldPublisherGrantReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns CreateAuthorizedFieldPublisherGrantReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantReq;

                            /**
                             * Creates a plain object from a CreateAuthorizedFieldPublisherGrantReq message. Also converts values to other types if specified.
                             * @param message CreateAuthorizedFieldPublisherGrantReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this CreateAuthorizedFieldPublisherGrantReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a CreateAuthorizedFieldPublisherGrantResp. */
                        interface ICreateAuthorizedFieldPublisherGrantResp {
                        }

                        /** Represents a CreateAuthorizedFieldPublisherGrantResp. */
                        class CreateAuthorizedFieldPublisherGrantResp implements ICreateAuthorizedFieldPublisherGrantResp {

                            /**
                             * Constructs a new CreateAuthorizedFieldPublisherGrantResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantResp);

                            /**
                             * Creates a new CreateAuthorizedFieldPublisherGrantResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns CreateAuthorizedFieldPublisherGrantResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantResp): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp;

                            /**
                             * Encodes the specified CreateAuthorizedFieldPublisherGrantResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp.verify|verify} messages.
                             * @param message CreateAuthorizedFieldPublisherGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified CreateAuthorizedFieldPublisherGrantResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp.verify|verify} messages.
                             * @param message CreateAuthorizedFieldPublisherGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.ICreateAuthorizedFieldPublisherGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a CreateAuthorizedFieldPublisherGrantResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns CreateAuthorizedFieldPublisherGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp;

                            /**
                             * Decodes a CreateAuthorizedFieldPublisherGrantResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns CreateAuthorizedFieldPublisherGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp;

                            /**
                             * Verifies a CreateAuthorizedFieldPublisherGrantResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a CreateAuthorizedFieldPublisherGrantResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns CreateAuthorizedFieldPublisherGrantResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp;

                            /**
                             * Creates a plain object from a CreateAuthorizedFieldPublisherGrantResp message. Also converts values to other types if specified.
                             * @param message CreateAuthorizedFieldPublisherGrantResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.CreateAuthorizedFieldPublisherGrantResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this CreateAuthorizedFieldPublisherGrantResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of an AuthorizedField. */
                        interface IAuthorizedField {

                            /** AuthorizedField messageName */
                            messageName?: (string|null);

                            /** AuthorizedField fieldName */
                            fieldName?: (string|null);
                        }

                        /** Represents an AuthorizedField. */
                        class AuthorizedField implements IAuthorizedField {

                            /**
                             * Constructs a new AuthorizedField.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField);

                            /** AuthorizedField messageName. */
                            public messageName: string;

                            /** AuthorizedField fieldName. */
                            public fieldName: string;

                            /**
                             * Creates a new AuthorizedField instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns AuthorizedField instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedField;

                            /**
                             * Encodes the specified AuthorizedField message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedField.verify|verify} messages.
                             * @param message AuthorizedField message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified AuthorizedField message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedField.verify|verify} messages.
                             * @param message AuthorizedField message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an AuthorizedField message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns AuthorizedField
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedField;

                            /**
                             * Decodes an AuthorizedField message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns AuthorizedField
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedField;

                            /**
                             * Verifies an AuthorizedField message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an AuthorizedField message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns AuthorizedField
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedField;

                            /**
                             * Creates a plain object from an AuthorizedField message. Also converts values to other types if specified.
                             * @param message AuthorizedField
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedField, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this AuthorizedField to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a RevokeAuthorizedFieldGrantReq. */
                        interface IRevokeAuthorizedFieldGrantReq {

                            /** RevokeAuthorizedFieldGrantReq publisher */
                            publisher?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant|null);

                            /** RevokeAuthorizedFieldGrantReq subscriber */
                            subscriber?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant|null);
                        }

                        /** Represents a RevokeAuthorizedFieldGrantReq. */
                        class RevokeAuthorizedFieldGrantReq implements IRevokeAuthorizedFieldGrantReq {

                            /**
                             * Constructs a new RevokeAuthorizedFieldGrantReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantReq);

                            /** RevokeAuthorizedFieldGrantReq publisher. */
                            public publisher?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant|null);

                            /** RevokeAuthorizedFieldGrantReq subscriber. */
                            public subscriber?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant|null);

                            /** RevokeAuthorizedFieldGrantReq revocationType. */
                            public revocationType?: ("publisher"|"subscriber");

                            /**
                             * Creates a new RevokeAuthorizedFieldGrantReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns RevokeAuthorizedFieldGrantReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantReq): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantReq;

                            /**
                             * Encodes the specified RevokeAuthorizedFieldGrantReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantReq.verify|verify} messages.
                             * @param message RevokeAuthorizedFieldGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified RevokeAuthorizedFieldGrantReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantReq.verify|verify} messages.
                             * @param message RevokeAuthorizedFieldGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a RevokeAuthorizedFieldGrantReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns RevokeAuthorizedFieldGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantReq;

                            /**
                             * Decodes a RevokeAuthorizedFieldGrantReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns RevokeAuthorizedFieldGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantReq;

                            /**
                             * Verifies a RevokeAuthorizedFieldGrantReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a RevokeAuthorizedFieldGrantReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns RevokeAuthorizedFieldGrantReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantReq;

                            /**
                             * Creates a plain object from a RevokeAuthorizedFieldGrantReq message. Also converts values to other types if specified.
                             * @param message RevokeAuthorizedFieldGrantReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this RevokeAuthorizedFieldGrantReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a RevokeAuthorizedFieldGrantResp. */
                        interface IRevokeAuthorizedFieldGrantResp {

                            /** RevokeAuthorizedFieldGrantResp revoked */
                            revoked?: (boolean|null);
                        }

                        /** Represents a RevokeAuthorizedFieldGrantResp. */
                        class RevokeAuthorizedFieldGrantResp implements IRevokeAuthorizedFieldGrantResp {

                            /**
                             * Constructs a new RevokeAuthorizedFieldGrantResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantResp);

                            /** RevokeAuthorizedFieldGrantResp revoked. */
                            public revoked: boolean;

                            /**
                             * Creates a new RevokeAuthorizedFieldGrantResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns RevokeAuthorizedFieldGrantResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantResp): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp;

                            /**
                             * Encodes the specified RevokeAuthorizedFieldGrantResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp.verify|verify} messages.
                             * @param message RevokeAuthorizedFieldGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified RevokeAuthorizedFieldGrantResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp.verify|verify} messages.
                             * @param message RevokeAuthorizedFieldGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IRevokeAuthorizedFieldGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a RevokeAuthorizedFieldGrantResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns RevokeAuthorizedFieldGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp;

                            /**
                             * Decodes a RevokeAuthorizedFieldGrantResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns RevokeAuthorizedFieldGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp;

                            /**
                             * Verifies a RevokeAuthorizedFieldGrantResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a RevokeAuthorizedFieldGrantResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns RevokeAuthorizedFieldGrantResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp;

                            /**
                             * Creates a plain object from a RevokeAuthorizedFieldGrantResp message. Also converts values to other types if specified.
                             * @param message RevokeAuthorizedFieldGrantResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.RevokeAuthorizedFieldGrantResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this RevokeAuthorizedFieldGrantResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq. */
                        interface IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq {

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq eventType */
                            eventType?: (string|null);

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq environment */
                            environment?: (string|null);

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq authorizedField */
                            authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);
                        }

                        /** Represents a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq. */
                        class ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq implements IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq {

                            /**
                             * Constructs a new ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq);

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq eventType. */
                            public eventType: string;

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq environment. */
                            public environment: string;

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq authorizedField. */
                            public authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);

                            /**
                             * Creates a new ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq;

                            /**
                             * Encodes the specified ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq.verify|verify} messages.
                             * @param message ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq.verify|verify} messages.
                             * @param message ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq;

                            /**
                             * Decodes a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq;

                            /**
                             * Verifies a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq;

                            /**
                             * Creates a plain object from a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq message. Also converts values to other types if specified.
                             * @param message ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp. */
                        interface IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp {

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp subscriberGrants */
                            subscriberGrants?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant[]|null);
                        }

                        /** Represents a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp. */
                        class ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp implements IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp {

                            /**
                             * Constructs a new ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp);

                            /** ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp subscriberGrants. */
                            public subscriberGrants: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant[];

                            /**
                             * Creates a new ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp;

                            /**
                             * Encodes the specified ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp.verify|verify} messages.
                             * @param message ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp.verify|verify} messages.
                             * @param message ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp;

                            /**
                             * Decodes a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp;

                            /**
                             * Verifies a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp;

                            /**
                             * Creates a plain object from a ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp message. Also converts values to other types if specified.
                             * @param message ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this ListAuthorizedFieldSubscriberGrantsByAuthorizedFieldResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteAuthorizedFieldGrantReq. */
                        interface IDeleteAuthorizedFieldGrantReq {

                            /** DeleteAuthorizedFieldGrantReq publisher */
                            publisher?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant|null);

                            /** DeleteAuthorizedFieldGrantReq subscriber */
                            subscriber?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant|null);
                        }

                        /** Represents a DeleteAuthorizedFieldGrantReq. */
                        class DeleteAuthorizedFieldGrantReq implements IDeleteAuthorizedFieldGrantReq {

                            /**
                             * Constructs a new DeleteAuthorizedFieldGrantReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantReq);

                            /** DeleteAuthorizedFieldGrantReq publisher. */
                            public publisher?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant|null);

                            /** DeleteAuthorizedFieldGrantReq subscriber. */
                            public subscriber?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant|null);

                            /** DeleteAuthorizedFieldGrantReq grant. */
                            public grant?: ("publisher"|"subscriber");

                            /**
                             * Creates a new DeleteAuthorizedFieldGrantReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteAuthorizedFieldGrantReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantReq): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantReq;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldGrantReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantReq.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldGrantReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantReq.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteAuthorizedFieldGrantReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteAuthorizedFieldGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantReq;

                            /**
                             * Decodes a DeleteAuthorizedFieldGrantReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteAuthorizedFieldGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantReq;

                            /**
                             * Verifies a DeleteAuthorizedFieldGrantReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteAuthorizedFieldGrantReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteAuthorizedFieldGrantReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantReq;

                            /**
                             * Creates a plain object from a DeleteAuthorizedFieldGrantReq message. Also converts values to other types if specified.
                             * @param message DeleteAuthorizedFieldGrantReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteAuthorizedFieldGrantReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteAuthorizedFieldGrantResp. */
                        interface IDeleteAuthorizedFieldGrantResp {

                            /** DeleteAuthorizedFieldGrantResp deleted */
                            deleted?: (boolean|null);
                        }

                        /** Represents a DeleteAuthorizedFieldGrantResp. */
                        class DeleteAuthorizedFieldGrantResp implements IDeleteAuthorizedFieldGrantResp {

                            /**
                             * Constructs a new DeleteAuthorizedFieldGrantResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantResp);

                            /** DeleteAuthorizedFieldGrantResp deleted. */
                            public deleted: boolean;

                            /**
                             * Creates a new DeleteAuthorizedFieldGrantResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteAuthorizedFieldGrantResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantResp): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldGrantResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldGrantResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteAuthorizedFieldGrantResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteAuthorizedFieldGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp;

                            /**
                             * Decodes a DeleteAuthorizedFieldGrantResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteAuthorizedFieldGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp;

                            /**
                             * Verifies a DeleteAuthorizedFieldGrantResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteAuthorizedFieldGrantResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteAuthorizedFieldGrantResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp;

                            /**
                             * Creates a plain object from a DeleteAuthorizedFieldGrantResp message. Also converts values to other types if specified.
                             * @param message DeleteAuthorizedFieldGrantResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldGrantResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteAuthorizedFieldGrantResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteAuthorizedFieldSubscriberGrantReq. */
                        interface IDeleteAuthorizedFieldSubscriberGrantReq {

                            /** DeleteAuthorizedFieldSubscriberGrantReq grant */
                            grant?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant|null);
                        }

                        /** Represents a DeleteAuthorizedFieldSubscriberGrantReq. */
                        class DeleteAuthorizedFieldSubscriberGrantReq implements IDeleteAuthorizedFieldSubscriberGrantReq {

                            /**
                             * Constructs a new DeleteAuthorizedFieldSubscriberGrantReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantReq);

                            /** DeleteAuthorizedFieldSubscriberGrantReq grant. */
                            public grant?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant|null);

                            /**
                             * Creates a new DeleteAuthorizedFieldSubscriberGrantReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteAuthorizedFieldSubscriberGrantReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantReq): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldSubscriberGrantReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantReq.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldSubscriberGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldSubscriberGrantReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantReq.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldSubscriberGrantReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteAuthorizedFieldSubscriberGrantReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteAuthorizedFieldSubscriberGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Decodes a DeleteAuthorizedFieldSubscriberGrantReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteAuthorizedFieldSubscriberGrantReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Verifies a DeleteAuthorizedFieldSubscriberGrantReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteAuthorizedFieldSubscriberGrantReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteAuthorizedFieldSubscriberGrantReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantReq;

                            /**
                             * Creates a plain object from a DeleteAuthorizedFieldSubscriberGrantReq message. Also converts values to other types if specified.
                             * @param message DeleteAuthorizedFieldSubscriberGrantReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteAuthorizedFieldSubscriberGrantReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteAuthorizedFieldSubscriberGrantResp. */
                        interface IDeleteAuthorizedFieldSubscriberGrantResp {

                            /** DeleteAuthorizedFieldSubscriberGrantResp deleted */
                            deleted?: (boolean|null);
                        }

                        /** Represents a DeleteAuthorizedFieldSubscriberGrantResp. */
                        class DeleteAuthorizedFieldSubscriberGrantResp implements IDeleteAuthorizedFieldSubscriberGrantResp {

                            /**
                             * Constructs a new DeleteAuthorizedFieldSubscriberGrantResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantResp);

                            /** DeleteAuthorizedFieldSubscriberGrantResp deleted. */
                            public deleted: boolean;

                            /**
                             * Creates a new DeleteAuthorizedFieldSubscriberGrantResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteAuthorizedFieldSubscriberGrantResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantResp): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldSubscriberGrantResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldSubscriberGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldSubscriberGrantResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldSubscriberGrantResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldSubscriberGrantResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteAuthorizedFieldSubscriberGrantResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteAuthorizedFieldSubscriberGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Decodes a DeleteAuthorizedFieldSubscriberGrantResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteAuthorizedFieldSubscriberGrantResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Verifies a DeleteAuthorizedFieldSubscriberGrantResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteAuthorizedFieldSubscriberGrantResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteAuthorizedFieldSubscriberGrantResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp;

                            /**
                             * Creates a plain object from a DeleteAuthorizedFieldSubscriberGrantResp message. Also converts values to other types if specified.
                             * @param message DeleteAuthorizedFieldSubscriberGrantResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldSubscriberGrantResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteAuthorizedFieldSubscriberGrantResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteEventTypeReq. */
                        interface IDeleteEventTypeReq {

                            /** DeleteEventTypeReq eventType */
                            eventType?: (string|null);
                        }

                        /** Represents a DeleteEventTypeReq. */
                        class DeleteEventTypeReq implements IDeleteEventTypeReq {

                            /**
                             * Constructs a new DeleteEventTypeReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeReq);

                            /** DeleteEventTypeReq eventType. */
                            public eventType: string;

                            /**
                             * Creates a new DeleteEventTypeReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteEventTypeReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeReq): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeReq;

                            /**
                             * Encodes the specified DeleteEventTypeReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeReq.verify|verify} messages.
                             * @param message DeleteEventTypeReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteEventTypeReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeReq.verify|verify} messages.
                             * @param message DeleteEventTypeReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteEventTypeReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteEventTypeReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeReq;

                            /**
                             * Decodes a DeleteEventTypeReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteEventTypeReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeReq;

                            /**
                             * Verifies a DeleteEventTypeReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteEventTypeReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteEventTypeReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeReq;

                            /**
                             * Creates a plain object from a DeleteEventTypeReq message. Also converts values to other types if specified.
                             * @param message DeleteEventTypeReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteEventTypeReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteEventTypeResp. */
                        interface IDeleteEventTypeResp {

                            /** DeleteEventTypeResp deleted */
                            deleted?: (boolean|null);
                        }

                        /** Represents a DeleteEventTypeResp. */
                        class DeleteEventTypeResp implements IDeleteEventTypeResp {

                            /**
                             * Constructs a new DeleteEventTypeResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeResp);

                            /** DeleteEventTypeResp deleted. */
                            public deleted: boolean;

                            /**
                             * Creates a new DeleteEventTypeResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteEventTypeResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeResp): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp;

                            /**
                             * Encodes the specified DeleteEventTypeResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp.verify|verify} messages.
                             * @param message DeleteEventTypeResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteEventTypeResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp.verify|verify} messages.
                             * @param message DeleteEventTypeResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteEventTypeResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteEventTypeResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp;

                            /**
                             * Decodes a DeleteEventTypeResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteEventTypeResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp;

                            /**
                             * Verifies a DeleteEventTypeResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteEventTypeResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteEventTypeResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp;

                            /**
                             * Creates a plain object from a DeleteEventTypeResp message. Also converts values to other types if specified.
                             * @param message DeleteEventTypeResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventTypeResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteEventTypeResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteEventStreamsForEventTypeReq. */
                        interface IDeleteEventStreamsForEventTypeReq {

                            /** DeleteEventStreamsForEventTypeReq eventType */
                            eventType?: (string|null);
                        }

                        /** Represents a DeleteEventStreamsForEventTypeReq. */
                        class DeleteEventStreamsForEventTypeReq implements IDeleteEventStreamsForEventTypeReq {

                            /**
                             * Constructs a new DeleteEventStreamsForEventTypeReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeReq);

                            /** DeleteEventStreamsForEventTypeReq eventType. */
                            public eventType: string;

                            /**
                             * Creates a new DeleteEventStreamsForEventTypeReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteEventStreamsForEventTypeReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeReq): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeReq;

                            /**
                             * Encodes the specified DeleteEventStreamsForEventTypeReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeReq.verify|verify} messages.
                             * @param message DeleteEventStreamsForEventTypeReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteEventStreamsForEventTypeReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeReq.verify|verify} messages.
                             * @param message DeleteEventStreamsForEventTypeReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteEventStreamsForEventTypeReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteEventStreamsForEventTypeReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeReq;

                            /**
                             * Decodes a DeleteEventStreamsForEventTypeReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteEventStreamsForEventTypeReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeReq;

                            /**
                             * Verifies a DeleteEventStreamsForEventTypeReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteEventStreamsForEventTypeReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteEventStreamsForEventTypeReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeReq;

                            /**
                             * Creates a plain object from a DeleteEventStreamsForEventTypeReq message. Also converts values to other types if specified.
                             * @param message DeleteEventStreamsForEventTypeReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteEventStreamsForEventTypeReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteEventStreamsForEventTypeResp. */
                        interface IDeleteEventStreamsForEventTypeResp {

                            /** DeleteEventStreamsForEventTypeResp deleted */
                            deleted?: (boolean|null);

                            /** DeleteEventStreamsForEventTypeResp numDeleted */
                            numDeleted?: (number|null);
                        }

                        /** Represents a DeleteEventStreamsForEventTypeResp. */
                        class DeleteEventStreamsForEventTypeResp implements IDeleteEventStreamsForEventTypeResp {

                            /**
                             * Constructs a new DeleteEventStreamsForEventTypeResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeResp);

                            /** DeleteEventStreamsForEventTypeResp deleted. */
                            public deleted: boolean;

                            /** DeleteEventStreamsForEventTypeResp numDeleted. */
                            public numDeleted: number;

                            /**
                             * Creates a new DeleteEventStreamsForEventTypeResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteEventStreamsForEventTypeResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeResp): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp;

                            /**
                             * Encodes the specified DeleteEventStreamsForEventTypeResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp.verify|verify} messages.
                             * @param message DeleteEventStreamsForEventTypeResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteEventStreamsForEventTypeResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp.verify|verify} messages.
                             * @param message DeleteEventStreamsForEventTypeResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteEventStreamsForEventTypeResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteEventStreamsForEventTypeResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteEventStreamsForEventTypeResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp;

                            /**
                             * Decodes a DeleteEventStreamsForEventTypeResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteEventStreamsForEventTypeResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp;

                            /**
                             * Verifies a DeleteEventStreamsForEventTypeResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteEventStreamsForEventTypeResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteEventStreamsForEventTypeResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp;

                            /**
                             * Creates a plain object from a DeleteEventStreamsForEventTypeResp message. Also converts values to other types if specified.
                             * @param message DeleteEventStreamsForEventTypeResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteEventStreamsForEventTypeResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteEventStreamsForEventTypeResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteAuthorizedFieldReq. */
                        interface IDeleteAuthorizedFieldReq {

                            /** DeleteAuthorizedFieldReq eventType */
                            eventType?: (string|null);

                            /** DeleteAuthorizedFieldReq environment */
                            environment?: (string|null);

                            /** DeleteAuthorizedFieldReq authorizedField */
                            authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);
                        }

                        /** Represents a DeleteAuthorizedFieldReq. */
                        class DeleteAuthorizedFieldReq implements IDeleteAuthorizedFieldReq {

                            /**
                             * Constructs a new DeleteAuthorizedFieldReq.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldReq);

                            /** DeleteAuthorizedFieldReq eventType. */
                            public eventType: string;

                            /** DeleteAuthorizedFieldReq environment. */
                            public environment: string;

                            /** DeleteAuthorizedFieldReq authorizedField. */
                            public authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);

                            /**
                             * Creates a new DeleteAuthorizedFieldReq instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteAuthorizedFieldReq instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldReq): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldReq;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldReq.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldReq.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldReq message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldReq, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteAuthorizedFieldReq message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteAuthorizedFieldReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldReq;

                            /**
                             * Decodes a DeleteAuthorizedFieldReq message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteAuthorizedFieldReq
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldReq;

                            /**
                             * Verifies a DeleteAuthorizedFieldReq message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteAuthorizedFieldReq message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteAuthorizedFieldReq
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldReq;

                            /**
                             * Creates a plain object from a DeleteAuthorizedFieldReq message. Also converts values to other types if specified.
                             * @param message DeleteAuthorizedFieldReq
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldReq, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteAuthorizedFieldReq to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a DeleteAuthorizedFieldResp. */
                        interface IDeleteAuthorizedFieldResp {

                            /** DeleteAuthorizedFieldResp deleted */
                            deleted?: (boolean|null);
                        }

                        /** Represents a DeleteAuthorizedFieldResp. */
                        class DeleteAuthorizedFieldResp implements IDeleteAuthorizedFieldResp {

                            /**
                             * Constructs a new DeleteAuthorizedFieldResp.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldResp);

                            /** DeleteAuthorizedFieldResp deleted. */
                            public deleted: boolean;

                            /**
                             * Creates a new DeleteAuthorizedFieldResp instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns DeleteAuthorizedFieldResp instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldResp): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified DeleteAuthorizedFieldResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp.verify|verify} messages.
                             * @param message DeleteAuthorizedFieldResp message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IDeleteAuthorizedFieldResp, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a DeleteAuthorizedFieldResp message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns DeleteAuthorizedFieldResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp;

                            /**
                             * Decodes a DeleteAuthorizedFieldResp message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns DeleteAuthorizedFieldResp
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp;

                            /**
                             * Verifies a DeleteAuthorizedFieldResp message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a DeleteAuthorizedFieldResp message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns DeleteAuthorizedFieldResp
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp;

                            /**
                             * Creates a plain object from a DeleteAuthorizedFieldResp message. Also converts values to other types if specified.
                             * @param message DeleteAuthorizedFieldResp
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.DeleteAuthorizedFieldResp, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this DeleteAuthorizedFieldResp to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of an AuthorizedFieldPublisherGrant. */
                        interface IAuthorizedFieldPublisherGrant {

                            /** AuthorizedFieldPublisherGrant eventType */
                            eventType?: (string|null);

                            /** AuthorizedFieldPublisherGrant environment */
                            environment?: (string|null);

                            /** AuthorizedFieldPublisherGrant iamRole */
                            iamRole?: (string|null);
                        }

                        /** Represents an AuthorizedFieldPublisherGrant. */
                        class AuthorizedFieldPublisherGrant implements IAuthorizedFieldPublisherGrant {

                            /**
                             * Constructs a new AuthorizedFieldPublisherGrant.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant);

                            /** AuthorizedFieldPublisherGrant eventType. */
                            public eventType: string;

                            /** AuthorizedFieldPublisherGrant environment. */
                            public environment: string;

                            /** AuthorizedFieldPublisherGrant iamRole. */
                            public iamRole: string;

                            /**
                             * Creates a new AuthorizedFieldPublisherGrant instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns AuthorizedFieldPublisherGrant instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldPublisherGrant;

                            /**
                             * Encodes the specified AuthorizedFieldPublisherGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldPublisherGrant.verify|verify} messages.
                             * @param message AuthorizedFieldPublisherGrant message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified AuthorizedFieldPublisherGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldPublisherGrant.verify|verify} messages.
                             * @param message AuthorizedFieldPublisherGrant message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldPublisherGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an AuthorizedFieldPublisherGrant message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns AuthorizedFieldPublisherGrant
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldPublisherGrant;

                            /**
                             * Decodes an AuthorizedFieldPublisherGrant message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns AuthorizedFieldPublisherGrant
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldPublisherGrant;

                            /**
                             * Verifies an AuthorizedFieldPublisherGrant message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an AuthorizedFieldPublisherGrant message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns AuthorizedFieldPublisherGrant
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldPublisherGrant;

                            /**
                             * Creates a plain object from an AuthorizedFieldPublisherGrant message. Also converts values to other types if specified.
                             * @param message AuthorizedFieldPublisherGrant
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldPublisherGrant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this AuthorizedFieldPublisherGrant to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of an AuthorizedFieldSubscriberGrant. */
                        interface IAuthorizedFieldSubscriberGrant {

                            /** AuthorizedFieldSubscriberGrant eventType */
                            eventType?: (string|null);

                            /** AuthorizedFieldSubscriberGrant environment */
                            environment?: (string|null);

                            /** AuthorizedFieldSubscriberGrant authorizedField */
                            authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);

                            /** AuthorizedFieldSubscriberGrant iamRole */
                            iamRole?: (string|null);

                            /** AuthorizedFieldSubscriberGrant kmsGrantId */
                            kmsGrantId?: (string|null);
                        }

                        /** Represents an AuthorizedFieldSubscriberGrant. */
                        class AuthorizedFieldSubscriberGrant implements IAuthorizedFieldSubscriberGrant {

                            /**
                             * Constructs a new AuthorizedFieldSubscriberGrant.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant);

                            /** AuthorizedFieldSubscriberGrant eventType. */
                            public eventType: string;

                            /** AuthorizedFieldSubscriberGrant environment. */
                            public environment: string;

                            /** AuthorizedFieldSubscriberGrant authorizedField. */
                            public authorizedField?: (code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedField|null);

                            /** AuthorizedFieldSubscriberGrant iamRole. */
                            public iamRole: string;

                            /** AuthorizedFieldSubscriberGrant kmsGrantId. */
                            public kmsGrantId: string;

                            /**
                             * Creates a new AuthorizedFieldSubscriberGrant instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns AuthorizedFieldSubscriberGrant instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldSubscriberGrant;

                            /**
                             * Encodes the specified AuthorizedFieldSubscriberGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldSubscriberGrant.verify|verify} messages.
                             * @param message AuthorizedFieldSubscriberGrant message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified AuthorizedFieldSubscriberGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldSubscriberGrant.verify|verify} messages.
                             * @param message AuthorizedFieldSubscriberGrant message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IAuthorizedFieldSubscriberGrant, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes an AuthorizedFieldSubscriberGrant message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns AuthorizedFieldSubscriberGrant
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldSubscriberGrant;

                            /**
                             * Decodes an AuthorizedFieldSubscriberGrant message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns AuthorizedFieldSubscriberGrant
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldSubscriberGrant;

                            /**
                             * Verifies an AuthorizedFieldSubscriberGrant message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates an AuthorizedFieldSubscriberGrant message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns AuthorizedFieldSubscriberGrant
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldSubscriberGrant;

                            /**
                             * Creates a plain object from an AuthorizedFieldSubscriberGrant message. Also converts values to other types if specified.
                             * @param message AuthorizedFieldSubscriberGrant
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.AuthorizedFieldSubscriberGrant, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this AuthorizedFieldSubscriberGrant to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }

                        /** Properties of a Publication. */
                        interface IPublication {

                            /** Publication eventType */
                            eventType?: (string|null);

                            /** Publication environment */
                            environment?: (string|null);

                            /** Publication snsTopicArn */
                            snsTopicArn?: (string|null);

                            /** Publication eventDescription */
                            eventDescription?: (string|null);

                            /** Publication eventDeprecated */
                            eventDeprecated?: (boolean|null);

                            /** Publication publisherIamRole */
                            publisherIamRole?: (string|null);

                            /** Publication publisherServiceName */
                            publisherServiceName?: (string|null);

                            /** Publication publisherServiceCatalogId */
                            publisherServiceCatalogId?: (string|null);

                            /** Publication serviceId */
                            serviceId?: (string|null);
                        }

                        /** Represents a Publication. */
                        class Publication implements IPublication {

                            /**
                             * Constructs a new Publication.
                             * @param [properties] Properties to set
                             */
                            constructor(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IPublication);

                            /** Publication eventType. */
                            public eventType: string;

                            /** Publication environment. */
                            public environment: string;

                            /** Publication snsTopicArn. */
                            public snsTopicArn: string;

                            /** Publication eventDescription. */
                            public eventDescription: string;

                            /** Publication eventDeprecated. */
                            public eventDeprecated: boolean;

                            /** Publication publisherIamRole. */
                            public publisherIamRole: string;

                            /** Publication publisherServiceName. */
                            public publisherServiceName: string;

                            /** Publication publisherServiceCatalogId. */
                            public publisherServiceCatalogId: string;

                            /** Publication serviceId. */
                            public serviceId: string;

                            /**
                             * Creates a new Publication instance using the specified properties.
                             * @param [properties] Properties to set
                             * @returns Publication instance
                             */
                            public static create(properties?: code.justin.tv.eventbus.controlplane.infrastructure.IPublication): code.justin.tv.eventbus.controlplane.infrastructure.Publication;

                            /**
                             * Encodes the specified Publication message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.Publication.verify|verify} messages.
                             * @param message Publication message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encode(message: code.justin.tv.eventbus.controlplane.infrastructure.IPublication, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Encodes the specified Publication message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.infrastructure.Publication.verify|verify} messages.
                             * @param message Publication message or plain object to encode
                             * @param [writer] Writer to encode to
                             * @returns Writer
                             */
                            public static encodeDelimited(message: code.justin.tv.eventbus.controlplane.infrastructure.IPublication, writer?: $protobuf.Writer): $protobuf.Writer;

                            /**
                             * Decodes a Publication message from the specified reader or buffer.
                             * @param reader Reader or buffer to decode from
                             * @param [length] Message length if known beforehand
                             * @returns Publication
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): code.justin.tv.eventbus.controlplane.infrastructure.Publication;

                            /**
                             * Decodes a Publication message from the specified reader or buffer, length delimited.
                             * @param reader Reader or buffer to decode from
                             * @returns Publication
                             * @throws {Error} If the payload is not a reader or valid buffer
                             * @throws {$protobuf.util.ProtocolError} If required fields are missing
                             */
                            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): code.justin.tv.eventbus.controlplane.infrastructure.Publication;

                            /**
                             * Verifies a Publication message.
                             * @param message Plain object to verify
                             * @returns `null` if valid, otherwise the reason why it is not
                             */
                            public static verify(message: { [k: string]: any }): (string|null);

                            /**
                             * Creates a Publication message from a plain object. Also converts values to their respective internal types.
                             * @param object Plain object
                             * @returns Publication
                             */
                            public static fromObject(object: { [k: string]: any }): code.justin.tv.eventbus.controlplane.infrastructure.Publication;

                            /**
                             * Creates a plain object from a Publication message. Also converts values to other types if specified.
                             * @param message Publication
                             * @param [options] Conversion options
                             * @returns Plain object
                             */
                            public static toObject(message: code.justin.tv.eventbus.controlplane.infrastructure.Publication, options?: $protobuf.IConversionOptions): { [k: string]: any };

                            /**
                             * Converts this Publication to JSON.
                             * @returns JSON object
                             */
                            public toJSON(): { [k: string]: any };
                        }
                    }
                }
            }
        }
    }
}

/** Namespace google. */
export namespace google {

    /** Namespace protobuf. */
    namespace protobuf {

        /** Properties of a Timestamp. */
        interface ITimestamp {

            /** Timestamp seconds */
            seconds?: (number|Long|null);

            /** Timestamp nanos */
            nanos?: (number|null);
        }

        /** Represents a Timestamp. */
        class Timestamp implements ITimestamp {

            /**
             * Constructs a new Timestamp.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.ITimestamp);

            /** Timestamp seconds. */
            public seconds: (number|Long);

            /** Timestamp nanos. */
            public nanos: number;

            /**
             * Creates a new Timestamp instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Timestamp instance
             */
            public static create(properties?: google.protobuf.ITimestamp): google.protobuf.Timestamp;

            /**
             * Encodes the specified Timestamp message. Does not implicitly {@link google.protobuf.Timestamp.verify|verify} messages.
             * @param message Timestamp message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.ITimestamp, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Timestamp message, length delimited. Does not implicitly {@link google.protobuf.Timestamp.verify|verify} messages.
             * @param message Timestamp message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.ITimestamp, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a Timestamp message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Timestamp
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.Timestamp;

            /**
             * Decodes a Timestamp message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Timestamp
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.Timestamp;

            /**
             * Verifies a Timestamp message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a Timestamp message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Timestamp
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.Timestamp;

            /**
             * Creates a plain object from a Timestamp message. Also converts values to other types if specified.
             * @param message Timestamp
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.Timestamp, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Timestamp to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a DoubleValue. */
        interface IDoubleValue {

            /** DoubleValue value */
            value?: (number|null);
        }

        /** Represents a DoubleValue. */
        class DoubleValue implements IDoubleValue {

            /**
             * Constructs a new DoubleValue.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IDoubleValue);

            /** DoubleValue value. */
            public value: number;

            /**
             * Creates a new DoubleValue instance using the specified properties.
             * @param [properties] Properties to set
             * @returns DoubleValue instance
             */
            public static create(properties?: google.protobuf.IDoubleValue): google.protobuf.DoubleValue;

            /**
             * Encodes the specified DoubleValue message. Does not implicitly {@link google.protobuf.DoubleValue.verify|verify} messages.
             * @param message DoubleValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IDoubleValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified DoubleValue message, length delimited. Does not implicitly {@link google.protobuf.DoubleValue.verify|verify} messages.
             * @param message DoubleValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IDoubleValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a DoubleValue message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns DoubleValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.DoubleValue;

            /**
             * Decodes a DoubleValue message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns DoubleValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.DoubleValue;

            /**
             * Verifies a DoubleValue message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a DoubleValue message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns DoubleValue
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.DoubleValue;

            /**
             * Creates a plain object from a DoubleValue message. Also converts values to other types if specified.
             * @param message DoubleValue
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.DoubleValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this DoubleValue to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a FloatValue. */
        interface IFloatValue {

            /** FloatValue value */
            value?: (number|null);
        }

        /** Represents a FloatValue. */
        class FloatValue implements IFloatValue {

            /**
             * Constructs a new FloatValue.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IFloatValue);

            /** FloatValue value. */
            public value: number;

            /**
             * Creates a new FloatValue instance using the specified properties.
             * @param [properties] Properties to set
             * @returns FloatValue instance
             */
            public static create(properties?: google.protobuf.IFloatValue): google.protobuf.FloatValue;

            /**
             * Encodes the specified FloatValue message. Does not implicitly {@link google.protobuf.FloatValue.verify|verify} messages.
             * @param message FloatValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IFloatValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified FloatValue message, length delimited. Does not implicitly {@link google.protobuf.FloatValue.verify|verify} messages.
             * @param message FloatValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IFloatValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a FloatValue message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns FloatValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.FloatValue;

            /**
             * Decodes a FloatValue message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns FloatValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.FloatValue;

            /**
             * Verifies a FloatValue message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a FloatValue message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns FloatValue
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.FloatValue;

            /**
             * Creates a plain object from a FloatValue message. Also converts values to other types if specified.
             * @param message FloatValue
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.FloatValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this FloatValue to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an Int64Value. */
        interface IInt64Value {

            /** Int64Value value */
            value?: (number|Long|null);
        }

        /** Represents an Int64Value. */
        class Int64Value implements IInt64Value {

            /**
             * Constructs a new Int64Value.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IInt64Value);

            /** Int64Value value. */
            public value: (number|Long);

            /**
             * Creates a new Int64Value instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Int64Value instance
             */
            public static create(properties?: google.protobuf.IInt64Value): google.protobuf.Int64Value;

            /**
             * Encodes the specified Int64Value message. Does not implicitly {@link google.protobuf.Int64Value.verify|verify} messages.
             * @param message Int64Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IInt64Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Int64Value message, length delimited. Does not implicitly {@link google.protobuf.Int64Value.verify|verify} messages.
             * @param message Int64Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IInt64Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an Int64Value message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Int64Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.Int64Value;

            /**
             * Decodes an Int64Value message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Int64Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.Int64Value;

            /**
             * Verifies an Int64Value message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an Int64Value message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Int64Value
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.Int64Value;

            /**
             * Creates a plain object from an Int64Value message. Also converts values to other types if specified.
             * @param message Int64Value
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.Int64Value, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Int64Value to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a UInt64Value. */
        interface IUInt64Value {

            /** UInt64Value value */
            value?: (number|Long|null);
        }

        /** Represents a UInt64Value. */
        class UInt64Value implements IUInt64Value {

            /**
             * Constructs a new UInt64Value.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IUInt64Value);

            /** UInt64Value value. */
            public value: (number|Long);

            /**
             * Creates a new UInt64Value instance using the specified properties.
             * @param [properties] Properties to set
             * @returns UInt64Value instance
             */
            public static create(properties?: google.protobuf.IUInt64Value): google.protobuf.UInt64Value;

            /**
             * Encodes the specified UInt64Value message. Does not implicitly {@link google.protobuf.UInt64Value.verify|verify} messages.
             * @param message UInt64Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IUInt64Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified UInt64Value message, length delimited. Does not implicitly {@link google.protobuf.UInt64Value.verify|verify} messages.
             * @param message UInt64Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IUInt64Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a UInt64Value message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns UInt64Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.UInt64Value;

            /**
             * Decodes a UInt64Value message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns UInt64Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.UInt64Value;

            /**
             * Verifies a UInt64Value message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a UInt64Value message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns UInt64Value
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.UInt64Value;

            /**
             * Creates a plain object from a UInt64Value message. Also converts values to other types if specified.
             * @param message UInt64Value
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.UInt64Value, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this UInt64Value to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of an Int32Value. */
        interface IInt32Value {

            /** Int32Value value */
            value?: (number|null);
        }

        /** Represents an Int32Value. */
        class Int32Value implements IInt32Value {

            /**
             * Constructs a new Int32Value.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IInt32Value);

            /** Int32Value value. */
            public value: number;

            /**
             * Creates a new Int32Value instance using the specified properties.
             * @param [properties] Properties to set
             * @returns Int32Value instance
             */
            public static create(properties?: google.protobuf.IInt32Value): google.protobuf.Int32Value;

            /**
             * Encodes the specified Int32Value message. Does not implicitly {@link google.protobuf.Int32Value.verify|verify} messages.
             * @param message Int32Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IInt32Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified Int32Value message, length delimited. Does not implicitly {@link google.protobuf.Int32Value.verify|verify} messages.
             * @param message Int32Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IInt32Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes an Int32Value message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns Int32Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.Int32Value;

            /**
             * Decodes an Int32Value message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns Int32Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.Int32Value;

            /**
             * Verifies an Int32Value message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates an Int32Value message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns Int32Value
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.Int32Value;

            /**
             * Creates a plain object from an Int32Value message. Also converts values to other types if specified.
             * @param message Int32Value
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.Int32Value, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this Int32Value to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a UInt32Value. */
        interface IUInt32Value {

            /** UInt32Value value */
            value?: (number|null);
        }

        /** Represents a UInt32Value. */
        class UInt32Value implements IUInt32Value {

            /**
             * Constructs a new UInt32Value.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IUInt32Value);

            /** UInt32Value value. */
            public value: number;

            /**
             * Creates a new UInt32Value instance using the specified properties.
             * @param [properties] Properties to set
             * @returns UInt32Value instance
             */
            public static create(properties?: google.protobuf.IUInt32Value): google.protobuf.UInt32Value;

            /**
             * Encodes the specified UInt32Value message. Does not implicitly {@link google.protobuf.UInt32Value.verify|verify} messages.
             * @param message UInt32Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IUInt32Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified UInt32Value message, length delimited. Does not implicitly {@link google.protobuf.UInt32Value.verify|verify} messages.
             * @param message UInt32Value message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IUInt32Value, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a UInt32Value message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns UInt32Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.UInt32Value;

            /**
             * Decodes a UInt32Value message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns UInt32Value
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.UInt32Value;

            /**
             * Verifies a UInt32Value message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a UInt32Value message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns UInt32Value
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.UInt32Value;

            /**
             * Creates a plain object from a UInt32Value message. Also converts values to other types if specified.
             * @param message UInt32Value
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.UInt32Value, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this UInt32Value to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a BoolValue. */
        interface IBoolValue {

            /** BoolValue value */
            value?: (boolean|null);
        }

        /** Represents a BoolValue. */
        class BoolValue implements IBoolValue {

            /**
             * Constructs a new BoolValue.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IBoolValue);

            /** BoolValue value. */
            public value: boolean;

            /**
             * Creates a new BoolValue instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BoolValue instance
             */
            public static create(properties?: google.protobuf.IBoolValue): google.protobuf.BoolValue;

            /**
             * Encodes the specified BoolValue message. Does not implicitly {@link google.protobuf.BoolValue.verify|verify} messages.
             * @param message BoolValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IBoolValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BoolValue message, length delimited. Does not implicitly {@link google.protobuf.BoolValue.verify|verify} messages.
             * @param message BoolValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IBoolValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BoolValue message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BoolValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.BoolValue;

            /**
             * Decodes a BoolValue message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BoolValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.BoolValue;

            /**
             * Verifies a BoolValue message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BoolValue message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BoolValue
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.BoolValue;

            /**
             * Creates a plain object from a BoolValue message. Also converts values to other types if specified.
             * @param message BoolValue
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.BoolValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BoolValue to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a StringValue. */
        interface IStringValue {

            /** StringValue value */
            value?: (string|null);
        }

        /** Represents a StringValue. */
        class StringValue implements IStringValue {

            /**
             * Constructs a new StringValue.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IStringValue);

            /** StringValue value. */
            public value: string;

            /**
             * Creates a new StringValue instance using the specified properties.
             * @param [properties] Properties to set
             * @returns StringValue instance
             */
            public static create(properties?: google.protobuf.IStringValue): google.protobuf.StringValue;

            /**
             * Encodes the specified StringValue message. Does not implicitly {@link google.protobuf.StringValue.verify|verify} messages.
             * @param message StringValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IStringValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified StringValue message, length delimited. Does not implicitly {@link google.protobuf.StringValue.verify|verify} messages.
             * @param message StringValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IStringValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a StringValue message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns StringValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.StringValue;

            /**
             * Decodes a StringValue message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns StringValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.StringValue;

            /**
             * Verifies a StringValue message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a StringValue message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns StringValue
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.StringValue;

            /**
             * Creates a plain object from a StringValue message. Also converts values to other types if specified.
             * @param message StringValue
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.StringValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this StringValue to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }

        /** Properties of a BytesValue. */
        interface IBytesValue {

            /** BytesValue value */
            value?: (Uint8Array|null);
        }

        /** Represents a BytesValue. */
        class BytesValue implements IBytesValue {

            /**
             * Constructs a new BytesValue.
             * @param [properties] Properties to set
             */
            constructor(properties?: google.protobuf.IBytesValue);

            /** BytesValue value. */
            public value: Uint8Array;

            /**
             * Creates a new BytesValue instance using the specified properties.
             * @param [properties] Properties to set
             * @returns BytesValue instance
             */
            public static create(properties?: google.protobuf.IBytesValue): google.protobuf.BytesValue;

            /**
             * Encodes the specified BytesValue message. Does not implicitly {@link google.protobuf.BytesValue.verify|verify} messages.
             * @param message BytesValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encode(message: google.protobuf.IBytesValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Encodes the specified BytesValue message, length delimited. Does not implicitly {@link google.protobuf.BytesValue.verify|verify} messages.
             * @param message BytesValue message or plain object to encode
             * @param [writer] Writer to encode to
             * @returns Writer
             */
            public static encodeDelimited(message: google.protobuf.IBytesValue, writer?: $protobuf.Writer): $protobuf.Writer;

            /**
             * Decodes a BytesValue message from the specified reader or buffer.
             * @param reader Reader or buffer to decode from
             * @param [length] Message length if known beforehand
             * @returns BytesValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decode(reader: ($protobuf.Reader|Uint8Array), length?: number): google.protobuf.BytesValue;

            /**
             * Decodes a BytesValue message from the specified reader or buffer, length delimited.
             * @param reader Reader or buffer to decode from
             * @returns BytesValue
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            public static decodeDelimited(reader: ($protobuf.Reader|Uint8Array)): google.protobuf.BytesValue;

            /**
             * Verifies a BytesValue message.
             * @param message Plain object to verify
             * @returns `null` if valid, otherwise the reason why it is not
             */
            public static verify(message: { [k: string]: any }): (string|null);

            /**
             * Creates a BytesValue message from a plain object. Also converts values to their respective internal types.
             * @param object Plain object
             * @returns BytesValue
             */
            public static fromObject(object: { [k: string]: any }): google.protobuf.BytesValue;

            /**
             * Creates a plain object from a BytesValue message. Also converts values to other types if specified.
             * @param message BytesValue
             * @param [options] Conversion options
             * @returns Plain object
             */
            public static toObject(message: google.protobuf.BytesValue, options?: $protobuf.IConversionOptions): { [k: string]: any };

            /**
             * Converts this BytesValue to JSON.
             * @returns JSON object
             */
            public toJSON(): { [k: string]: any };
        }
    }
}
