/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.code = (function() {

    /**
     * Namespace code.
     * @exports code
     * @namespace
     */
    var code = {};

    code.justin = (function() {

        /**
         * Namespace justin.
         * @memberof code
         * @namespace
         */
        var justin = {};

        justin.tv = (function() {

            /**
             * Namespace tv.
             * @memberof code.justin
             * @namespace
             */
            var tv = {};

            tv.eventbus = (function() {

                /**
                 * Namespace eventbus.
                 * @memberof code.justin.tv
                 * @namespace
                 */
                var eventbus = {};

                eventbus.controlplane = (function() {

                    /**
                     * Namespace controlplane.
                     * @memberof code.justin.tv.eventbus
                     * @namespace
                     */
                    var controlplane = {};

                    controlplane.AuditLogs = (function() {

                        /**
                         * Constructs a new AuditLogs service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an AuditLogs
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function AuditLogs(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (AuditLogs.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = AuditLogs;

                        /**
                         * Creates new AuditLogs service using the specified rpc implementation.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLogs
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {AuditLogs} RPC service. Useful where requests and/or responses are streamed.
                         */
                        AuditLogs.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.AuditLogs#getAuditLogsForService}.
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLogs
                         * @typedef GetAuditLogsForServiceCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp} [response] GetAuditLogsForServiceResp
                         */

                        /**
                         * Calls GetAuditLogsForService.
                         * @function getAuditLogsForService
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLogs
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq} request GetAuditLogsForServiceReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.AuditLogs.GetAuditLogsForServiceCallback} callback Node-style callback called with the error, if any, and GetAuditLogsForServiceResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(AuditLogs.prototype.getAuditLogsForService = function getAuditLogsForService(request, callback) {
                            return this.rpcCall(getAuditLogsForService, $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq, $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp, request, callback);
                        }, "name", { value: "GetAuditLogsForService" });

                        /**
                         * Calls GetAuditLogsForService.
                         * @function getAuditLogsForService
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLogs
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq} request GetAuditLogsForServiceReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp>} Promise
                         * @variation 2
                         */

                        return AuditLogs;
                    })();

                    controlplane.GetAuditLogsForServiceReq = (function() {

                        /**
                         * Properties of a GetAuditLogsForServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetAuditLogsForServiceReq
                         * @property {string|null} [serviceId] GetAuditLogsForServiceReq serviceId
                         */

                        /**
                         * Constructs a new GetAuditLogsForServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetAuditLogsForServiceReq.
                         * @implements IGetAuditLogsForServiceReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq=} [properties] Properties to set
                         */
                        function GetAuditLogsForServiceReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetAuditLogsForServiceReq serviceId.
                         * @member {string} serviceId
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @instance
                         */
                        GetAuditLogsForServiceReq.prototype.serviceId = "";

                        /**
                         * Creates a new GetAuditLogsForServiceReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq} GetAuditLogsForServiceReq instance
                         */
                        GetAuditLogsForServiceReq.create = function create(properties) {
                            return new GetAuditLogsForServiceReq(properties);
                        };

                        /**
                         * Encodes the specified GetAuditLogsForServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq} message GetAuditLogsForServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuditLogsForServiceReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.serviceId != null && Object.hasOwnProperty.call(message, "serviceId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.serviceId);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetAuditLogsForServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceReq} message GetAuditLogsForServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuditLogsForServiceReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetAuditLogsForServiceReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq} GetAuditLogsForServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuditLogsForServiceReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.serviceId = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetAuditLogsForServiceReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq} GetAuditLogsForServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuditLogsForServiceReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetAuditLogsForServiceReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAuditLogsForServiceReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                if (!$util.isString(message.serviceId))
                                    return "serviceId: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetAuditLogsForServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq} GetAuditLogsForServiceReq
                         */
                        GetAuditLogsForServiceReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq();
                            if (object.serviceId != null)
                                message.serviceId = String(object.serviceId);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetAuditLogsForServiceReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq} message GetAuditLogsForServiceReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAuditLogsForServiceReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.serviceId = "";
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                object.serviceId = message.serviceId;
                            return object;
                        };

                        /**
                         * Converts this GetAuditLogsForServiceReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAuditLogsForServiceReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetAuditLogsForServiceReq;
                    })();

                    controlplane.AuditLog = (function() {

                        /**
                         * Properties of an AuditLog.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IAuditLog
                         * @property {string|null} [serviceId] AuditLog serviceId
                         * @property {string|null} [userName] AuditLog userName
                         * @property {string|null} [resourceType] AuditLog resourceType
                         * @property {string|null} [resourceName] AuditLog resourceName
                         * @property {string|null} [result] AuditLog result
                         * @property {string|null} [action] AuditLog action
                         * @property {google.protobuf.ITimestamp|null} [timestamp] AuditLog timestamp
                         * @property {string|null} [before] AuditLog before
                         * @property {string|null} [after] AuditLog after
                         */

                        /**
                         * Constructs a new AuditLog.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an AuditLog.
                         * @implements IAuditLog
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IAuditLog=} [properties] Properties to set
                         */
                        function AuditLog(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * AuditLog serviceId.
                         * @member {string} serviceId
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.serviceId = "";

                        /**
                         * AuditLog userName.
                         * @member {string} userName
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.userName = "";

                        /**
                         * AuditLog resourceType.
                         * @member {string} resourceType
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.resourceType = "";

                        /**
                         * AuditLog resourceName.
                         * @member {string} resourceName
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.resourceName = "";

                        /**
                         * AuditLog result.
                         * @member {string} result
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.result = "";

                        /**
                         * AuditLog action.
                         * @member {string} action
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.action = "";

                        /**
                         * AuditLog timestamp.
                         * @member {google.protobuf.ITimestamp|null|undefined} timestamp
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.timestamp = null;

                        /**
                         * AuditLog before.
                         * @member {string} before
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.before = "";

                        /**
                         * AuditLog after.
                         * @member {string} after
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         */
                        AuditLog.prototype.after = "";

                        /**
                         * Creates a new AuditLog instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuditLog=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.AuditLog} AuditLog instance
                         */
                        AuditLog.create = function create(properties) {
                            return new AuditLog(properties);
                        };

                        /**
                         * Encodes the specified AuditLog message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuditLog.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuditLog} message AuditLog message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuditLog.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.serviceId != null && Object.hasOwnProperty.call(message, "serviceId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.serviceId);
                            if (message.userName != null && Object.hasOwnProperty.call(message, "userName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.userName);
                            if (message.resourceType != null && Object.hasOwnProperty.call(message, "resourceType"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.resourceType);
                            if (message.resourceName != null && Object.hasOwnProperty.call(message, "resourceName"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.resourceName);
                            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.result);
                            if (message.action != null && Object.hasOwnProperty.call(message, "action"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.action);
                            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                                $root.google.protobuf.Timestamp.encode(message.timestamp, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.before != null && Object.hasOwnProperty.call(message, "before"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.before);
                            if (message.after != null && Object.hasOwnProperty.call(message, "after"))
                                writer.uint32(/* id 9, wireType 2 =*/74).string(message.after);
                            return writer;
                        };

                        /**
                         * Encodes the specified AuditLog message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuditLog.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuditLog} message AuditLog message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuditLog.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an AuditLog message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.AuditLog} AuditLog
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuditLog.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.AuditLog();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.serviceId = reader.string();
                                    break;
                                case 2:
                                    message.userName = reader.string();
                                    break;
                                case 3:
                                    message.resourceType = reader.string();
                                    break;
                                case 4:
                                    message.resourceName = reader.string();
                                    break;
                                case 5:
                                    message.result = reader.string();
                                    break;
                                case 6:
                                    message.action = reader.string();
                                    break;
                                case 7:
                                    message.timestamp = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                case 8:
                                    message.before = reader.string();
                                    break;
                                case 9:
                                    message.after = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an AuditLog message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.AuditLog} AuditLog
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuditLog.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an AuditLog message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AuditLog.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                if (!$util.isString(message.serviceId))
                                    return "serviceId: string expected";
                            if (message.userName != null && message.hasOwnProperty("userName"))
                                if (!$util.isString(message.userName))
                                    return "userName: string expected";
                            if (message.resourceType != null && message.hasOwnProperty("resourceType"))
                                if (!$util.isString(message.resourceType))
                                    return "resourceType: string expected";
                            if (message.resourceName != null && message.hasOwnProperty("resourceName"))
                                if (!$util.isString(message.resourceName))
                                    return "resourceName: string expected";
                            if (message.result != null && message.hasOwnProperty("result"))
                                if (!$util.isString(message.result))
                                    return "result: string expected";
                            if (message.action != null && message.hasOwnProperty("action"))
                                if (!$util.isString(message.action))
                                    return "action: string expected";
                            if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.timestamp);
                                if (error)
                                    return "timestamp." + error;
                            }
                            if (message.before != null && message.hasOwnProperty("before"))
                                if (!$util.isString(message.before))
                                    return "before: string expected";
                            if (message.after != null && message.hasOwnProperty("after"))
                                if (!$util.isString(message.after))
                                    return "after: string expected";
                            return null;
                        };

                        /**
                         * Creates an AuditLog message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.AuditLog} AuditLog
                         */
                        AuditLog.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.AuditLog)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.AuditLog();
                            if (object.serviceId != null)
                                message.serviceId = String(object.serviceId);
                            if (object.userName != null)
                                message.userName = String(object.userName);
                            if (object.resourceType != null)
                                message.resourceType = String(object.resourceType);
                            if (object.resourceName != null)
                                message.resourceName = String(object.resourceName);
                            if (object.result != null)
                                message.result = String(object.result);
                            if (object.action != null)
                                message.action = String(object.action);
                            if (object.timestamp != null) {
                                if (typeof object.timestamp !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.AuditLog.timestamp: object expected");
                                message.timestamp = $root.google.protobuf.Timestamp.fromObject(object.timestamp);
                            }
                            if (object.before != null)
                                message.before = String(object.before);
                            if (object.after != null)
                                message.after = String(object.after);
                            return message;
                        };

                        /**
                         * Creates a plain object from an AuditLog message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.AuditLog} message AuditLog
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AuditLog.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.serviceId = "";
                                object.userName = "";
                                object.resourceType = "";
                                object.resourceName = "";
                                object.result = "";
                                object.action = "";
                                object.timestamp = null;
                                object.before = "";
                                object.after = "";
                            }
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                object.serviceId = message.serviceId;
                            if (message.userName != null && message.hasOwnProperty("userName"))
                                object.userName = message.userName;
                            if (message.resourceType != null && message.hasOwnProperty("resourceType"))
                                object.resourceType = message.resourceType;
                            if (message.resourceName != null && message.hasOwnProperty("resourceName"))
                                object.resourceName = message.resourceName;
                            if (message.result != null && message.hasOwnProperty("result"))
                                object.result = message.result;
                            if (message.action != null && message.hasOwnProperty("action"))
                                object.action = message.action;
                            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                                object.timestamp = $root.google.protobuf.Timestamp.toObject(message.timestamp, options);
                            if (message.before != null && message.hasOwnProperty("before"))
                                object.before = message.before;
                            if (message.after != null && message.hasOwnProperty("after"))
                                object.after = message.after;
                            return object;
                        };

                        /**
                         * Converts this AuditLog to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.AuditLog
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AuditLog.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return AuditLog;
                    })();

                    controlplane.GetAuditLogsForServiceResp = (function() {

                        /**
                         * Properties of a GetAuditLogsForServiceResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetAuditLogsForServiceResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IAuditLog>|null} [auditLogs] GetAuditLogsForServiceResp auditLogs
                         */

                        /**
                         * Constructs a new GetAuditLogsForServiceResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetAuditLogsForServiceResp.
                         * @implements IGetAuditLogsForServiceResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp=} [properties] Properties to set
                         */
                        function GetAuditLogsForServiceResp(properties) {
                            this.auditLogs = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetAuditLogsForServiceResp auditLogs.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IAuditLog>} auditLogs
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @instance
                         */
                        GetAuditLogsForServiceResp.prototype.auditLogs = $util.emptyArray;

                        /**
                         * Creates a new GetAuditLogsForServiceResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp} GetAuditLogsForServiceResp instance
                         */
                        GetAuditLogsForServiceResp.create = function create(properties) {
                            return new GetAuditLogsForServiceResp(properties);
                        };

                        /**
                         * Encodes the specified GetAuditLogsForServiceResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp} message GetAuditLogsForServiceResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuditLogsForServiceResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.auditLogs != null && message.auditLogs.length)
                                for (var i = 0; i < message.auditLogs.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.AuditLog.encode(message.auditLogs[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified GetAuditLogsForServiceResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuditLogsForServiceResp} message GetAuditLogsForServiceResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuditLogsForServiceResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetAuditLogsForServiceResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp} GetAuditLogsForServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuditLogsForServiceResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.auditLogs && message.auditLogs.length))
                                        message.auditLogs = [];
                                    message.auditLogs.push($root.code.justin.tv.eventbus.controlplane.AuditLog.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetAuditLogsForServiceResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp} GetAuditLogsForServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuditLogsForServiceResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetAuditLogsForServiceResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAuditLogsForServiceResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.auditLogs != null && message.hasOwnProperty("auditLogs")) {
                                if (!Array.isArray(message.auditLogs))
                                    return "auditLogs: array expected";
                                for (var i = 0; i < message.auditLogs.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.AuditLog.verify(message.auditLogs[i]);
                                    if (error)
                                        return "auditLogs." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a GetAuditLogsForServiceResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp} GetAuditLogsForServiceResp
                         */
                        GetAuditLogsForServiceResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp();
                            if (object.auditLogs) {
                                if (!Array.isArray(object.auditLogs))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp.auditLogs: array expected");
                                message.auditLogs = [];
                                for (var i = 0; i < object.auditLogs.length; ++i) {
                                    if (typeof object.auditLogs[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp.auditLogs: object expected");
                                    message.auditLogs[i] = $root.code.justin.tv.eventbus.controlplane.AuditLog.fromObject(object.auditLogs[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetAuditLogsForServiceResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp} message GetAuditLogsForServiceResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAuditLogsForServiceResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.auditLogs = [];
                            if (message.auditLogs && message.auditLogs.length) {
                                object.auditLogs = [];
                                for (var j = 0; j < message.auditLogs.length; ++j)
                                    object.auditLogs[j] = $root.code.justin.tv.eventbus.controlplane.AuditLog.toObject(message.auditLogs[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this GetAuditLogsForServiceResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuditLogsForServiceResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAuditLogsForServiceResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetAuditLogsForServiceResp;
                    })();

                    controlplane.EventStreams = (function() {

                        /**
                         * Constructs a new EventStreams service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an EventStreams
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function EventStreams(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (EventStreams.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = EventStreams;

                        /**
                         * Creates new EventStreams service using the specified rpc implementation.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {EventStreams} RPC service. Useful where requests and/or responses are streamed.
                         */
                        EventStreams.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventStreams#list}.
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ListEventStreamsResp} [response] ListEventStreamsResp
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsReq} request ListEventStreamsReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.EventStreams.ListCallback} callback Node-style callback called with the error, if any, and ListEventStreamsResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(EventStreams.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.code.justin.tv.eventbus.controlplane.ListEventStreamsReq, $root.code.justin.tv.eventbus.controlplane.ListEventStreamsResp, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsReq} request ListEventStreamsReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ListEventStreamsResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventStreams#get}.
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @typedef GetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.EventStream} [response] EventStream
                         */

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamReq} request GetEventStreamReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.EventStreams.GetCallback} callback Node-style callback called with the error, if any, and EventStream
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(EventStreams.prototype.get = function get(request, callback) {
                            return this.rpcCall(get, $root.code.justin.tv.eventbus.controlplane.GetEventStreamReq, $root.code.justin.tv.eventbus.controlplane.EventStream, request, callback);
                        }, "name", { value: "Get" });

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamReq} request GetEventStreamReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.EventStream>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventStreams#getStats}.
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @typedef GetStatsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.EventStreamStats} [response] EventStreamStats
                         */

                        /**
                         * Calls GetStats.
                         * @function getStats
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq} request GetEventStreamStatsReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.EventStreams.GetStatsCallback} callback Node-style callback called with the error, if any, and EventStreamStats
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(EventStreams.prototype.getStats = function getStats(request, callback) {
                            return this.rpcCall(getStats, $root.code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq, $root.code.justin.tv.eventbus.controlplane.EventStreamStats, request, callback);
                        }, "name", { value: "GetStats" });

                        /**
                         * Calls GetStats.
                         * @function getStats
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreams
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq} request GetEventStreamStatsReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.EventStreamStats>} Promise
                         * @variation 2
                         */

                        return EventStreams;
                    })();

                    controlplane.EventTypes = (function() {

                        /**
                         * Constructs a new EventTypes service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an EventTypes
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function EventTypes(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (EventTypes.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = EventTypes;

                        /**
                         * Creates new EventTypes service using the specified rpc implementation.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {EventTypes} RPC service. Useful where requests and/or responses are streamed.
                         */
                        EventTypes.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventTypes#list}.
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ListEventTypesResp} [response] ListEventTypesResp
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesReq} request ListEventTypesReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.EventTypes.ListCallback} callback Node-style callback called with the error, if any, and ListEventTypesResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(EventTypes.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.code.justin.tv.eventbus.controlplane.ListEventTypesReq, $root.code.justin.tv.eventbus.controlplane.ListEventTypesResp, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesReq} request ListEventTypesReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ListEventTypesResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventTypes#listAuthorizedFieldSubscriberGrantsByEventType}.
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @typedef ListAuthorizedFieldSubscriberGrantsByEventTypeCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp} [response] ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         */

                        /**
                         * Calls ListAuthorizedFieldSubscriberGrantsByEventType.
                         * @function listAuthorizedFieldSubscriberGrantsByEventType
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq} request ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.EventTypes.ListAuthorizedFieldSubscriberGrantsByEventTypeCallback} callback Node-style callback called with the error, if any, and ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(EventTypes.prototype.listAuthorizedFieldSubscriberGrantsByEventType = function listAuthorizedFieldSubscriberGrantsByEventType(request, callback) {
                            return this.rpcCall(listAuthorizedFieldSubscriberGrantsByEventType, $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq, $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp, request, callback);
                        }, "name", { value: "ListAuthorizedFieldSubscriberGrantsByEventType" });

                        /**
                         * Calls ListAuthorizedFieldSubscriberGrantsByEventType.
                         * @function listAuthorizedFieldSubscriberGrantsByEventType
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq} request ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.EventTypes#listAuthorizedFieldPublisherGrantsByEventType}.
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @typedef ListAuthorizedFieldPublisherGrantsByEventTypeCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp} [response] ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         */

                        /**
                         * Calls ListAuthorizedFieldPublisherGrantsByEventType.
                         * @function listAuthorizedFieldPublisherGrantsByEventType
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq} request ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.EventTypes.ListAuthorizedFieldPublisherGrantsByEventTypeCallback} callback Node-style callback called with the error, if any, and ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(EventTypes.prototype.listAuthorizedFieldPublisherGrantsByEventType = function listAuthorizedFieldPublisherGrantsByEventType(request, callback) {
                            return this.rpcCall(listAuthorizedFieldPublisherGrantsByEventType, $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq, $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp, request, callback);
                        }, "name", { value: "ListAuthorizedFieldPublisherGrantsByEventType" });

                        /**
                         * Calls ListAuthorizedFieldPublisherGrantsByEventType.
                         * @function listAuthorizedFieldPublisherGrantsByEventType
                         * @memberof code.justin.tv.eventbus.controlplane.EventTypes
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq} request ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp>} Promise
                         * @variation 2
                         */

                        return EventTypes;
                    })();

                    controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq = (function() {

                        /**
                         * Properties of a ListAuthorizedFieldSubscriberGrantsByEventTypeReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @property {string|null} [eventTypeName] ListAuthorizedFieldSubscriberGrantsByEventTypeReq eventTypeName
                         */

                        /**
                         * Constructs a new ListAuthorizedFieldSubscriberGrantsByEventTypeReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListAuthorizedFieldSubscriberGrantsByEventTypeReq.
                         * @implements IListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq=} [properties] Properties to set
                         */
                        function ListAuthorizedFieldSubscriberGrantsByEventTypeReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListAuthorizedFieldSubscriberGrantsByEventTypeReq eventTypeName.
                         * @member {string} eventTypeName
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @instance
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.prototype.eventTypeName = "";

                        /**
                         * Creates a new ListAuthorizedFieldSubscriberGrantsByEventTypeReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq} ListAuthorizedFieldSubscriberGrantsByEventTypeReq instance
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.create = function create(properties) {
                            return new ListAuthorizedFieldSubscriberGrantsByEventTypeReq(properties);
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq} message ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventTypeName != null && Object.hasOwnProperty.call(message, "eventTypeName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.eventTypeName);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeReq} message ListAuthorizedFieldSubscriberGrantsByEventTypeReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq} ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.eventTypeName = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq} ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventTypeName != null && message.hasOwnProperty("eventTypeName"))
                                if (!$util.isString(message.eventTypeName))
                                    return "eventTypeName: string expected";
                            return null;
                        };

                        /**
                         * Creates a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq} ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq();
                            if (object.eventTypeName != null)
                                message.eventTypeName = String(object.eventTypeName);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListAuthorizedFieldSubscriberGrantsByEventTypeReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq} message ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.eventTypeName = "";
                            if (message.eventTypeName != null && message.hasOwnProperty("eventTypeName"))
                                object.eventTypeName = message.eventTypeName;
                            return object;
                        };

                        /**
                         * Converts this ListAuthorizedFieldSubscriberGrantsByEventTypeReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListAuthorizedFieldSubscriberGrantsByEventTypeReq;
                    })();

                    controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp = (function() {

                        /**
                         * Properties of a ListAuthorizedFieldSubscriberGrantsByEventTypeResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IGrant>|null} [grants] ListAuthorizedFieldSubscriberGrantsByEventTypeResp grants
                         */

                        /**
                         * Constructs a new ListAuthorizedFieldSubscriberGrantsByEventTypeResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListAuthorizedFieldSubscriberGrantsByEventTypeResp.
                         * @implements IListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp=} [properties] Properties to set
                         */
                        function ListAuthorizedFieldSubscriberGrantsByEventTypeResp(properties) {
                            this.grants = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListAuthorizedFieldSubscriberGrantsByEventTypeResp grants.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IGrant>} grants
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @instance
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.prototype.grants = $util.emptyArray;

                        /**
                         * Creates a new ListAuthorizedFieldSubscriberGrantsByEventTypeResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp} ListAuthorizedFieldSubscriberGrantsByEventTypeResp instance
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.create = function create(properties) {
                            return new ListAuthorizedFieldSubscriberGrantsByEventTypeResp(properties);
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp} message ListAuthorizedFieldSubscriberGrantsByEventTypeResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.grants != null && message.grants.length)
                                for (var i = 0; i < message.grants.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.Grant.encode(message.grants[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldSubscriberGrantsByEventTypeResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldSubscriberGrantsByEventTypeResp} message ListAuthorizedFieldSubscriberGrantsByEventTypeResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp} ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.grants && message.grants.length))
                                        message.grants = [];
                                    message.grants.push($root.code.justin.tv.eventbus.controlplane.Grant.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp} ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.grants != null && message.hasOwnProperty("grants")) {
                                if (!Array.isArray(message.grants))
                                    return "grants: array expected";
                                for (var i = 0; i < message.grants.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.Grant.verify(message.grants[i]);
                                    if (error)
                                        return "grants." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp} ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp();
                            if (object.grants) {
                                if (!Array.isArray(object.grants))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp.grants: array expected");
                                message.grants = [];
                                for (var i = 0; i < object.grants.length; ++i) {
                                    if (typeof object.grants[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp.grants: object expected");
                                    message.grants[i] = $root.code.justin.tv.eventbus.controlplane.Grant.fromObject(object.grants[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListAuthorizedFieldSubscriberGrantsByEventTypeResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp} message ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.grants = [];
                            if (message.grants && message.grants.length) {
                                object.grants = [];
                                for (var j = 0; j < message.grants.length; ++j)
                                    object.grants[j] = $root.code.justin.tv.eventbus.controlplane.Grant.toObject(message.grants[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this ListAuthorizedFieldSubscriberGrantsByEventTypeResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldSubscriberGrantsByEventTypeResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAuthorizedFieldSubscriberGrantsByEventTypeResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListAuthorizedFieldSubscriberGrantsByEventTypeResp;
                    })();

                    controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq = (function() {

                        /**
                         * Properties of a ListAuthorizedFieldPublisherGrantsByEventTypeReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @property {string|null} [eventTypeName] ListAuthorizedFieldPublisherGrantsByEventTypeReq eventTypeName
                         */

                        /**
                         * Constructs a new ListAuthorizedFieldPublisherGrantsByEventTypeReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListAuthorizedFieldPublisherGrantsByEventTypeReq.
                         * @implements IListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq=} [properties] Properties to set
                         */
                        function ListAuthorizedFieldPublisherGrantsByEventTypeReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListAuthorizedFieldPublisherGrantsByEventTypeReq eventTypeName.
                         * @member {string} eventTypeName
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @instance
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.prototype.eventTypeName = "";

                        /**
                         * Creates a new ListAuthorizedFieldPublisherGrantsByEventTypeReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq} ListAuthorizedFieldPublisherGrantsByEventTypeReq instance
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.create = function create(properties) {
                            return new ListAuthorizedFieldPublisherGrantsByEventTypeReq(properties);
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq} message ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventTypeName != null && Object.hasOwnProperty.call(message, "eventTypeName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.eventTypeName);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeReq} message ListAuthorizedFieldPublisherGrantsByEventTypeReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq} ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.eventTypeName = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq} ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListAuthorizedFieldPublisherGrantsByEventTypeReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventTypeName != null && message.hasOwnProperty("eventTypeName"))
                                if (!$util.isString(message.eventTypeName))
                                    return "eventTypeName: string expected";
                            return null;
                        };

                        /**
                         * Creates a ListAuthorizedFieldPublisherGrantsByEventTypeReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq} ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq();
                            if (object.eventTypeName != null)
                                message.eventTypeName = String(object.eventTypeName);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListAuthorizedFieldPublisherGrantsByEventTypeReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq} message ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.eventTypeName = "";
                            if (message.eventTypeName != null && message.hasOwnProperty("eventTypeName"))
                                object.eventTypeName = message.eventTypeName;
                            return object;
                        };

                        /**
                         * Converts this ListAuthorizedFieldPublisherGrantsByEventTypeReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListAuthorizedFieldPublisherGrantsByEventTypeReq;
                    })();

                    controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp = (function() {

                        /**
                         * Properties of a ListAuthorizedFieldPublisherGrantsByEventTypeResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IPublisherGrant>|null} [grants] ListAuthorizedFieldPublisherGrantsByEventTypeResp grants
                         */

                        /**
                         * Constructs a new ListAuthorizedFieldPublisherGrantsByEventTypeResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListAuthorizedFieldPublisherGrantsByEventTypeResp.
                         * @implements IListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp=} [properties] Properties to set
                         */
                        function ListAuthorizedFieldPublisherGrantsByEventTypeResp(properties) {
                            this.grants = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListAuthorizedFieldPublisherGrantsByEventTypeResp grants.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IPublisherGrant>} grants
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @instance
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.prototype.grants = $util.emptyArray;

                        /**
                         * Creates a new ListAuthorizedFieldPublisherGrantsByEventTypeResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp} ListAuthorizedFieldPublisherGrantsByEventTypeResp instance
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.create = function create(properties) {
                            return new ListAuthorizedFieldPublisherGrantsByEventTypeResp(properties);
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp} message ListAuthorizedFieldPublisherGrantsByEventTypeResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.grants != null && message.grants.length)
                                for (var i = 0; i < message.grants.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.PublisherGrant.encode(message.grants[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified ListAuthorizedFieldPublisherGrantsByEventTypeResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListAuthorizedFieldPublisherGrantsByEventTypeResp} message ListAuthorizedFieldPublisherGrantsByEventTypeResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp} ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.grants && message.grants.length))
                                        message.grants = [];
                                    message.grants.push($root.code.justin.tv.eventbus.controlplane.PublisherGrant.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListAuthorizedFieldPublisherGrantsByEventTypeResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp} ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListAuthorizedFieldPublisherGrantsByEventTypeResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.grants != null && message.hasOwnProperty("grants")) {
                                if (!Array.isArray(message.grants))
                                    return "grants: array expected";
                                for (var i = 0; i < message.grants.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.PublisherGrant.verify(message.grants[i]);
                                    if (error)
                                        return "grants." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a ListAuthorizedFieldPublisherGrantsByEventTypeResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp} ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp();
                            if (object.grants) {
                                if (!Array.isArray(object.grants))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp.grants: array expected");
                                message.grants = [];
                                for (var i = 0; i < object.grants.length; ++i) {
                                    if (typeof object.grants[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp.grants: object expected");
                                    message.grants[i] = $root.code.justin.tv.eventbus.controlplane.PublisherGrant.fromObject(object.grants[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListAuthorizedFieldPublisherGrantsByEventTypeResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp} message ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.grants = [];
                            if (message.grants && message.grants.length) {
                                object.grants = [];
                                for (var j = 0; j < message.grants.length; ++j)
                                    object.grants[j] = $root.code.justin.tv.eventbus.controlplane.PublisherGrant.toObject(message.grants[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this ListAuthorizedFieldPublisherGrantsByEventTypeResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListAuthorizedFieldPublisherGrantsByEventTypeResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListAuthorizedFieldPublisherGrantsByEventTypeResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListAuthorizedFieldPublisherGrantsByEventTypeResp;
                    })();

                    controlplane.Grant = (function() {

                        /**
                         * Properties of a Grant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGrant
                         * @property {string|null} [iamRoleArn] Grant iamRoleArn
                         * @property {string|null} [serviceName] Grant serviceName
                         * @property {string|null} [fieldName] Grant fieldName
                         * @property {string|null} [messageName] Grant messageName
                         * @property {string|null} [environment] Grant environment
                         */

                        /**
                         * Constructs a new Grant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a Grant.
                         * @implements IGrant
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGrant=} [properties] Properties to set
                         */
                        function Grant(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Grant iamRoleArn.
                         * @member {string} iamRoleArn
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @instance
                         */
                        Grant.prototype.iamRoleArn = "";

                        /**
                         * Grant serviceName.
                         * @member {string} serviceName
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @instance
                         */
                        Grant.prototype.serviceName = "";

                        /**
                         * Grant fieldName.
                         * @member {string} fieldName
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @instance
                         */
                        Grant.prototype.fieldName = "";

                        /**
                         * Grant messageName.
                         * @member {string} messageName
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @instance
                         */
                        Grant.prototype.messageName = "";

                        /**
                         * Grant environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @instance
                         */
                        Grant.prototype.environment = "";

                        /**
                         * Creates a new Grant instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGrant=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.Grant} Grant instance
                         */
                        Grant.create = function create(properties) {
                            return new Grant(properties);
                        };

                        /**
                         * Encodes the specified Grant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Grant.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGrant} message Grant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Grant.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.iamRoleArn != null && Object.hasOwnProperty.call(message, "iamRoleArn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.iamRoleArn);
                            if (message.serviceName != null && Object.hasOwnProperty.call(message, "serviceName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.serviceName);
                            if (message.fieldName != null && Object.hasOwnProperty.call(message, "fieldName"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.fieldName);
                            if (message.messageName != null && Object.hasOwnProperty.call(message, "messageName"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.messageName);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified Grant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Grant.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGrant} message Grant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Grant.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a Grant message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.Grant} Grant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Grant.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.Grant();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.iamRoleArn = reader.string();
                                    break;
                                case 2:
                                    message.serviceName = reader.string();
                                    break;
                                case 3:
                                    message.fieldName = reader.string();
                                    break;
                                case 4:
                                    message.messageName = reader.string();
                                    break;
                                case 5:
                                    message.environment = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a Grant message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.Grant} Grant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Grant.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a Grant message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Grant.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.iamRoleArn != null && message.hasOwnProperty("iamRoleArn"))
                                if (!$util.isString(message.iamRoleArn))
                                    return "iamRoleArn: string expected";
                            if (message.serviceName != null && message.hasOwnProperty("serviceName"))
                                if (!$util.isString(message.serviceName))
                                    return "serviceName: string expected";
                            if (message.fieldName != null && message.hasOwnProperty("fieldName"))
                                if (!$util.isString(message.fieldName))
                                    return "fieldName: string expected";
                            if (message.messageName != null && message.hasOwnProperty("messageName"))
                                if (!$util.isString(message.messageName))
                                    return "messageName: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            return null;
                        };

                        /**
                         * Creates a Grant message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.Grant} Grant
                         */
                        Grant.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.Grant)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.Grant();
                            if (object.iamRoleArn != null)
                                message.iamRoleArn = String(object.iamRoleArn);
                            if (object.serviceName != null)
                                message.serviceName = String(object.serviceName);
                            if (object.fieldName != null)
                                message.fieldName = String(object.fieldName);
                            if (object.messageName != null)
                                message.messageName = String(object.messageName);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            return message;
                        };

                        /**
                         * Creates a plain object from a Grant message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.Grant} message Grant
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Grant.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.iamRoleArn = "";
                                object.serviceName = "";
                                object.fieldName = "";
                                object.messageName = "";
                                object.environment = "";
                            }
                            if (message.iamRoleArn != null && message.hasOwnProperty("iamRoleArn"))
                                object.iamRoleArn = message.iamRoleArn;
                            if (message.serviceName != null && message.hasOwnProperty("serviceName"))
                                object.serviceName = message.serviceName;
                            if (message.fieldName != null && message.hasOwnProperty("fieldName"))
                                object.fieldName = message.fieldName;
                            if (message.messageName != null && message.hasOwnProperty("messageName"))
                                object.messageName = message.messageName;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            return object;
                        };

                        /**
                         * Converts this Grant to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.Grant
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Grant.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return Grant;
                    })();

                    controlplane.PublisherGrant = (function() {

                        /**
                         * Properties of a PublisherGrant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IPublisherGrant
                         * @property {string|null} [iamRoleArn] PublisherGrant iamRoleArn
                         * @property {string|null} [serviceName] PublisherGrant serviceName
                         * @property {string|null} [environment] PublisherGrant environment
                         */

                        /**
                         * Constructs a new PublisherGrant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a PublisherGrant.
                         * @implements IPublisherGrant
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherGrant=} [properties] Properties to set
                         */
                        function PublisherGrant(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * PublisherGrant iamRoleArn.
                         * @member {string} iamRoleArn
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @instance
                         */
                        PublisherGrant.prototype.iamRoleArn = "";

                        /**
                         * PublisherGrant serviceName.
                         * @member {string} serviceName
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @instance
                         */
                        PublisherGrant.prototype.serviceName = "";

                        /**
                         * PublisherGrant environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @instance
                         */
                        PublisherGrant.prototype.environment = "";

                        /**
                         * Creates a new PublisherGrant instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherGrant=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherGrant} PublisherGrant instance
                         */
                        PublisherGrant.create = function create(properties) {
                            return new PublisherGrant(properties);
                        };

                        /**
                         * Encodes the specified PublisherGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherGrant.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherGrant} message PublisherGrant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PublisherGrant.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.iamRoleArn != null && Object.hasOwnProperty.call(message, "iamRoleArn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.iamRoleArn);
                            if (message.serviceName != null && Object.hasOwnProperty.call(message, "serviceName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.serviceName);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified PublisherGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherGrant.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherGrant} message PublisherGrant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PublisherGrant.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a PublisherGrant message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherGrant} PublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PublisherGrant.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.PublisherGrant();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.iamRoleArn = reader.string();
                                    break;
                                case 2:
                                    message.serviceName = reader.string();
                                    break;
                                case 3:
                                    message.environment = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a PublisherGrant message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherGrant} PublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PublisherGrant.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a PublisherGrant message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        PublisherGrant.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.iamRoleArn != null && message.hasOwnProperty("iamRoleArn"))
                                if (!$util.isString(message.iamRoleArn))
                                    return "iamRoleArn: string expected";
                            if (message.serviceName != null && message.hasOwnProperty("serviceName"))
                                if (!$util.isString(message.serviceName))
                                    return "serviceName: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            return null;
                        };

                        /**
                         * Creates a PublisherGrant message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherGrant} PublisherGrant
                         */
                        PublisherGrant.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.PublisherGrant)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.PublisherGrant();
                            if (object.iamRoleArn != null)
                                message.iamRoleArn = String(object.iamRoleArn);
                            if (object.serviceName != null)
                                message.serviceName = String(object.serviceName);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            return message;
                        };

                        /**
                         * Creates a plain object from a PublisherGrant message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.PublisherGrant} message PublisherGrant
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        PublisherGrant.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.iamRoleArn = "";
                                object.serviceName = "";
                                object.environment = "";
                            }
                            if (message.iamRoleArn != null && message.hasOwnProperty("iamRoleArn"))
                                object.iamRoleArn = message.iamRoleArn;
                            if (message.serviceName != null && message.hasOwnProperty("serviceName"))
                                object.serviceName = message.serviceName;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            return object;
                        };

                        /**
                         * Converts this PublisherGrant to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherGrant
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        PublisherGrant.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return PublisherGrant;
                    })();

                    controlplane.EventType = (function() {

                        /**
                         * Properties of an EventType.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IEventType
                         * @property {string|null} [id] EventType id
                         * @property {string|null} [name] EventType name
                         * @property {string|null} [description] EventType description
                         * @property {string|null} [repoFilepath] EventType repoFilepath
                         * @property {boolean|null} [deprecated] EventType deprecated
                         * @property {string|null} [ldapGroup] EventType ldapGroup
                         */

                        /**
                         * Constructs a new EventType.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an EventType.
                         * @implements IEventType
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IEventType=} [properties] Properties to set
                         */
                        function EventType(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * EventType id.
                         * @member {string} id
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @instance
                         */
                        EventType.prototype.id = "";

                        /**
                         * EventType name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @instance
                         */
                        EventType.prototype.name = "";

                        /**
                         * EventType description.
                         * @member {string} description
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @instance
                         */
                        EventType.prototype.description = "";

                        /**
                         * EventType repoFilepath.
                         * @member {string} repoFilepath
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @instance
                         */
                        EventType.prototype.repoFilepath = "";

                        /**
                         * EventType deprecated.
                         * @member {boolean} deprecated
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @instance
                         */
                        EventType.prototype.deprecated = false;

                        /**
                         * EventType ldapGroup.
                         * @member {string} ldapGroup
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @instance
                         */
                        EventType.prototype.ldapGroup = "";

                        /**
                         * Creates a new EventType instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventType=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.EventType} EventType instance
                         */
                        EventType.create = function create(properties) {
                            return new EventType(properties);
                        };

                        /**
                         * Encodes the specified EventType message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventType.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventType} message EventType message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EventType.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.name);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
                            if (message.repoFilepath != null && Object.hasOwnProperty.call(message, "repoFilepath"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.repoFilepath);
                            if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.deprecated);
                            if (message.ldapGroup != null && Object.hasOwnProperty.call(message, "ldapGroup"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.ldapGroup);
                            return writer;
                        };

                        /**
                         * Encodes the specified EventType message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventType.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventType} message EventType message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EventType.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an EventType message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.EventType} EventType
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EventType.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.EventType();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.id = reader.string();
                                    break;
                                case 2:
                                    message.name = reader.string();
                                    break;
                                case 3:
                                    message.description = reader.string();
                                    break;
                                case 4:
                                    message.repoFilepath = reader.string();
                                    break;
                                case 5:
                                    message.deprecated = reader.bool();
                                    break;
                                case 6:
                                    message.ldapGroup = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an EventType message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.EventType} EventType
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EventType.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an EventType message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EventType.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.repoFilepath != null && message.hasOwnProperty("repoFilepath"))
                                if (!$util.isString(message.repoFilepath))
                                    return "repoFilepath: string expected";
                            if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                                if (typeof message.deprecated !== "boolean")
                                    return "deprecated: boolean expected";
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                if (!$util.isString(message.ldapGroup))
                                    return "ldapGroup: string expected";
                            return null;
                        };

                        /**
                         * Creates an EventType message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.EventType} EventType
                         */
                        EventType.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.EventType)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.EventType();
                            if (object.id != null)
                                message.id = String(object.id);
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.repoFilepath != null)
                                message.repoFilepath = String(object.repoFilepath);
                            if (object.deprecated != null)
                                message.deprecated = Boolean(object.deprecated);
                            if (object.ldapGroup != null)
                                message.ldapGroup = String(object.ldapGroup);
                            return message;
                        };

                        /**
                         * Creates a plain object from an EventType message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.EventType} message EventType
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EventType.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.id = "";
                                object.name = "";
                                object.description = "";
                                object.repoFilepath = "";
                                object.deprecated = false;
                                object.ldapGroup = "";
                            }
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.repoFilepath != null && message.hasOwnProperty("repoFilepath"))
                                object.repoFilepath = message.repoFilepath;
                            if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                                object.deprecated = message.deprecated;
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                object.ldapGroup = message.ldapGroup;
                            return object;
                        };

                        /**
                         * Converts this EventType to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.EventType
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EventType.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return EventType;
                    })();

                    controlplane.ListEventTypesReq = (function() {

                        /**
                         * Properties of a ListEventTypesReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListEventTypesReq
                         * @property {string|null} [ldapGroup] ListEventTypesReq ldapGroup
                         */

                        /**
                         * Constructs a new ListEventTypesReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListEventTypesReq.
                         * @implements IListEventTypesReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesReq=} [properties] Properties to set
                         */
                        function ListEventTypesReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListEventTypesReq ldapGroup.
                         * @member {string} ldapGroup
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @instance
                         */
                        ListEventTypesReq.prototype.ldapGroup = "";

                        /**
                         * Creates a new ListEventTypesReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesReq} ListEventTypesReq instance
                         */
                        ListEventTypesReq.create = function create(properties) {
                            return new ListEventTypesReq(properties);
                        };

                        /**
                         * Encodes the specified ListEventTypesReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesReq} message ListEventTypesReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventTypesReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.ldapGroup != null && Object.hasOwnProperty.call(message, "ldapGroup"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.ldapGroup);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListEventTypesReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesReq} message ListEventTypesReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventTypesReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListEventTypesReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesReq} ListEventTypesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventTypesReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListEventTypesReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.ldapGroup = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListEventTypesReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesReq} ListEventTypesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventTypesReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListEventTypesReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListEventTypesReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                if (!$util.isString(message.ldapGroup))
                                    return "ldapGroup: string expected";
                            return null;
                        };

                        /**
                         * Creates a ListEventTypesReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesReq} ListEventTypesReq
                         */
                        ListEventTypesReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListEventTypesReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListEventTypesReq();
                            if (object.ldapGroup != null)
                                message.ldapGroup = String(object.ldapGroup);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListEventTypesReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListEventTypesReq} message ListEventTypesReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListEventTypesReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.ldapGroup = "";
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                object.ldapGroup = message.ldapGroup;
                            return object;
                        };

                        /**
                         * Converts this ListEventTypesReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListEventTypesReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListEventTypesReq;
                    })();

                    controlplane.ListEventTypesResp = (function() {

                        /**
                         * Properties of a ListEventTypesResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListEventTypesResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IEventType>|null} [eventTypes] ListEventTypesResp eventTypes
                         */

                        /**
                         * Constructs a new ListEventTypesResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListEventTypesResp.
                         * @implements IListEventTypesResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesResp=} [properties] Properties to set
                         */
                        function ListEventTypesResp(properties) {
                            this.eventTypes = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListEventTypesResp eventTypes.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IEventType>} eventTypes
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @instance
                         */
                        ListEventTypesResp.prototype.eventTypes = $util.emptyArray;

                        /**
                         * Creates a new ListEventTypesResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesResp} ListEventTypesResp instance
                         */
                        ListEventTypesResp.create = function create(properties) {
                            return new ListEventTypesResp(properties);
                        };

                        /**
                         * Encodes the specified ListEventTypesResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesResp} message ListEventTypesResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventTypesResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventTypes != null && message.eventTypes.length)
                                for (var i = 0; i < message.eventTypes.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.EventType.encode(message.eventTypes[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified ListEventTypesResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventTypesResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventTypesResp} message ListEventTypesResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventTypesResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListEventTypesResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesResp} ListEventTypesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventTypesResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListEventTypesResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.eventTypes && message.eventTypes.length))
                                        message.eventTypes = [];
                                    message.eventTypes.push($root.code.justin.tv.eventbus.controlplane.EventType.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListEventTypesResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesResp} ListEventTypesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventTypesResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListEventTypesResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListEventTypesResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventTypes != null && message.hasOwnProperty("eventTypes")) {
                                if (!Array.isArray(message.eventTypes))
                                    return "eventTypes: array expected";
                                for (var i = 0; i < message.eventTypes.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.EventType.verify(message.eventTypes[i]);
                                    if (error)
                                        return "eventTypes." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a ListEventTypesResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventTypesResp} ListEventTypesResp
                         */
                        ListEventTypesResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListEventTypesResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListEventTypesResp();
                            if (object.eventTypes) {
                                if (!Array.isArray(object.eventTypes))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.ListEventTypesResp.eventTypes: array expected");
                                message.eventTypes = [];
                                for (var i = 0; i < object.eventTypes.length; ++i) {
                                    if (typeof object.eventTypes[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.ListEventTypesResp.eventTypes: object expected");
                                    message.eventTypes[i] = $root.code.justin.tv.eventbus.controlplane.EventType.fromObject(object.eventTypes[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListEventTypesResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListEventTypesResp} message ListEventTypesResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListEventTypesResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.eventTypes = [];
                            if (message.eventTypes && message.eventTypes.length) {
                                object.eventTypes = [];
                                for (var j = 0; j < message.eventTypes.length; ++j)
                                    object.eventTypes[j] = $root.code.justin.tv.eventbus.controlplane.EventType.toObject(message.eventTypes[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this ListEventTypesResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventTypesResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListEventTypesResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListEventTypesResp;
                    })();

                    controlplane.ListEventStreamsReq = (function() {

                        /**
                         * Properties of a ListEventStreamsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListEventStreamsReq
                         * @property {string|null} [cursor] ListEventStreamsReq cursor
                         * @property {string|null} [eventTypeName] ListEventStreamsReq eventTypeName
                         */

                        /**
                         * Constructs a new ListEventStreamsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListEventStreamsReq.
                         * @implements IListEventStreamsReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsReq=} [properties] Properties to set
                         */
                        function ListEventStreamsReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListEventStreamsReq cursor.
                         * @member {string} cursor
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @instance
                         */
                        ListEventStreamsReq.prototype.cursor = "";

                        /**
                         * ListEventStreamsReq eventTypeName.
                         * @member {string} eventTypeName
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @instance
                         */
                        ListEventStreamsReq.prototype.eventTypeName = "";

                        /**
                         * Creates a new ListEventStreamsReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsReq} ListEventStreamsReq instance
                         */
                        ListEventStreamsReq.create = function create(properties) {
                            return new ListEventStreamsReq(properties);
                        };

                        /**
                         * Encodes the specified ListEventStreamsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsReq} message ListEventStreamsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventStreamsReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.cursor != null && Object.hasOwnProperty.call(message, "cursor"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.cursor);
                            if (message.eventTypeName != null && Object.hasOwnProperty.call(message, "eventTypeName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.eventTypeName);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListEventStreamsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsReq} message ListEventStreamsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventStreamsReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListEventStreamsReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsReq} ListEventStreamsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventStreamsReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListEventStreamsReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.cursor = reader.string();
                                    break;
                                case 2:
                                    message.eventTypeName = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListEventStreamsReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsReq} ListEventStreamsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventStreamsReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListEventStreamsReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListEventStreamsReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.cursor != null && message.hasOwnProperty("cursor"))
                                if (!$util.isString(message.cursor))
                                    return "cursor: string expected";
                            if (message.eventTypeName != null && message.hasOwnProperty("eventTypeName"))
                                if (!$util.isString(message.eventTypeName))
                                    return "eventTypeName: string expected";
                            return null;
                        };

                        /**
                         * Creates a ListEventStreamsReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsReq} ListEventStreamsReq
                         */
                        ListEventStreamsReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListEventStreamsReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListEventStreamsReq();
                            if (object.cursor != null)
                                message.cursor = String(object.cursor);
                            if (object.eventTypeName != null)
                                message.eventTypeName = String(object.eventTypeName);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListEventStreamsReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListEventStreamsReq} message ListEventStreamsReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListEventStreamsReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.cursor = "";
                                object.eventTypeName = "";
                            }
                            if (message.cursor != null && message.hasOwnProperty("cursor"))
                                object.cursor = message.cursor;
                            if (message.eventTypeName != null && message.hasOwnProperty("eventTypeName"))
                                object.eventTypeName = message.eventTypeName;
                            return object;
                        };

                        /**
                         * Converts this ListEventStreamsReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListEventStreamsReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListEventStreamsReq;
                    })();

                    controlplane.ListEventStreamsResp = (function() {

                        /**
                         * Properties of a ListEventStreamsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListEventStreamsResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IEventStream>|null} [eventStreams] ListEventStreamsResp eventStreams
                         * @property {string|null} [nextCursor] ListEventStreamsResp nextCursor
                         */

                        /**
                         * Constructs a new ListEventStreamsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListEventStreamsResp.
                         * @implements IListEventStreamsResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsResp=} [properties] Properties to set
                         */
                        function ListEventStreamsResp(properties) {
                            this.eventStreams = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListEventStreamsResp eventStreams.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IEventStream>} eventStreams
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @instance
                         */
                        ListEventStreamsResp.prototype.eventStreams = $util.emptyArray;

                        /**
                         * ListEventStreamsResp nextCursor.
                         * @member {string} nextCursor
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @instance
                         */
                        ListEventStreamsResp.prototype.nextCursor = "";

                        /**
                         * Creates a new ListEventStreamsResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsResp} ListEventStreamsResp instance
                         */
                        ListEventStreamsResp.create = function create(properties) {
                            return new ListEventStreamsResp(properties);
                        };

                        /**
                         * Encodes the specified ListEventStreamsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsResp} message ListEventStreamsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventStreamsResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventStreams != null && message.eventStreams.length)
                                for (var i = 0; i < message.eventStreams.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.EventStream.encode(message.eventStreams[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.nextCursor != null && Object.hasOwnProperty.call(message, "nextCursor"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextCursor);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListEventStreamsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListEventStreamsResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListEventStreamsResp} message ListEventStreamsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListEventStreamsResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListEventStreamsResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsResp} ListEventStreamsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventStreamsResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListEventStreamsResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.eventStreams && message.eventStreams.length))
                                        message.eventStreams = [];
                                    message.eventStreams.push($root.code.justin.tv.eventbus.controlplane.EventStream.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    message.nextCursor = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListEventStreamsResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsResp} ListEventStreamsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListEventStreamsResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListEventStreamsResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListEventStreamsResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventStreams != null && message.hasOwnProperty("eventStreams")) {
                                if (!Array.isArray(message.eventStreams))
                                    return "eventStreams: array expected";
                                for (var i = 0; i < message.eventStreams.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.EventStream.verify(message.eventStreams[i]);
                                    if (error)
                                        return "eventStreams." + error;
                                }
                            }
                            if (message.nextCursor != null && message.hasOwnProperty("nextCursor"))
                                if (!$util.isString(message.nextCursor))
                                    return "nextCursor: string expected";
                            return null;
                        };

                        /**
                         * Creates a ListEventStreamsResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListEventStreamsResp} ListEventStreamsResp
                         */
                        ListEventStreamsResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListEventStreamsResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListEventStreamsResp();
                            if (object.eventStreams) {
                                if (!Array.isArray(object.eventStreams))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.ListEventStreamsResp.eventStreams: array expected");
                                message.eventStreams = [];
                                for (var i = 0; i < object.eventStreams.length; ++i) {
                                    if (typeof object.eventStreams[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.ListEventStreamsResp.eventStreams: object expected");
                                    message.eventStreams[i] = $root.code.justin.tv.eventbus.controlplane.EventStream.fromObject(object.eventStreams[i]);
                                }
                            }
                            if (object.nextCursor != null)
                                message.nextCursor = String(object.nextCursor);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListEventStreamsResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListEventStreamsResp} message ListEventStreamsResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListEventStreamsResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.eventStreams = [];
                            if (options.defaults)
                                object.nextCursor = "";
                            if (message.eventStreams && message.eventStreams.length) {
                                object.eventStreams = [];
                                for (var j = 0; j < message.eventStreams.length; ++j)
                                    object.eventStreams[j] = $root.code.justin.tv.eventbus.controlplane.EventStream.toObject(message.eventStreams[j], options);
                            }
                            if (message.nextCursor != null && message.hasOwnProperty("nextCursor"))
                                object.nextCursor = message.nextCursor;
                            return object;
                        };

                        /**
                         * Converts this ListEventStreamsResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListEventStreamsResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListEventStreamsResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListEventStreamsResp;
                    })();

                    controlplane.GetEventStreamReq = (function() {

                        /**
                         * Properties of a GetEventStreamReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetEventStreamReq
                         * @property {string|null} [eventType] GetEventStreamReq eventType
                         * @property {string|null} [environment] GetEventStreamReq environment
                         */

                        /**
                         * Constructs a new GetEventStreamReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetEventStreamReq.
                         * @implements IGetEventStreamReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamReq=} [properties] Properties to set
                         */
                        function GetEventStreamReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetEventStreamReq eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @instance
                         */
                        GetEventStreamReq.prototype.eventType = "";

                        /**
                         * GetEventStreamReq environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @instance
                         */
                        GetEventStreamReq.prototype.environment = "";

                        /**
                         * Creates a new GetEventStreamReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamReq} GetEventStreamReq instance
                         */
                        GetEventStreamReq.create = function create(properties) {
                            return new GetEventStreamReq(properties);
                        };

                        /**
                         * Encodes the specified GetEventStreamReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamReq} message GetEventStreamReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetEventStreamReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.eventType);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetEventStreamReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamReq} message GetEventStreamReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetEventStreamReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetEventStreamReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamReq} GetEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetEventStreamReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetEventStreamReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.eventType = reader.string();
                                    break;
                                case 2:
                                    message.environment = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetEventStreamReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamReq} GetEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetEventStreamReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetEventStreamReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetEventStreamReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetEventStreamReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamReq} GetEventStreamReq
                         */
                        GetEventStreamReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetEventStreamReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetEventStreamReq();
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetEventStreamReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetEventStreamReq} message GetEventStreamReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetEventStreamReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.eventType = "";
                                object.environment = "";
                            }
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            return object;
                        };

                        /**
                         * Converts this GetEventStreamReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetEventStreamReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetEventStreamReq;
                    })();

                    controlplane.GetEventStreamStatsReq = (function() {

                        /**
                         * Properties of a GetEventStreamStatsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetEventStreamStatsReq
                         * @property {string|null} [eventType] GetEventStreamStatsReq eventType
                         * @property {string|null} [environment] GetEventStreamStatsReq environment
                         */

                        /**
                         * Constructs a new GetEventStreamStatsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetEventStreamStatsReq.
                         * @implements IGetEventStreamStatsReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq=} [properties] Properties to set
                         */
                        function GetEventStreamStatsReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetEventStreamStatsReq eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @instance
                         */
                        GetEventStreamStatsReq.prototype.eventType = "";

                        /**
                         * GetEventStreamStatsReq environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @instance
                         */
                        GetEventStreamStatsReq.prototype.environment = "";

                        /**
                         * Creates a new GetEventStreamStatsReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq} GetEventStreamStatsReq instance
                         */
                        GetEventStreamStatsReq.create = function create(properties) {
                            return new GetEventStreamStatsReq(properties);
                        };

                        /**
                         * Encodes the specified GetEventStreamStatsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq} message GetEventStreamStatsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetEventStreamStatsReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.eventType);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetEventStreamStatsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetEventStreamStatsReq} message GetEventStreamStatsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetEventStreamStatsReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetEventStreamStatsReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq} GetEventStreamStatsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetEventStreamStatsReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.eventType = reader.string();
                                    break;
                                case 2:
                                    message.environment = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetEventStreamStatsReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq} GetEventStreamStatsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetEventStreamStatsReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetEventStreamStatsReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetEventStreamStatsReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetEventStreamStatsReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq} GetEventStreamStatsReq
                         */
                        GetEventStreamStatsReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq();
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetEventStreamStatsReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq} message GetEventStreamStatsReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetEventStreamStatsReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.eventType = "";
                                object.environment = "";
                            }
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            return object;
                        };

                        /**
                         * Converts this GetEventStreamStatsReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetEventStreamStatsReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetEventStreamStatsReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetEventStreamStatsReq;
                    })();

                    controlplane.EventStream = (function() {

                        /**
                         * Properties of an EventStream.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IEventStream
                         * @property {string|null} [eventType] EventStream eventType
                         * @property {string|null} [environment] EventStream environment
                         * @property {string|null} [displayName] EventStream displayName
                         * @property {string|null} [shortDescription] EventStream shortDescription
                         * @property {google.protobuf.ITimestamp|null} [activeSince] EventStream activeSince
                         * @property {string|null} [description] EventStream description
                         * @property {code.justin.tv.eventbus.controlplane.IEventStreamStats|null} [stats] EventStream stats
                         * @property {string|null} [schema] EventStream schema
                         * @property {string|null} [repoFilepath] EventStream repoFilepath
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IAuthorizedField>|null} [authorizedFields] EventStream authorizedFields
                         * @property {boolean|null} [deprecated] EventStream deprecated
                         * @property {string|null} [ldapGroup] EventStream ldapGroup
                         */

                        /**
                         * Constructs a new EventStream.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an EventStream.
                         * @implements IEventStream
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IEventStream=} [properties] Properties to set
                         */
                        function EventStream(properties) {
                            this.authorizedFields = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * EventStream eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.eventType = "";

                        /**
                         * EventStream environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.environment = "";

                        /**
                         * EventStream displayName.
                         * @member {string} displayName
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.displayName = "";

                        /**
                         * EventStream shortDescription.
                         * @member {string} shortDescription
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.shortDescription = "";

                        /**
                         * EventStream activeSince.
                         * @member {google.protobuf.ITimestamp|null|undefined} activeSince
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.activeSince = null;

                        /**
                         * EventStream description.
                         * @member {string} description
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.description = "";

                        /**
                         * EventStream stats.
                         * @member {code.justin.tv.eventbus.controlplane.IEventStreamStats|null|undefined} stats
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.stats = null;

                        /**
                         * EventStream schema.
                         * @member {string} schema
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.schema = "";

                        /**
                         * EventStream repoFilepath.
                         * @member {string} repoFilepath
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.repoFilepath = "";

                        /**
                         * EventStream authorizedFields.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IAuthorizedField>} authorizedFields
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.authorizedFields = $util.emptyArray;

                        /**
                         * EventStream deprecated.
                         * @member {boolean} deprecated
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.deprecated = false;

                        /**
                         * EventStream ldapGroup.
                         * @member {string} ldapGroup
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         */
                        EventStream.prototype.ldapGroup = "";

                        /**
                         * Creates a new EventStream instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventStream=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.EventStream} EventStream instance
                         */
                        EventStream.create = function create(properties) {
                            return new EventStream(properties);
                        };

                        /**
                         * Encodes the specified EventStream message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStream.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventStream} message EventStream message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EventStream.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.eventType);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.environment);
                            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.displayName);
                            if (message.shortDescription != null && Object.hasOwnProperty.call(message, "shortDescription"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.shortDescription);
                            if (message.activeSince != null && Object.hasOwnProperty.call(message, "activeSince"))
                                $root.google.protobuf.Timestamp.encode(message.activeSince, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.description);
                            if (message.stats != null && Object.hasOwnProperty.call(message, "stats"))
                                $root.code.justin.tv.eventbus.controlplane.EventStreamStats.encode(message.stats, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            if (message.schema != null && Object.hasOwnProperty.call(message, "schema"))
                                writer.uint32(/* id 8, wireType 2 =*/66).string(message.schema);
                            if (message.repoFilepath != null && Object.hasOwnProperty.call(message, "repoFilepath"))
                                writer.uint32(/* id 9, wireType 2 =*/74).string(message.repoFilepath);
                            if (message.authorizedFields != null && message.authorizedFields.length)
                                for (var i = 0; i < message.authorizedFields.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.AuthorizedField.encode(message.authorizedFields[i], writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                            if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                                writer.uint32(/* id 11, wireType 0 =*/88).bool(message.deprecated);
                            if (message.ldapGroup != null && Object.hasOwnProperty.call(message, "ldapGroup"))
                                writer.uint32(/* id 12, wireType 2 =*/98).string(message.ldapGroup);
                            return writer;
                        };

                        /**
                         * Encodes the specified EventStream message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStream.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventStream} message EventStream message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EventStream.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an EventStream message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.EventStream} EventStream
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EventStream.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.EventStream();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.eventType = reader.string();
                                    break;
                                case 2:
                                    message.environment = reader.string();
                                    break;
                                case 3:
                                    message.displayName = reader.string();
                                    break;
                                case 4:
                                    message.shortDescription = reader.string();
                                    break;
                                case 5:
                                    message.activeSince = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                case 6:
                                    message.description = reader.string();
                                    break;
                                case 7:
                                    message.stats = $root.code.justin.tv.eventbus.controlplane.EventStreamStats.decode(reader, reader.uint32());
                                    break;
                                case 8:
                                    message.schema = reader.string();
                                    break;
                                case 9:
                                    message.repoFilepath = reader.string();
                                    break;
                                case 10:
                                    if (!(message.authorizedFields && message.authorizedFields.length))
                                        message.authorizedFields = [];
                                    message.authorizedFields.push($root.code.justin.tv.eventbus.controlplane.AuthorizedField.decode(reader, reader.uint32()));
                                    break;
                                case 11:
                                    message.deprecated = reader.bool();
                                    break;
                                case 12:
                                    message.ldapGroup = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an EventStream message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.EventStream} EventStream
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EventStream.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an EventStream message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EventStream.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                if (!$util.isString(message.displayName))
                                    return "displayName: string expected";
                            if (message.shortDescription != null && message.hasOwnProperty("shortDescription"))
                                if (!$util.isString(message.shortDescription))
                                    return "shortDescription: string expected";
                            if (message.activeSince != null && message.hasOwnProperty("activeSince")) {
                                var error = $root.google.protobuf.Timestamp.verify(message.activeSince);
                                if (error)
                                    return "activeSince." + error;
                            }
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.stats != null && message.hasOwnProperty("stats")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.EventStreamStats.verify(message.stats);
                                if (error)
                                    return "stats." + error;
                            }
                            if (message.schema != null && message.hasOwnProperty("schema"))
                                if (!$util.isString(message.schema))
                                    return "schema: string expected";
                            if (message.repoFilepath != null && message.hasOwnProperty("repoFilepath"))
                                if (!$util.isString(message.repoFilepath))
                                    return "repoFilepath: string expected";
                            if (message.authorizedFields != null && message.hasOwnProperty("authorizedFields")) {
                                if (!Array.isArray(message.authorizedFields))
                                    return "authorizedFields: array expected";
                                for (var i = 0; i < message.authorizedFields.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.AuthorizedField.verify(message.authorizedFields[i]);
                                    if (error)
                                        return "authorizedFields." + error;
                                }
                            }
                            if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                                if (typeof message.deprecated !== "boolean")
                                    return "deprecated: boolean expected";
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                if (!$util.isString(message.ldapGroup))
                                    return "ldapGroup: string expected";
                            return null;
                        };

                        /**
                         * Creates an EventStream message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.EventStream} EventStream
                         */
                        EventStream.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.EventStream)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.EventStream();
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            if (object.displayName != null)
                                message.displayName = String(object.displayName);
                            if (object.shortDescription != null)
                                message.shortDescription = String(object.shortDescription);
                            if (object.activeSince != null) {
                                if (typeof object.activeSince !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStream.activeSince: object expected");
                                message.activeSince = $root.google.protobuf.Timestamp.fromObject(object.activeSince);
                            }
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.stats != null) {
                                if (typeof object.stats !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStream.stats: object expected");
                                message.stats = $root.code.justin.tv.eventbus.controlplane.EventStreamStats.fromObject(object.stats);
                            }
                            if (object.schema != null)
                                message.schema = String(object.schema);
                            if (object.repoFilepath != null)
                                message.repoFilepath = String(object.repoFilepath);
                            if (object.authorizedFields) {
                                if (!Array.isArray(object.authorizedFields))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStream.authorizedFields: array expected");
                                message.authorizedFields = [];
                                for (var i = 0; i < object.authorizedFields.length; ++i) {
                                    if (typeof object.authorizedFields[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.EventStream.authorizedFields: object expected");
                                    message.authorizedFields[i] = $root.code.justin.tv.eventbus.controlplane.AuthorizedField.fromObject(object.authorizedFields[i]);
                                }
                            }
                            if (object.deprecated != null)
                                message.deprecated = Boolean(object.deprecated);
                            if (object.ldapGroup != null)
                                message.ldapGroup = String(object.ldapGroup);
                            return message;
                        };

                        /**
                         * Creates a plain object from an EventStream message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.EventStream} message EventStream
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EventStream.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.authorizedFields = [];
                            if (options.defaults) {
                                object.eventType = "";
                                object.environment = "";
                                object.displayName = "";
                                object.shortDescription = "";
                                object.activeSince = null;
                                object.description = "";
                                object.stats = null;
                                object.schema = "";
                                object.repoFilepath = "";
                                object.deprecated = false;
                                object.ldapGroup = "";
                            }
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            if (message.displayName != null && message.hasOwnProperty("displayName"))
                                object.displayName = message.displayName;
                            if (message.shortDescription != null && message.hasOwnProperty("shortDescription"))
                                object.shortDescription = message.shortDescription;
                            if (message.activeSince != null && message.hasOwnProperty("activeSince"))
                                object.activeSince = $root.google.protobuf.Timestamp.toObject(message.activeSince, options);
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.stats != null && message.hasOwnProperty("stats"))
                                object.stats = $root.code.justin.tv.eventbus.controlplane.EventStreamStats.toObject(message.stats, options);
                            if (message.schema != null && message.hasOwnProperty("schema"))
                                object.schema = message.schema;
                            if (message.repoFilepath != null && message.hasOwnProperty("repoFilepath"))
                                object.repoFilepath = message.repoFilepath;
                            if (message.authorizedFields && message.authorizedFields.length) {
                                object.authorizedFields = [];
                                for (var j = 0; j < message.authorizedFields.length; ++j)
                                    object.authorizedFields[j] = $root.code.justin.tv.eventbus.controlplane.AuthorizedField.toObject(message.authorizedFields[j], options);
                            }
                            if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                                object.deprecated = message.deprecated;
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                object.ldapGroup = message.ldapGroup;
                            return object;
                        };

                        /**
                         * Converts this EventStream to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.EventStream
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EventStream.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return EventStream;
                    })();

                    controlplane.EventStreamStats = (function() {

                        /**
                         * Properties of an EventStreamStats.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IEventStreamStats
                         * @property {google.protobuf.IDoubleValue|null} [tpsMean] EventStreamStats tpsMean
                         * @property {google.protobuf.IDoubleValue|null} [tps_95th] EventStreamStats tps_95th
                         * @property {google.protobuf.IDoubleValue|null} [meanEventsPerMinute] EventStreamStats meanEventsPerMinute
                         * @property {google.protobuf.IDoubleValue|null} [maxEventsPerMinute] EventStreamStats maxEventsPerMinute
                         * @property {google.protobuf.IDoubleValue|null} [minEventsPerMinute] EventStreamStats minEventsPerMinute
                         * @property {google.protobuf.IDoubleValue|null} [meanEventPayloadSize] EventStreamStats meanEventPayloadSize
                         * @property {number|null} [publisherCount] EventStreamStats publisherCount
                         * @property {number|null} [subscriberCount] EventStreamStats subscriberCount
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IPublisherServiceInfo>|null} [publishers] EventStreamStats publishers
                         */

                        /**
                         * Constructs a new EventStreamStats.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an EventStreamStats.
                         * @implements IEventStreamStats
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IEventStreamStats=} [properties] Properties to set
                         */
                        function EventStreamStats(properties) {
                            this.publishers = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * EventStreamStats tpsMean.
                         * @member {google.protobuf.IDoubleValue|null|undefined} tpsMean
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.tpsMean = null;

                        /**
                         * EventStreamStats tps_95th.
                         * @member {google.protobuf.IDoubleValue|null|undefined} tps_95th
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.tps_95th = null;

                        /**
                         * EventStreamStats meanEventsPerMinute.
                         * @member {google.protobuf.IDoubleValue|null|undefined} meanEventsPerMinute
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.meanEventsPerMinute = null;

                        /**
                         * EventStreamStats maxEventsPerMinute.
                         * @member {google.protobuf.IDoubleValue|null|undefined} maxEventsPerMinute
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.maxEventsPerMinute = null;

                        /**
                         * EventStreamStats minEventsPerMinute.
                         * @member {google.protobuf.IDoubleValue|null|undefined} minEventsPerMinute
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.minEventsPerMinute = null;

                        /**
                         * EventStreamStats meanEventPayloadSize.
                         * @member {google.protobuf.IDoubleValue|null|undefined} meanEventPayloadSize
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.meanEventPayloadSize = null;

                        /**
                         * EventStreamStats publisherCount.
                         * @member {number} publisherCount
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.publisherCount = 0;

                        /**
                         * EventStreamStats subscriberCount.
                         * @member {number} subscriberCount
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.subscriberCount = 0;

                        /**
                         * EventStreamStats publishers.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IPublisherServiceInfo>} publishers
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         */
                        EventStreamStats.prototype.publishers = $util.emptyArray;

                        /**
                         * Creates a new EventStreamStats instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventStreamStats=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.EventStreamStats} EventStreamStats instance
                         */
                        EventStreamStats.create = function create(properties) {
                            return new EventStreamStats(properties);
                        };

                        /**
                         * Encodes the specified EventStreamStats message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStreamStats.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventStreamStats} message EventStreamStats message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EventStreamStats.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.tpsMean != null && Object.hasOwnProperty.call(message, "tpsMean"))
                                $root.google.protobuf.DoubleValue.encode(message.tpsMean, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.tps_95th != null && Object.hasOwnProperty.call(message, "tps_95th"))
                                $root.google.protobuf.DoubleValue.encode(message.tps_95th, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            if (message.meanEventsPerMinute != null && Object.hasOwnProperty.call(message, "meanEventsPerMinute"))
                                $root.google.protobuf.DoubleValue.encode(message.meanEventsPerMinute, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                            if (message.maxEventsPerMinute != null && Object.hasOwnProperty.call(message, "maxEventsPerMinute"))
                                $root.google.protobuf.DoubleValue.encode(message.maxEventsPerMinute, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            if (message.minEventsPerMinute != null && Object.hasOwnProperty.call(message, "minEventsPerMinute"))
                                $root.google.protobuf.DoubleValue.encode(message.minEventsPerMinute, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.meanEventPayloadSize != null && Object.hasOwnProperty.call(message, "meanEventPayloadSize"))
                                $root.google.protobuf.DoubleValue.encode(message.meanEventPayloadSize, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                            if (message.publisherCount != null && Object.hasOwnProperty.call(message, "publisherCount"))
                                writer.uint32(/* id 7, wireType 0 =*/56).uint32(message.publisherCount);
                            if (message.subscriberCount != null && Object.hasOwnProperty.call(message, "subscriberCount"))
                                writer.uint32(/* id 8, wireType 0 =*/64).uint32(message.subscriberCount);
                            if (message.publishers != null && message.publishers.length)
                                for (var i = 0; i < message.publishers.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo.encode(message.publishers[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified EventStreamStats message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EventStreamStats.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEventStreamStats} message EventStreamStats message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EventStreamStats.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an EventStreamStats message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.EventStreamStats} EventStreamStats
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EventStreamStats.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.EventStreamStats();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.tpsMean = $root.google.protobuf.DoubleValue.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.tps_95th = $root.google.protobuf.DoubleValue.decode(reader, reader.uint32());
                                    break;
                                case 3:
                                    message.meanEventsPerMinute = $root.google.protobuf.DoubleValue.decode(reader, reader.uint32());
                                    break;
                                case 4:
                                    message.maxEventsPerMinute = $root.google.protobuf.DoubleValue.decode(reader, reader.uint32());
                                    break;
                                case 5:
                                    message.minEventsPerMinute = $root.google.protobuf.DoubleValue.decode(reader, reader.uint32());
                                    break;
                                case 6:
                                    message.meanEventPayloadSize = $root.google.protobuf.DoubleValue.decode(reader, reader.uint32());
                                    break;
                                case 7:
                                    message.publisherCount = reader.uint32();
                                    break;
                                case 8:
                                    message.subscriberCount = reader.uint32();
                                    break;
                                case 9:
                                    if (!(message.publishers && message.publishers.length))
                                        message.publishers = [];
                                    message.publishers.push($root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an EventStreamStats message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.EventStreamStats} EventStreamStats
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EventStreamStats.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an EventStreamStats message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EventStreamStats.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.tpsMean != null && message.hasOwnProperty("tpsMean")) {
                                var error = $root.google.protobuf.DoubleValue.verify(message.tpsMean);
                                if (error)
                                    return "tpsMean." + error;
                            }
                            if (message.tps_95th != null && message.hasOwnProperty("tps_95th")) {
                                var error = $root.google.protobuf.DoubleValue.verify(message.tps_95th);
                                if (error)
                                    return "tps_95th." + error;
                            }
                            if (message.meanEventsPerMinute != null && message.hasOwnProperty("meanEventsPerMinute")) {
                                var error = $root.google.protobuf.DoubleValue.verify(message.meanEventsPerMinute);
                                if (error)
                                    return "meanEventsPerMinute." + error;
                            }
                            if (message.maxEventsPerMinute != null && message.hasOwnProperty("maxEventsPerMinute")) {
                                var error = $root.google.protobuf.DoubleValue.verify(message.maxEventsPerMinute);
                                if (error)
                                    return "maxEventsPerMinute." + error;
                            }
                            if (message.minEventsPerMinute != null && message.hasOwnProperty("minEventsPerMinute")) {
                                var error = $root.google.protobuf.DoubleValue.verify(message.minEventsPerMinute);
                                if (error)
                                    return "minEventsPerMinute." + error;
                            }
                            if (message.meanEventPayloadSize != null && message.hasOwnProperty("meanEventPayloadSize")) {
                                var error = $root.google.protobuf.DoubleValue.verify(message.meanEventPayloadSize);
                                if (error)
                                    return "meanEventPayloadSize." + error;
                            }
                            if (message.publisherCount != null && message.hasOwnProperty("publisherCount"))
                                if (!$util.isInteger(message.publisherCount))
                                    return "publisherCount: integer expected";
                            if (message.subscriberCount != null && message.hasOwnProperty("subscriberCount"))
                                if (!$util.isInteger(message.subscriberCount))
                                    return "subscriberCount: integer expected";
                            if (message.publishers != null && message.hasOwnProperty("publishers")) {
                                if (!Array.isArray(message.publishers))
                                    return "publishers: array expected";
                                for (var i = 0; i < message.publishers.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo.verify(message.publishers[i]);
                                    if (error)
                                        return "publishers." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates an EventStreamStats message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.EventStreamStats} EventStreamStats
                         */
                        EventStreamStats.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.EventStreamStats)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.EventStreamStats();
                            if (object.tpsMean != null) {
                                if (typeof object.tpsMean !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.tpsMean: object expected");
                                message.tpsMean = $root.google.protobuf.DoubleValue.fromObject(object.tpsMean);
                            }
                            if (object.tps_95th != null) {
                                if (typeof object.tps_95th !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.tps_95th: object expected");
                                message.tps_95th = $root.google.protobuf.DoubleValue.fromObject(object.tps_95th);
                            }
                            if (object.meanEventsPerMinute != null) {
                                if (typeof object.meanEventsPerMinute !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.meanEventsPerMinute: object expected");
                                message.meanEventsPerMinute = $root.google.protobuf.DoubleValue.fromObject(object.meanEventsPerMinute);
                            }
                            if (object.maxEventsPerMinute != null) {
                                if (typeof object.maxEventsPerMinute !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.maxEventsPerMinute: object expected");
                                message.maxEventsPerMinute = $root.google.protobuf.DoubleValue.fromObject(object.maxEventsPerMinute);
                            }
                            if (object.minEventsPerMinute != null) {
                                if (typeof object.minEventsPerMinute !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.minEventsPerMinute: object expected");
                                message.minEventsPerMinute = $root.google.protobuf.DoubleValue.fromObject(object.minEventsPerMinute);
                            }
                            if (object.meanEventPayloadSize != null) {
                                if (typeof object.meanEventPayloadSize !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.meanEventPayloadSize: object expected");
                                message.meanEventPayloadSize = $root.google.protobuf.DoubleValue.fromObject(object.meanEventPayloadSize);
                            }
                            if (object.publisherCount != null)
                                message.publisherCount = object.publisherCount >>> 0;
                            if (object.subscriberCount != null)
                                message.subscriberCount = object.subscriberCount >>> 0;
                            if (object.publishers) {
                                if (!Array.isArray(object.publishers))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.publishers: array expected");
                                message.publishers = [];
                                for (var i = 0; i < object.publishers.length; ++i) {
                                    if (typeof object.publishers[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.EventStreamStats.publishers: object expected");
                                    message.publishers[i] = $root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo.fromObject(object.publishers[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an EventStreamStats message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.EventStreamStats} message EventStreamStats
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EventStreamStats.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.publishers = [];
                            if (options.defaults) {
                                object.tpsMean = null;
                                object.tps_95th = null;
                                object.meanEventsPerMinute = null;
                                object.maxEventsPerMinute = null;
                                object.minEventsPerMinute = null;
                                object.meanEventPayloadSize = null;
                                object.publisherCount = 0;
                                object.subscriberCount = 0;
                            }
                            if (message.tpsMean != null && message.hasOwnProperty("tpsMean"))
                                object.tpsMean = $root.google.protobuf.DoubleValue.toObject(message.tpsMean, options);
                            if (message.tps_95th != null && message.hasOwnProperty("tps_95th"))
                                object.tps_95th = $root.google.protobuf.DoubleValue.toObject(message.tps_95th, options);
                            if (message.meanEventsPerMinute != null && message.hasOwnProperty("meanEventsPerMinute"))
                                object.meanEventsPerMinute = $root.google.protobuf.DoubleValue.toObject(message.meanEventsPerMinute, options);
                            if (message.maxEventsPerMinute != null && message.hasOwnProperty("maxEventsPerMinute"))
                                object.maxEventsPerMinute = $root.google.protobuf.DoubleValue.toObject(message.maxEventsPerMinute, options);
                            if (message.minEventsPerMinute != null && message.hasOwnProperty("minEventsPerMinute"))
                                object.minEventsPerMinute = $root.google.protobuf.DoubleValue.toObject(message.minEventsPerMinute, options);
                            if (message.meanEventPayloadSize != null && message.hasOwnProperty("meanEventPayloadSize"))
                                object.meanEventPayloadSize = $root.google.protobuf.DoubleValue.toObject(message.meanEventPayloadSize, options);
                            if (message.publisherCount != null && message.hasOwnProperty("publisherCount"))
                                object.publisherCount = message.publisherCount;
                            if (message.subscriberCount != null && message.hasOwnProperty("subscriberCount"))
                                object.subscriberCount = message.subscriberCount;
                            if (message.publishers && message.publishers.length) {
                                object.publishers = [];
                                for (var j = 0; j < message.publishers.length; ++j)
                                    object.publishers[j] = $root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo.toObject(message.publishers[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this EventStreamStats to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.EventStreamStats
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EventStreamStats.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return EventStreamStats;
                    })();

                    controlplane.PublisherServiceInfo = (function() {

                        /**
                         * Properties of a PublisherServiceInfo.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IPublisherServiceInfo
                         * @property {string|null} [name] PublisherServiceInfo name
                         * @property {string|null} [serviceCatalogUrl] PublisherServiceInfo serviceCatalogUrl
                         */

                        /**
                         * Constructs a new PublisherServiceInfo.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a PublisherServiceInfo.
                         * @implements IPublisherServiceInfo
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherServiceInfo=} [properties] Properties to set
                         */
                        function PublisherServiceInfo(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * PublisherServiceInfo name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @instance
                         */
                        PublisherServiceInfo.prototype.name = "";

                        /**
                         * PublisherServiceInfo serviceCatalogUrl.
                         * @member {string} serviceCatalogUrl
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @instance
                         */
                        PublisherServiceInfo.prototype.serviceCatalogUrl = "";

                        /**
                         * Creates a new PublisherServiceInfo instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherServiceInfo=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherServiceInfo} PublisherServiceInfo instance
                         */
                        PublisherServiceInfo.create = function create(properties) {
                            return new PublisherServiceInfo(properties);
                        };

                        /**
                         * Encodes the specified PublisherServiceInfo message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherServiceInfo.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherServiceInfo} message PublisherServiceInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PublisherServiceInfo.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.serviceCatalogUrl != null && Object.hasOwnProperty.call(message, "serviceCatalogUrl"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.serviceCatalogUrl);
                            return writer;
                        };

                        /**
                         * Encodes the specified PublisherServiceInfo message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.PublisherServiceInfo.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IPublisherServiceInfo} message PublisherServiceInfo message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PublisherServiceInfo.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a PublisherServiceInfo message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherServiceInfo} PublisherServiceInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PublisherServiceInfo.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                case 2:
                                    message.serviceCatalogUrl = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a PublisherServiceInfo message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherServiceInfo} PublisherServiceInfo
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PublisherServiceInfo.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a PublisherServiceInfo message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        PublisherServiceInfo.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.serviceCatalogUrl != null && message.hasOwnProperty("serviceCatalogUrl"))
                                if (!$util.isString(message.serviceCatalogUrl))
                                    return "serviceCatalogUrl: string expected";
                            return null;
                        };

                        /**
                         * Creates a PublisherServiceInfo message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.PublisherServiceInfo} PublisherServiceInfo
                         */
                        PublisherServiceInfo.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.PublisherServiceInfo();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.serviceCatalogUrl != null)
                                message.serviceCatalogUrl = String(object.serviceCatalogUrl);
                            return message;
                        };

                        /**
                         * Creates a plain object from a PublisherServiceInfo message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.PublisherServiceInfo} message PublisherServiceInfo
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        PublisherServiceInfo.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.serviceCatalogUrl = "";
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.serviceCatalogUrl != null && message.hasOwnProperty("serviceCatalogUrl"))
                                object.serviceCatalogUrl = message.serviceCatalogUrl;
                            return object;
                        };

                        /**
                         * Converts this PublisherServiceInfo to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.PublisherServiceInfo
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        PublisherServiceInfo.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return PublisherServiceInfo;
                    })();

                    controlplane.AuthorizedField = (function() {

                        /**
                         * Properties of an AuthorizedField.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IAuthorizedField
                         * @property {string|null} [messageName] AuthorizedField messageName
                         * @property {string|null} [fieldName] AuthorizedField fieldName
                         */

                        /**
                         * Constructs a new AuthorizedField.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an AuthorizedField.
                         * @implements IAuthorizedField
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedField=} [properties] Properties to set
                         */
                        function AuthorizedField(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * AuthorizedField messageName.
                         * @member {string} messageName
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @instance
                         */
                        AuthorizedField.prototype.messageName = "";

                        /**
                         * AuthorizedField fieldName.
                         * @member {string} fieldName
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @instance
                         */
                        AuthorizedField.prototype.fieldName = "";

                        /**
                         * Creates a new AuthorizedField instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedField=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedField} AuthorizedField instance
                         */
                        AuthorizedField.create = function create(properties) {
                            return new AuthorizedField(properties);
                        };

                        /**
                         * Encodes the specified AuthorizedField message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedField.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedField} message AuthorizedField message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuthorizedField.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.messageName != null && Object.hasOwnProperty.call(message, "messageName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.messageName);
                            if (message.fieldName != null && Object.hasOwnProperty.call(message, "fieldName"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.fieldName);
                            return writer;
                        };

                        /**
                         * Encodes the specified AuthorizedField message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedField.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedField} message AuthorizedField message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuthorizedField.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an AuthorizedField message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedField} AuthorizedField
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuthorizedField.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.AuthorizedField();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.messageName = reader.string();
                                    break;
                                case 2:
                                    message.fieldName = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an AuthorizedField message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedField} AuthorizedField
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuthorizedField.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an AuthorizedField message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AuthorizedField.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.messageName != null && message.hasOwnProperty("messageName"))
                                if (!$util.isString(message.messageName))
                                    return "messageName: string expected";
                            if (message.fieldName != null && message.hasOwnProperty("fieldName"))
                                if (!$util.isString(message.fieldName))
                                    return "fieldName: string expected";
                            return null;
                        };

                        /**
                         * Creates an AuthorizedField message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedField} AuthorizedField
                         */
                        AuthorizedField.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.AuthorizedField)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.AuthorizedField();
                            if (object.messageName != null)
                                message.messageName = String(object.messageName);
                            if (object.fieldName != null)
                                message.fieldName = String(object.fieldName);
                            return message;
                        };

                        /**
                         * Creates a plain object from an AuthorizedField message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.AuthorizedField} message AuthorizedField
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AuthorizedField.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.messageName = "";
                                object.fieldName = "";
                            }
                            if (message.messageName != null && message.hasOwnProperty("messageName"))
                                object.messageName = message.messageName;
                            if (message.fieldName != null && message.hasOwnProperty("fieldName"))
                                object.fieldName = message.fieldName;
                            return object;
                        };

                        /**
                         * Converts this AuthorizedField to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedField
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AuthorizedField.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return AuthorizedField;
                    })();

                    controlplane.FeatureFlags = (function() {

                        /**
                         * Constructs a new FeatureFlags service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a FeatureFlags
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function FeatureFlags(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (FeatureFlags.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = FeatureFlags;

                        /**
                         * Creates new FeatureFlags service using the specified rpc implementation.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {FeatureFlags} RPC service. Useful where requests and/or responses are streamed.
                         */
                        FeatureFlags.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#isEnabled}.
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @typedef IsEnabledCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.IsEnabledResp} [response] IsEnabledResp
                         */

                        /**
                         * Calls IsEnabled.
                         * @function isEnabled
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledReq} request IsEnabledReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.FeatureFlags.IsEnabledCallback} callback Node-style callback called with the error, if any, and IsEnabledResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(FeatureFlags.prototype.isEnabled = function isEnabled(request, callback) {
                            return this.rpcCall(isEnabled, $root.code.justin.tv.eventbus.controlplane.IsEnabledReq, $root.code.justin.tv.eventbus.controlplane.IsEnabledResp, request, callback);
                        }, "name", { value: "IsEnabled" });

                        /**
                         * Calls IsEnabled.
                         * @function isEnabled
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledReq} request IsEnabledReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.IsEnabledResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#enable}.
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @typedef EnableCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.EnableResp} [response] EnableResp
                         */

                        /**
                         * Calls Enable.
                         * @function enable
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IEnableReq} request EnableReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.FeatureFlags.EnableCallback} callback Node-style callback called with the error, if any, and EnableResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(FeatureFlags.prototype.enable = function enable(request, callback) {
                            return this.rpcCall(enable, $root.code.justin.tv.eventbus.controlplane.EnableReq, $root.code.justin.tv.eventbus.controlplane.EnableResp, request, callback);
                        }, "name", { value: "Enable" });

                        /**
                         * Calls Enable.
                         * @function enable
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IEnableReq} request EnableReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.EnableResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#disable}.
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @typedef DisableCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.DisableResp} [response] DisableResp
                         */

                        /**
                         * Calls Disable.
                         * @function disable
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDisableReq} request DisableReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.FeatureFlags.DisableCallback} callback Node-style callback called with the error, if any, and DisableResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(FeatureFlags.prototype.disable = function disable(request, callback) {
                            return this.rpcCall(disable, $root.code.justin.tv.eventbus.controlplane.DisableReq, $root.code.justin.tv.eventbus.controlplane.DisableResp, request, callback);
                        }, "name", { value: "Disable" });

                        /**
                         * Calls Disable.
                         * @function disable
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDisableReq} request DisableReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.DisableResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#list}.
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp} [response] ListFeatureFlagsResp
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq} request ListFeatureFlagsReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.FeatureFlags.ListCallback} callback Node-style callback called with the error, if any, and ListFeatureFlagsResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(FeatureFlags.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq, $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq} request ListFeatureFlagsReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#create}.
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @typedef CreateCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp} [response] CreateFeatureFlagsResp
                         */

                        /**
                         * Calls Create.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq} request CreateFeatureFlagsReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.FeatureFlags.CreateCallback} callback Node-style callback called with the error, if any, and CreateFeatureFlagsResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(FeatureFlags.prototype.create = function create(request, callback) {
                            return this.rpcCall(create, $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq, $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp, request, callback);
                        }, "name", { value: "Create" });

                        /**
                         * Calls Create.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq} request CreateFeatureFlagsReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.FeatureFlags#delete_}.
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @typedef DeleteCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp} [response] DeleteFeatureFlagsResp
                         */

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq} request DeleteFeatureFlagsReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.FeatureFlags.DeleteCallback} callback Node-style callback called with the error, if any, and DeleteFeatureFlagsResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(FeatureFlags.prototype["delete"] = function delete_(request, callback) {
                            return this.rpcCall(delete_, $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq, $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp, request, callback);
                        }, "name", { value: "Delete" });

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlags
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq} request DeleteFeatureFlagsReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp>} Promise
                         * @variation 2
                         */

                        return FeatureFlags;
                    })();

                    controlplane.IsEnabledReq = (function() {

                        /**
                         * Properties of an IsEnabledReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IIsEnabledReq
                         * @property {string|null} [name] IsEnabledReq name
                         */

                        /**
                         * Constructs a new IsEnabledReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an IsEnabledReq.
                         * @implements IIsEnabledReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledReq=} [properties] Properties to set
                         */
                        function IsEnabledReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * IsEnabledReq name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @instance
                         */
                        IsEnabledReq.prototype.name = "";

                        /**
                         * Creates a new IsEnabledReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledReq} IsEnabledReq instance
                         */
                        IsEnabledReq.create = function create(properties) {
                            return new IsEnabledReq(properties);
                        };

                        /**
                         * Encodes the specified IsEnabledReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledReq} message IsEnabledReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IsEnabledReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };

                        /**
                         * Encodes the specified IsEnabledReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledReq} message IsEnabledReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IsEnabledReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an IsEnabledReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledReq} IsEnabledReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IsEnabledReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.IsEnabledReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an IsEnabledReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledReq} IsEnabledReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IsEnabledReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an IsEnabledReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        IsEnabledReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };

                        /**
                         * Creates an IsEnabledReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledReq} IsEnabledReq
                         */
                        IsEnabledReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.IsEnabledReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.IsEnabledReq();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };

                        /**
                         * Creates a plain object from an IsEnabledReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IsEnabledReq} message IsEnabledReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        IsEnabledReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };

                        /**
                         * Converts this IsEnabledReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        IsEnabledReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return IsEnabledReq;
                    })();

                    controlplane.IsEnabledResp = (function() {

                        /**
                         * Properties of an IsEnabledResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IIsEnabledResp
                         * @property {boolean|null} [isEnabled] IsEnabledResp isEnabled
                         */

                        /**
                         * Constructs a new IsEnabledResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an IsEnabledResp.
                         * @implements IIsEnabledResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledResp=} [properties] Properties to set
                         */
                        function IsEnabledResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * IsEnabledResp isEnabled.
                         * @member {boolean} isEnabled
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @instance
                         */
                        IsEnabledResp.prototype.isEnabled = false;

                        /**
                         * Creates a new IsEnabledResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledResp} IsEnabledResp instance
                         */
                        IsEnabledResp.create = function create(properties) {
                            return new IsEnabledResp(properties);
                        };

                        /**
                         * Encodes the specified IsEnabledResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledResp} message IsEnabledResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IsEnabledResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.isEnabled != null && Object.hasOwnProperty.call(message, "isEnabled"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isEnabled);
                            return writer;
                        };

                        /**
                         * Encodes the specified IsEnabledResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IsEnabledResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIsEnabledResp} message IsEnabledResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IsEnabledResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an IsEnabledResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledResp} IsEnabledResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IsEnabledResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.IsEnabledResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 2:
                                    message.isEnabled = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an IsEnabledResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledResp} IsEnabledResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IsEnabledResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an IsEnabledResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        IsEnabledResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.isEnabled != null && message.hasOwnProperty("isEnabled"))
                                if (typeof message.isEnabled !== "boolean")
                                    return "isEnabled: boolean expected";
                            return null;
                        };

                        /**
                         * Creates an IsEnabledResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.IsEnabledResp} IsEnabledResp
                         */
                        IsEnabledResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.IsEnabledResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.IsEnabledResp();
                            if (object.isEnabled != null)
                                message.isEnabled = Boolean(object.isEnabled);
                            return message;
                        };

                        /**
                         * Creates a plain object from an IsEnabledResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IsEnabledResp} message IsEnabledResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        IsEnabledResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.isEnabled = false;
                            if (message.isEnabled != null && message.hasOwnProperty("isEnabled"))
                                object.isEnabled = message.isEnabled;
                            return object;
                        };

                        /**
                         * Converts this IsEnabledResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.IsEnabledResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        IsEnabledResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return IsEnabledResp;
                    })();

                    controlplane.EnableReq = (function() {

                        /**
                         * Properties of an EnableReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IEnableReq
                         * @property {string|null} [name] EnableReq name
                         */

                        /**
                         * Constructs a new EnableReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an EnableReq.
                         * @implements IEnableReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IEnableReq=} [properties] Properties to set
                         */
                        function EnableReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * EnableReq name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @instance
                         */
                        EnableReq.prototype.name = "";

                        /**
                         * Creates a new EnableReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEnableReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.EnableReq} EnableReq instance
                         */
                        EnableReq.create = function create(properties) {
                            return new EnableReq(properties);
                        };

                        /**
                         * Encodes the specified EnableReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEnableReq} message EnableReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EnableReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };

                        /**
                         * Encodes the specified EnableReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEnableReq} message EnableReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EnableReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an EnableReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.EnableReq} EnableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EnableReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.EnableReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an EnableReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.EnableReq} EnableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EnableReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an EnableReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EnableReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };

                        /**
                         * Creates an EnableReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.EnableReq} EnableReq
                         */
                        EnableReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.EnableReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.EnableReq();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };

                        /**
                         * Creates a plain object from an EnableReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.EnableReq} message EnableReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EnableReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };

                        /**
                         * Converts this EnableReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.EnableReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EnableReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return EnableReq;
                    })();

                    controlplane.EnableResp = (function() {

                        /**
                         * Properties of an EnableResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IEnableResp
                         */

                        /**
                         * Constructs a new EnableResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an EnableResp.
                         * @implements IEnableResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IEnableResp=} [properties] Properties to set
                         */
                        function EnableResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new EnableResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEnableResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.EnableResp} EnableResp instance
                         */
                        EnableResp.create = function create(properties) {
                            return new EnableResp(properties);
                        };

                        /**
                         * Encodes the specified EnableResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEnableResp} message EnableResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EnableResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified EnableResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.EnableResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IEnableResp} message EnableResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        EnableResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an EnableResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.EnableResp} EnableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EnableResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.EnableResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an EnableResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.EnableResp} EnableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        EnableResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an EnableResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        EnableResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates an EnableResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.EnableResp} EnableResp
                         */
                        EnableResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.EnableResp)
                                return object;
                            return new $root.code.justin.tv.eventbus.controlplane.EnableResp();
                        };

                        /**
                         * Creates a plain object from an EnableResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.EnableResp} message EnableResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        EnableResp.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this EnableResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.EnableResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        EnableResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return EnableResp;
                    })();

                    controlplane.DisableReq = (function() {

                        /**
                         * Properties of a DisableReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IDisableReq
                         * @property {string|null} [name] DisableReq name
                         */

                        /**
                         * Constructs a new DisableReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a DisableReq.
                         * @implements IDisableReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IDisableReq=} [properties] Properties to set
                         */
                        function DisableReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DisableReq name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @instance
                         */
                        DisableReq.prototype.name = "";

                        /**
                         * Creates a new DisableReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDisableReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.DisableReq} DisableReq instance
                         */
                        DisableReq.create = function create(properties) {
                            return new DisableReq(properties);
                        };

                        /**
                         * Encodes the specified DisableReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDisableReq} message DisableReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DisableReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };

                        /**
                         * Encodes the specified DisableReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDisableReq} message DisableReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DisableReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DisableReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.DisableReq} DisableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DisableReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.DisableReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DisableReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.DisableReq} DisableReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DisableReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DisableReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DisableReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };

                        /**
                         * Creates a DisableReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.DisableReq} DisableReq
                         */
                        DisableReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.DisableReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.DisableReq();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };

                        /**
                         * Creates a plain object from a DisableReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.DisableReq} message DisableReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DisableReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };

                        /**
                         * Converts this DisableReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.DisableReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DisableReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DisableReq;
                    })();

                    controlplane.DisableResp = (function() {

                        /**
                         * Properties of a DisableResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IDisableResp
                         */

                        /**
                         * Constructs a new DisableResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a DisableResp.
                         * @implements IDisableResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IDisableResp=} [properties] Properties to set
                         */
                        function DisableResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new DisableResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDisableResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.DisableResp} DisableResp instance
                         */
                        DisableResp.create = function create(properties) {
                            return new DisableResp(properties);
                        };

                        /**
                         * Encodes the specified DisableResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDisableResp} message DisableResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DisableResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified DisableResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DisableResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDisableResp} message DisableResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DisableResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DisableResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.DisableResp} DisableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DisableResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.DisableResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DisableResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.DisableResp} DisableResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DisableResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DisableResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DisableResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a DisableResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.DisableResp} DisableResp
                         */
                        DisableResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.DisableResp)
                                return object;
                            return new $root.code.justin.tv.eventbus.controlplane.DisableResp();
                        };

                        /**
                         * Creates a plain object from a DisableResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.DisableResp} message DisableResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DisableResp.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this DisableResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.DisableResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DisableResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DisableResp;
                    })();

                    controlplane.FeatureFlag = (function() {

                        /**
                         * Properties of a FeatureFlag.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IFeatureFlag
                         * @property {string|null} [name] FeatureFlag name
                         * @property {boolean|null} [isEnabled] FeatureFlag isEnabled
                         */

                        /**
                         * Constructs a new FeatureFlag.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a FeatureFlag.
                         * @implements IFeatureFlag
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IFeatureFlag=} [properties] Properties to set
                         */
                        function FeatureFlag(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * FeatureFlag name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @instance
                         */
                        FeatureFlag.prototype.name = "";

                        /**
                         * FeatureFlag isEnabled.
                         * @member {boolean} isEnabled
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @instance
                         */
                        FeatureFlag.prototype.isEnabled = false;

                        /**
                         * Creates a new FeatureFlag instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IFeatureFlag=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.FeatureFlag} FeatureFlag instance
                         */
                        FeatureFlag.create = function create(properties) {
                            return new FeatureFlag(properties);
                        };

                        /**
                         * Encodes the specified FeatureFlag message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.FeatureFlag.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IFeatureFlag} message FeatureFlag message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FeatureFlag.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            if (message.isEnabled != null && Object.hasOwnProperty.call(message, "isEnabled"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.isEnabled);
                            return writer;
                        };

                        /**
                         * Encodes the specified FeatureFlag message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.FeatureFlag.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IFeatureFlag} message FeatureFlag message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        FeatureFlag.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a FeatureFlag message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.FeatureFlag} FeatureFlag
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FeatureFlag.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.FeatureFlag();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                case 2:
                                    message.isEnabled = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a FeatureFlag message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.FeatureFlag} FeatureFlag
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        FeatureFlag.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a FeatureFlag message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        FeatureFlag.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.isEnabled != null && message.hasOwnProperty("isEnabled"))
                                if (typeof message.isEnabled !== "boolean")
                                    return "isEnabled: boolean expected";
                            return null;
                        };

                        /**
                         * Creates a FeatureFlag message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.FeatureFlag} FeatureFlag
                         */
                        FeatureFlag.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.FeatureFlag)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.FeatureFlag();
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.isEnabled != null)
                                message.isEnabled = Boolean(object.isEnabled);
                            return message;
                        };

                        /**
                         * Creates a plain object from a FeatureFlag message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.FeatureFlag} message FeatureFlag
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        FeatureFlag.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.name = "";
                                object.isEnabled = false;
                            }
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.isEnabled != null && message.hasOwnProperty("isEnabled"))
                                object.isEnabled = message.isEnabled;
                            return object;
                        };

                        /**
                         * Converts this FeatureFlag to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.FeatureFlag
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        FeatureFlag.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return FeatureFlag;
                    })();

                    controlplane.ListFeatureFlagsReq = (function() {

                        /**
                         * Properties of a ListFeatureFlagsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListFeatureFlagsReq
                         */

                        /**
                         * Constructs a new ListFeatureFlagsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListFeatureFlagsReq.
                         * @implements IListFeatureFlagsReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq=} [properties] Properties to set
                         */
                        function ListFeatureFlagsReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new ListFeatureFlagsReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq} ListFeatureFlagsReq instance
                         */
                        ListFeatureFlagsReq.create = function create(properties) {
                            return new ListFeatureFlagsReq(properties);
                        };

                        /**
                         * Encodes the specified ListFeatureFlagsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq} message ListFeatureFlagsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFeatureFlagsReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified ListFeatureFlagsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsReq} message ListFeatureFlagsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFeatureFlagsReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListFeatureFlagsReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq} ListFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFeatureFlagsReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListFeatureFlagsReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq} ListFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFeatureFlagsReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListFeatureFlagsReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListFeatureFlagsReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a ListFeatureFlagsReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq} ListFeatureFlagsReq
                         */
                        ListFeatureFlagsReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq)
                                return object;
                            return new $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq();
                        };

                        /**
                         * Creates a plain object from a ListFeatureFlagsReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq} message ListFeatureFlagsReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListFeatureFlagsReq.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this ListFeatureFlagsReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListFeatureFlagsReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListFeatureFlagsReq;
                    })();

                    controlplane.ListFeatureFlagsResp = (function() {

                        /**
                         * Properties of a ListFeatureFlagsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListFeatureFlagsResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IFeatureFlag>|null} [featureFlags] ListFeatureFlagsResp featureFlags
                         */

                        /**
                         * Constructs a new ListFeatureFlagsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListFeatureFlagsResp.
                         * @implements IListFeatureFlagsResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp=} [properties] Properties to set
                         */
                        function ListFeatureFlagsResp(properties) {
                            this.featureFlags = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListFeatureFlagsResp featureFlags.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IFeatureFlag>} featureFlags
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @instance
                         */
                        ListFeatureFlagsResp.prototype.featureFlags = $util.emptyArray;

                        /**
                         * Creates a new ListFeatureFlagsResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp} ListFeatureFlagsResp instance
                         */
                        ListFeatureFlagsResp.create = function create(properties) {
                            return new ListFeatureFlagsResp(properties);
                        };

                        /**
                         * Encodes the specified ListFeatureFlagsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp} message ListFeatureFlagsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFeatureFlagsResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.featureFlags != null && message.featureFlags.length)
                                for (var i = 0; i < message.featureFlags.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.FeatureFlag.encode(message.featureFlags[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified ListFeatureFlagsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListFeatureFlagsResp} message ListFeatureFlagsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListFeatureFlagsResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListFeatureFlagsResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp} ListFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFeatureFlagsResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.featureFlags && message.featureFlags.length))
                                        message.featureFlags = [];
                                    message.featureFlags.push($root.code.justin.tv.eventbus.controlplane.FeatureFlag.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListFeatureFlagsResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp} ListFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListFeatureFlagsResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListFeatureFlagsResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListFeatureFlagsResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.featureFlags != null && message.hasOwnProperty("featureFlags")) {
                                if (!Array.isArray(message.featureFlags))
                                    return "featureFlags: array expected";
                                for (var i = 0; i < message.featureFlags.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.FeatureFlag.verify(message.featureFlags[i]);
                                    if (error)
                                        return "featureFlags." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a ListFeatureFlagsResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp} ListFeatureFlagsResp
                         */
                        ListFeatureFlagsResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp();
                            if (object.featureFlags) {
                                if (!Array.isArray(object.featureFlags))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp.featureFlags: array expected");
                                message.featureFlags = [];
                                for (var i = 0; i < object.featureFlags.length; ++i) {
                                    if (typeof object.featureFlags[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp.featureFlags: object expected");
                                    message.featureFlags[i] = $root.code.justin.tv.eventbus.controlplane.FeatureFlag.fromObject(object.featureFlags[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListFeatureFlagsResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp} message ListFeatureFlagsResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListFeatureFlagsResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.featureFlags = [];
                            if (message.featureFlags && message.featureFlags.length) {
                                object.featureFlags = [];
                                for (var j = 0; j < message.featureFlags.length; ++j)
                                    object.featureFlags[j] = $root.code.justin.tv.eventbus.controlplane.FeatureFlag.toObject(message.featureFlags[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this ListFeatureFlagsResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListFeatureFlagsResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListFeatureFlagsResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListFeatureFlagsResp;
                    })();

                    controlplane.CreateFeatureFlagsReq = (function() {

                        /**
                         * Properties of a CreateFeatureFlagsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateFeatureFlagsReq
                         * @property {code.justin.tv.eventbus.controlplane.IFeatureFlag|null} [featureFlag] CreateFeatureFlagsReq featureFlag
                         */

                        /**
                         * Constructs a new CreateFeatureFlagsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateFeatureFlagsReq.
                         * @implements ICreateFeatureFlagsReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq=} [properties] Properties to set
                         */
                        function CreateFeatureFlagsReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateFeatureFlagsReq featureFlag.
                         * @member {code.justin.tv.eventbus.controlplane.IFeatureFlag|null|undefined} featureFlag
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @instance
                         */
                        CreateFeatureFlagsReq.prototype.featureFlag = null;

                        /**
                         * Creates a new CreateFeatureFlagsReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq} CreateFeatureFlagsReq instance
                         */
                        CreateFeatureFlagsReq.create = function create(properties) {
                            return new CreateFeatureFlagsReq(properties);
                        };

                        /**
                         * Encodes the specified CreateFeatureFlagsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq} message CreateFeatureFlagsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFeatureFlagsReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.featureFlag != null && Object.hasOwnProperty.call(message, "featureFlag"))
                                $root.code.justin.tv.eventbus.controlplane.FeatureFlag.encode(message.featureFlag, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateFeatureFlagsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsReq} message CreateFeatureFlagsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFeatureFlagsReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateFeatureFlagsReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq} CreateFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFeatureFlagsReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.featureFlag = $root.code.justin.tv.eventbus.controlplane.FeatureFlag.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateFeatureFlagsReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq} CreateFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFeatureFlagsReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateFeatureFlagsReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateFeatureFlagsReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.featureFlag != null && message.hasOwnProperty("featureFlag")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.FeatureFlag.verify(message.featureFlag);
                                if (error)
                                    return "featureFlag." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a CreateFeatureFlagsReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq} CreateFeatureFlagsReq
                         */
                        CreateFeatureFlagsReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq();
                            if (object.featureFlag != null) {
                                if (typeof object.featureFlag !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq.featureFlag: object expected");
                                message.featureFlag = $root.code.justin.tv.eventbus.controlplane.FeatureFlag.fromObject(object.featureFlag);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateFeatureFlagsReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq} message CreateFeatureFlagsReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateFeatureFlagsReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.featureFlag = null;
                            if (message.featureFlag != null && message.hasOwnProperty("featureFlag"))
                                object.featureFlag = $root.code.justin.tv.eventbus.controlplane.FeatureFlag.toObject(message.featureFlag, options);
                            return object;
                        };

                        /**
                         * Converts this CreateFeatureFlagsReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateFeatureFlagsReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateFeatureFlagsReq;
                    })();

                    controlplane.CreateFeatureFlagsResp = (function() {

                        /**
                         * Properties of a CreateFeatureFlagsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateFeatureFlagsResp
                         * @property {string|null} [id] CreateFeatureFlagsResp id
                         */

                        /**
                         * Constructs a new CreateFeatureFlagsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateFeatureFlagsResp.
                         * @implements ICreateFeatureFlagsResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp=} [properties] Properties to set
                         */
                        function CreateFeatureFlagsResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateFeatureFlagsResp id.
                         * @member {string} id
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @instance
                         */
                        CreateFeatureFlagsResp.prototype.id = "";

                        /**
                         * Creates a new CreateFeatureFlagsResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp} CreateFeatureFlagsResp instance
                         */
                        CreateFeatureFlagsResp.create = function create(properties) {
                            return new CreateFeatureFlagsResp(properties);
                        };

                        /**
                         * Encodes the specified CreateFeatureFlagsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp} message CreateFeatureFlagsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFeatureFlagsResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateFeatureFlagsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateFeatureFlagsResp} message CreateFeatureFlagsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateFeatureFlagsResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateFeatureFlagsResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp} CreateFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFeatureFlagsResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.id = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateFeatureFlagsResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp} CreateFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateFeatureFlagsResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateFeatureFlagsResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateFeatureFlagsResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            return null;
                        };

                        /**
                         * Creates a CreateFeatureFlagsResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp} CreateFeatureFlagsResp
                         */
                        CreateFeatureFlagsResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp();
                            if (object.id != null)
                                message.id = String(object.id);
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateFeatureFlagsResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp} message CreateFeatureFlagsResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateFeatureFlagsResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.id = "";
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            return object;
                        };

                        /**
                         * Converts this CreateFeatureFlagsResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateFeatureFlagsResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateFeatureFlagsResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateFeatureFlagsResp;
                    })();

                    controlplane.DeleteFeatureFlagsReq = (function() {

                        /**
                         * Properties of a DeleteFeatureFlagsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IDeleteFeatureFlagsReq
                         * @property {string|null} [name] DeleteFeatureFlagsReq name
                         */

                        /**
                         * Constructs a new DeleteFeatureFlagsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a DeleteFeatureFlagsReq.
                         * @implements IDeleteFeatureFlagsReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq=} [properties] Properties to set
                         */
                        function DeleteFeatureFlagsReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DeleteFeatureFlagsReq name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @instance
                         */
                        DeleteFeatureFlagsReq.prototype.name = "";

                        /**
                         * Creates a new DeleteFeatureFlagsReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq} DeleteFeatureFlagsReq instance
                         */
                        DeleteFeatureFlagsReq.create = function create(properties) {
                            return new DeleteFeatureFlagsReq(properties);
                        };

                        /**
                         * Encodes the specified DeleteFeatureFlagsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq} message DeleteFeatureFlagsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFeatureFlagsReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteFeatureFlagsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsReq} message DeleteFeatureFlagsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFeatureFlagsReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteFeatureFlagsReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq} DeleteFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFeatureFlagsReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.name = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteFeatureFlagsReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq} DeleteFeatureFlagsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFeatureFlagsReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteFeatureFlagsReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteFeatureFlagsReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteFeatureFlagsReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq} DeleteFeatureFlagsReq
                         */
                        DeleteFeatureFlagsReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq();
                            if (object.name != null)
                                message.name = String(object.name);
                            return message;
                        };

                        /**
                         * Creates a plain object from a DeleteFeatureFlagsReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq} message DeleteFeatureFlagsReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteFeatureFlagsReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.name = "";
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            return object;
                        };

                        /**
                         * Converts this DeleteFeatureFlagsReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteFeatureFlagsReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteFeatureFlagsReq;
                    })();

                    controlplane.DeleteFeatureFlagsResp = (function() {

                        /**
                         * Properties of a DeleteFeatureFlagsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IDeleteFeatureFlagsResp
                         */

                        /**
                         * Constructs a new DeleteFeatureFlagsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a DeleteFeatureFlagsResp.
                         * @implements IDeleteFeatureFlagsResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp=} [properties] Properties to set
                         */
                        function DeleteFeatureFlagsResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new DeleteFeatureFlagsResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp} DeleteFeatureFlagsResp instance
                         */
                        DeleteFeatureFlagsResp.create = function create(properties) {
                            return new DeleteFeatureFlagsResp(properties);
                        };

                        /**
                         * Encodes the specified DeleteFeatureFlagsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp} message DeleteFeatureFlagsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFeatureFlagsResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteFeatureFlagsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteFeatureFlagsResp} message DeleteFeatureFlagsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteFeatureFlagsResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteFeatureFlagsResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp} DeleteFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFeatureFlagsResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteFeatureFlagsResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp} DeleteFeatureFlagsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteFeatureFlagsResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteFeatureFlagsResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteFeatureFlagsResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteFeatureFlagsResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp} DeleteFeatureFlagsResp
                         */
                        DeleteFeatureFlagsResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp)
                                return object;
                            return new $root.code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp();
                        };

                        /**
                         * Creates a plain object from a DeleteFeatureFlagsResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp} message DeleteFeatureFlagsResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteFeatureFlagsResp.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this DeleteFeatureFlagsResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteFeatureFlagsResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteFeatureFlagsResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteFeatureFlagsResp;
                    })();

                    controlplane.Services = (function() {

                        /**
                         * Constructs a new Services service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a Services
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Services(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (Services.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Services;

                        /**
                         * Creates new Services service using the specified rpc implementation.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Services} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Services.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#list}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ListServicesResp} [response] ListServicesResp
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesReq} request ListServicesReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.ListCallback} callback Node-style callback called with the error, if any, and ListServicesResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.code.justin.tv.eventbus.controlplane.ListServicesReq, $root.code.justin.tv.eventbus.controlplane.ListServicesResp, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesReq} request ListServicesReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ListServicesResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#get}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef GetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.Service} [response] Service
                         */

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetServiceReq} request GetServiceReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.GetCallback} callback Node-style callback called with the error, if any, and Service
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.get = function get(request, callback) {
                            return this.rpcCall(get, $root.code.justin.tv.eventbus.controlplane.GetServiceReq, $root.code.justin.tv.eventbus.controlplane.Service, request, callback);
                        }, "name", { value: "Get" });

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetServiceReq} request GetServiceReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.Service>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#create}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef CreateCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.CreateServiceResp} [response] CreateServiceResp
                         */

                        /**
                         * Calls Create.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceReq} request CreateServiceReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.CreateCallback} callback Node-style callback called with the error, if any, and CreateServiceResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.create = function create(request, callback) {
                            return this.rpcCall(create, $root.code.justin.tv.eventbus.controlplane.CreateServiceReq, $root.code.justin.tv.eventbus.controlplane.CreateServiceResp, request, callback);
                        }, "name", { value: "Create" });

                        /**
                         * Calls Create.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceReq} request CreateServiceReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.CreateServiceResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#update}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef UpdateCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.UpdateServiceResp} [response] UpdateServiceResp
                         */

                        /**
                         * Calls Update.
                         * @function update
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceReq} request UpdateServiceReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.UpdateCallback} callback Node-style callback called with the error, if any, and UpdateServiceResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.update = function update(request, callback) {
                            return this.rpcCall(update, $root.code.justin.tv.eventbus.controlplane.UpdateServiceReq, $root.code.justin.tv.eventbus.controlplane.UpdateServiceResp, request, callback);
                        }, "name", { value: "Update" });

                        /**
                         * Calls Update.
                         * @function update
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceReq} request UpdateServiceReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.UpdateServiceResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#getAuthorizedFieldGrants}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef GetAuthorizedFieldGrantsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp} [response] GetAuthorizedFieldGrantsResp
                         */

                        /**
                         * Calls GetAuthorizedFieldGrants.
                         * @function getAuthorizedFieldGrants
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq} request GetAuthorizedFieldGrantsReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.GetAuthorizedFieldGrantsCallback} callback Node-style callback called with the error, if any, and GetAuthorizedFieldGrantsResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.getAuthorizedFieldGrants = function getAuthorizedFieldGrants(request, callback) {
                            return this.rpcCall(getAuthorizedFieldGrants, $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq, $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp, request, callback);
                        }, "name", { value: "GetAuthorizedFieldGrants" });

                        /**
                         * Calls GetAuthorizedFieldGrants.
                         * @function getAuthorizedFieldGrants
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq} request GetAuthorizedFieldGrantsReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#requestorLDAPGroups}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef RequestorLDAPGroupsCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp} [response] RequestorLDAPGroupsResp
                         */

                        /**
                         * Calls RequestorLDAPGroups.
                         * @function requestorLDAPGroups
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq} request RequestorLDAPGroupsReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.RequestorLDAPGroupsCallback} callback Node-style callback called with the error, if any, and RequestorLDAPGroupsResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.requestorLDAPGroups = function requestorLDAPGroups(request, callback) {
                            return this.rpcCall(requestorLDAPGroups, $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq, $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp, request, callback);
                        }, "name", { value: "RequestorLDAPGroups" });

                        /**
                         * Calls RequestorLDAPGroups.
                         * @function requestorLDAPGroups
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq} request RequestorLDAPGroupsReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#resolveLDAPGroupUsers}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef ResolveLDAPGroupUsersCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp} [response] ResolveLDAPGroupUsersResp
                         */

                        /**
                         * Calls ResolveLDAPGroupUsers.
                         * @function resolveLDAPGroupUsers
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq} request ResolveLDAPGroupUsersReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.ResolveLDAPGroupUsersCallback} callback Node-style callback called with the error, if any, and ResolveLDAPGroupUsersResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.resolveLDAPGroupUsers = function resolveLDAPGroupUsers(request, callback) {
                            return this.rpcCall(resolveLDAPGroupUsers, $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq, $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp, request, callback);
                        }, "name", { value: "ResolveLDAPGroupUsers" });

                        /**
                         * Calls ResolveLDAPGroupUsers.
                         * @function resolveLDAPGroupUsers
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq} request ResolveLDAPGroupUsersReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#deleteIAMRole}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef DeleteIAMRoleCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp} [response] DeleteIAMRoleResp
                         */

                        /**
                         * Calls DeleteIAMRole.
                         * @function deleteIAMRole
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq} request DeleteIAMRoleReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.DeleteIAMRoleCallback} callback Node-style callback called with the error, if any, and DeleteIAMRoleResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.deleteIAMRole = function deleteIAMRole(request, callback) {
                            return this.rpcCall(deleteIAMRole, $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq, $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp, request, callback);
                        }, "name", { value: "DeleteIAMRole" });

                        /**
                         * Calls DeleteIAMRole.
                         * @function deleteIAMRole
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq} request DeleteIAMRoleReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#getServicesForEventStream}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef GetServicesForEventStreamCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp} [response] GetServicesForEventStreamResp
                         */

                        /**
                         * Calls GetServicesForEventStream.
                         * @function getServicesForEventStream
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq} request GetServicesForEventStreamReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.GetServicesForEventStreamCallback} callback Node-style callback called with the error, if any, and GetServicesForEventStreamResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.getServicesForEventStream = function getServicesForEventStream(request, callback) {
                            return this.rpcCall(getServicesForEventStream, $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq, $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp, request, callback);
                        }, "name", { value: "GetServicesForEventStream" });

                        /**
                         * Calls GetServicesForEventStream.
                         * @function getServicesForEventStream
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq} request GetServicesForEventStreamReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#getCloudFormationVersion}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef GetCloudFormationVersionCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp} [response] GetCloudFormationVersionResp
                         */

                        /**
                         * Calls GetCloudFormationVersion.
                         * @function getCloudFormationVersion
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq} request GetCloudFormationVersionReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.GetCloudFormationVersionCallback} callback Node-style callback called with the error, if any, and GetCloudFormationVersionResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.getCloudFormationVersion = function getCloudFormationVersion(request, callback) {
                            return this.rpcCall(getCloudFormationVersion, $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq, $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp, request, callback);
                        }, "name", { value: "GetCloudFormationVersion" });

                        /**
                         * Calls GetCloudFormationVersion.
                         * @function getCloudFormationVersion
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq} request GetCloudFormationVersionReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#createIAMRole}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef CreateIAMRoleCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.CreateIAMRoleResp} [response] CreateIAMRoleResp
                         */

                        /**
                         * Calls CreateIAMRole.
                         * @function createIAMRole
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq} request CreateIAMRoleReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.CreateIAMRoleCallback} callback Node-style callback called with the error, if any, and CreateIAMRoleResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.createIAMRole = function createIAMRole(request, callback) {
                            return this.rpcCall(createIAMRole, $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleReq, $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleResp, request, callback);
                        }, "name", { value: "CreateIAMRole" });

                        /**
                         * Calls CreateIAMRole.
                         * @function createIAMRole
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq} request CreateIAMRoleReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.CreateIAMRoleResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#updateIAMRoleLabel}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef UpdateIAMRoleLabelCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp} [response] UpdateIAMRoleLabelResp
                         */

                        /**
                         * Calls UpdateIAMRoleLabel.
                         * @function updateIAMRoleLabel
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq} request UpdateIAMRoleLabelReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.UpdateIAMRoleLabelCallback} callback Node-style callback called with the error, if any, and UpdateIAMRoleLabelResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.updateIAMRoleLabel = function updateIAMRoleLabel(request, callback) {
                            return this.rpcCall(updateIAMRoleLabel, $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq, $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp, request, callback);
                        }, "name", { value: "UpdateIAMRoleLabel" });

                        /**
                         * Calls UpdateIAMRoleLabel.
                         * @function updateIAMRoleLabel
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq} request UpdateIAMRoleLabelReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Services#validateIAMRole}.
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @typedef ValidateIAMRoleCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp} [response] ValidateIAMRoleResp
                         */

                        /**
                         * Calls ValidateIAMRole.
                         * @function validateIAMRole
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq} request ValidateIAMRoleReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Services.ValidateIAMRoleCallback} callback Node-style callback called with the error, if any, and ValidateIAMRoleResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Services.prototype.validateIAMRole = function validateIAMRole(request, callback) {
                            return this.rpcCall(validateIAMRole, $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq, $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp, request, callback);
                        }, "name", { value: "ValidateIAMRole" });

                        /**
                         * Calls ValidateIAMRole.
                         * @function validateIAMRole
                         * @memberof code.justin.tv.eventbus.controlplane.Services
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq} request ValidateIAMRoleReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp>} Promise
                         * @variation 2
                         */

                        return Services;
                    })();

                    controlplane.ListServicesReq = (function() {

                        /**
                         * Properties of a ListServicesReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListServicesReq
                         */

                        /**
                         * Constructs a new ListServicesReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListServicesReq.
                         * @implements IListServicesReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesReq=} [properties] Properties to set
                         */
                        function ListServicesReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new ListServicesReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesReq} ListServicesReq instance
                         */
                        ListServicesReq.create = function create(properties) {
                            return new ListServicesReq(properties);
                        };

                        /**
                         * Encodes the specified ListServicesReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesReq} message ListServicesReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicesReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified ListServicesReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesReq} message ListServicesReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicesReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListServicesReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesReq} ListServicesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicesReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListServicesReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListServicesReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesReq} ListServicesReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicesReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListServicesReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListServicesReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a ListServicesReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesReq} ListServicesReq
                         */
                        ListServicesReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListServicesReq)
                                return object;
                            return new $root.code.justin.tv.eventbus.controlplane.ListServicesReq();
                        };

                        /**
                         * Creates a plain object from a ListServicesReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListServicesReq} message ListServicesReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListServicesReq.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this ListServicesReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListServicesReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListServicesReq;
                    })();

                    controlplane.ListServicesResp = (function() {

                        /**
                         * Properties of a ListServicesResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IListServicesResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IService>|null} [services] ListServicesResp services
                         */

                        /**
                         * Constructs a new ListServicesResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ListServicesResp.
                         * @implements IListServicesResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesResp=} [properties] Properties to set
                         */
                        function ListServicesResp(properties) {
                            this.services = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListServicesResp services.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IService>} services
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @instance
                         */
                        ListServicesResp.prototype.services = $util.emptyArray;

                        /**
                         * Creates a new ListServicesResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesResp} ListServicesResp instance
                         */
                        ListServicesResp.create = function create(properties) {
                            return new ListServicesResp(properties);
                        };

                        /**
                         * Encodes the specified ListServicesResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesResp} message ListServicesResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicesResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.services != null && message.services.length)
                                for (var i = 0; i < message.services.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.Service.encode(message.services[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified ListServicesResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ListServicesResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IListServicesResp} message ListServicesResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListServicesResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListServicesResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesResp} ListServicesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicesResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ListServicesResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.services && message.services.length))
                                        message.services = [];
                                    message.services.push($root.code.justin.tv.eventbus.controlplane.Service.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListServicesResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesResp} ListServicesResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListServicesResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListServicesResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListServicesResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.services != null && message.hasOwnProperty("services")) {
                                if (!Array.isArray(message.services))
                                    return "services: array expected";
                                for (var i = 0; i < message.services.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.Service.verify(message.services[i]);
                                    if (error)
                                        return "services." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a ListServicesResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ListServicesResp} ListServicesResp
                         */
                        ListServicesResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ListServicesResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ListServicesResp();
                            if (object.services) {
                                if (!Array.isArray(object.services))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.ListServicesResp.services: array expected");
                                message.services = [];
                                for (var i = 0; i < object.services.length; ++i) {
                                    if (typeof object.services[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.ListServicesResp.services: object expected");
                                    message.services[i] = $root.code.justin.tv.eventbus.controlplane.Service.fromObject(object.services[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListServicesResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ListServicesResp} message ListServicesResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListServicesResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.services = [];
                            if (message.services && message.services.length) {
                                object.services = [];
                                for (var j = 0; j < message.services.length; ++j)
                                    object.services[j] = $root.code.justin.tv.eventbus.controlplane.Service.toObject(message.services[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this ListServicesResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ListServicesResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListServicesResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListServicesResp;
                    })();

                    controlplane.GetServiceReq = (function() {

                        /**
                         * Properties of a GetServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetServiceReq
                         * @property {string|null} [id] GetServiceReq id
                         */

                        /**
                         * Constructs a new GetServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetServiceReq.
                         * @implements IGetServiceReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetServiceReq=} [properties] Properties to set
                         */
                        function GetServiceReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetServiceReq id.
                         * @member {string} id
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @instance
                         */
                        GetServiceReq.prototype.id = "";

                        /**
                         * Creates a new GetServiceReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServiceReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetServiceReq} GetServiceReq instance
                         */
                        GetServiceReq.create = function create(properties) {
                            return new GetServiceReq(properties);
                        };

                        /**
                         * Encodes the specified GetServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServiceReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServiceReq} message GetServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServiceReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServiceReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServiceReq} message GetServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServiceReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetServiceReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetServiceReq} GetServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServiceReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetServiceReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.id = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetServiceReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetServiceReq} GetServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServiceReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetServiceReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetServiceReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetServiceReq} GetServiceReq
                         */
                        GetServiceReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetServiceReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetServiceReq();
                            if (object.id != null)
                                message.id = String(object.id);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetServiceReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetServiceReq} message GetServiceReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetServiceReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.id = "";
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            return object;
                        };

                        /**
                         * Converts this GetServiceReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetServiceReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetServiceReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetServiceReq;
                    })();

                    controlplane.CreateServiceReq = (function() {

                        /**
                         * Properties of a CreateServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateServiceReq
                         * @property {code.justin.tv.eventbus.controlplane.IService|null} [service] CreateServiceReq service
                         */

                        /**
                         * Constructs a new CreateServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateServiceReq.
                         * @implements ICreateServiceReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceReq=} [properties] Properties to set
                         */
                        function CreateServiceReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateServiceReq service.
                         * @member {code.justin.tv.eventbus.controlplane.IService|null|undefined} service
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @instance
                         */
                        CreateServiceReq.prototype.service = null;

                        /**
                         * Creates a new CreateServiceReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceReq} CreateServiceReq instance
                         */
                        CreateServiceReq.create = function create(properties) {
                            return new CreateServiceReq(properties);
                        };

                        /**
                         * Encodes the specified CreateServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceReq} message CreateServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateServiceReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.service != null && Object.hasOwnProperty.call(message, "service"))
                                $root.code.justin.tv.eventbus.controlplane.Service.encode(message.service, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceReq} message CreateServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateServiceReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateServiceReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceReq} CreateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateServiceReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateServiceReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.service = $root.code.justin.tv.eventbus.controlplane.Service.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateServiceReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceReq} CreateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateServiceReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateServiceReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateServiceReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.service != null && message.hasOwnProperty("service")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.Service.verify(message.service);
                                if (error)
                                    return "service." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a CreateServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceReq} CreateServiceReq
                         */
                        CreateServiceReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateServiceReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateServiceReq();
                            if (object.service != null) {
                                if (typeof object.service !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.CreateServiceReq.service: object expected");
                                message.service = $root.code.justin.tv.eventbus.controlplane.Service.fromObject(object.service);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateServiceReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateServiceReq} message CreateServiceReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateServiceReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.service = null;
                            if (message.service != null && message.hasOwnProperty("service"))
                                object.service = $root.code.justin.tv.eventbus.controlplane.Service.toObject(message.service, options);
                            return object;
                        };

                        /**
                         * Converts this CreateServiceReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateServiceReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateServiceReq;
                    })();

                    controlplane.CreateServiceResp = (function() {

                        /**
                         * Properties of a CreateServiceResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateServiceResp
                         * @property {code.justin.tv.eventbus.controlplane.IService|null} [service] CreateServiceResp service
                         */

                        /**
                         * Constructs a new CreateServiceResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateServiceResp.
                         * @implements ICreateServiceResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceResp=} [properties] Properties to set
                         */
                        function CreateServiceResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateServiceResp service.
                         * @member {code.justin.tv.eventbus.controlplane.IService|null|undefined} service
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @instance
                         */
                        CreateServiceResp.prototype.service = null;

                        /**
                         * Creates a new CreateServiceResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceResp} CreateServiceResp instance
                         */
                        CreateServiceResp.create = function create(properties) {
                            return new CreateServiceResp(properties);
                        };

                        /**
                         * Encodes the specified CreateServiceResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceResp} message CreateServiceResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateServiceResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.service != null && Object.hasOwnProperty.call(message, "service"))
                                $root.code.justin.tv.eventbus.controlplane.Service.encode(message.service, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateServiceResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateServiceResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateServiceResp} message CreateServiceResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateServiceResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateServiceResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceResp} CreateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateServiceResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateServiceResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.service = $root.code.justin.tv.eventbus.controlplane.Service.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateServiceResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceResp} CreateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateServiceResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateServiceResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateServiceResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.service != null && message.hasOwnProperty("service")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.Service.verify(message.service);
                                if (error)
                                    return "service." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a CreateServiceResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateServiceResp} CreateServiceResp
                         */
                        CreateServiceResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateServiceResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateServiceResp();
                            if (object.service != null) {
                                if (typeof object.service !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.CreateServiceResp.service: object expected");
                                message.service = $root.code.justin.tv.eventbus.controlplane.Service.fromObject(object.service);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateServiceResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateServiceResp} message CreateServiceResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateServiceResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.service = null;
                            if (message.service != null && message.hasOwnProperty("service"))
                                object.service = $root.code.justin.tv.eventbus.controlplane.Service.toObject(message.service, options);
                            return object;
                        };

                        /**
                         * Converts this CreateServiceResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateServiceResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateServiceResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateServiceResp;
                    })();

                    controlplane.UpdateServiceReq = (function() {

                        /**
                         * Properties of an UpdateServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IUpdateServiceReq
                         * @property {code.justin.tv.eventbus.controlplane.IService|null} [service] UpdateServiceReq service
                         */

                        /**
                         * Constructs a new UpdateServiceReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an UpdateServiceReq.
                         * @implements IUpdateServiceReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceReq=} [properties] Properties to set
                         */
                        function UpdateServiceReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * UpdateServiceReq service.
                         * @member {code.justin.tv.eventbus.controlplane.IService|null|undefined} service
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @instance
                         */
                        UpdateServiceReq.prototype.service = null;

                        /**
                         * Creates a new UpdateServiceReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceReq} UpdateServiceReq instance
                         */
                        UpdateServiceReq.create = function create(properties) {
                            return new UpdateServiceReq(properties);
                        };

                        /**
                         * Encodes the specified UpdateServiceReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceReq} message UpdateServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateServiceReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.service != null && Object.hasOwnProperty.call(message, "service"))
                                $root.code.justin.tv.eventbus.controlplane.Service.encode(message.service, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified UpdateServiceReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceReq} message UpdateServiceReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateServiceReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an UpdateServiceReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceReq} UpdateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateServiceReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.UpdateServiceReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.service = $root.code.justin.tv.eventbus.controlplane.Service.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an UpdateServiceReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceReq} UpdateServiceReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateServiceReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an UpdateServiceReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateServiceReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.service != null && message.hasOwnProperty("service")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.Service.verify(message.service);
                                if (error)
                                    return "service." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates an UpdateServiceReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceReq} UpdateServiceReq
                         */
                        UpdateServiceReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.UpdateServiceReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.UpdateServiceReq();
                            if (object.service != null) {
                                if (typeof object.service !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.UpdateServiceReq.service: object expected");
                                message.service = $root.code.justin.tv.eventbus.controlplane.Service.fromObject(object.service);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an UpdateServiceReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.UpdateServiceReq} message UpdateServiceReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateServiceReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.service = null;
                            if (message.service != null && message.hasOwnProperty("service"))
                                object.service = $root.code.justin.tv.eventbus.controlplane.Service.toObject(message.service, options);
                            return object;
                        };

                        /**
                         * Converts this UpdateServiceReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateServiceReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return UpdateServiceReq;
                    })();

                    controlplane.UpdateServiceResp = (function() {

                        /**
                         * Properties of an UpdateServiceResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IUpdateServiceResp
                         * @property {code.justin.tv.eventbus.controlplane.IService|null} [service] UpdateServiceResp service
                         */

                        /**
                         * Constructs a new UpdateServiceResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an UpdateServiceResp.
                         * @implements IUpdateServiceResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceResp=} [properties] Properties to set
                         */
                        function UpdateServiceResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * UpdateServiceResp service.
                         * @member {code.justin.tv.eventbus.controlplane.IService|null|undefined} service
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @instance
                         */
                        UpdateServiceResp.prototype.service = null;

                        /**
                         * Creates a new UpdateServiceResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceResp} UpdateServiceResp instance
                         */
                        UpdateServiceResp.create = function create(properties) {
                            return new UpdateServiceResp(properties);
                        };

                        /**
                         * Encodes the specified UpdateServiceResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceResp} message UpdateServiceResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateServiceResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.service != null && Object.hasOwnProperty.call(message, "service"))
                                $root.code.justin.tv.eventbus.controlplane.Service.encode(message.service, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified UpdateServiceResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateServiceResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateServiceResp} message UpdateServiceResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateServiceResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an UpdateServiceResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceResp} UpdateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateServiceResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.UpdateServiceResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.service = $root.code.justin.tv.eventbus.controlplane.Service.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an UpdateServiceResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceResp} UpdateServiceResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateServiceResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an UpdateServiceResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateServiceResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.service != null && message.hasOwnProperty("service")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.Service.verify(message.service);
                                if (error)
                                    return "service." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates an UpdateServiceResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateServiceResp} UpdateServiceResp
                         */
                        UpdateServiceResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.UpdateServiceResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.UpdateServiceResp();
                            if (object.service != null) {
                                if (typeof object.service !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.UpdateServiceResp.service: object expected");
                                message.service = $root.code.justin.tv.eventbus.controlplane.Service.fromObject(object.service);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an UpdateServiceResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.UpdateServiceResp} message UpdateServiceResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateServiceResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.service = null;
                            if (message.service != null && message.hasOwnProperty("service"))
                                object.service = $root.code.justin.tv.eventbus.controlplane.Service.toObject(message.service, options);
                            return object;
                        };

                        /**
                         * Converts this UpdateServiceResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateServiceResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateServiceResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return UpdateServiceResp;
                    })();

                    controlplane.Service = (function() {

                        /**
                         * Properties of a Service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IService
                         * @property {string|null} [id] Service id
                         * @property {string|null} [name] Service name
                         * @property {string|null} [serviceCatalogUrl] Service serviceCatalogUrl
                         * @property {string|null} [description] Service description
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IAccount>|null} [accounts] Service accounts
                         * @property {string|null} [ldapGroup] Service ldapGroup
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IIAMRole>|null} [iamRoles] Service iamRoles
                         */

                        /**
                         * Constructs a new Service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a Service.
                         * @implements IService
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IService=} [properties] Properties to set
                         */
                        function Service(properties) {
                            this.accounts = [];
                            this.iamRoles = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Service id.
                         * @member {string} id
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         */
                        Service.prototype.id = "";

                        /**
                         * Service name.
                         * @member {string} name
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         */
                        Service.prototype.name = "";

                        /**
                         * Service serviceCatalogUrl.
                         * @member {string} serviceCatalogUrl
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         */
                        Service.prototype.serviceCatalogUrl = "";

                        /**
                         * Service description.
                         * @member {string} description
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         */
                        Service.prototype.description = "";

                        /**
                         * Service accounts.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IAccount>} accounts
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         */
                        Service.prototype.accounts = $util.emptyArray;

                        /**
                         * Service ldapGroup.
                         * @member {string} ldapGroup
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         */
                        Service.prototype.ldapGroup = "";

                        /**
                         * Service iamRoles.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IIAMRole>} iamRoles
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         */
                        Service.prototype.iamRoles = $util.emptyArray;

                        /**
                         * Creates a new Service instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IService=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.Service} Service instance
                         */
                        Service.create = function create(properties) {
                            return new Service(properties);
                        };

                        /**
                         * Encodes the specified Service message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Service.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IService} message Service message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Service.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.name);
                            if (message.serviceCatalogUrl != null && Object.hasOwnProperty.call(message, "serviceCatalogUrl"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.serviceCatalogUrl);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.description);
                            if (message.accounts != null && message.accounts.length)
                                for (var i = 0; i < message.accounts.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.Account.encode(message.accounts[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                            if (message.ldapGroup != null && Object.hasOwnProperty.call(message, "ldapGroup"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.ldapGroup);
                            if (message.iamRoles != null && message.iamRoles.length)
                                for (var i = 0; i < message.iamRoles.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.IAMRole.encode(message.iamRoles[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified Service message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Service.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IService} message Service message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Service.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a Service message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.Service} Service
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Service.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.Service();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.id = reader.string();
                                    break;
                                case 2:
                                    message.name = reader.string();
                                    break;
                                case 3:
                                    message.serviceCatalogUrl = reader.string();
                                    break;
                                case 4:
                                    message.description = reader.string();
                                    break;
                                case 5:
                                    if (!(message.accounts && message.accounts.length))
                                        message.accounts = [];
                                    message.accounts.push($root.code.justin.tv.eventbus.controlplane.Account.decode(reader, reader.uint32()));
                                    break;
                                case 6:
                                    message.ldapGroup = reader.string();
                                    break;
                                case 7:
                                    if (!(message.iamRoles && message.iamRoles.length))
                                        message.iamRoles = [];
                                    message.iamRoles.push($root.code.justin.tv.eventbus.controlplane.IAMRole.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a Service message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.Service} Service
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Service.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a Service message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Service.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            if (message.name != null && message.hasOwnProperty("name"))
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            if (message.serviceCatalogUrl != null && message.hasOwnProperty("serviceCatalogUrl"))
                                if (!$util.isString(message.serviceCatalogUrl))
                                    return "serviceCatalogUrl: string expected";
                            if (message.description != null && message.hasOwnProperty("description"))
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            if (message.accounts != null && message.hasOwnProperty("accounts")) {
                                if (!Array.isArray(message.accounts))
                                    return "accounts: array expected";
                                for (var i = 0; i < message.accounts.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.Account.verify(message.accounts[i]);
                                    if (error)
                                        return "accounts." + error;
                                }
                            }
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                if (!$util.isString(message.ldapGroup))
                                    return "ldapGroup: string expected";
                            if (message.iamRoles != null && message.hasOwnProperty("iamRoles")) {
                                if (!Array.isArray(message.iamRoles))
                                    return "iamRoles: array expected";
                                for (var i = 0; i < message.iamRoles.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.IAMRole.verify(message.iamRoles[i]);
                                    if (error)
                                        return "iamRoles." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a Service message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.Service} Service
                         */
                        Service.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.Service)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.Service();
                            if (object.id != null)
                                message.id = String(object.id);
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.serviceCatalogUrl != null)
                                message.serviceCatalogUrl = String(object.serviceCatalogUrl);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.accounts) {
                                if (!Array.isArray(object.accounts))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.Service.accounts: array expected");
                                message.accounts = [];
                                for (var i = 0; i < object.accounts.length; ++i) {
                                    if (typeof object.accounts[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.Service.accounts: object expected");
                                    message.accounts[i] = $root.code.justin.tv.eventbus.controlplane.Account.fromObject(object.accounts[i]);
                                }
                            }
                            if (object.ldapGroup != null)
                                message.ldapGroup = String(object.ldapGroup);
                            if (object.iamRoles) {
                                if (!Array.isArray(object.iamRoles))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.Service.iamRoles: array expected");
                                message.iamRoles = [];
                                for (var i = 0; i < object.iamRoles.length; ++i) {
                                    if (typeof object.iamRoles[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.Service.iamRoles: object expected");
                                    message.iamRoles[i] = $root.code.justin.tv.eventbus.controlplane.IAMRole.fromObject(object.iamRoles[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a Service message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.Service} message Service
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Service.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.accounts = [];
                                object.iamRoles = [];
                            }
                            if (options.defaults) {
                                object.id = "";
                                object.name = "";
                                object.serviceCatalogUrl = "";
                                object.description = "";
                                object.ldapGroup = "";
                            }
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            if (message.name != null && message.hasOwnProperty("name"))
                                object.name = message.name;
                            if (message.serviceCatalogUrl != null && message.hasOwnProperty("serviceCatalogUrl"))
                                object.serviceCatalogUrl = message.serviceCatalogUrl;
                            if (message.description != null && message.hasOwnProperty("description"))
                                object.description = message.description;
                            if (message.accounts && message.accounts.length) {
                                object.accounts = [];
                                for (var j = 0; j < message.accounts.length; ++j)
                                    object.accounts[j] = $root.code.justin.tv.eventbus.controlplane.Account.toObject(message.accounts[j], options);
                            }
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                object.ldapGroup = message.ldapGroup;
                            if (message.iamRoles && message.iamRoles.length) {
                                object.iamRoles = [];
                                for (var j = 0; j < message.iamRoles.length; ++j)
                                    object.iamRoles[j] = $root.code.justin.tv.eventbus.controlplane.IAMRole.toObject(message.iamRoles[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this Service to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.Service
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Service.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return Service;
                    })();

                    controlplane.Account = (function() {

                        /**
                         * Properties of an Account.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IAccount
                         * @property {string|null} [id] Account id
                         * @property {string|null} [label] Account label
                         * @property {string|null} [cloudformationStatus] Account cloudformationStatus
                         */

                        /**
                         * Constructs a new Account.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an Account.
                         * @implements IAccount
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IAccount=} [properties] Properties to set
                         */
                        function Account(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Account id.
                         * @member {string} id
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @instance
                         */
                        Account.prototype.id = "";

                        /**
                         * Account label.
                         * @member {string} label
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @instance
                         */
                        Account.prototype.label = "";

                        /**
                         * Account cloudformationStatus.
                         * @member {string} cloudformationStatus
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @instance
                         */
                        Account.prototype.cloudformationStatus = "";

                        /**
                         * Creates a new Account instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAccount=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.Account} Account instance
                         */
                        Account.create = function create(properties) {
                            return new Account(properties);
                        };

                        /**
                         * Encodes the specified Account message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Account.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAccount} message Account message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Account.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
                            if (message.label != null && Object.hasOwnProperty.call(message, "label"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.label);
                            if (message.cloudformationStatus != null && Object.hasOwnProperty.call(message, "cloudformationStatus"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.cloudformationStatus);
                            return writer;
                        };

                        /**
                         * Encodes the specified Account message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Account.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAccount} message Account message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Account.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an Account message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.Account} Account
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Account.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.Account();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.id = reader.string();
                                    break;
                                case 2:
                                    message.label = reader.string();
                                    break;
                                case 3:
                                    message.cloudformationStatus = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an Account message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.Account} Account
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Account.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an Account message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Account.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            if (message.label != null && message.hasOwnProperty("label"))
                                if (!$util.isString(message.label))
                                    return "label: string expected";
                            if (message.cloudformationStatus != null && message.hasOwnProperty("cloudformationStatus"))
                                if (!$util.isString(message.cloudformationStatus))
                                    return "cloudformationStatus: string expected";
                            return null;
                        };

                        /**
                         * Creates an Account message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.Account} Account
                         */
                        Account.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.Account)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.Account();
                            if (object.id != null)
                                message.id = String(object.id);
                            if (object.label != null)
                                message.label = String(object.label);
                            if (object.cloudformationStatus != null)
                                message.cloudformationStatus = String(object.cloudformationStatus);
                            return message;
                        };

                        /**
                         * Creates a plain object from an Account message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.Account} message Account
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Account.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.id = "";
                                object.label = "";
                                object.cloudformationStatus = "";
                            }
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            if (message.label != null && message.hasOwnProperty("label"))
                                object.label = message.label;
                            if (message.cloudformationStatus != null && message.hasOwnProperty("cloudformationStatus"))
                                object.cloudformationStatus = message.cloudformationStatus;
                            return object;
                        };

                        /**
                         * Converts this Account to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.Account
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Account.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return Account;
                    })();

                    controlplane.RequestorLDAPGroupsReq = (function() {

                        /**
                         * Properties of a RequestorLDAPGroupsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IRequestorLDAPGroupsReq
                         */

                        /**
                         * Constructs a new RequestorLDAPGroupsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a RequestorLDAPGroupsReq.
                         * @implements IRequestorLDAPGroupsReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq=} [properties] Properties to set
                         */
                        function RequestorLDAPGroupsReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new RequestorLDAPGroupsReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq} RequestorLDAPGroupsReq instance
                         */
                        RequestorLDAPGroupsReq.create = function create(properties) {
                            return new RequestorLDAPGroupsReq(properties);
                        };

                        /**
                         * Encodes the specified RequestorLDAPGroupsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq} message RequestorLDAPGroupsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        RequestorLDAPGroupsReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified RequestorLDAPGroupsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsReq} message RequestorLDAPGroupsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        RequestorLDAPGroupsReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a RequestorLDAPGroupsReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq} RequestorLDAPGroupsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        RequestorLDAPGroupsReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a RequestorLDAPGroupsReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq} RequestorLDAPGroupsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        RequestorLDAPGroupsReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a RequestorLDAPGroupsReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        RequestorLDAPGroupsReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a RequestorLDAPGroupsReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq} RequestorLDAPGroupsReq
                         */
                        RequestorLDAPGroupsReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq)
                                return object;
                            return new $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq();
                        };

                        /**
                         * Creates a plain object from a RequestorLDAPGroupsReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq} message RequestorLDAPGroupsReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        RequestorLDAPGroupsReq.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this RequestorLDAPGroupsReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        RequestorLDAPGroupsReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return RequestorLDAPGroupsReq;
                    })();

                    controlplane.RequestorLDAPGroupsResp = (function() {

                        /**
                         * Properties of a RequestorLDAPGroupsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IRequestorLDAPGroupsResp
                         * @property {Array.<string>|null} [ldapGroups] RequestorLDAPGroupsResp ldapGroups
                         */

                        /**
                         * Constructs a new RequestorLDAPGroupsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a RequestorLDAPGroupsResp.
                         * @implements IRequestorLDAPGroupsResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp=} [properties] Properties to set
                         */
                        function RequestorLDAPGroupsResp(properties) {
                            this.ldapGroups = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * RequestorLDAPGroupsResp ldapGroups.
                         * @member {Array.<string>} ldapGroups
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @instance
                         */
                        RequestorLDAPGroupsResp.prototype.ldapGroups = $util.emptyArray;

                        /**
                         * Creates a new RequestorLDAPGroupsResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp} RequestorLDAPGroupsResp instance
                         */
                        RequestorLDAPGroupsResp.create = function create(properties) {
                            return new RequestorLDAPGroupsResp(properties);
                        };

                        /**
                         * Encodes the specified RequestorLDAPGroupsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp} message RequestorLDAPGroupsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        RequestorLDAPGroupsResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.ldapGroups != null && message.ldapGroups.length)
                                for (var i = 0; i < message.ldapGroups.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.ldapGroups[i]);
                            return writer;
                        };

                        /**
                         * Encodes the specified RequestorLDAPGroupsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IRequestorLDAPGroupsResp} message RequestorLDAPGroupsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        RequestorLDAPGroupsResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a RequestorLDAPGroupsResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp} RequestorLDAPGroupsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        RequestorLDAPGroupsResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.ldapGroups && message.ldapGroups.length))
                                        message.ldapGroups = [];
                                    message.ldapGroups.push(reader.string());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a RequestorLDAPGroupsResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp} RequestorLDAPGroupsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        RequestorLDAPGroupsResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a RequestorLDAPGroupsResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        RequestorLDAPGroupsResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.ldapGroups != null && message.hasOwnProperty("ldapGroups")) {
                                if (!Array.isArray(message.ldapGroups))
                                    return "ldapGroups: array expected";
                                for (var i = 0; i < message.ldapGroups.length; ++i)
                                    if (!$util.isString(message.ldapGroups[i]))
                                        return "ldapGroups: string[] expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a RequestorLDAPGroupsResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp} RequestorLDAPGroupsResp
                         */
                        RequestorLDAPGroupsResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp();
                            if (object.ldapGroups) {
                                if (!Array.isArray(object.ldapGroups))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp.ldapGroups: array expected");
                                message.ldapGroups = [];
                                for (var i = 0; i < object.ldapGroups.length; ++i)
                                    message.ldapGroups[i] = String(object.ldapGroups[i]);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a RequestorLDAPGroupsResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp} message RequestorLDAPGroupsResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        RequestorLDAPGroupsResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.ldapGroups = [];
                            if (message.ldapGroups && message.ldapGroups.length) {
                                object.ldapGroups = [];
                                for (var j = 0; j < message.ldapGroups.length; ++j)
                                    object.ldapGroups[j] = message.ldapGroups[j];
                            }
                            return object;
                        };

                        /**
                         * Converts this RequestorLDAPGroupsResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.RequestorLDAPGroupsResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        RequestorLDAPGroupsResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return RequestorLDAPGroupsResp;
                    })();

                    controlplane.ResolveLDAPGroupUsersReq = (function() {

                        /**
                         * Properties of a ResolveLDAPGroupUsersReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IResolveLDAPGroupUsersReq
                         * @property {string|null} [ldapGroup] ResolveLDAPGroupUsersReq ldapGroup
                         */

                        /**
                         * Constructs a new ResolveLDAPGroupUsersReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ResolveLDAPGroupUsersReq.
                         * @implements IResolveLDAPGroupUsersReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq=} [properties] Properties to set
                         */
                        function ResolveLDAPGroupUsersReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ResolveLDAPGroupUsersReq ldapGroup.
                         * @member {string} ldapGroup
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @instance
                         */
                        ResolveLDAPGroupUsersReq.prototype.ldapGroup = "";

                        /**
                         * Creates a new ResolveLDAPGroupUsersReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq} ResolveLDAPGroupUsersReq instance
                         */
                        ResolveLDAPGroupUsersReq.create = function create(properties) {
                            return new ResolveLDAPGroupUsersReq(properties);
                        };

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq} message ResolveLDAPGroupUsersReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ResolveLDAPGroupUsersReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.ldapGroup != null && Object.hasOwnProperty.call(message, "ldapGroup"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.ldapGroup);
                            return writer;
                        };

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersReq} message ResolveLDAPGroupUsersReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ResolveLDAPGroupUsersReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ResolveLDAPGroupUsersReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq} ResolveLDAPGroupUsersReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ResolveLDAPGroupUsersReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.ldapGroup = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ResolveLDAPGroupUsersReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq} ResolveLDAPGroupUsersReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ResolveLDAPGroupUsersReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ResolveLDAPGroupUsersReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ResolveLDAPGroupUsersReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                if (!$util.isString(message.ldapGroup))
                                    return "ldapGroup: string expected";
                            return null;
                        };

                        /**
                         * Creates a ResolveLDAPGroupUsersReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq} ResolveLDAPGroupUsersReq
                         */
                        ResolveLDAPGroupUsersReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq();
                            if (object.ldapGroup != null)
                                message.ldapGroup = String(object.ldapGroup);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ResolveLDAPGroupUsersReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq} message ResolveLDAPGroupUsersReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ResolveLDAPGroupUsersReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.ldapGroup = "";
                            if (message.ldapGroup != null && message.hasOwnProperty("ldapGroup"))
                                object.ldapGroup = message.ldapGroup;
                            return object;
                        };

                        /**
                         * Converts this ResolveLDAPGroupUsersReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ResolveLDAPGroupUsersReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ResolveLDAPGroupUsersReq;
                    })();

                    controlplane.ResolveLDAPGroupUsersResp = (function() {

                        /**
                         * Properties of a ResolveLDAPGroupUsersResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IResolveLDAPGroupUsersResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.ILDAPEntry>|null} [ldapEntries] ResolveLDAPGroupUsersResp ldapEntries
                         */

                        /**
                         * Constructs a new ResolveLDAPGroupUsersResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ResolveLDAPGroupUsersResp.
                         * @implements IResolveLDAPGroupUsersResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp=} [properties] Properties to set
                         */
                        function ResolveLDAPGroupUsersResp(properties) {
                            this.ldapEntries = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ResolveLDAPGroupUsersResp ldapEntries.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.ILDAPEntry>} ldapEntries
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @instance
                         */
                        ResolveLDAPGroupUsersResp.prototype.ldapEntries = $util.emptyArray;

                        /**
                         * Creates a new ResolveLDAPGroupUsersResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp} ResolveLDAPGroupUsersResp instance
                         */
                        ResolveLDAPGroupUsersResp.create = function create(properties) {
                            return new ResolveLDAPGroupUsersResp(properties);
                        };

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp} message ResolveLDAPGroupUsersResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ResolveLDAPGroupUsersResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.ldapEntries != null && message.ldapEntries.length)
                                for (var i = 0; i < message.ldapEntries.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.LDAPEntry.encode(message.ldapEntries[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified ResolveLDAPGroupUsersResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IResolveLDAPGroupUsersResp} message ResolveLDAPGroupUsersResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ResolveLDAPGroupUsersResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ResolveLDAPGroupUsersResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp} ResolveLDAPGroupUsersResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ResolveLDAPGroupUsersResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.ldapEntries && message.ldapEntries.length))
                                        message.ldapEntries = [];
                                    message.ldapEntries.push($root.code.justin.tv.eventbus.controlplane.LDAPEntry.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ResolveLDAPGroupUsersResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp} ResolveLDAPGroupUsersResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ResolveLDAPGroupUsersResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ResolveLDAPGroupUsersResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ResolveLDAPGroupUsersResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.ldapEntries != null && message.hasOwnProperty("ldapEntries")) {
                                if (!Array.isArray(message.ldapEntries))
                                    return "ldapEntries: array expected";
                                for (var i = 0; i < message.ldapEntries.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.LDAPEntry.verify(message.ldapEntries[i]);
                                    if (error)
                                        return "ldapEntries." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a ResolveLDAPGroupUsersResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp} ResolveLDAPGroupUsersResp
                         */
                        ResolveLDAPGroupUsersResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp();
                            if (object.ldapEntries) {
                                if (!Array.isArray(object.ldapEntries))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp.ldapEntries: array expected");
                                message.ldapEntries = [];
                                for (var i = 0; i < object.ldapEntries.length; ++i) {
                                    if (typeof object.ldapEntries[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp.ldapEntries: object expected");
                                    message.ldapEntries[i] = $root.code.justin.tv.eventbus.controlplane.LDAPEntry.fromObject(object.ldapEntries[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a ResolveLDAPGroupUsersResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp} message ResolveLDAPGroupUsersResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ResolveLDAPGroupUsersResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.ldapEntries = [];
                            if (message.ldapEntries && message.ldapEntries.length) {
                                object.ldapEntries = [];
                                for (var j = 0; j < message.ldapEntries.length; ++j)
                                    object.ldapEntries[j] = $root.code.justin.tv.eventbus.controlplane.LDAPEntry.toObject(message.ldapEntries[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this ResolveLDAPGroupUsersResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ResolveLDAPGroupUsersResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ResolveLDAPGroupUsersResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ResolveLDAPGroupUsersResp;
                    })();

                    controlplane.LDAPEntry = (function() {

                        /**
                         * Properties of a LDAPEntry.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ILDAPEntry
                         * @property {string|null} [commonName] LDAPEntry commonName
                         * @property {string|null} [uid] LDAPEntry uid
                         */

                        /**
                         * Constructs a new LDAPEntry.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a LDAPEntry.
                         * @implements ILDAPEntry
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ILDAPEntry=} [properties] Properties to set
                         */
                        function LDAPEntry(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * LDAPEntry commonName.
                         * @member {string} commonName
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @instance
                         */
                        LDAPEntry.prototype.commonName = "";

                        /**
                         * LDAPEntry uid.
                         * @member {string} uid
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @instance
                         */
                        LDAPEntry.prototype.uid = "";

                        /**
                         * Creates a new LDAPEntry instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ILDAPEntry=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.LDAPEntry} LDAPEntry instance
                         */
                        LDAPEntry.create = function create(properties) {
                            return new LDAPEntry(properties);
                        };

                        /**
                         * Encodes the specified LDAPEntry message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.LDAPEntry.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ILDAPEntry} message LDAPEntry message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LDAPEntry.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.commonName != null && Object.hasOwnProperty.call(message, "commonName"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.commonName);
                            if (message.uid != null && Object.hasOwnProperty.call(message, "uid"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.uid);
                            return writer;
                        };

                        /**
                         * Encodes the specified LDAPEntry message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.LDAPEntry.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ILDAPEntry} message LDAPEntry message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        LDAPEntry.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a LDAPEntry message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.LDAPEntry} LDAPEntry
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LDAPEntry.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.LDAPEntry();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.commonName = reader.string();
                                    break;
                                case 2:
                                    message.uid = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a LDAPEntry message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.LDAPEntry} LDAPEntry
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        LDAPEntry.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a LDAPEntry message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        LDAPEntry.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.commonName != null && message.hasOwnProperty("commonName"))
                                if (!$util.isString(message.commonName))
                                    return "commonName: string expected";
                            if (message.uid != null && message.hasOwnProperty("uid"))
                                if (!$util.isString(message.uid))
                                    return "uid: string expected";
                            return null;
                        };

                        /**
                         * Creates a LDAPEntry message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.LDAPEntry} LDAPEntry
                         */
                        LDAPEntry.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.LDAPEntry)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.LDAPEntry();
                            if (object.commonName != null)
                                message.commonName = String(object.commonName);
                            if (object.uid != null)
                                message.uid = String(object.uid);
                            return message;
                        };

                        /**
                         * Creates a plain object from a LDAPEntry message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.LDAPEntry} message LDAPEntry
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        LDAPEntry.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.commonName = "";
                                object.uid = "";
                            }
                            if (message.commonName != null && message.hasOwnProperty("commonName"))
                                object.commonName = message.commonName;
                            if (message.uid != null && message.hasOwnProperty("uid"))
                                object.uid = message.uid;
                            return object;
                        };

                        /**
                         * Converts this LDAPEntry to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.LDAPEntry
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        LDAPEntry.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return LDAPEntry;
                    })();

                    controlplane.GetAuthorizedFieldGrantsReq = (function() {

                        /**
                         * Properties of a GetAuthorizedFieldGrantsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetAuthorizedFieldGrantsReq
                         * @property {string|null} [serviceId] GetAuthorizedFieldGrantsReq serviceId
                         */

                        /**
                         * Constructs a new GetAuthorizedFieldGrantsReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetAuthorizedFieldGrantsReq.
                         * @implements IGetAuthorizedFieldGrantsReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq=} [properties] Properties to set
                         */
                        function GetAuthorizedFieldGrantsReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetAuthorizedFieldGrantsReq serviceId.
                         * @member {string} serviceId
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @instance
                         */
                        GetAuthorizedFieldGrantsReq.prototype.serviceId = "";

                        /**
                         * Creates a new GetAuthorizedFieldGrantsReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq} GetAuthorizedFieldGrantsReq instance
                         */
                        GetAuthorizedFieldGrantsReq.create = function create(properties) {
                            return new GetAuthorizedFieldGrantsReq(properties);
                        };

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq} message GetAuthorizedFieldGrantsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuthorizedFieldGrantsReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.serviceId != null && Object.hasOwnProperty.call(message, "serviceId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.serviceId);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsReq} message GetAuthorizedFieldGrantsReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuthorizedFieldGrantsReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetAuthorizedFieldGrantsReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq} GetAuthorizedFieldGrantsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuthorizedFieldGrantsReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.serviceId = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetAuthorizedFieldGrantsReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq} GetAuthorizedFieldGrantsReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuthorizedFieldGrantsReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetAuthorizedFieldGrantsReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAuthorizedFieldGrantsReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                if (!$util.isString(message.serviceId))
                                    return "serviceId: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetAuthorizedFieldGrantsReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq} GetAuthorizedFieldGrantsReq
                         */
                        GetAuthorizedFieldGrantsReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq();
                            if (object.serviceId != null)
                                message.serviceId = String(object.serviceId);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetAuthorizedFieldGrantsReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq} message GetAuthorizedFieldGrantsReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAuthorizedFieldGrantsReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.serviceId = "";
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                object.serviceId = message.serviceId;
                            return object;
                        };

                        /**
                         * Converts this GetAuthorizedFieldGrantsReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAuthorizedFieldGrantsReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetAuthorizedFieldGrantsReq;
                    })();

                    controlplane.GetAuthorizedFieldGrantsResp = (function() {

                        /**
                         * Properties of a GetAuthorizedFieldGrantsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetAuthorizedFieldGrantsResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant>|null} [subscriberGrants] GetAuthorizedFieldGrantsResp subscriberGrants
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant>|null} [publisherGrants] GetAuthorizedFieldGrantsResp publisherGrants
                         */

                        /**
                         * Constructs a new GetAuthorizedFieldGrantsResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetAuthorizedFieldGrantsResp.
                         * @implements IGetAuthorizedFieldGrantsResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp=} [properties] Properties to set
                         */
                        function GetAuthorizedFieldGrantsResp(properties) {
                            this.subscriberGrants = [];
                            this.publisherGrants = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetAuthorizedFieldGrantsResp subscriberGrants.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant>} subscriberGrants
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @instance
                         */
                        GetAuthorizedFieldGrantsResp.prototype.subscriberGrants = $util.emptyArray;

                        /**
                         * GetAuthorizedFieldGrantsResp publisherGrants.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant>} publisherGrants
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @instance
                         */
                        GetAuthorizedFieldGrantsResp.prototype.publisherGrants = $util.emptyArray;

                        /**
                         * Creates a new GetAuthorizedFieldGrantsResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp} GetAuthorizedFieldGrantsResp instance
                         */
                        GetAuthorizedFieldGrantsResp.create = function create(properties) {
                            return new GetAuthorizedFieldGrantsResp(properties);
                        };

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp} message GetAuthorizedFieldGrantsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuthorizedFieldGrantsResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.subscriberGrants != null && message.subscriberGrants.length)
                                for (var i = 0; i < message.subscriberGrants.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.encode(message.subscriberGrants[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.publisherGrants != null && message.publisherGrants.length)
                                for (var i = 0; i < message.publisherGrants.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.encode(message.publisherGrants[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified GetAuthorizedFieldGrantsResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetAuthorizedFieldGrantsResp} message GetAuthorizedFieldGrantsResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetAuthorizedFieldGrantsResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetAuthorizedFieldGrantsResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp} GetAuthorizedFieldGrantsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuthorizedFieldGrantsResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.subscriberGrants && message.subscriberGrants.length))
                                        message.subscriberGrants = [];
                                    message.subscriberGrants.push($root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.decode(reader, reader.uint32()));
                                    break;
                                case 2:
                                    if (!(message.publisherGrants && message.publisherGrants.length))
                                        message.publisherGrants = [];
                                    message.publisherGrants.push($root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetAuthorizedFieldGrantsResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp} GetAuthorizedFieldGrantsResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetAuthorizedFieldGrantsResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetAuthorizedFieldGrantsResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetAuthorizedFieldGrantsResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.subscriberGrants != null && message.hasOwnProperty("subscriberGrants")) {
                                if (!Array.isArray(message.subscriberGrants))
                                    return "subscriberGrants: array expected";
                                for (var i = 0; i < message.subscriberGrants.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.verify(message.subscriberGrants[i]);
                                    if (error)
                                        return "subscriberGrants." + error;
                                }
                            }
                            if (message.publisherGrants != null && message.hasOwnProperty("publisherGrants")) {
                                if (!Array.isArray(message.publisherGrants))
                                    return "publisherGrants: array expected";
                                for (var i = 0; i < message.publisherGrants.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.verify(message.publisherGrants[i]);
                                    if (error)
                                        return "publisherGrants." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a GetAuthorizedFieldGrantsResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp} GetAuthorizedFieldGrantsResp
                         */
                        GetAuthorizedFieldGrantsResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp();
                            if (object.subscriberGrants) {
                                if (!Array.isArray(object.subscriberGrants))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.subscriberGrants: array expected");
                                message.subscriberGrants = [];
                                for (var i = 0; i < object.subscriberGrants.length; ++i) {
                                    if (typeof object.subscriberGrants[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.subscriberGrants: object expected");
                                    message.subscriberGrants[i] = $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.fromObject(object.subscriberGrants[i]);
                                }
                            }
                            if (object.publisherGrants) {
                                if (!Array.isArray(object.publisherGrants))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.publisherGrants: array expected");
                                message.publisherGrants = [];
                                for (var i = 0; i < object.publisherGrants.length; ++i) {
                                    if (typeof object.publisherGrants[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp.publisherGrants: object expected");
                                    message.publisherGrants[i] = $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.fromObject(object.publisherGrants[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetAuthorizedFieldGrantsResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp} message GetAuthorizedFieldGrantsResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetAuthorizedFieldGrantsResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.subscriberGrants = [];
                                object.publisherGrants = [];
                            }
                            if (message.subscriberGrants && message.subscriberGrants.length) {
                                object.subscriberGrants = [];
                                for (var j = 0; j < message.subscriberGrants.length; ++j)
                                    object.subscriberGrants[j] = $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.toObject(message.subscriberGrants[j], options);
                            }
                            if (message.publisherGrants && message.publisherGrants.length) {
                                object.publisherGrants = [];
                                for (var j = 0; j < message.publisherGrants.length; ++j)
                                    object.publisherGrants[j] = $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.toObject(message.publisherGrants[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this GetAuthorizedFieldGrantsResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetAuthorizedFieldGrantsResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetAuthorizedFieldGrantsResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetAuthorizedFieldGrantsResp;
                    })();

                    controlplane.AuthorizedFieldPublisherGrant = (function() {

                        /**
                         * Properties of an AuthorizedFieldPublisherGrant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IAuthorizedFieldPublisherGrant
                         * @property {code.justin.tv.eventbus.controlplane.IIAMRole|null} [iamRole] AuthorizedFieldPublisherGrant iamRole
                         * @property {string|null} [eventType] AuthorizedFieldPublisherGrant eventType
                         * @property {string|null} [environment] AuthorizedFieldPublisherGrant environment
                         */

                        /**
                         * Constructs a new AuthorizedFieldPublisherGrant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an AuthorizedFieldPublisherGrant.
                         * @implements IAuthorizedFieldPublisherGrant
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant=} [properties] Properties to set
                         */
                        function AuthorizedFieldPublisherGrant(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * AuthorizedFieldPublisherGrant iamRole.
                         * @member {code.justin.tv.eventbus.controlplane.IIAMRole|null|undefined} iamRole
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @instance
                         */
                        AuthorizedFieldPublisherGrant.prototype.iamRole = null;

                        /**
                         * AuthorizedFieldPublisherGrant eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @instance
                         */
                        AuthorizedFieldPublisherGrant.prototype.eventType = "";

                        /**
                         * AuthorizedFieldPublisherGrant environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @instance
                         */
                        AuthorizedFieldPublisherGrant.prototype.environment = "";

                        /**
                         * Creates a new AuthorizedFieldPublisherGrant instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant} AuthorizedFieldPublisherGrant instance
                         */
                        AuthorizedFieldPublisherGrant.create = function create(properties) {
                            return new AuthorizedFieldPublisherGrant(properties);
                        };

                        /**
                         * Encodes the specified AuthorizedFieldPublisherGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant} message AuthorizedFieldPublisherGrant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuthorizedFieldPublisherGrant.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.iamRole != null && Object.hasOwnProperty.call(message, "iamRole"))
                                $root.code.justin.tv.eventbus.controlplane.IAMRole.encode(message.iamRole, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.eventType);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified AuthorizedFieldPublisherGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldPublisherGrant} message AuthorizedFieldPublisherGrant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuthorizedFieldPublisherGrant.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an AuthorizedFieldPublisherGrant message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant} AuthorizedFieldPublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuthorizedFieldPublisherGrant.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.eventType = reader.string();
                                    break;
                                case 3:
                                    message.environment = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an AuthorizedFieldPublisherGrant message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant} AuthorizedFieldPublisherGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuthorizedFieldPublisherGrant.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an AuthorizedFieldPublisherGrant message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AuthorizedFieldPublisherGrant.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.iamRole != null && message.hasOwnProperty("iamRole")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.IAMRole.verify(message.iamRole);
                                if (error)
                                    return "iamRole." + error;
                            }
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            return null;
                        };

                        /**
                         * Creates an AuthorizedFieldPublisherGrant message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant} AuthorizedFieldPublisherGrant
                         */
                        AuthorizedFieldPublisherGrant.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant();
                            if (object.iamRole != null) {
                                if (typeof object.iamRole !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant.iamRole: object expected");
                                message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.fromObject(object.iamRole);
                            }
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            return message;
                        };

                        /**
                         * Creates a plain object from an AuthorizedFieldPublisherGrant message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant} message AuthorizedFieldPublisherGrant
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AuthorizedFieldPublisherGrant.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.iamRole = null;
                                object.eventType = "";
                                object.environment = "";
                            }
                            if (message.iamRole != null && message.hasOwnProperty("iamRole"))
                                object.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.toObject(message.iamRole, options);
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            return object;
                        };

                        /**
                         * Converts this AuthorizedFieldPublisherGrant to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldPublisherGrant
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AuthorizedFieldPublisherGrant.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return AuthorizedFieldPublisherGrant;
                    })();

                    controlplane.DeleteIAMRoleReq = (function() {

                        /**
                         * Properties of a DeleteIAMRoleReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IDeleteIAMRoleReq
                         * @property {string|null} [arn] DeleteIAMRoleReq arn
                         */

                        /**
                         * Constructs a new DeleteIAMRoleReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a DeleteIAMRoleReq.
                         * @implements IDeleteIAMRoleReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq=} [properties] Properties to set
                         */
                        function DeleteIAMRoleReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DeleteIAMRoleReq arn.
                         * @member {string} arn
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @instance
                         */
                        DeleteIAMRoleReq.prototype.arn = "";

                        /**
                         * Creates a new DeleteIAMRoleReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq} DeleteIAMRoleReq instance
                         */
                        DeleteIAMRoleReq.create = function create(properties) {
                            return new DeleteIAMRoleReq(properties);
                        };

                        /**
                         * Encodes the specified DeleteIAMRoleReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq} message DeleteIAMRoleReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteIAMRoleReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.arn != null && Object.hasOwnProperty.call(message, "arn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.arn);
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteIAMRoleReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleReq} message DeleteIAMRoleReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteIAMRoleReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteIAMRoleReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq} DeleteIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteIAMRoleReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.arn = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteIAMRoleReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq} DeleteIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteIAMRoleReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteIAMRoleReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteIAMRoleReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                if (!$util.isString(message.arn))
                                    return "arn: string expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteIAMRoleReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq} DeleteIAMRoleReq
                         */
                        DeleteIAMRoleReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq();
                            if (object.arn != null)
                                message.arn = String(object.arn);
                            return message;
                        };

                        /**
                         * Creates a plain object from a DeleteIAMRoleReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq} message DeleteIAMRoleReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteIAMRoleReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.arn = "";
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                object.arn = message.arn;
                            return object;
                        };

                        /**
                         * Converts this DeleteIAMRoleReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteIAMRoleReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteIAMRoleReq;
                    })();

                    controlplane.DeleteIAMRoleResp = (function() {

                        /**
                         * Properties of a DeleteIAMRoleResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IDeleteIAMRoleResp
                         */

                        /**
                         * Constructs a new DeleteIAMRoleResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a DeleteIAMRoleResp.
                         * @implements IDeleteIAMRoleResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp=} [properties] Properties to set
                         */
                        function DeleteIAMRoleResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new DeleteIAMRoleResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp} DeleteIAMRoleResp instance
                         */
                        DeleteIAMRoleResp.create = function create(properties) {
                            return new DeleteIAMRoleResp(properties);
                        };

                        /**
                         * Encodes the specified DeleteIAMRoleResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp} message DeleteIAMRoleResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteIAMRoleResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteIAMRoleResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteIAMRoleResp} message DeleteIAMRoleResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteIAMRoleResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteIAMRoleResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp} DeleteIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteIAMRoleResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteIAMRoleResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp} DeleteIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteIAMRoleResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteIAMRoleResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteIAMRoleResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteIAMRoleResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp} DeleteIAMRoleResp
                         */
                        DeleteIAMRoleResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp)
                                return object;
                            return new $root.code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp();
                        };

                        /**
                         * Creates a plain object from a DeleteIAMRoleResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp} message DeleteIAMRoleResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteIAMRoleResp.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this DeleteIAMRoleResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteIAMRoleResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteIAMRoleResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteIAMRoleResp;
                    })();

                    controlplane.GetServicesForEventStreamReq = (function() {

                        /**
                         * Properties of a GetServicesForEventStreamReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetServicesForEventStreamReq
                         * @property {string|null} [eventType] GetServicesForEventStreamReq eventType
                         */

                        /**
                         * Constructs a new GetServicesForEventStreamReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetServicesForEventStreamReq.
                         * @implements IGetServicesForEventStreamReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq=} [properties] Properties to set
                         */
                        function GetServicesForEventStreamReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetServicesForEventStreamReq eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @instance
                         */
                        GetServicesForEventStreamReq.prototype.eventType = "";

                        /**
                         * Creates a new GetServicesForEventStreamReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq} GetServicesForEventStreamReq instance
                         */
                        GetServicesForEventStreamReq.create = function create(properties) {
                            return new GetServicesForEventStreamReq(properties);
                        };

                        /**
                         * Encodes the specified GetServicesForEventStreamReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq} message GetServicesForEventStreamReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServicesForEventStreamReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.eventType);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetServicesForEventStreamReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamReq} message GetServicesForEventStreamReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServicesForEventStreamReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetServicesForEventStreamReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq} GetServicesForEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServicesForEventStreamReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.eventType = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetServicesForEventStreamReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq} GetServicesForEventStreamReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServicesForEventStreamReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetServicesForEventStreamReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetServicesForEventStreamReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetServicesForEventStreamReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq} GetServicesForEventStreamReq
                         */
                        GetServicesForEventStreamReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq();
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetServicesForEventStreamReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq} message GetServicesForEventStreamReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetServicesForEventStreamReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.eventType = "";
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            return object;
                        };

                        /**
                         * Converts this GetServicesForEventStreamReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetServicesForEventStreamReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetServicesForEventStreamReq;
                    })();

                    controlplane.GetServicesForEventStreamResp = (function() {

                        /**
                         * Properties of a GetServicesForEventStreamResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetServicesForEventStreamResp
                         * @property {Array.<code.justin.tv.eventbus.controlplane.IService>|null} [services] GetServicesForEventStreamResp services
                         */

                        /**
                         * Constructs a new GetServicesForEventStreamResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetServicesForEventStreamResp.
                         * @implements IGetServicesForEventStreamResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp=} [properties] Properties to set
                         */
                        function GetServicesForEventStreamResp(properties) {
                            this.services = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetServicesForEventStreamResp services.
                         * @member {Array.<code.justin.tv.eventbus.controlplane.IService>} services
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @instance
                         */
                        GetServicesForEventStreamResp.prototype.services = $util.emptyArray;

                        /**
                         * Creates a new GetServicesForEventStreamResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp} GetServicesForEventStreamResp instance
                         */
                        GetServicesForEventStreamResp.create = function create(properties) {
                            return new GetServicesForEventStreamResp(properties);
                        };

                        /**
                         * Encodes the specified GetServicesForEventStreamResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp} message GetServicesForEventStreamResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServicesForEventStreamResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.services != null && message.services.length)
                                for (var i = 0; i < message.services.length; ++i)
                                    $root.code.justin.tv.eventbus.controlplane.Service.encode(message.services[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified GetServicesForEventStreamResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetServicesForEventStreamResp} message GetServicesForEventStreamResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetServicesForEventStreamResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetServicesForEventStreamResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp} GetServicesForEventStreamResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServicesForEventStreamResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    if (!(message.services && message.services.length))
                                        message.services = [];
                                    message.services.push($root.code.justin.tv.eventbus.controlplane.Service.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetServicesForEventStreamResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp} GetServicesForEventStreamResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetServicesForEventStreamResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetServicesForEventStreamResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetServicesForEventStreamResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.services != null && message.hasOwnProperty("services")) {
                                if (!Array.isArray(message.services))
                                    return "services: array expected";
                                for (var i = 0; i < message.services.length; ++i) {
                                    var error = $root.code.justin.tv.eventbus.controlplane.Service.verify(message.services[i]);
                                    if (error)
                                        return "services." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates a GetServicesForEventStreamResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp} GetServicesForEventStreamResp
                         */
                        GetServicesForEventStreamResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp();
                            if (object.services) {
                                if (!Array.isArray(object.services))
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp.services: array expected");
                                message.services = [];
                                for (var i = 0; i < object.services.length; ++i) {
                                    if (typeof object.services[i] !== "object")
                                        throw TypeError(".code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp.services: object expected");
                                    message.services[i] = $root.code.justin.tv.eventbus.controlplane.Service.fromObject(object.services[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetServicesForEventStreamResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp} message GetServicesForEventStreamResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetServicesForEventStreamResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.services = [];
                            if (message.services && message.services.length) {
                                object.services = [];
                                for (var j = 0; j < message.services.length; ++j)
                                    object.services[j] = $root.code.justin.tv.eventbus.controlplane.Service.toObject(message.services[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this GetServicesForEventStreamResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetServicesForEventStreamResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetServicesForEventStreamResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetServicesForEventStreamResp;
                    })();

                    controlplane.GetCloudFormationVersionReq = (function() {

                        /**
                         * Properties of a GetCloudFormationVersionReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetCloudFormationVersionReq
                         * @property {code.justin.tv.eventbus.controlplane.IIAMRole|null} [iamRole] GetCloudFormationVersionReq iamRole
                         */

                        /**
                         * Constructs a new GetCloudFormationVersionReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetCloudFormationVersionReq.
                         * @implements IGetCloudFormationVersionReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq=} [properties] Properties to set
                         */
                        function GetCloudFormationVersionReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetCloudFormationVersionReq iamRole.
                         * @member {code.justin.tv.eventbus.controlplane.IIAMRole|null|undefined} iamRole
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @instance
                         */
                        GetCloudFormationVersionReq.prototype.iamRole = null;

                        /**
                         * Creates a new GetCloudFormationVersionReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq} GetCloudFormationVersionReq instance
                         */
                        GetCloudFormationVersionReq.create = function create(properties) {
                            return new GetCloudFormationVersionReq(properties);
                        };

                        /**
                         * Encodes the specified GetCloudFormationVersionReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq} message GetCloudFormationVersionReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetCloudFormationVersionReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.iamRole != null && Object.hasOwnProperty.call(message, "iamRole"))
                                $root.code.justin.tv.eventbus.controlplane.IAMRole.encode(message.iamRole, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified GetCloudFormationVersionReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionReq} message GetCloudFormationVersionReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetCloudFormationVersionReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetCloudFormationVersionReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq} GetCloudFormationVersionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetCloudFormationVersionReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetCloudFormationVersionReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq} GetCloudFormationVersionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetCloudFormationVersionReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetCloudFormationVersionReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetCloudFormationVersionReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.iamRole != null && message.hasOwnProperty("iamRole")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.IAMRole.verify(message.iamRole);
                                if (error)
                                    return "iamRole." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a GetCloudFormationVersionReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq} GetCloudFormationVersionReq
                         */
                        GetCloudFormationVersionReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq();
                            if (object.iamRole != null) {
                                if (typeof object.iamRole !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq.iamRole: object expected");
                                message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.fromObject(object.iamRole);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetCloudFormationVersionReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq} message GetCloudFormationVersionReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetCloudFormationVersionReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.iamRole = null;
                            if (message.iamRole != null && message.hasOwnProperty("iamRole"))
                                object.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.toObject(message.iamRole, options);
                            return object;
                        };

                        /**
                         * Converts this GetCloudFormationVersionReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetCloudFormationVersionReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetCloudFormationVersionReq;
                    })();

                    controlplane.GetCloudFormationVersionResp = (function() {

                        /**
                         * Properties of a GetCloudFormationVersionResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IGetCloudFormationVersionResp
                         * @property {string|null} [version] GetCloudFormationVersionResp version
                         */

                        /**
                         * Constructs a new GetCloudFormationVersionResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a GetCloudFormationVersionResp.
                         * @implements IGetCloudFormationVersionResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp=} [properties] Properties to set
                         */
                        function GetCloudFormationVersionResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetCloudFormationVersionResp version.
                         * @member {string} version
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @instance
                         */
                        GetCloudFormationVersionResp.prototype.version = "";

                        /**
                         * Creates a new GetCloudFormationVersionResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp} GetCloudFormationVersionResp instance
                         */
                        GetCloudFormationVersionResp.create = function create(properties) {
                            return new GetCloudFormationVersionResp(properties);
                        };

                        /**
                         * Encodes the specified GetCloudFormationVersionResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp} message GetCloudFormationVersionResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetCloudFormationVersionResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.version);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetCloudFormationVersionResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IGetCloudFormationVersionResp} message GetCloudFormationVersionResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetCloudFormationVersionResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetCloudFormationVersionResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp} GetCloudFormationVersionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetCloudFormationVersionResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.version = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetCloudFormationVersionResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp} GetCloudFormationVersionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetCloudFormationVersionResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetCloudFormationVersionResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetCloudFormationVersionResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.version != null && message.hasOwnProperty("version"))
                                if (!$util.isString(message.version))
                                    return "version: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetCloudFormationVersionResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp} GetCloudFormationVersionResp
                         */
                        GetCloudFormationVersionResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp();
                            if (object.version != null)
                                message.version = String(object.version);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetCloudFormationVersionResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp} message GetCloudFormationVersionResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetCloudFormationVersionResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.version = "";
                            if (message.version != null && message.hasOwnProperty("version"))
                                object.version = message.version;
                            return object;
                        };

                        /**
                         * Converts this GetCloudFormationVersionResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.GetCloudFormationVersionResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetCloudFormationVersionResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetCloudFormationVersionResp;
                    })();

                    controlplane.CreateIAMRoleReq = (function() {

                        /**
                         * Properties of a CreateIAMRoleReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateIAMRoleReq
                         * @property {string|null} [serviceId] CreateIAMRoleReq serviceId
                         * @property {code.justin.tv.eventbus.controlplane.IIAMRole|null} [iamRole] CreateIAMRoleReq iamRole
                         */

                        /**
                         * Constructs a new CreateIAMRoleReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateIAMRoleReq.
                         * @implements ICreateIAMRoleReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq=} [properties] Properties to set
                         */
                        function CreateIAMRoleReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateIAMRoleReq serviceId.
                         * @member {string} serviceId
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @instance
                         */
                        CreateIAMRoleReq.prototype.serviceId = "";

                        /**
                         * CreateIAMRoleReq iamRole.
                         * @member {code.justin.tv.eventbus.controlplane.IIAMRole|null|undefined} iamRole
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @instance
                         */
                        CreateIAMRoleReq.prototype.iamRole = null;

                        /**
                         * Creates a new CreateIAMRoleReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleReq} CreateIAMRoleReq instance
                         */
                        CreateIAMRoleReq.create = function create(properties) {
                            return new CreateIAMRoleReq(properties);
                        };

                        /**
                         * Encodes the specified CreateIAMRoleReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq} message CreateIAMRoleReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateIAMRoleReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.serviceId != null && Object.hasOwnProperty.call(message, "serviceId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.serviceId);
                            if (message.iamRole != null && Object.hasOwnProperty.call(message, "iamRole"))
                                $root.code.justin.tv.eventbus.controlplane.IAMRole.encode(message.iamRole, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateIAMRoleReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleReq} message CreateIAMRoleReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateIAMRoleReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateIAMRoleReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleReq} CreateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateIAMRoleReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.serviceId = reader.string();
                                    break;
                                case 2:
                                    message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateIAMRoleReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleReq} CreateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateIAMRoleReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateIAMRoleReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateIAMRoleReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                if (!$util.isString(message.serviceId))
                                    return "serviceId: string expected";
                            if (message.iamRole != null && message.hasOwnProperty("iamRole")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.IAMRole.verify(message.iamRole);
                                if (error)
                                    return "iamRole." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a CreateIAMRoleReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleReq} CreateIAMRoleReq
                         */
                        CreateIAMRoleReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleReq();
                            if (object.serviceId != null)
                                message.serviceId = String(object.serviceId);
                            if (object.iamRole != null) {
                                if (typeof object.iamRole !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.CreateIAMRoleReq.iamRole: object expected");
                                message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.fromObject(object.iamRole);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateIAMRoleReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateIAMRoleReq} message CreateIAMRoleReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateIAMRoleReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.serviceId = "";
                                object.iamRole = null;
                            }
                            if (message.serviceId != null && message.hasOwnProperty("serviceId"))
                                object.serviceId = message.serviceId;
                            if (message.iamRole != null && message.hasOwnProperty("iamRole"))
                                object.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.toObject(message.iamRole, options);
                            return object;
                        };

                        /**
                         * Converts this CreateIAMRoleReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateIAMRoleReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateIAMRoleReq;
                    })();

                    controlplane.CreateIAMRoleResp = (function() {

                        /**
                         * Properties of a CreateIAMRoleResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateIAMRoleResp
                         * @property {code.justin.tv.eventbus.controlplane.IIAMRole|null} [iamRole] CreateIAMRoleResp iamRole
                         */

                        /**
                         * Constructs a new CreateIAMRoleResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateIAMRoleResp.
                         * @implements ICreateIAMRoleResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp=} [properties] Properties to set
                         */
                        function CreateIAMRoleResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateIAMRoleResp iamRole.
                         * @member {code.justin.tv.eventbus.controlplane.IIAMRole|null|undefined} iamRole
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @instance
                         */
                        CreateIAMRoleResp.prototype.iamRole = null;

                        /**
                         * Creates a new CreateIAMRoleResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleResp} CreateIAMRoleResp instance
                         */
                        CreateIAMRoleResp.create = function create(properties) {
                            return new CreateIAMRoleResp(properties);
                        };

                        /**
                         * Encodes the specified CreateIAMRoleResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp} message CreateIAMRoleResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateIAMRoleResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.iamRole != null && Object.hasOwnProperty.call(message, "iamRole"))
                                $root.code.justin.tv.eventbus.controlplane.IAMRole.encode(message.iamRole, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateIAMRoleResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateIAMRoleResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateIAMRoleResp} message CreateIAMRoleResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateIAMRoleResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateIAMRoleResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleResp} CreateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateIAMRoleResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 2:
                                    message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateIAMRoleResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleResp} CreateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateIAMRoleResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateIAMRoleResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateIAMRoleResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.iamRole != null && message.hasOwnProperty("iamRole")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.IAMRole.verify(message.iamRole);
                                if (error)
                                    return "iamRole." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a CreateIAMRoleResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateIAMRoleResp} CreateIAMRoleResp
                         */
                        CreateIAMRoleResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateIAMRoleResp();
                            if (object.iamRole != null) {
                                if (typeof object.iamRole !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.CreateIAMRoleResp.iamRole: object expected");
                                message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.fromObject(object.iamRole);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateIAMRoleResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateIAMRoleResp} message CreateIAMRoleResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateIAMRoleResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.iamRole = null;
                            if (message.iamRole != null && message.hasOwnProperty("iamRole"))
                                object.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.toObject(message.iamRole, options);
                            return object;
                        };

                        /**
                         * Converts this CreateIAMRoleResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateIAMRoleResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateIAMRoleResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateIAMRoleResp;
                    })();

                    controlplane.UpdateIAMRoleLabelReq = (function() {

                        /**
                         * Properties of an UpdateIAMRoleLabelReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IUpdateIAMRoleLabelReq
                         * @property {string|null} [arn] UpdateIAMRoleLabelReq arn
                         * @property {string|null} [label] UpdateIAMRoleLabelReq label
                         */

                        /**
                         * Constructs a new UpdateIAMRoleLabelReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an UpdateIAMRoleLabelReq.
                         * @implements IUpdateIAMRoleLabelReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq=} [properties] Properties to set
                         */
                        function UpdateIAMRoleLabelReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * UpdateIAMRoleLabelReq arn.
                         * @member {string} arn
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @instance
                         */
                        UpdateIAMRoleLabelReq.prototype.arn = "";

                        /**
                         * UpdateIAMRoleLabelReq label.
                         * @member {string} label
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @instance
                         */
                        UpdateIAMRoleLabelReq.prototype.label = "";

                        /**
                         * Creates a new UpdateIAMRoleLabelReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq} UpdateIAMRoleLabelReq instance
                         */
                        UpdateIAMRoleLabelReq.create = function create(properties) {
                            return new UpdateIAMRoleLabelReq(properties);
                        };

                        /**
                         * Encodes the specified UpdateIAMRoleLabelReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq} message UpdateIAMRoleLabelReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateIAMRoleLabelReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.arn != null && Object.hasOwnProperty.call(message, "arn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.arn);
                            if (message.label != null && Object.hasOwnProperty.call(message, "label"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.label);
                            return writer;
                        };

                        /**
                         * Encodes the specified UpdateIAMRoleLabelReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelReq} message UpdateIAMRoleLabelReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateIAMRoleLabelReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an UpdateIAMRoleLabelReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq} UpdateIAMRoleLabelReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateIAMRoleLabelReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.arn = reader.string();
                                    break;
                                case 2:
                                    message.label = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an UpdateIAMRoleLabelReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq} UpdateIAMRoleLabelReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateIAMRoleLabelReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an UpdateIAMRoleLabelReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateIAMRoleLabelReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                if (!$util.isString(message.arn))
                                    return "arn: string expected";
                            if (message.label != null && message.hasOwnProperty("label"))
                                if (!$util.isString(message.label))
                                    return "label: string expected";
                            return null;
                        };

                        /**
                         * Creates an UpdateIAMRoleLabelReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq} UpdateIAMRoleLabelReq
                         */
                        UpdateIAMRoleLabelReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq();
                            if (object.arn != null)
                                message.arn = String(object.arn);
                            if (object.label != null)
                                message.label = String(object.label);
                            return message;
                        };

                        /**
                         * Creates a plain object from an UpdateIAMRoleLabelReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq} message UpdateIAMRoleLabelReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateIAMRoleLabelReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.arn = "";
                                object.label = "";
                            }
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                object.arn = message.arn;
                            if (message.label != null && message.hasOwnProperty("label"))
                                object.label = message.label;
                            return object;
                        };

                        /**
                         * Converts this UpdateIAMRoleLabelReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateIAMRoleLabelReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return UpdateIAMRoleLabelReq;
                    })();

                    controlplane.UpdateIAMRoleLabelResp = (function() {

                        /**
                         * Properties of an UpdateIAMRoleLabelResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IUpdateIAMRoleLabelResp
                         * @property {string|null} [arn] UpdateIAMRoleLabelResp arn
                         * @property {string|null} [label] UpdateIAMRoleLabelResp label
                         */

                        /**
                         * Constructs a new UpdateIAMRoleLabelResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an UpdateIAMRoleLabelResp.
                         * @implements IUpdateIAMRoleLabelResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp=} [properties] Properties to set
                         */
                        function UpdateIAMRoleLabelResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * UpdateIAMRoleLabelResp arn.
                         * @member {string} arn
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @instance
                         */
                        UpdateIAMRoleLabelResp.prototype.arn = "";

                        /**
                         * UpdateIAMRoleLabelResp label.
                         * @member {string} label
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @instance
                         */
                        UpdateIAMRoleLabelResp.prototype.label = "";

                        /**
                         * Creates a new UpdateIAMRoleLabelResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp} UpdateIAMRoleLabelResp instance
                         */
                        UpdateIAMRoleLabelResp.create = function create(properties) {
                            return new UpdateIAMRoleLabelResp(properties);
                        };

                        /**
                         * Encodes the specified UpdateIAMRoleLabelResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp} message UpdateIAMRoleLabelResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateIAMRoleLabelResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.arn != null && Object.hasOwnProperty.call(message, "arn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.arn);
                            if (message.label != null && Object.hasOwnProperty.call(message, "label"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.label);
                            return writer;
                        };

                        /**
                         * Encodes the specified UpdateIAMRoleLabelResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IUpdateIAMRoleLabelResp} message UpdateIAMRoleLabelResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        UpdateIAMRoleLabelResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an UpdateIAMRoleLabelResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp} UpdateIAMRoleLabelResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateIAMRoleLabelResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.arn = reader.string();
                                    break;
                                case 2:
                                    message.label = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an UpdateIAMRoleLabelResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp} UpdateIAMRoleLabelResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        UpdateIAMRoleLabelResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an UpdateIAMRoleLabelResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        UpdateIAMRoleLabelResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                if (!$util.isString(message.arn))
                                    return "arn: string expected";
                            if (message.label != null && message.hasOwnProperty("label"))
                                if (!$util.isString(message.label))
                                    return "label: string expected";
                            return null;
                        };

                        /**
                         * Creates an UpdateIAMRoleLabelResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp} UpdateIAMRoleLabelResp
                         */
                        UpdateIAMRoleLabelResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp();
                            if (object.arn != null)
                                message.arn = String(object.arn);
                            if (object.label != null)
                                message.label = String(object.label);
                            return message;
                        };

                        /**
                         * Creates a plain object from an UpdateIAMRoleLabelResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp} message UpdateIAMRoleLabelResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        UpdateIAMRoleLabelResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.arn = "";
                                object.label = "";
                            }
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                object.arn = message.arn;
                            if (message.label != null && message.hasOwnProperty("label"))
                                object.label = message.label;
                            return object;
                        };

                        /**
                         * Converts this UpdateIAMRoleLabelResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.UpdateIAMRoleLabelResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        UpdateIAMRoleLabelResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return UpdateIAMRoleLabelResp;
                    })();

                    controlplane.ValidateIAMRoleReq = (function() {

                        /**
                         * Properties of a ValidateIAMRoleReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IValidateIAMRoleReq
                         * @property {string|null} [arn] ValidateIAMRoleReq arn
                         */

                        /**
                         * Constructs a new ValidateIAMRoleReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ValidateIAMRoleReq.
                         * @implements IValidateIAMRoleReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq=} [properties] Properties to set
                         */
                        function ValidateIAMRoleReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ValidateIAMRoleReq arn.
                         * @member {string} arn
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @instance
                         */
                        ValidateIAMRoleReq.prototype.arn = "";

                        /**
                         * Creates a new ValidateIAMRoleReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq} ValidateIAMRoleReq instance
                         */
                        ValidateIAMRoleReq.create = function create(properties) {
                            return new ValidateIAMRoleReq(properties);
                        };

                        /**
                         * Encodes the specified ValidateIAMRoleReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq} message ValidateIAMRoleReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidateIAMRoleReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.arn != null && Object.hasOwnProperty.call(message, "arn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.arn);
                            return writer;
                        };

                        /**
                         * Encodes the specified ValidateIAMRoleReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleReq} message ValidateIAMRoleReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidateIAMRoleReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ValidateIAMRoleReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq} ValidateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidateIAMRoleReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.arn = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ValidateIAMRoleReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq} ValidateIAMRoleReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidateIAMRoleReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ValidateIAMRoleReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ValidateIAMRoleReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                if (!$util.isString(message.arn))
                                    return "arn: string expected";
                            return null;
                        };

                        /**
                         * Creates a ValidateIAMRoleReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq} ValidateIAMRoleReq
                         */
                        ValidateIAMRoleReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq();
                            if (object.arn != null)
                                message.arn = String(object.arn);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ValidateIAMRoleReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq} message ValidateIAMRoleReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ValidateIAMRoleReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.arn = "";
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                object.arn = message.arn;
                            return object;
                        };

                        /**
                         * Converts this ValidateIAMRoleReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ValidateIAMRoleReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ValidateIAMRoleReq;
                    })();

                    controlplane.ValidateIAMRoleResp = (function() {

                        /**
                         * Properties of a ValidateIAMRoleResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IValidateIAMRoleResp
                         * @property {boolean|null} [isValid] ValidateIAMRoleResp isValid
                         * @property {string|null} [message] ValidateIAMRoleResp message
                         */

                        /**
                         * Constructs a new ValidateIAMRoleResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a ValidateIAMRoleResp.
                         * @implements IValidateIAMRoleResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp=} [properties] Properties to set
                         */
                        function ValidateIAMRoleResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ValidateIAMRoleResp isValid.
                         * @member {boolean} isValid
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @instance
                         */
                        ValidateIAMRoleResp.prototype.isValid = false;

                        /**
                         * ValidateIAMRoleResp message.
                         * @member {string} message
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @instance
                         */
                        ValidateIAMRoleResp.prototype.message = "";

                        /**
                         * Creates a new ValidateIAMRoleResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp} ValidateIAMRoleResp instance
                         */
                        ValidateIAMRoleResp.create = function create(properties) {
                            return new ValidateIAMRoleResp(properties);
                        };

                        /**
                         * Encodes the specified ValidateIAMRoleResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp} message ValidateIAMRoleResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidateIAMRoleResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.isValid != null && Object.hasOwnProperty.call(message, "isValid"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.isValid);
                            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.message);
                            return writer;
                        };

                        /**
                         * Encodes the specified ValidateIAMRoleResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IValidateIAMRoleResp} message ValidateIAMRoleResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ValidateIAMRoleResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ValidateIAMRoleResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp} ValidateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidateIAMRoleResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.isValid = reader.bool();
                                    break;
                                case 2:
                                    message.message = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ValidateIAMRoleResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp} ValidateIAMRoleResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ValidateIAMRoleResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ValidateIAMRoleResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ValidateIAMRoleResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.isValid != null && message.hasOwnProperty("isValid"))
                                if (typeof message.isValid !== "boolean")
                                    return "isValid: boolean expected";
                            if (message.message != null && message.hasOwnProperty("message"))
                                if (!$util.isString(message.message))
                                    return "message: string expected";
                            return null;
                        };

                        /**
                         * Creates a ValidateIAMRoleResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp} ValidateIAMRoleResp
                         */
                        ValidateIAMRoleResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp();
                            if (object.isValid != null)
                                message.isValid = Boolean(object.isValid);
                            if (object.message != null)
                                message.message = String(object.message);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ValidateIAMRoleResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp} message ValidateIAMRoleResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ValidateIAMRoleResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.isValid = false;
                                object.message = "";
                            }
                            if (message.isValid != null && message.hasOwnProperty("isValid"))
                                object.isValid = message.isValid;
                            if (message.message != null && message.hasOwnProperty("message"))
                                object.message = message.message;
                            return object;
                        };

                        /**
                         * Converts this ValidateIAMRoleResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.ValidateIAMRoleResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ValidateIAMRoleResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ValidateIAMRoleResp;
                    })();

                    controlplane.IAMRole = (function() {

                        /**
                         * Properties of a IAMRole.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IIAMRole
                         * @property {string|null} [arn] IAMRole arn
                         * @property {string|null} [label] IAMRole label
                         * @property {string|null} [cloudformationStatus] IAMRole cloudformationStatus
                         * @property {string|null} [id] IAMRole id
                         */

                        /**
                         * Constructs a new IAMRole.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a IAMRole.
                         * @implements IIAMRole
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IIAMRole=} [properties] Properties to set
                         */
                        function IAMRole(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * IAMRole arn.
                         * @member {string} arn
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @instance
                         */
                        IAMRole.prototype.arn = "";

                        /**
                         * IAMRole label.
                         * @member {string} label
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @instance
                         */
                        IAMRole.prototype.label = "";

                        /**
                         * IAMRole cloudformationStatus.
                         * @member {string} cloudformationStatus
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @instance
                         */
                        IAMRole.prototype.cloudformationStatus = "";

                        /**
                         * IAMRole id.
                         * @member {string} id
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @instance
                         */
                        IAMRole.prototype.id = "";

                        /**
                         * Creates a new IAMRole instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIAMRole=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.IAMRole} IAMRole instance
                         */
                        IAMRole.create = function create(properties) {
                            return new IAMRole(properties);
                        };

                        /**
                         * Encodes the specified IAMRole message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IAMRole.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIAMRole} message IAMRole message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IAMRole.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.arn != null && Object.hasOwnProperty.call(message, "arn"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.arn);
                            if (message.label != null && Object.hasOwnProperty.call(message, "label"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.label);
                            if (message.cloudformationStatus != null && Object.hasOwnProperty.call(message, "cloudformationStatus"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.cloudformationStatus);
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.id);
                            return writer;
                        };

                        /**
                         * Encodes the specified IAMRole message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.IAMRole.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IIAMRole} message IAMRole message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        IAMRole.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a IAMRole message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.IAMRole} IAMRole
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IAMRole.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.IAMRole();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.arn = reader.string();
                                    break;
                                case 2:
                                    message.label = reader.string();
                                    break;
                                case 3:
                                    message.cloudformationStatus = reader.string();
                                    break;
                                case 4:
                                    message.id = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a IAMRole message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.IAMRole} IAMRole
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        IAMRole.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a IAMRole message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        IAMRole.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                if (!$util.isString(message.arn))
                                    return "arn: string expected";
                            if (message.label != null && message.hasOwnProperty("label"))
                                if (!$util.isString(message.label))
                                    return "label: string expected";
                            if (message.cloudformationStatus != null && message.hasOwnProperty("cloudformationStatus"))
                                if (!$util.isString(message.cloudformationStatus))
                                    return "cloudformationStatus: string expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            return null;
                        };

                        /**
                         * Creates a IAMRole message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.IAMRole} IAMRole
                         */
                        IAMRole.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.IAMRole)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.IAMRole();
                            if (object.arn != null)
                                message.arn = String(object.arn);
                            if (object.label != null)
                                message.label = String(object.label);
                            if (object.cloudformationStatus != null)
                                message.cloudformationStatus = String(object.cloudformationStatus);
                            if (object.id != null)
                                message.id = String(object.id);
                            return message;
                        };

                        /**
                         * Creates a plain object from a IAMRole message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAMRole} message IAMRole
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        IAMRole.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.arn = "";
                                object.label = "";
                                object.cloudformationStatus = "";
                                object.id = "";
                            }
                            if (message.arn != null && message.hasOwnProperty("arn"))
                                object.arn = message.arn;
                            if (message.label != null && message.hasOwnProperty("label"))
                                object.label = message.label;
                            if (message.cloudformationStatus != null && message.hasOwnProperty("cloudformationStatus"))
                                object.cloudformationStatus = message.cloudformationStatus;
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            return object;
                        };

                        /**
                         * Converts this IAMRole to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.IAMRole
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        IAMRole.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return IAMRole;
                    })();

                    controlplane.AuthorizedFieldSubscriberGrant = (function() {

                        /**
                         * Properties of an AuthorizedFieldSubscriberGrant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IAuthorizedFieldSubscriberGrant
                         * @property {code.justin.tv.eventbus.controlplane.IIAMRole|null} [iamRole] AuthorizedFieldSubscriberGrant iamRole
                         * @property {string|null} [eventType] AuthorizedFieldSubscriberGrant eventType
                         * @property {string|null} [environment] AuthorizedFieldSubscriberGrant environment
                         * @property {code.justin.tv.eventbus.controlplane.IAuthorizedField|null} [authorizedField] AuthorizedFieldSubscriberGrant authorizedField
                         */

                        /**
                         * Constructs a new AuthorizedFieldSubscriberGrant.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents an AuthorizedFieldSubscriberGrant.
                         * @implements IAuthorizedFieldSubscriberGrant
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant=} [properties] Properties to set
                         */
                        function AuthorizedFieldSubscriberGrant(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * AuthorizedFieldSubscriberGrant iamRole.
                         * @member {code.justin.tv.eventbus.controlplane.IIAMRole|null|undefined} iamRole
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @instance
                         */
                        AuthorizedFieldSubscriberGrant.prototype.iamRole = null;

                        /**
                         * AuthorizedFieldSubscriberGrant eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @instance
                         */
                        AuthorizedFieldSubscriberGrant.prototype.eventType = "";

                        /**
                         * AuthorizedFieldSubscriberGrant environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @instance
                         */
                        AuthorizedFieldSubscriberGrant.prototype.environment = "";

                        /**
                         * AuthorizedFieldSubscriberGrant authorizedField.
                         * @member {code.justin.tv.eventbus.controlplane.IAuthorizedField|null|undefined} authorizedField
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @instance
                         */
                        AuthorizedFieldSubscriberGrant.prototype.authorizedField = null;

                        /**
                         * Creates a new AuthorizedFieldSubscriberGrant instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant} AuthorizedFieldSubscriberGrant instance
                         */
                        AuthorizedFieldSubscriberGrant.create = function create(properties) {
                            return new AuthorizedFieldSubscriberGrant(properties);
                        };

                        /**
                         * Encodes the specified AuthorizedFieldSubscriberGrant message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant} message AuthorizedFieldSubscriberGrant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuthorizedFieldSubscriberGrant.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.iamRole != null && Object.hasOwnProperty.call(message, "iamRole"))
                                $root.code.justin.tv.eventbus.controlplane.IAMRole.encode(message.iamRole, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.eventType);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.environment);
                            if (message.authorizedField != null && Object.hasOwnProperty.call(message, "authorizedField"))
                                $root.code.justin.tv.eventbus.controlplane.AuthorizedField.encode(message.authorizedField, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified AuthorizedFieldSubscriberGrant message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IAuthorizedFieldSubscriberGrant} message AuthorizedFieldSubscriberGrant message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AuthorizedFieldSubscriberGrant.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an AuthorizedFieldSubscriberGrant message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant} AuthorizedFieldSubscriberGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuthorizedFieldSubscriberGrant.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.decode(reader, reader.uint32());
                                    break;
                                case 2:
                                    message.eventType = reader.string();
                                    break;
                                case 3:
                                    message.environment = reader.string();
                                    break;
                                case 4:
                                    message.authorizedField = $root.code.justin.tv.eventbus.controlplane.AuthorizedField.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an AuthorizedFieldSubscriberGrant message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant} AuthorizedFieldSubscriberGrant
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AuthorizedFieldSubscriberGrant.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an AuthorizedFieldSubscriberGrant message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AuthorizedFieldSubscriberGrant.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.iamRole != null && message.hasOwnProperty("iamRole")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.IAMRole.verify(message.iamRole);
                                if (error)
                                    return "iamRole." + error;
                            }
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            if (message.authorizedField != null && message.hasOwnProperty("authorizedField")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.AuthorizedField.verify(message.authorizedField);
                                if (error)
                                    return "authorizedField." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates an AuthorizedFieldSubscriberGrant message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant} AuthorizedFieldSubscriberGrant
                         */
                        AuthorizedFieldSubscriberGrant.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant();
                            if (object.iamRole != null) {
                                if (typeof object.iamRole !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.iamRole: object expected");
                                message.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.fromObject(object.iamRole);
                            }
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            if (object.authorizedField != null) {
                                if (typeof object.authorizedField !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant.authorizedField: object expected");
                                message.authorizedField = $root.code.justin.tv.eventbus.controlplane.AuthorizedField.fromObject(object.authorizedField);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an AuthorizedFieldSubscriberGrant message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant} message AuthorizedFieldSubscriberGrant
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AuthorizedFieldSubscriberGrant.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.iamRole = null;
                                object.eventType = "";
                                object.environment = "";
                                object.authorizedField = null;
                            }
                            if (message.iamRole != null && message.hasOwnProperty("iamRole"))
                                object.iamRole = $root.code.justin.tv.eventbus.controlplane.IAMRole.toObject(message.iamRole, options);
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            if (message.authorizedField != null && message.hasOwnProperty("authorizedField"))
                                object.authorizedField = $root.code.justin.tv.eventbus.controlplane.AuthorizedField.toObject(message.authorizedField, options);
                            return object;
                        };

                        /**
                         * Converts this AuthorizedFieldSubscriberGrant to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.AuthorizedFieldSubscriberGrant
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AuthorizedFieldSubscriberGrant.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return AuthorizedFieldSubscriberGrant;
                    })();

                    controlplane.Subscriptions = (function() {

                        /**
                         * Constructs a new Subscriptions service.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a Subscriptions
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function Subscriptions(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (Subscriptions.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Subscriptions;

                        /**
                         * Creates new Subscriptions service using the specified rpc implementation.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {Subscriptions} RPC service. Useful where requests and/or responses are streamed.
                         */
                        Subscriptions.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Subscriptions#create}.
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @typedef CreateCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.CreateSubscriptionResp} [response] CreateSubscriptionResp
                         */

                        /**
                         * Calls Create.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq} request CreateSubscriptionReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Subscriptions.CreateCallback} callback Node-style callback called with the error, if any, and CreateSubscriptionResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Subscriptions.prototype.create = function create(request, callback) {
                            return this.rpcCall(create, $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionReq, $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionResp, request, callback);
                        }, "name", { value: "Create" });

                        /**
                         * Calls Create.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq} request CreateSubscriptionReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.CreateSubscriptionResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Subscriptions#delete_}.
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @typedef DeleteCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp} [response] DeleteSubscriptionResp
                         */

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq} request DeleteSubscriptionReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Subscriptions.DeleteCallback} callback Node-style callback called with the error, if any, and DeleteSubscriptionResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Subscriptions.prototype["delete"] = function delete_(request, callback) {
                            return this.rpcCall(delete_, $root.code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq, $root.code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp, request, callback);
                        }, "name", { value: "Delete" });

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq} request DeleteSubscriptionReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.DeleteSubscriptionResp>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link code.justin.tv.eventbus.controlplane.Subscriptions#getSubscriptionsForTarget}.
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @typedef GetSubscriptionsForTargetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp} [response] GetSubscriptionsForTargetResp
                         */

                        /**
                         * Calls GetSubscriptionsForTarget.
                         * @function getSubscriptionsForTarget
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq} request GetSubscriptionsForTargetReq message or plain object
                         * @param {code.justin.tv.eventbus.controlplane.Subscriptions.GetSubscriptionsForTargetCallback} callback Node-style callback called with the error, if any, and GetSubscriptionsForTargetResp
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(Subscriptions.prototype.getSubscriptionsForTarget = function getSubscriptionsForTarget(request, callback) {
                            return this.rpcCall(getSubscriptionsForTarget, $root.code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetReq, $root.code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp, request, callback);
                        }, "name", { value: "GetSubscriptionsForTarget" });

                        /**
                         * Calls GetSubscriptionsForTarget.
                         * @function getSubscriptionsForTarget
                         * @memberof code.justin.tv.eventbus.controlplane.Subscriptions
                         * @instance
                         * @param {code.justin.tv.eventbus.controlplane.IGetSubscriptionsForTargetReq} request GetSubscriptionsForTargetReq message or plain object
                         * @returns {Promise<code.justin.tv.eventbus.controlplane.GetSubscriptionsForTargetResp>} Promise
                         * @variation 2
                         */

                        return Subscriptions;
                    })();

                    controlplane.Subscription = (function() {

                        /**
                         * Properties of a Subscription.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ISubscription
                         * @property {string|null} [targetId] Subscription targetId
                         * @property {string|null} [eventType] Subscription eventType
                         * @property {string|null} [id] Subscription id
                         * @property {code.justin.tv.eventbus.controlplane.SubscriptionStatus|null} [status] Subscription status
                         * @property {string|null} [message] Subscription message
                         * @property {string|null} [environment] Subscription environment
                         */

                        /**
                         * Constructs a new Subscription.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a Subscription.
                         * @implements ISubscription
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ISubscription=} [properties] Properties to set
                         */
                        function Subscription(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Subscription targetId.
                         * @member {string} targetId
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @instance
                         */
                        Subscription.prototype.targetId = "";

                        /**
                         * Subscription eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @instance
                         */
                        Subscription.prototype.eventType = "";

                        /**
                         * Subscription id.
                         * @member {string} id
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @instance
                         */
                        Subscription.prototype.id = "";

                        /**
                         * Subscription status.
                         * @member {code.justin.tv.eventbus.controlplane.SubscriptionStatus} status
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @instance
                         */
                        Subscription.prototype.status = 0;

                        /**
                         * Subscription message.
                         * @member {string} message
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @instance
                         */
                        Subscription.prototype.message = "";

                        /**
                         * Subscription environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @instance
                         */
                        Subscription.prototype.environment = "";

                        /**
                         * Creates a new Subscription instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ISubscription=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.Subscription} Subscription instance
                         */
                        Subscription.create = function create(properties) {
                            return new Subscription(properties);
                        };

                        /**
                         * Encodes the specified Subscription message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Subscription.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ISubscription} message Subscription message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Subscription.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.targetId != null && Object.hasOwnProperty.call(message, "targetId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.targetId);
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.eventType);
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.id);
                            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.status);
                            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                                writer.uint32(/* id 5, wireType 2 =*/42).string(message.message);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 6, wireType 2 =*/50).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified Subscription message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.Subscription.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ISubscription} message Subscription message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Subscription.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a Subscription message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.Subscription} Subscription
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Subscription.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.Subscription();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.targetId = reader.string();
                                    break;
                                case 2:
                                    message.eventType = reader.string();
                                    break;
                                case 3:
                                    message.id = reader.string();
                                    break;
                                case 4:
                                    message.status = reader.int32();
                                    break;
                                case 5:
                                    message.message = reader.string();
                                    break;
                                case 6:
                                    message.environment = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a Subscription message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.Subscription} Subscription
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Subscription.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a Subscription message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Subscription.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.targetId != null && message.hasOwnProperty("targetId"))
                                if (!$util.isString(message.targetId))
                                    return "targetId: string expected";
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            if (message.id != null && message.hasOwnProperty("id"))
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            if (message.status != null && message.hasOwnProperty("status"))
                                switch (message.status) {
                                default:
                                    return "status: enum value expected";
                                case 0:
                                case 1:
                                case 2:
                                case 3:
                                case 4:
                                case 5:
                                case 6:
                                case 7:
                                case 8:
                                case 9:
                                    break;
                                }
                            if (message.message != null && message.hasOwnProperty("message"))
                                if (!$util.isString(message.message))
                                    return "message: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            return null;
                        };

                        /**
                         * Creates a Subscription message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.Subscription} Subscription
                         */
                        Subscription.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.Subscription)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.Subscription();
                            if (object.targetId != null)
                                message.targetId = String(object.targetId);
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            if (object.id != null)
                                message.id = String(object.id);
                            switch (object.status) {
                            case "SUBSCRIPTION_STATUS_UNKNOWN":
                            case 0:
                                message.status = 0;
                                break;
                            case "SUBSCRIPTION_STATUS_DISABLED":
                            case 1:
                                message.status = 1;
                                break;
                            case "SUBSCRIPTION_STATUS_ENABLED":
                            case 2:
                                message.status = 2;
                                break;
                            case "SUBSCRIPTION_STATUS_PENDING_DISABLE":
                            case 3:
                                message.status = 3;
                                break;
                            case "SUBSCRIPTION_STATUS_PENDING_ENABLE":
                            case 4:
                                message.status = 4;
                                break;
                            case "SUBSCRIPTION_STATUS_ERROR_DISABLE":
                            case 5:
                                message.status = 5;
                                break;
                            case "SUBSCRIPTION_STATUS_ERROR_ENABLE":
                            case 6:
                                message.status = 6;
                                break;
                            case "SUBSCRIPTION_STATUS_ERROR_CREATE":
                            case 7:
                                message.status = 7;
                                break;
                            case "SUBSCRIPTION_STATUS_PENDING_DELETE":
                            case 8:
                                message.status = 8;
                                break;
                            case "SUBSCRIPTION_STATUS_ERROR_DELETE":
                            case 9:
                                message.status = 9;
                                break;
                            }
                            if (object.message != null)
                                message.message = String(object.message);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            return message;
                        };

                        /**
                         * Creates a plain object from a Subscription message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.Subscription} message Subscription
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Subscription.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.targetId = "";
                                object.eventType = "";
                                object.id = "";
                                object.status = options.enums === String ? "SUBSCRIPTION_STATUS_UNKNOWN" : 0;
                                object.message = "";
                                object.environment = "";
                            }
                            if (message.targetId != null && message.hasOwnProperty("targetId"))
                                object.targetId = message.targetId;
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            if (message.id != null && message.hasOwnProperty("id"))
                                object.id = message.id;
                            if (message.status != null && message.hasOwnProperty("status"))
                                object.status = options.enums === String ? $root.code.justin.tv.eventbus.controlplane.SubscriptionStatus[message.status] : message.status;
                            if (message.message != null && message.hasOwnProperty("message"))
                                object.message = message.message;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            return object;
                        };

                        /**
                         * Converts this Subscription to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.Subscription
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Subscription.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return Subscription;
                    })();

                    controlplane.CreateSubscriptionReq = (function() {

                        /**
                         * Properties of a CreateSubscriptionReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateSubscriptionReq
                         * @property {string|null} [targetId] CreateSubscriptionReq targetId
                         * @property {string|null} [eventType] CreateSubscriptionReq eventType
                         * @property {string|null} [environment] CreateSubscriptionReq environment
                         */

                        /**
                         * Constructs a new CreateSubscriptionReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateSubscriptionReq.
                         * @implements ICreateSubscriptionReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq=} [properties] Properties to set
                         */
                        function CreateSubscriptionReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateSubscriptionReq targetId.
                         * @member {string} targetId
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @instance
                         */
                        CreateSubscriptionReq.prototype.targetId = "";

                        /**
                         * CreateSubscriptionReq eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @instance
                         */
                        CreateSubscriptionReq.prototype.eventType = "";

                        /**
                         * CreateSubscriptionReq environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @instance
                         */
                        CreateSubscriptionReq.prototype.environment = "";

                        /**
                         * Creates a new CreateSubscriptionReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionReq} CreateSubscriptionReq instance
                         */
                        CreateSubscriptionReq.create = function create(properties) {
                            return new CreateSubscriptionReq(properties);
                        };

                        /**
                         * Encodes the specified CreateSubscriptionReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq} message CreateSubscriptionReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSubscriptionReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.targetId != null && Object.hasOwnProperty.call(message, "targetId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.targetId);
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.eventType);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateSubscriptionReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionReq} message CreateSubscriptionReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSubscriptionReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateSubscriptionReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionReq} CreateSubscriptionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSubscriptionReq.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionReq();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.targetId = reader.string();
                                    break;
                                case 2:
                                    message.eventType = reader.string();
                                    break;
                                case 3:
                                    message.environment = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateSubscriptionReq message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionReq} CreateSubscriptionReq
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSubscriptionReq.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateSubscriptionReq message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateSubscriptionReq.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.targetId != null && message.hasOwnProperty("targetId"))
                                if (!$util.isString(message.targetId))
                                    return "targetId: string expected";
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                if (!$util.isString(message.eventType))
                                    return "eventType: string expected";
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                if (!$util.isString(message.environment))
                                    return "environment: string expected";
                            return null;
                        };

                        /**
                         * Creates a CreateSubscriptionReq message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionReq} CreateSubscriptionReq
                         */
                        CreateSubscriptionReq.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionReq)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionReq();
                            if (object.targetId != null)
                                message.targetId = String(object.targetId);
                            if (object.eventType != null)
                                message.eventType = String(object.eventType);
                            if (object.environment != null)
                                message.environment = String(object.environment);
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateSubscriptionReq message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateSubscriptionReq} message CreateSubscriptionReq
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateSubscriptionReq.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.targetId = "";
                                object.eventType = "";
                                object.environment = "";
                            }
                            if (message.targetId != null && message.hasOwnProperty("targetId"))
                                object.targetId = message.targetId;
                            if (message.eventType != null && message.hasOwnProperty("eventType"))
                                object.eventType = message.eventType;
                            if (message.environment != null && message.hasOwnProperty("environment"))
                                object.environment = message.environment;
                            return object;
                        };

                        /**
                         * Converts this CreateSubscriptionReq to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionReq
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateSubscriptionReq.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateSubscriptionReq;
                    })();

                    controlplane.CreateSubscriptionResp = (function() {

                        /**
                         * Properties of a CreateSubscriptionResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface ICreateSubscriptionResp
                         * @property {code.justin.tv.eventbus.controlplane.ISubscription|null} [subscription] CreateSubscriptionResp subscription
                         */

                        /**
                         * Constructs a new CreateSubscriptionResp.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a CreateSubscriptionResp.
                         * @implements ICreateSubscriptionResp
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp=} [properties] Properties to set
                         */
                        function CreateSubscriptionResp(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * CreateSubscriptionResp subscription.
                         * @member {code.justin.tv.eventbus.controlplane.ISubscription|null|undefined} subscription
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @instance
                         */
                        CreateSubscriptionResp.prototype.subscription = null;

                        /**
                         * Creates a new CreateSubscriptionResp instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionResp} CreateSubscriptionResp instance
                         */
                        CreateSubscriptionResp.create = function create(properties) {
                            return new CreateSubscriptionResp(properties);
                        };

                        /**
                         * Encodes the specified CreateSubscriptionResp message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionResp.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp} message CreateSubscriptionResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSubscriptionResp.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                                $root.code.justin.tv.eventbus.controlplane.Subscription.encode(message.subscription, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified CreateSubscriptionResp message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.CreateSubscriptionResp.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.ICreateSubscriptionResp} message CreateSubscriptionResp message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        CreateSubscriptionResp.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a CreateSubscriptionResp message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionResp} CreateSubscriptionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSubscriptionResp.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionResp();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1:
                                    message.subscription = $root.code.justin.tv.eventbus.controlplane.Subscription.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a CreateSubscriptionResp message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionResp} CreateSubscriptionResp
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        CreateSubscriptionResp.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a CreateSubscriptionResp message.
                         * @function verify
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        CreateSubscriptionResp.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.subscription != null && message.hasOwnProperty("subscription")) {
                                var error = $root.code.justin.tv.eventbus.controlplane.Subscription.verify(message.subscription);
                                if (error)
                                    return "subscription." + error;
                            }
                            return null;
                        };

                        /**
                         * Creates a CreateSubscriptionResp message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {code.justin.tv.eventbus.controlplane.CreateSubscriptionResp} CreateSubscriptionResp
                         */
                        CreateSubscriptionResp.fromObject = function fromObject(object) {
                            if (object instanceof $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionResp)
                                return object;
                            var message = new $root.code.justin.tv.eventbus.controlplane.CreateSubscriptionResp();
                            if (object.subscription != null) {
                                if (typeof object.subscription !== "object")
                                    throw TypeError(".code.justin.tv.eventbus.controlplane.CreateSubscriptionResp.subscription: object expected");
                                message.subscription = $root.code.justin.tv.eventbus.controlplane.Subscription.fromObject(object.subscription);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from a CreateSubscriptionResp message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.CreateSubscriptionResp} message CreateSubscriptionResp
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        CreateSubscriptionResp.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.subscription = null;
                            if (message.subscription != null && message.hasOwnProperty("subscription"))
                                object.subscription = $root.code.justin.tv.eventbus.controlplane.Subscription.toObject(message.subscription, options);
                            return object;
                        };

                        /**
                         * Converts this CreateSubscriptionResp to JSON.
                         * @function toJSON
                         * @memberof code.justin.tv.eventbus.controlplane.CreateSubscriptionResp
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        CreateSubscriptionResp.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return CreateSubscriptionResp;
                    })();

                    controlplane.DeleteSubscriptionReq = (function() {

                        /**
                         * Properties of a DeleteSubscriptionReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @interface IDeleteSubscriptionReq
                         * @property {string|null} [targetId] DeleteSubscriptionReq targetId
                         * @property {string|null} [eventType] DeleteSubscriptionReq eventType
                         * @property {string|null} [environment] DeleteSubscriptionReq environment
                         */

                        /**
                         * Constructs a new DeleteSubscriptionReq.
                         * @memberof code.justin.tv.eventbus.controlplane
                         * @classdesc Represents a DeleteSubscriptionReq.
                         * @implements IDeleteSubscriptionReq
                         * @constructor
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq=} [properties] Properties to set
                         */
                        function DeleteSubscriptionReq(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DeleteSubscriptionReq targetId.
                         * @member {string} targetId
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq
                         * @instance
                         */
                        DeleteSubscriptionReq.prototype.targetId = "";

                        /**
                         * DeleteSubscriptionReq eventType.
                         * @member {string} eventType
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq
                         * @instance
                         */
                        DeleteSubscriptionReq.prototype.eventType = "";

                        /**
                         * DeleteSubscriptionReq environment.
                         * @member {string} environment
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq
                         * @instance
                         */
                        DeleteSubscriptionReq.prototype.environment = "";

                        /**
                         * Creates a new DeleteSubscriptionReq instance using the specified properties.
                         * @function create
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq=} [properties] Properties to set
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq} DeleteSubscriptionReq instance
                         */
                        DeleteSubscriptionReq.create = function create(properties) {
                            return new DeleteSubscriptionReq(properties);
                        };

                        /**
                         * Encodes the specified DeleteSubscriptionReq message. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq.verify|verify} messages.
                         * @function encode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq} message DeleteSubscriptionReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteSubscriptionReq.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.targetId != null && Object.hasOwnProperty.call(message, "targetId"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.targetId);
                            if (message.eventType != null && Object.hasOwnProperty.call(message, "eventType"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.eventType);
                            if (message.environment != null && Object.hasOwnProperty.call(message, "environment"))
                                writer.uint32(/* id 3, wireType 2 =*/26).string(message.environment);
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteSubscriptionReq message, length delimited. Does not implicitly {@link code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq
                         * @static
                         * @param {code.justin.tv.eventbus.controlplane.IDeleteSubscriptionReq} message DeleteSubscriptionReq message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteSubscriptionReq.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteSubscriptionReq message from the specified reader or buffer.
                         * @function decode
                         * @memberof code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {code.justin.tv.eventbus.controlplane.DeleteSubscriptionReq} DeleteSubscriptionReq
                         * @throws {Error} If the payload is not 