import { Root } from 'dashboard/core/components/root/';
import { featureFlagInit } from 'dashboard/core/utils/featureFlags';
import * as history from 'history';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { Router } from 'react-router';

const h = history.createBrowserHistory();

(async () => {
  await featureFlagInit();
  const rootElement = document.createElement('div');
  document.body.appendChild(rootElement);

  ReactDOM.render(
    <div className="tw-root--hover">
      <Router history={h}>
        <Root />
      </Router>
    </div>,
    rootElement,
  );
})();
