import { code } from 'dashboard/generated/controlplane';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { AuthFieldsSubscriptionTab } from './component';

import twirp = code.justin.tv.eventbus.controlplane;

/* tslint:disable:no-any */
jest.mock('react-dom', () => ({
  createPortal: (node: any) => node,
}));

let mockLoading = false;

jest.mock('dashboard/core/utils/event-stream', () => ({
  useAuthorizedFieldSubscriberGrants: () => {
    return {
      loading: mockLoading,
    };
  },
}));

const authorizedFields: twirp.IAuthorizedField[] = [
  {
    messageName: 'TopSecret',
    fieldName: 'DontLook',
  },
  {
    messageName: 'Shhhhhhh',
    fieldName: 'NeedToKnowBasis',
  },
];

it('renders (loading spinner)', () => {
  mockLoading = true;
  expect(
    Renderer.create(
      <React.Fragment>
        <AuthFieldsSubscriptionTab
          eventType="event-type"
          authorizedFields={authorizedFields}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('renders (loaded)', () => {
  mockLoading = false;
  expect(
    Renderer.create(
      <React.Fragment>
        <AuthFieldsSubscriptionTab
          eventType="event-type"
          authorizedFields={authorizedFields}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('renders (no authorized fields)', () => {
  mockLoading = false;
  expect(
    Renderer.create(
      <React.Fragment>
        <AuthFieldsSubscriptionTab
          eventType="event-type"
          authorizedFields={new Array<twirp.AuthorizedField>()}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});
/* tslint:enable:no-any */
