import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';

import { PublishPermissionsTab } from './component';

/* tslint:disable:no-any */
jest.mock('react-dom', () => ({
    createPortal: (node: any) => node,
}));

let mockLoading = false;

jest.mock('dashboard/core/utils/event-stream', () => ({
  useAuthorizedFieldPublisherGrants: () => {
    return {
      loading: mockLoading,
    };
  },
}));

it('renders (loading spinner)', () => {
  mockLoading = true;
  expect(
    Renderer.create(
      <React.Fragment>
        <PublishPermissionsTab eventType="event-type"/>
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('renders (loaded)', () => {
  mockLoading = false;
  expect(
    Renderer.create(
      <React.Fragment>
        <PublishPermissionsTab eventType="event-type"/>
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});
/* tslint:enable:no-any */
