import { code } from 'dashboard/generated/controlplane';
import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { Button, Input } from 'twitch-core-ui';
import { AddIAMRoleModal } from '.';

import twirp = code.justin.tv.eventbus.controlplane;

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

jest.mock('dashboard/core/utils/iam_role', () => ({
  // tslint:disable-next-line:no-any
  createIAMRole: (
    _role: twirp.IIAMRole,
    _onSuccess: (iamRole: twirp.IIAMRole) => void,
    _onError: (e: Error) => void,
  ) => {
    /**/
  },
}));

describe('save button', () => {
  const root = Renderer.create(
    <AddIAMRoleModal serviceID="123" onSuccess={_.noop} />,
  ).root;

  it('is disabled by default', () => {
    const saveButton = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Button && node.props.children === 'Register',
    );
    expect(saveButton.props.disabled).toBe(true);
  });

  it('is disabled when only label is given', () => {
    const labelInput = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Input && node.props.id === 'label',
    );
    Renderer.act(() => {
      labelInput.props.onChange({
        currentTarget: {
          value: 'my-service-prod',
        },
      });
    });
    const saveButton = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Button && node.props.children === 'Register',
    );
    expect(saveButton.props.disabled).toBe(true);
  });

  it('is disabled when an invalid IAM role is provided', () => {
    const arnInput = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Input && node.props.id === 'arn',
    );
    Renderer.act(() => {
      arnInput.props.onChange({
        currentTarget: {
          value: 'bad-iam-role',
        },
      });
    });
    const saveButton = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Button && node.props.children === 'Register',
    );
    expect(saveButton.props.disabled).toBe(true);
  });

  it('is enabled when a good arn is provided', () => {
    const arnInput = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Input && node.props.id === 'arn',
    );
    Renderer.act(() => {
      arnInput.props.onChange({
        currentTarget: {
          value: 'arn:aws:iam::123456789012:role/your-role-goes-here',
        },
      });
    });
    const saveButton = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Button && node.props.children === 'Register',
    );
    expect(saveButton.props.disabled).toBe(false);
  });
});

describe('CreateIAMRoleModal', () => {
  it('renders', () => {
    expect(
      Renderer.create(
        <React.Fragment>
          <AddIAMRoleModal serviceID="123" onSuccess={_.noop} />
        </React.Fragment>,
      ),
    ).toMatchSnapshot();
  });
});
