import { ResourceLoadStatus } from 'dashboard/definitions/resources';
import { code } from 'dashboard/generated/controlplane';
import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { AuditLogsTable } from './baseComponent';

import twirp = code.justin.tv.eventbus.controlplane;

it('renders (single audit log)', () => {
  const auditLog = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'ACCOUNT',
  });
  const auditLogs = [auditLog];

  expect(
    Renderer.create(
      <React.Fragment>
        <AuditLogsTable
          auditLogs={auditLogs}
          filters={[]}
          loading={ResourceLoadStatus.COMPLETED}
          openDetailsModal={_.noop}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('renders (multiple audit logs)', () => {
  const auditLog1 = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'error: error text',
    action: 'UPDATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'IAM ROLE',
  });
  const auditLog2 = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'ACCOUNT',
  });
  const auditLogs = [auditLog1, auditLog2];
  expect(
    Renderer.create(
      <React.Fragment>
        <AuditLogsTable
          auditLogs={auditLogs}
          filters={[]}
          loading={ResourceLoadStatus.COMPLETED}
          openDetailsModal={_.noop}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('filters', () => {
  const auditLog1 = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'error: error text',
    action: 'UPDATE',
    timestamp: { seconds: 0 },
    resourceName: 'r1',
    resourceType: 'IAM ROLE',
  });
  const auditLog2 = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'r2',
    resourceType: 'ACCOUNT',
  });
  const auditLogs = [auditLog1, auditLog2];
  expect(
    Renderer.create(
      <React.Fragment>
        <AuditLogsTable
          auditLogs={auditLogs}
          filters={[['resourceType', 'IAM Role']]}
          loading={ResourceLoadStatus.COMPLETED}
          openDetailsModal={_.noop}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('renders (no audit logs)', () => {
  const auditLogs: twirp.AuditLog[] = [];
  expect(
    Renderer.create(
      <React.Fragment>
        <AuditLogsTable
          auditLogs={auditLogs}
          filters={[]}
          loading={ResourceLoadStatus.COMPLETED}
          openDetailsModal={_.noop}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('renders errors', () => {
  const auditLog = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'ACCOUNT',
  });
  const auditLogs = [auditLog];
  expect(
    Renderer.create(
      <React.Fragment>
        <AuditLogsTable
          auditLogs={auditLogs}
          filters={[]}
          loading={ResourceLoadStatus.ERRORED}
          openDetailsModal={_.noop}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});

it('renders loading', () => {
  const auditLog = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'ACCOUNT',
  });
  const auditLogs = [auditLog];
  expect(
    Renderer.create(
      <React.Fragment>
        <AuditLogsTable
          auditLogs={auditLogs}
          filters={[]}
          loading={ResourceLoadStatus.LOADING}
          openDetailsModal={_.noop}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});
