import * as _ from 'lodash';
import * as React from 'react';
import * as ShallowRenderer from 'react-test-renderer/shallow';

import { code } from 'dashboard/generated/controlplane';
import twirp = code.justin.tv.eventbus.controlplane;

import { AuditLogDetailsModal } from './detailsModal';

it('renders (no before or after)', () => {
  const auditLog = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'ACCOUNT',
  });
  const renderer = ShallowRenderer.createRenderer();
  const tree = renderer.render((
    <AuditLogDetailsModal
      auditLog={auditLog}
      close={_.noop}
    />
  ));
  expect(tree).toMatchSnapshot();
});

it('renders (with after only)', () => {
  const auditLog = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'ACCOUNT',
    after: JSON.stringify({
      arn: 'arn:goes:here',
      label: 'label-goes-here',
    }),
  });
  const renderer = ShallowRenderer.createRenderer();
  const tree = renderer.render((
    <AuditLogDetailsModal
      auditLog={auditLog}
      close={_.noop}
    />
  ));
  expect(tree).toMatchSnapshot();
});

it('renders (with before and after)', () => {
  const auditLog = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'resourceName',
    resourceType: 'ACCOUNT',
    before: JSON.stringify({
      arn: 'arn:old:arn',
      // missing label
    }),
    after: JSON.stringify({
      arn: 'arn:goes:here',
      label: 'label-goes-here',
    }),
  });
  const renderer = ShallowRenderer.createRenderer();
  const tree = renderer.render((
    <AuditLogDetailsModal
      auditLog={auditLog}
      close={_.noop}
    />
  ));
  expect(tree).toMatchSnapshot();
});
