import * as _ from 'lodash';
import * as React from 'react';

import { DiffPatcher, formatters } from 'jsondiffpatch';
import 'jsondiffpatch/dist/formatters-styles/html.css';

import { code } from 'dashboard/generated/controlplane';
import twirp = code.justin.tv.eventbus.controlplane;

import { CustomModal } from 'dashboard/core/components/modal';
import { CoreText, Layout } from 'twitch-core-ui';
import { COLUMN_NAMES, displayFunctions } from './util';

interface Props {
  close: () => void;
  auditLog: twirp.AuditLog;
}

export class AuditLogDetailsModal extends React.PureComponent<Props> {
  public render() {
    const diffPatcher = new DiffPatcher();

    let innerHtml: string = '';
    const left = this.props.auditLog.before && JSON.parse(this.props.auditLog.before);
    const right = this.props.auditLog.after && JSON.parse(this.props.auditLog.after);

    if (!_.isEmpty(right)) {
      const delta = diffPatcher.diff(left, right);
      innerHtml = formatters.html.format(delta!, left);
    }

    const action = displayFunctions.action(this.props.auditLog);
    const resourceType = displayFunctions.resourceType(this.props.auditLog);
    const description = displayFunctions.description(this.props.auditLog);
    return (
      <CustomModal
        title={`Log Entry: ${resourceType} ${action}`}
        isOpen={true}
        onClose={this.props.close}
      >
        <Layout>
          <Layout padding={{ bottom: 1 }}>
            <p><strong>{COLUMN_NAMES.userName}:</strong> {displayFunctions.userName(this.props.auditLog)}</p>
          </Layout>
          <Layout padding={{ bottom: 1 }}>
            <p><strong>{COLUMN_NAMES.timestamp}:</strong> {displayFunctions.timestamp(this.props.auditLog)}</p>
          </Layout>
          <Layout padding={{ bottom: 1 }}>
            <p><strong>{COLUMN_NAMES.resourceName}:</strong> {displayFunctions.resourceName(this.props.auditLog)}</p>
          </Layout>
          <Layout padding={{ bottom: 1 }}>
            <p><strong>{COLUMN_NAMES.result}:</strong> {displayFunctions.result(this.props.auditLog)}</p>
          </Layout>
          {description &&
            <Layout padding={{ bottom: 1 }}>
              <p><strong>{COLUMN_NAMES.description}:</strong> {description}</p>
            </Layout>
          }
          {innerHtml &&
            <div>
              <CoreText bold={true}>Changes:</CoreText>
              <div dangerouslySetInnerHTML={{ __html: innerHtml }} />
            </div>
          }
        </Layout>
      </CustomModal>
    );
  }
}
