import { code } from 'dashboard/generated/controlplane';
import twirp = code.justin.tv.eventbus.controlplane;

import { filter, filterableFields, filterAuditLogs } from './util';

describe('filterAuditLogs', () => {
  const auditLog1 = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'Success',
    action: 'CREATE',
    timestamp: { seconds: 0 },
    resourceName: 'account1',
    resourceType: 'ACCOUNT',
  });
  const auditLog2 = new twirp.AuditLog({
    userName: 'natwilla',
    result: 'error: test error',
    action: 'UPDATE',
    timestamp: { seconds: 0 },
    resourceName: 'service1',
    resourceType: 'SERVICE',
  });
  const auditLog3 = new twirp.AuditLog({
    userName: 'potjorda',
    result: 'Success',
    action: 'DELETE',
    timestamp: { seconds: 0 },
    resourceName: 'target1',
    resourceType: 'SUBSCRIPTION TARGET',
  });
  const auditLogs = [auditLog1, auditLog2, auditLog3];

  it('returns all rows when given no filters', () => {
    const filters: filter[] = [];
    const filtered = filterAuditLogs(auditLogs, filters, filterableFields);
    expect(filtered).toEqual(auditLogs);
  });

  it('returns all rows when given no fields', () => {
    const filters: filter[] = [];
    const filtered = filterAuditLogs(auditLogs, filters, []);
    expect(filtered).toEqual(auditLogs);
  });

  it('filters to rows matching a filter on a column', () => {
    const filters: filter[] = [['userName', 'natwilla']];
    const filtered = filterAuditLogs(auditLogs, filters, filterableFields);
    expect(filtered).toEqual([auditLog1, auditLog2]);
  });

  it('filters to rows matching any filter on a column', () => {
    const filters: filter[] = [['userName', 'natwilla'], ['userName', 'potjorda']];
    const filtered = filterAuditLogs(auditLogs, filters, filterableFields);
    expect(filtered).toEqual(auditLogs);
  });

  it('filters to rows matching all filters', () => {
    const filters: filter[] = [['userName', 'natwilla'], ['result', 'Success']];
    const filtered = filterAuditLogs(auditLogs, filters, filterableFields);
    expect(filtered).toEqual([auditLog1]);
  });
});
