import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { ConfirmPublishDeleteModal } from '.';

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

describe('CreateIAMRoleModal', () => {
  it('renders', () => {
    expect(
      Renderer.create(
        <React.Fragment>
          <ConfirmPublishDeleteModal
            publisherGrant={{
              iamRole: {
                arn: 'arn',
              },
              environment: 'production',
              eventType: 'event type',
            }}
            onSuccess={_.noop}
          />
        </React.Fragment>,
      ),
    ).toMatchSnapshot();
  });
});
