import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { Button, ButtonType } from 'twitch-core-ui';
import { DeleteIAMRoleModal } from './component';

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

jest.mock('dashboard/core/utils/iam_role', () => ({
  deleteIAMRole: () => {
    return {};
  },
}));

describe('DeleteIAMRoleModal', () => {
  it('renders when allowed', () => {
    expect(
      Renderer.create(
      <React.Fragment>
        <DeleteIAMRoleModal arn="arn" isAllowed onSuccess={_.noop} />
      </React.Fragment>,
      ),
    ).toMatchSnapshot();
  });

  it('renders when not allowed', () => {
    expect(
      Renderer.create(
        <DeleteIAMRoleModal arn="arn" isAllowed={false} onSuccess={_.noop} />,
      ),
    ).toMatchSnapshot();
  });
});

describe('when allowed to delete IAM role', () => {
  const root = Renderer.create(
    <DeleteIAMRoleModal arn="arn" isAllowed onSuccess={_.noop} />,
  ).root;

  it('there is a delete button', () => {
    const deleteButton = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Button && node.props.children === 'Delete',
    );
    expect(deleteButton.props.type).toBe(ButtonType.Alert);
  });
});

describe('when not allowed to delete IAM role', () => {
  const root = Renderer.create(
    <DeleteIAMRoleModal arn="arn" isAllowed={false} onSuccess={_.noop} />,
  ).root;

  it('there is not a delete button', () => {
    try {
      root.find(
        (node: Renderer.ReactTestInstance) =>
          node.type === Button && node.props.children === 'Delete',
      );
    } catch {
      return;
    }
    fail(new Error('expected to not find delete button'));
  });
});
