import { code } from 'dashboard/generated/controlplane';
import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { Button, Input } from 'twitch-core-ui';
import { EditIAMRoleLabelModal } from '.';

import twirp = code.justin.tv.eventbus.controlplane;

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

jest.mock('dashboard/core/utils/iam_role', () => ({
  // tslint:disable-next-line:no-any
  updateIAMRoleLabel: (
    _role: twirp.IIAMRole,
    _onSuccess: (iamRole: twirp.IIAMRole) => void,
    _onError: (e: Error) => void,
  ) => {
    /**/
  },
}));

describe('EditIAMRoleLabelModal', () => {
  const iamRole = {
    arn: 'arn:aws:iam::123456789012:role/your-role-goes-here',
    label: 'old-label',
  };

  const root = Renderer.create(
    <EditIAMRoleLabelModal iamRole={iamRole} onSuccess={_.noop} />,
  ).root;

  const labelInput = root.find(
    (node: Renderer.ReactTestInstance) =>
      node.type === Input && node.props.id === 'label',
  );

  const saveButton = root.find(
    (node: Renderer.ReactTestInstance) =>
      node.type === Button && node.props.children === 'Update',
  );

  it('has a default label value equal to current label', () => {
    expect(labelInput.props.value).toBe(iamRole.label);
  });

  describe('save button', () => {
    it('is disabled by default', () => {
      expect(saveButton.props.disabled).toBe(true);
    });

    it('becomes enabled when the label changes', () => {
      Renderer.act(() =>
        labelInput.props.onChange({
          currentTarget: {
            value: 'new-label-value',
          },
        }),
      );
      expect(saveButton.props.disabled).toBe(false);
    });
  });

  it('has a disabled arn input field', () => {
    const arnInput = root.find(
      (node: Renderer.ReactTestInstance) =>
        node.type === Input && node.props.id === 'arn',
    );
    expect(arnInput.props.value).toBe(iamRole.arn);
    expect(arnInput.props.disabled).toBe(true);
  });

  it('renders', () => {
    expect(
      Renderer.create(
        <React.Fragment>
          <EditIAMRoleLabelModal
            iamRole={{ arn: 'ARN', label: 'LABEL' }}
            onSuccess={_.noop}
          />
        </React.Fragment>,
      ),
    ).toMatchSnapshot();
  });
});
