import { code } from 'dashboard/generated/controlplane';
import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { act, ReactTestInstance } from 'react-test-renderer';
import { Button, Input } from 'twitch-core-ui';
import { EditServiceModal } from './component';

import twirp = code.justin.tv.eventbus.controlplane;

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

jest.mock('dashboard/core/utils/ldap', () => ({
  useLDAPGroups: () => ({
    ldapGroups: ['group1', 'group2', 'group3'],
    loading: false,
    error: null,
  }),
}));

it('save button is disabled by default', () => {
  const service = new twirp.Service();

  let dom = Renderer.create(<></>);
  act(() => {
    dom = Renderer.create(
      <EditServiceModal onSaveSuccess={_.noop} service={service} />,
    );
  });
  const root = dom.root;

  const saveButton = root.find(
    (node: ReactTestInstance) =>
      node.type === Button && node.props.children === 'Update Service',
  );
  expect(saveButton.props.disabled).toBe(true);
});

it('save button is enabled when fields change', () => {
  const service = new twirp.Service({
    serviceCatalogUrl: 'original url',
    ldapGroup: 'infra',
  });

  let dom = Renderer.create(<></>);
  act(() => {
    dom = Renderer.create(
      <EditServiceModal onSaveSuccess={_.noop} service={service} />,
    );
  });
  const root = dom.root;

  const serviceCatalogUrlField = root.find(
    (node: ReactTestInstance) =>
      node.type === Input && node.props.name === 'serviceCatalogUrl',
  );

  act(() =>
    serviceCatalogUrlField.props.onChange({
      currentTarget: {
        value: 'new/value',
        name: 'serviceCatalogUrl',
      },
    }),
  );

  const saveButton = root.find(
    (node: ReactTestInstance) =>
      node.type === Button && node.props.children === 'Update Service',
  );
  expect(saveButton.props.disabled).toBe(false);
});

it('renders', () => {
  const iamRoles = _.map(_.times(2), () => ({
    arn: 'arn:aws:iam::123456789012:role/your-role-goes-here',
    label: 'test',
  }));
  const service = new twirp.Service({ iamRoles });
  expect(
    Renderer.create(
      <React.Fragment>
        <EditServiceModal onSaveSuccess={_.noop} service={service} />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});
