import { useCloudformationVersion } from 'dashboard/core/utils/cloudformation';
import * as React from 'react';
import {
  Layout,
  Pill,
  PillType,
  Tooltip,
} from 'twitch-core-ui';

interface Props {
  arn: string;
}
export const CloudFormationVersion = ({ arn }: Props) => {
  const { version, loading, error } = useCloudformationVersion(arn);
  return (
      <Layout>
        {!loading && error && (
          <Tooltip label={error.message}>
            <Pill type={PillType.Alert} label={`CFN: error`} />
          </Tooltip>
        )}
        {!loading && !error && version === 'unknown' && (
          <Tooltip label="CloudFormation not installed, or version below v1.3" enterDelay={0}>
            <Pill type={PillType.Warn} label={`CFN: unknown`} />
          </Tooltip>

        )}
        {!loading && !error && version !== 'unknown' && (
          <Pill type={PillType.Success} label={`CFN: ${version}`} />
        )}
    </Layout>
  );
};
