import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import * as ShallowRenderer from 'react-test-renderer/shallow';
import { Pill, PillType } from 'twitch-core-ui';
import { IAMRoleValidation } from './validation';

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

jest.mock('dashboard/core/utils/iam_role', () => ({
  // tslint:disable-next-line:no-any
  useIAMRoleValidation: (arn: string) => {
    if (arn === 'arn-is-valid') {
      return {
        isValid: true,
        message: '',
        loading: false,
        error: null,
      };
    } else {
      return {
        isValid: false,
        message: 'failed validation',
        loading: false,
        error: null,
      };
    }
  },
}));

describe('IAMRoleValidation', () => {
  it('is a green pill when valid', () => {
    const root = Renderer.create(<IAMRoleValidation arn="arn-is-valid" />).root;

    const icon = root.find(
      (node: Renderer.ReactTestInstance) => node.type === Pill,
    );
    expect(icon.props.type).toBe(PillType.Success);
    expect(icon.props.label).toBe('healthy');
  });

  it('has a warning icon when invalid', () => {
    const root = Renderer.create(<IAMRoleValidation arn="bad-arn" />).root;

    const icon = root.find(
      (node: Renderer.ReactTestInstance) => node.type === Pill,
    );
    expect(icon.props.type).toBe(PillType.Alert);
    expect(icon.props.label).toBe('unhealthy');
  });

  it('renders when valid', () => {
    const renderer = ShallowRenderer.createRenderer();
    const tree = renderer.render(<IAMRoleValidation arn="arn-is-valid" />);
    expect(tree).toMatchSnapshot();
  });

  it('renders when invalid', () => {
    const renderer = ShallowRenderer.createRenderer();
    const tree = renderer.render(<IAMRoleValidation arn="arn-is-not-valid" />);
    expect(tree).toMatchSnapshot();
  });
});
