import { useIAMRoleValidation } from 'dashboard/core/utils/iam_role';
import * as React from 'react';
import {
  Layout,
  Pill,
  PillType,
  Tooltip,
} from 'twitch-core-ui';

// tslint:disable-next-line
interface IAMRoleValidationProps {
  arn: string;
}
export const IAMRoleValidation = ({ arn }: IAMRoleValidationProps) => {
  const { isValid, message, loading, error } = useIAMRoleValidation(arn);
  const feedback = error ? error.message : message;

  if (loading) {
    return <></>;
  } else if (isValid) {
    return (
      <Layout>
        <Tooltip label="Validation successful">
          <Pill type={PillType.Success} label={`healthy`} />
        </Tooltip>
      </Layout>
    );
  }

  return (
    <Layout>
        <Tooltip label={feedback}>
          <Pill type={PillType.Alert} label={`unhealthy`} />
        </Tooltip>
    </Layout>
  );
};
