import { code } from 'dashboard/generated/controlplane';
import { AuditLogsTableWrapper } from 'dashboard/pages/service-overview/components/audit-logs-table';
import { IAMRoles } from 'dashboard/pages/service-overview/components/iam-roles';
import { SubscriptionTargets } from 'dashboard/pages/service-overview/components/targets-tab';
import * as _ from 'lodash';
import * as React from 'react';
import {
  Display,
  JustifyContent,
  Layout,
  StyledLayout,
  Tabs,
} from 'twitch-core-ui';

import twirp = code.justin.tv.eventbus.controlplane;

interface Props {
  service: twirp.IService;
  onReloadService: () => void;
}

export const ServiceOverviewTabs = ({ service, onReloadService }: Props) => {
  const [activeTabIndex, setActiveTabIndex] = React.useState(0);
  const handleTabSelect = (_e: React.MouseEvent<HTMLElement>, i: number) => {
    setActiveTabIndex(i);
  };

  const tabList = [
    {
      display: 'Subscription Targets',
      content: <SubscriptionTargets service={service} />,
    },
    {
      display: 'IAM Roles',
      content: <IAMRoles service={service} onReloadService={onReloadService} />,
    },
    {
      display: 'Audit Log',
      content: <AuditLogsTableWrapper service={service} />,
    },
  ];

  // TODO: this component should not be responsible for rendering the content within each tab (ASYNC-1268)
  return (
    <Layout>
      <Layout margin={{ bottom: 2 }}>
        <Tabs
          activeTabIndex={activeTabIndex}
          tabs={_.map(tabList, (tab) => {
            return {
              label: tab.display,
              onClick: handleTabSelect,
            };
          })}
        />
      </Layout>
      <StyledLayout
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
      >
        {tabList[activeTabIndex].content}
      </StyledLayout>
    </Layout>
  );
};
