import { code } from 'dashboard/generated/controlplane';
import * as _ from 'lodash';
import * as React from 'react';
import { BrowserRouter } from 'react-router-dom';
import * as Renderer from 'react-test-renderer';
import { TargetsTable } from './component';

import twirp = code.justin.tv.eventbus.controlplane;

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

it('renders (no targets)', () => {
  const service: twirp.Service = new twirp.Service();
  const targets: twirp.Target[] = [];
  expect(
    Renderer.create(
      <BrowserRouter>
        <React.Fragment>
          <TargetsTable
            service={service}
            targets={targets}
            onDeregister={_.noop}
          />
        </React.Fragment>
      </BrowserRouter>,
    ),
  ).toMatchSnapshot();
});

it('renders (targets)', () => {
  const service: twirp.Service = new twirp.Service();
  const targets: twirp.Target[] = [
    new twirp.Target({
      id: '1',
      sqs: {
        queueArn: '',
        queueUrl: '',
      },
    }),
    new twirp.Target({
      id: '2',
      sqs: {
        queueArn: '',
        queueUrl: 'http://queue',
        deadletterQueueUrl: 'http://DLQ',
      },
    }),
  ];
  expect(
    Renderer.create(
      <BrowserRouter>
        <React.Fragment>
          <TargetsTable
            service={service}
            targets={targets}
            onDeregister={_.noop}
          />
        </React.Fragment>
      </BrowserRouter>,
    ),
  ).toMatchSnapshot();
});
