import { CustomModal } from 'dashboard/core/components/modal';
import { ModalContext } from 'dashboard/core/contexts/modals';
import { useSubscriptionTargetValidation } from 'dashboard/core/utils/target';
import * as _ from 'lodash';
import * as React from 'react';
import { useContext } from 'react';
import {
  Color,
  CoreText,
  FontSize,
  Layout,
  LoadingSpinner,
  SVG,
  SVGAsset,
  SVGType,
  TextAlign,
  Tooltip,
} from 'twitch-core-ui';

// tslint:disable-next-line
interface SubscriptionTargetValidationProps {
  queueUrl: string;
}
export const SubscriptionTargetValidation = ({
  queueUrl,
}: SubscriptionTargetValidationProps) => {
  const { isValid, message, loading, error } = useSubscriptionTargetValidation(
    queueUrl,
  );

  const { showModal } = useContext(ModalContext);

  const feedback = error ? error.message : message;

  const handleShowValidationFailureModal = () => {
    showModal({
      component: SubscriptionTargetInvalidModal,
      props: {
        queueUrl,
        message: feedback,
      },
    });
  };

  if (loading) {
    return <LoadingSpinner />;
  } else if (isValid) {
    return (
      <Layout>
        <Tooltip label="Validation Successful">
          <SVG asset={SVGAsset.Check} type={SVGType.Success} />
        </Tooltip>
      </Layout>
    );
  }

  return (
    <Layout>
      <div
        className={'subscription-target-validation-badge'}
        onClick={handleShowValidationFailureModal}
      >
        <Tooltip label={`Invalid (click for details)`}>
          <SVG asset={SVGAsset.Warning} type={SVGType.Alert} />
        </Tooltip>
      </div>
    </Layout>
  );
};

// tslint:disable-next-line
interface SubscriptionTargetInvalidModalProps {
  queueUrl: string;
  message: string;
}
export const SubscriptionTargetInvalidModal = ({
  queueUrl,
  message,
}: SubscriptionTargetInvalidModalProps) => {
  const { hideModal } = useContext(ModalContext);

  return (
    <CustomModal title={`IAM Role Invalid`} isOpen={true} onClose={hideModal}>
      <Layout className="modal-text-warning" textAlign={TextAlign.Center}>
        <Layout padding={{ y: 1 }}>
          <CoreText fontSize={FontSize.Size5}>{queueUrl}</CoreText>
        </Layout>
        <Layout padding={{ y: 1 }}>
          <CoreText color={Color.Alt2}>{_.capitalize(message)}</CoreText>
        </Layout>
      </Layout>
    </CustomModal>
  );
};
