import { code } from 'dashboard/generated/controlplane';

import twirp = code.justin.tv.eventbus.controlplane;

// Either crafts a human-friendly status message based on the SQSStatus
// enum value, or returns the error message stashed in the Message field
// of the SQSDetails if one exists
export const sqsStatusMessage = (sqsDetails: twirp.ISQSDetails): string => {
    // For whatever reason, I couldn't get this to work comparing directly
    // to the enum values, so I resorted to this method where status are
    // coerced into strings first and it seems to work fine. -nherson

    const formattedSqsStatuses: { [key: string]: string } = {
        CREATED: 'Created',
        DELETED: 'Deleted',
        PENDING_CREATE: 'Pending creation',
        PENDING_DELETE: 'Pending deletion',
        ERROR: sqsDetails.statusMessage || 'Error',
    };
    return formattedSqsStatuses[`${sqsDetails.sqsStatus}`] || 'Unknown';
};
