import * as _ from 'lodash';
import * as React from 'react';
import * as Renderer from 'react-test-renderer';
import { act, ReactTestInstance } from 'react-test-renderer';
import { Button, Input } from 'twitch-core-ui';
import { CreateServiceModal } from './component';

jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

it('save button is disabled by default', () => {
  const root = Renderer.create(
    <CreateServiceModal
      ldapGroups={['group1', 'group2', 'group3']}
      existingServiceCatalogIDs={[]}
      onCreateSuccess={_.noop}
    />,
  ).root;
  const saveButton = root.find(
    (node: ReactTestInstance) =>
      node.type === Button && node.props.children === 'Register Service',
  );
  expect(saveButton.props.disabled).toBe(true);
});

describe('save button', () => {
  const root = Renderer.create(
    <CreateServiceModal
      ldapGroups={['group1', 'group2', 'group3']}
      existingServiceCatalogIDs={[]}
      onCreateSuccess={_.noop}
    />,
  ).root;
  const ldapGroupField = root.find(
    (node: ReactTestInstance) => node.props.name === 'ldapGroup',
  );
  act(() =>
    ldapGroupField.props.onChange({
      currentTarget: {
        value: 'infra',
        name: 'ldapGroup',
      },
    }),
  );

  const serviceCatalogUrlField = root.find(
    (node: ReactTestInstance) =>
      node.type === Input && node.props.name === 'serviceCatalogUrl',
  );
  act(() =>
    serviceCatalogUrlField.props.onChange({
      currentTarget: {
        value: 'https://catalog.xarth.tv/services/1/details',
        name: 'serviceCatalogUrl',
      },
    }),
  );

  it('is enabled when service fields are filled', () => {
    const saveButton = root.find(
      (node: ReactTestInstance) =>
        node.type === Button && node.props.children === 'Register Service',
    );
    expect(saveButton.props.disabled).toBe(false);
  });
});

it('renders', () => {
  expect(
    Renderer.create(
      <React.Fragment>
        <CreateServiceModal
          ldapGroups={['group1', 'group2', 'group3']}
          existingServiceCatalogIDs={[]}
          onCreateSuccess={_.noop}
        />
      </React.Fragment>,
    ),
  ).toMatchSnapshot();
});
