import * as React from 'react';
import { Select } from 'twitch-core-ui';

interface LDAPGroupSelectProps {
    ldapGroups: string[];
    defaultValue?: string;
    onChange: (event: React.FormEvent) => void;
}

interface LDAPGroupSelectState {}

export class LDAPGroupSelect extends React.Component<LDAPGroupSelectProps, LDAPGroupSelectState> {
    public state: LDAPGroupSelectState = {};

    constructor(props: LDAPGroupSelectProps) {
        super(props);
    }

    public render() {
        return (
            <Select name="ldapGroup" onChange={this.props.onChange} defaultValue={this.props.defaultValue}>
                {this.options()}
            </Select>
        );
    }

    public options() {
        const groupOpts = new Array();
        if (!this.props.defaultValue) {
            groupOpts.push(<option key="" value=""/>);
        }
        for (const g of this.props.ldapGroups) {
            groupOpts.push(<option key={g} value={g}>{g}</option>);
        }
        return groupOpts;
    }
}
