import { code } from 'dashboard/generated/controlplane';
import * as _ from 'lodash';
import * as React from 'react';
import {
  AlignItems,
  Background,
  Color,
  CoreLink,
  CoreText,
  Display,
  JustifyContent,
  Layout,
  StyledLayout,
  Table,
  TableBody,
  TableCell,
  TableHeader,
  TableHeading,
  TableRow,
  TextAlign,
  TextType,
  VerticalAlign,
} from 'twitch-core-ui';

import twirp = code.justin.tv.eventbus.controlplane;

interface Props {
  services: twirp.Service[];
}

export class ServicesTable extends React.Component<Props> {
  public render() {
    if (_.isEmpty(this.props.services)) {
      return (
        <StyledLayout
          padding={1}
          display={Display.Flex}
          justifyContent={JustifyContent.Center}
        >
          <Layout padding={1} alignItems={AlignItems.Center}>
            <CoreText type={TextType.H4} color={Color.Alt2}>
              No services added yet.
            </CoreText>
          </Layout>
        </StyledLayout>
      );
    }

    /* tslint:disable:jsx-no-lambda */
    const servicesByName = _.sortBy(this.props.services, (service) =>
      _.lowerCase(service.name),
    );
    const rows: JSX.Element[] = _.map(servicesByName, (service) => {
      const serviceName = service.name ? (
        service.name
      ) : (
        <span title="Service name missing or service catalog unreachable">
          (Name Missing)
        </span>
      );
      return (
        <TableRow key={service.id}>
          <TableCell
            verticalAlign={VerticalAlign.Middle}
            textAlign={TextAlign.Center}
            className="service-table-cell"
          >
            <CoreLink linkTo={'/services/' + service.id}>
              {serviceName}
            </CoreLink>
          </TableCell>
          <TableCell
            verticalAlign={VerticalAlign.Middle}
            textAlign={TextAlign.Center}
            className="service-table-cell"
          >
            {service.ldapGroup}
          </TableCell>
        </TableRow>
      );
    });
    /* tslint:enable:jsx-no-lambda */
    const table = (
      <Table className="service-table">
        <TableHeader>
          <TableHeading label="Name" textAlign={TextAlign.Center} />
          <TableHeading label="LDAP Group" textAlign={TextAlign.Center} />
        </TableHeader>
        <TableBody>{rows}</TableBody>
      </Table>
    );
    return (
      <Layout>
        <StyledLayout background={Background.Base} fullWidth>
          {table}
        </StyledLayout>
      </Layout>
    );
  }
}
