import { code } from 'dashboard/generated/controlplane';
import * as React from 'react';
import { BrowserRouter } from 'react-router-dom';
import * as Renderer from 'react-test-renderer';
import { ServicesTable } from './component';

import twirp = code.justin.tv.eventbus.controlplane;

it('renders (no services)', () => {
  const services: twirp.Service[] = [];
  expect(
    Renderer.create(
      <BrowserRouter>
        <React.Fragment>
          <ServicesTable services={services} />
        </React.Fragment>
      </BrowserRouter>,
    ),
  ).toMatchSnapshot();
});

it('renders (multiple services)', () => {
  const services: twirp.Service[] = [
    new twirp.Service({ id: '2' }),
    new twirp.Service({ id: '1', name: 'ABC' }),
  ];
  expect(
    Renderer.create(
      <BrowserRouter>
        <React.Fragment>
          <ServicesTable services={services} />
        </React.Fragment>
      </BrowserRouter>,
    ),
  ).toMatchSnapshot();
});

it('orders services alphabetically', () => {
  const services: twirp.Service[] = [
    new twirp.Service({
      id: '1',
      name: 'late in the alphabet',
    }),
    new twirp.Service({
      id: '2',
      name: 'early in the alphabet',
    }),
  ];
  expect(
    Renderer.create(
      <BrowserRouter>
        <React.Fragment>
          <ServicesTable services={services} />
        </React.Fragment>
      </BrowserRouter>,
    ),
  ).toMatchSnapshot();
});
