import { EventDetails } from 'dashboard/core/components/event-details';
import { CustomModal } from 'dashboard/core/components/modal';
import { ModalContext } from 'dashboard/core/contexts/modals';
import { code } from 'dashboard/generated/controlplane';
import * as React from 'react';
import { useContext } from 'react';
import { Layout } from 'twitch-core-ui';
import controlplane = code.justin.tv.eventbus.controlplane;

interface EventDetailsModalProps {
  eventStream: controlplane.EventStream;
}

export const EventDetailsModal = ({ eventStream }: EventDetailsModalProps) => {
  const { hideModal } = useContext(ModalContext);
  return (
    <CustomModal title={'Event Details'} isOpen={true} onClose={hideModal}>
      <Layout className="event-details-modal">
        <EventDetails event={eventStream} />
      </Layout>
    </CustomModal>
  );
};
