import * as _ from 'lodash';
import * as React from 'react';
import { CheckBox, Display, JustifyContent, Layout } from 'twitch-core-ui';

import * as environments from 'dashboard/definitions/environments';

interface EnvironmentFilterProps {
  eventFilters: string[];
  toggleFilters: (env: string) => void;
}

export class EnvironmentFilters extends React.Component<EnvironmentFilterProps> {
  public render() {
    const environmentFilters = _.map(environments.ALL_ENVIRONMENTS, (env) => {
      const checked = _.includes(this.props.eventFilters, env);
      /* tslint:disable:jsx-no-lambda */
      return (
        <Layout key={env} margin={{ x: 1 }}>
          <CheckBox label={env} checked={checked} onChange={() => this.props.toggleFilters(env)}/>
        </Layout>
      );
      /* tslint:enable:jsx-no-lambda */
    });
    return (
      <Layout
        display={Display.Flex}
        justifyContent={JustifyContent.End}
        fullWidth={false}
        margin={{ top: 1 }}
      >
        {environmentFilters}
      </Layout>
    );
  }
}
