import twirp = code.justin.tv.eventbus.controlplane;
import { CustomModal } from 'dashboard/core/components/modal';
import { ModalContext } from 'dashboard/core/contexts/modals';
import { deleteSubscription } from 'dashboard/core/utils/subscriptions';
import { code } from 'dashboard/generated/controlplane';
import * as React from 'react';
import { useContext, useState } from 'react';
import {
  Button,
  ButtonState,
  ButtonType,
  Color,
  CoreText,
  Display,
  FlexDirection,
  JustifyContent,
  Layout,
  TextAlign,
} from 'twitch-core-ui';

interface Props {
  targetId: string;
  eventType: string;
  environment: string;
  onDeleteSuccess: (subscription: twirp.ISubscription) => void;
}
export const RemoveSubscriptionModal = ({
  targetId,
  eventType,
  environment,
  onDeleteSuccess,
}: Props) => {
  const { hideModal } = useContext(ModalContext);

  const [loading, setLoading] = useState(false);
  const [errorText, setErrorText] = useState<string | null>(null);

  const handleDeleteSubscription = () => {
    const subscription = {
      targetId,
      eventType,
      environment,
    };
    setLoading(true);
    deleteSubscription(
      subscription,
      () => {
        onDeleteSuccess(subscription);
        setLoading(false);
        hideModal();
      },
      (e: Error) => setErrorText(e.message),
    );
  };

  return (
    <CustomModal
      title="Unsubscribe Confirmation"
      isOpen={true}
      onClose={hideModal}
    >
      <Layout
        display={Display.Flex}
        flexDirection={FlexDirection.Row}
        justifyContent={JustifyContent.Center}
      >
        <Layout
          display={Display.Flex}
          padding={1}
          flexDirection={FlexDirection.Column}
        >
          <Layout>
            <CoreText bold>Event:</CoreText>
          </Layout>
          <Layout>
            <CoreText bold>Environment:</CoreText>
          </Layout>
        </Layout>

        <Layout
          display={Display.Flex}
          padding={1}
          flexDirection={FlexDirection.Column}
        >
          <Layout>
            <CoreText>{eventType}</CoreText>
          </Layout>
          <Layout>
            <CoreText>{environment}</CoreText>
          </Layout>
        </Layout>
      </Layout>
      <Layout
        padding={1}
        className="modal-text-warning"
        textAlign={TextAlign.Center}
      >
        <CoreText>
          Are you sure you want to unsubscribe from this event stream? The
          subscription target will no longer receive these events.
        </CoreText>
      </Layout>
      <Layout>
        {errorText && <CoreText color={Color.Error}>{errorText}</CoreText>}
      </Layout>
      <Layout
        padding={1}
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
      >
        <Button onClick={handleDeleteSubscription} type={ButtonType.Alert} state={loading ? ButtonState.Loading : ButtonState.Default}>
          Unsubscribe
        </Button>
      </Layout>
    </CustomModal>
  );
};
