
jest.mock('react-dom', () => ({
  // tslint:disable-next-line:no-any
  createPortal: (node: any) => node,
}));

jest.mock('react-router-dom', () => ({
  useParams: () => ({
    serviceId: '123',
    targetId: '123',
  }),
}));

// // Override CoreLink here because it is being an unreasonable PITA for testing
// jest.mock("twitch-core-ui/types/components/core-link", () => ({
//   CoreLink: ({ linkTo }: { linkTo: string }) => {
//     const React = require("react");
//     return <div>{linkTo}</div>;
//   },
// }));

jest.mock('dashboard/core/utils/event-stream', () => ({
  useProductionEventStreams: () => ({
    loading: false,
    error: null,
    eventStreams: [
      {
        eventType: 'CoolEvent',
        environment: 'production',
      },
      {
        eventType: 'FooBar',
        environment: 'production',
      },
      {
        eventType: 'UnusedEvent',
        environment: 'production',
      },
    ],
  }),
}));

jest.mock('dashboard/core/utils/subscriptions', () => ({
  useSubscriptions: (_: string) => ({
    loading: false,
    error: null,
    forbidden: false,
    subscriptions: [
      {
        eventType: 'CoolEvent',
        environment: 'staging',
      },
      {
        eventType: 'CoolEvent',
        environment: 'development',
      },
      {
        eventType: 'FooBar',
        environment: 'production',
      },
    ],
  }),
}));

jest.mock('dashboard/core/utils/target', () => ({
  useTarget: (_: string, __: string) => ({
    loading: false,
    error: null,
    target: {
      id: '123',
      serviceId: '234',
      name: 'MyCoolTarget',
      sqs: {
        queueUrl: 'URL',
      },
    },
  }),
}));

jest.mock('dashboard/core/utils/service', () => ({
  useService: (_: string) => ({
    loading: false,
    error: null,
    forbidden: false,
    notFound: false,
    service: {
      id: '123',
      name: 'MyCoolTarget',
    },
  }),
}));

jest.mock('react-router-dom', () => ({
  useParams: () => ({
    serviceId: '123',
    targetId: '123',
  }),
}));

// TODO: fix this https://jira.twitch.com/browse/ASYNC-1599
describe('SubscriptionsPage', () => {
  it("won't work for whatever reason so it's disabled", () => {
    expect(true).toBe(true);
  });
});
// describe("SubscriptionsPage", () => {
//   it("renders", () => {
//     expect(
//       Renderer.create(
//         <React.Fragment>
//           <SubscriptionsPage />
//         </React.Fragment>
//       )
//     ).toMatchSnapshot();
//   });
// });
