import { code } from 'dashboard/generated/controlplane';
import { getSubscriptionIfExists } from './subscriptionStatus';

import twirp = code.justin.tv.eventbus.controlplane;

it('test getSubscriptionIfExists existing subscription', () => {
    const sub1: twirp.ISubscription = {
        environment: 'production',
        eventType: 'FakeEventUpdate',
        id: '1',
    };

    const sub2: twirp.ISubscription = {
        environment: 'staging',
        eventType: 'FakeEventUpdate',
        id: '2',
    };

    const subs: twirp.ISubscription[] = new Array(sub1, sub2);
    expect(getSubscriptionIfExists(subs, 'FakeEventUpdate', 'staging')).toBe(sub2);
    expect(getSubscriptionIfExists(subs, 'FakeEventUpdate', 'production')).toBe(sub1);
});

it('test getSubscriptionIfExists no subscription', () => {
    const sub1: twirp.ISubscription = {
        environment: 'production',
        eventType: 'FakeEventUpdate',
        id: '1',
    };

    const sub2: twirp.ISubscription = {
        environment: 'staging',
        eventType: 'FakeEventUpdate',
        id: '2',
    };

    const subs: twirp.ISubscription[] = new Array(sub1, sub2);
    expect(getSubscriptionIfExists(subs, 'FakeEventUpdate', 'development')).toBe(null);
    expect(getSubscriptionIfExists(subs, 'FakeEventUpdate2', 'production')).toBe(null);
});
