import * as React from 'react';
import { MemoryRouter, RouteComponentProps } from 'react-router-dom';

/**
 * *** Pulled from Twilight project, except not wrapping in Twilight instance ***
 *
 * Wraps a component inside of a <Router> element to preserve routing
 * and other router based components like <Link>.
 *
 * @param element The component to wrap
 */
export function withRouter(element: JSX.Element) {
  return (
    <MemoryRouter>
      {element}
    </MemoryRouter>
  );
}

export function mockRouteProps<Props extends object>(props: Props): RouteComponentProps<Props> {
  return {
    match: {
      params: props,
      isExact: true,
      path: '/',
      url: '/',
    },
    staticContext: {},
    location: {
      pathname: '',
      search: '',
      hash: '',
      state: {},
      key: '',
    },
    history: {
      length: 50,
      action: 'POP',
      location: {
        pathname: '',
        search: '',
        hash: '',
        state: {},
        key: '',
      },
      createHref: jest.fn(),
      push: jest.fn(),
      replace: jest.fn(),
      go: jest.fn(),
      goBack: jest.fn(),
      goForward: jest.fn(),
      block: jest.fn(),
      listen: jest.fn(),
    },
  };
}
