
declare module 'simplebar' {
  class SimpleBar {
    public static removeObserver(): void;

    constructor(element: HTMLElement, options?: SimpleBar.Options);

    public recalculate(): void;
    public getScrollElement(): Element;
    public getContentElement(): Element;
  }

  namespace SimpleBar {
    interface Options {
      wrapContent?: boolean;
      autoHide?: boolean;
      scrollbarMinSize?: number;
      classNames?: ClassNamesOptions;
    }

    interface ClassNamesOptions {
      content?: string;
      scrollContent?: string;
      scrollbar?: string;
      track?: string;
    }
  }

  export = SimpleBar;
}
