---
title: Authorized Fields
weight: 7
---

Authorized fields allow publishers to include personally identifiable information (PII) in event schemas. Data in an authorized field is individually encrypted before being published and manually decrypted upon receipt. Management of which subscribers may access any given authorized field is managed by the EventBus team.

Subscribers only have the ability to decrypt and read the contents of an authorized field if they have been granted prior access. Without granted access, subscribers still receive encrypted authorized fields, but are unable to decrypt and read them. 

Publishers, when granted permission to publish to an event stream, will automatically have the ability to encrypt (not decrypt) every authorized field for that event, including any authorized fields added to the schema in the future.

### Getting Started

* **Schema:** [here]({{< ref "schema/authorized_fields.md" >}})
* **Publishers:** [here]({{< ref "publishers/authorized_fields.md" >}})
* **Subscribers:** [here]({{< ref "subscribers/authorized_fields.md" >}})

### Further Reading

Authorized fields are powered by AWS Key Management Service (KMS). Specifically, management of publisher and subscriber access to make cryptographic calls is accomplished through KMS grants. Encryption and decryption operations leverage KMS and envelope encryption concepts, and are implemented by the Object Level Encryption (OLE) library, written and maintained by SecDev.

* AWS Key Management Service: https://docs.aws.amazon.com/kms/latest/developerguide/overview.html
* KMS grant concepts: https://docs.aws.amazon.com/kms/latest/developerguide/grants.html
* Envelope encryption concepts: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#enveloping
* OLE library: https://git.xarth.tv/amzn/TwitchOLE