---
title: CloudFormation Versions
---

We recommend running a recent version of the Event Bus CloudFormation template at all times. If you wish to pin to a specific version in your application's Terraform or CloudFormation, use this page to determine the URL to use.

## Latest

Always contains the latest version of the CloudFormation template.

URL: https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation.yaml

## Version 1.4.0

* Allows SQS queues to have either `*eventbus*` or `*EventBus*` in the name.

URL: https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation_v1.4.0.yaml

## Version 1.3.0

* Embeds the version of the CloudFormation into the `EventBus` IAM role as a tag.
* Adds permission for `iam:ListRoleTags` to both the cross-account `EventBus` role and the `EventBusAccess` policy.
* The above two changes allow the EventBus client and the EventBus dashboard to determine the currently installed CloudFormation version.

URL: https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation_v1.3.0.yaml

## Version 1.2.0

* Removes unused permissions from the IAM Role utilized by the Event Bus.

URL: https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation_v1.2.0.yaml

## Version 1.1.0

* Adds support for authorized fields encryption and decryption operations using KMS.
* Adds CloudFormation outputs necessary for subscribers to provide their own queue.

URL: https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation_v1.1.0.yaml

## Version 1.0.1

* Corrects the ARN paths for S3 buckets.

URL: https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation_v1.0.1.yaml

## Version 1.0.0

* Creates the `EventBusRole` IAM Role for the Event Bus to assume to wire up subscriptions via SNS and SQS.
* Creates the `EventBusAccessPolicy` IAM Policy for applications to attach to their role. This policy allows assuming roles to publish/subscribe to/from the Event Bus.

URL: https://eventbus-setup.s3-us-west-2.amazonaws.com/cloudformation_v1.0.0.yaml
