---
title: Glossary
weight: 3
---

Authorized Field
: Fields in event schemas which are individually encrypted and require an explicit permission grant in order for subscribers to decrypt. Authorized fields are used to securely transmit personally identifiable information (PII) over the EventBus.

Authorized Field Grant
: A single access permission given to an IAM role to read (i.e. decrypt) an authorized field in a given environment.

Environment
: Production, staging, or development. A single service exists in some or all of these environments.

Event
: The atom of the Event Bus. Every event represents a change that services care about.

Event Schema
: A description of the values in the event payload. Defined in protobuf files in the [Event Bus schema repository](https://git.xarth.tv/eventbus/schema).

Event Stream
: A stream of events that all share the same event type and environment.

Event Type
: The category an event belongs to (e.g. “UserNameUpdate”). An event type has a defined event schema.

Publication
: A record in the Event Bus providing a service permission to publish to an event stream.

Publisher
: A publisher is a service that sends events to an event stream. A publisher must be granted permission to publish to the event stream.

Service
: A service has an entry in the [Twitch Service Catalog](https://catalog.xarth.tv/services) and is associated with multiple publications and/or subscriptions.

Subscriber
: A subscriber is a service that receives events from an event stream. Subscribers can subscribe to any event stream they wish.

Subscription
: A record in the Event Bus providing a service access to receive events from an event stream.

Subscription Target
: A subscription target defines where events should be sent for a subscription. Today the only subscription target we support is SQS.

