---
title: IAM Roles
weight: 5
---

The EventBus uses IAM roles to grant access to publish events (publishers) and read authorized fields (subscribers). IAM roles can be registered freely to the EventBus via a service's entry page on the EventBus dashboard. 

# Which IAM role(s) should I add?

In most cases, you should add the base IAM role that is used by the service's runtime. In Fulton land, this typically looks like `arn:aws:iam::000000000000:role/<ServiceName-PDX-<Stage>-ServiceRole-<RandomCharacters>`. If your service performs custom assume-role logic within the codebase, use whichever role is assumed and associated with the EventBus client initialization.

A role should be added for each stage. In the case of Fulton, it is ok for users to submit their SAM stack roles if necessary.

# How do I add an IAM role?

Roles can be added from your service's overview page on the EventBus dashboard:

![Migrate to IAM Roles](../images/iam_role_migration.gif)

{{% notice note %}}
IAM role ARNs cannot be changed once registered, but the label can be updated using the pencil icon.
{{% /notice %}}

# How can I remove a role?

Before removing an IAM role, all provisioned permissions must be revoked. For publish permissions, this can be done on a self-service basis. For authorized field subscriber permissions, these must be removed by an admin; contact someone in #event-bus for help with this.

To remove an IAM role, find it in the `IAM Roles` tab for your service, and click `More > Delete`. 

# IAM role validation

Next to each IAM role in the dashboard is either a green checkmark or a red warning symbol. This indicates whether or not an IAM role passes a series of checks that ensure permissions are set up properly for the role.

### My role is showing up as invalid, what gives?

This can happen if:

   * The role was deleted in AWS and no longer exists
   * The role was deleted in AWS, and then recreated with the exact same name
   * An internal server error occurred when registering the role with EventBus

In any of these cases, reach out to the EventBus team for help correcting this issue. More details can be shown by clicking the red warning icon.

# I noticed a role named `EventBus/EventBus` in my account, what's that?

This role is installed by the CloudFormation/CDK during onboarding. It is used to assume role into your service account to subscribe your queues to event streams, check permissions, validate resources, etc. This role should _not_ be added by you to the EventBus dashboard.
