---
title: Overview
weight: 1
---

## Mission

The EventBus drastically simplifies the workflow required for internal developers to publish and subscribe to events quickly, reliably, and securely. This ultimately enables Twitch to more efficiently create the real-time services necessary to meet the demands of internal and external customers.


## Tenets

* **Availability Before Features** - As a foundational building block for real-time services, availability is the most important metric to optimize for. No features or changes will be accepted that put availability in jeopardy.
* **Simple Behavior, Simple Expectations** - To power the diverse categories of real-time features, the EventBus will expose basic building blocks that teams can then build complex logic on top of.
* **Safety First** - All event payloads will abide by security best practices. Publishers and subscribers will be required to adhere to these standards to integrate with the EventBus.
* **Transparency at Every Level** - Metrics and logs will be made available to internal developers. Engineers can rely on this data to diagnose issues with their real-time services.

## Features

### Powered by Protobuf

Protobuf is used to define all event schemas within the EventBus. In addition, all schemas are publically tracked and versioned in version source control. This enables:
* Developers need not think about how to encode or decode events
* Tooling guarding schema changes detect bad practices and breaking changes
* Subscribers need not worry about publisher breaking changes impacting their subscribing application

### Client Included

The EventBus has a client ready to plug into Go applications. For publishers, it will handle the heavy lifting regarding how to route published events. For subscribers, a mux-like design allows simple registration of callback functions for each event being subscribed to.

### No Middleman Service

The EventBus runs no custom service between publication of an event and it's reception by subscribers. The event data path is entirely powered by AWS services such as SNS and SQS. This reduces the risk of downtime and mitigates the worry of scaling capabilities. The EventBus's scale is AWS's scale.