---
title: Publishers
weight: 4
---

This section assumes you have followed the steps in [Getting Started]({{< ref "getting_started/_index.md" >}}). Additionally, if you wish to publish a new event type, follow the guide to [Contribute a Schema]({{< ref "schema/contributing.md" >}}).

## Receive Permission to Publish {#receive-permission-to-publish}

### Self Service

A service must be authorized before it's allowed to publish to an event stream. This is required to protect the quality of the events on the Event Bus.

Each event type is owned by an LDAP group, specified in the event's schema (see [Event Type Ownership]({{<ref "schema/event_type_ownership.md" >}}) for more info). If your service belongs to the same LDAP group, you may provision publishing permissions to your IAM roles directly as needed. _DO NOT_ grant production publish permissions to any non-production IAM role. The EventBus team recommends the following mapping from service environment to EventBus event publish environment:

* Production --> Production
* Beta/Staging --> Staging
* Dev/SAM/Sandbox/etc --> Development

### Asking an Event Type Owner

If you want your service to publish an event belonging to a different LDAP group, talk to the members of that group. Group membership can be viewed using the [Twitch internal dashboard tool](https://dashboard.xarth.tv/ldaptools/groups). That team can use the [event type management page]({{< ref "schema/event_type_ownership.md#event-type-management" >}}) to provision access on your behalf.

### Troubleshooting

If you have worked through the above steps and cannot get proper access, or have questions about publish permissions, please ask in #event-bus.

## Publish from your Application

Create a new Event Bus publisher object in your application. Be sure to specify the correct environment and the list of event types you will be publishing. In this example, we choose to only publish to the `ClockUpdate` event, which publishes the current time.

```go
import (
	"github.com/aws/aws-sdk-go/aws/session"

	"code.justin.tv/eventbus/client/publisher"
	"code.justin.tv/eventbus/schema/pkg/clock"
)

awsSession, err := session.NewSession()

p, err := publisher.New(publisher.Config{
	Session: awsSession,
	Environment: publisher.EnvProduction,
	EventTypes: []string{clock.UpdateEventType},
})
```

Sometime later, we'll want to publish a `ClockUpdate` event. That looks like:

```go
import (
	"time"

	"code.justin.tv/eventbus/schema/pkg/clock"
)

event := &clock.ClockUpdate{
	Time: &timestamp.Timestamp{Seconds: time.Now().Unix()},
}

err := p.Publish(ctx, event)
```

## Publishing During Local Development (optional)

When developing locally, you may want to have your application publish to development event streams. This requires a few bonus steps:

1. Determine the IAM Role you use for local development. For example, if you use Isengard credentials during local development, your IAM Role might be `arn:aws:iam::{account_id}:role/Admin`
1. Verify that you have [attached the EventBusAccess policy]({{< ref "/getting_started/_index.md#attach-event-bus-policy" >}}) to your development IAM role
1. Make sure your development IAM Role is registered for your service in the [Event Bus dashboard](https://eventbus.xarth.tv)
1. Confirm with the Event Bus team that your development IAM Role has [received permission to publish]({{< ref "/publishers/_index.md#receive-permission-to-publish" >}})

## Transfer Publisher Duties

There may come a time when some service (e.g. `Foobar`) wants to hand over publishing of some event to a new service (e.g. `Garply`). To do this, follow these steps:

1. If `Foobar` and `Garply` belong to different LDAP groups (as registered in EventBus dashboard), submit a schema PR changing the LDAP group of the event to the LDAP group of `Garply` ; merge on approval
2. Provision permissions for `Garply` IAM roles to publish the event
3. `Foobar` and `Garply` owners decide on and execute a plan for `Foobar` to stop publishing and `Garply` to start publishing; this choreography is up to the service owners to determine
4. `Foobar` owners revoke their publish permissions as they are no longer needed