---
title: Authorized Fields
weight: 1
---

{{% authorized-field-warning %}}

#### Prerequisites

Before attemping to publish an authorized field, be sure you have already merged the authorized field into your event's schema. See [here]({{< ref "publishers/_index.md" >}}) for instructions on doing so.

#### Example

The generated schema code and EventBus client provide helpers to make encrypting and embedding authorized fields into events as straightforward as possible. Following the example shown above, adding PII user data to the `HatCreate` event requires a few extra lines of code:

_Before_
```
import "code.justin.tv/eventbus/schema/pkg/hat"

event := &hat.Create{
    Color: "red",
    Size: 3,
    Creator: &hat.User{
        Id: userID,
    },
}

err := publisherClient.Publish(ctx, event)
```

_After_
```
import "code.justin.tv/eventbus/schema/pkg/hat"

event := &hat.Create{
    Color: "red",
    Size: 3,
    Creator: &hat.User{
        Id: userID,
    },
}

err := event.GetCreator().SetEncryptedName(publisherClient, userNamePlaintext)
// errcheck...

err = event.GetCreator().SetEncryptedEmail(publisherClient, userEmailPlaintext)
// errcheck...

err = publisherClient.Publish(ctx, event)
```