---
title: Deprecating an Event Type
weight: 2
---

The Event Bus provides a mechanism for deprecating event types for publishers.

# Marking an Event Type as Deprecated

Marking an event type as deprecated is easy! Simply add a deprecated option in the event schema as shown below.

```protobuf
message ClockUpdate {
  option deprecated = true;

  google.protobuf.Timestamp time = 1;
}
```

This will mark the event as deprecated in the [event catalog](https://eventbus.xarth.tv/events). Attempting to subscribe to deprecated events will result in a warning and confirmation. Subscribing to deprecated events is still permitted in case it is needed during an emergency.

# Stopping Publishing

Publishers are able to view the subscribers to their event by expanding the event in the [event catalog](https://eventbus.xarth.tv/events) and checking the Subscribers section. Please reach out to the teams owning those integrations before cutting off publishing to the deprecated event.

# Deprecated Event Type Removal

The Event Bus team will be responsible for removing the deprecated event type internally and  monitoring the event's metrics and make sure of its removal once it has not published and delivered an event for 2 weeks. Feel free to ping the #event-bus channel if there are any questions or concerns related to event deprecation or removal.
