---
title: Authorized Fields
weight: 4
---

Authorized fields allow publishers to include personally identifiable information (PII) in event schemas. To learn more about authorized fields, see [the overview documentation]({{< ref "authorized_fields/_index.md" >}})

An authorized field looks like any other protobuf field, except it uses a special type. Suppose there exists an event called `HatCreate` and we wanted to add information about the creator, beyond just their user id. This is PII and requires use of authorized fields:

```
import "eventbus/authorization.proto";

message HatCreate {
    // the color of the hat
    string color = 1;
    // the size of the hat
    int64 size = 2;
    // our new nested data structure
    User creator = 3;
}

message User {
    // the user's ID, which is not an authorized field
    string id = 1;
    // the user's name, which is an authorized field
    eventbus.authorization.String name = 2 [(eventbus.authorization.data_classification) = "customer"];
    // the user's email address, which is an authorized field
    eventbus.authorization.String email = 3 [(eventbus.authorization.data_classification) = "customer"];
}
```

Using the special type `eventbus.authorization.String` automatically indicates that a field requires authorization. In the generated code, helper methods are provided to easily encrypt plaintext input and embed it into the field on your behalf (see [here]({{< ref "publishers/authorized_fields.md" >}}) for examples).

Use of `eventbus.authorization.String` requires that the field is annotated with the `eventbus.authorization.data_classification` field option; failure to do so will result in a schema linting error. This field option exists to aid subscribers seeking authorization in understanding the expectations of handling the field according to [Twitch data classification standards](https://wiki.twitch.com/display/SEC/Twitch+Data+Classification+and+Handling+Policy).

Authorized fields are _required_ for all EventBus data that is classified as **restricted** or **customer**. Data classified as **public** or **internal** need not be stored in an authorized field. However, a publisher may use an authorized field for **public** or **internal** data if they wish to limit which subscribers have access to read the field for any reason.