---
title: Contributing
weight: 1
---

## Step 1: Talk to an Event Bus Driver

Start by jumping into the [#event-bus](https://twitch.slack.com/app_redirect?channel=CB742918S) Slack channel and talking about the event you plan to add! The Event Bus Team keeps track of all the events being developed and can let you know of any overlap. Additionally, they have built expertise on future proofing Protobuf schemas and will often point out interesting areas of nuance for you to consider.

## Step 2: Review Some Examples

We strongly recommend reviewing a few existing events to get a sense for good schema design. Some of our favorites include: [ChannelUpdate](https://git.xarth.tv/eventbus/schema/blob/master/events/channel/update.proto), [UserFollowUserCreate](https://git.xarth.tv/eventbus/schema/blob/master/events/user_follow_user/create.proto), [UserMultiFactorAuthUpdate](https://git.xarth.tv/eventbus/schema/blob/master/events/user_multi_factor_auth/update.proto), and [CheerCreate](https://git.xarth.tv/eventbus/schema/blob/master/events/cheer/create.proto).

## Step 3: Implement Your Schema

Clone the [schema repository](https://git.xarth.tv/eventbus/schema) and add your new event schema in the `events` directory. Follow the [Style Guidelines]({{< ref "schema/style.md" >}}) in your implementation.

During development, you'll want to frequently leverage the following commands:

1. `make fmt`
1. `make lint`
1. `make test`
1. `make build`

The above commands only require Docker to be installed. These exact commands are run by Jenkins when a pull request is opened, so be sure they work on your local machine first before opening the pull request.

{{% notice note %}}
Do you need to add a field containing personally identifiable information (PII)? Use an [authorized field]({{< ref "schema/authorized_fields.md" >}}).
{{% /notice %}}

## Step 4: Get the Review

Open a pull request in the [schema repository](https://git.xarth.tv/eventbus/schema) and await a review. Anyone on the Event Bus Team can approve your schema, but for an immediate review ping `@eventbus-team` in the [#event-bus](https://twitch.slack.com/app_redirect?channel=CB742918S) Slack channel.
