---
title: Event Type Ownership
weight: 5
---

{{% notice note %}}
Event type ownership is a new EventBus concept, and features are being actively developed on top of it. Not-yet-implemented features will be marked accordingly as "future".
{{% /notice %}}

The EventBus includes support for indicating the LDAP group ownership of each event type schema. By annotating the schema with this information, the LDAP group assumes management of critical permissions for the event type, including granting services the ability to publish and access authorized fields.

## What Being an Event Type Owner Allows

* Self service abilities including granting owned services publish permission for the event type
* Grant publish permissions to _other_ EventBus IAM roles belonging to unowned services
* Grant access to authorized fields for the event type

## What Being an Event Type Owner DOES NOT Allow

* Determine which services may subscribe to the event type (currently, any service can subscribe to any event type)
* Make unilateral changes to the event type schema without EventBus team approval

## Defining an Event Type Owner in Protobuf

Add the following message level option (and the needed import) to the event type protobuf message:

```
syntax = "proto3";

package foobar;

option go_package = "foobar";

import "eventbus/owner.proto"; // includes the message level option for LDAP group owner

// FoobarUpdate fires when Foobar is updated
message FoobarUpdate {

  // Indicate that team-amazing-cool-people manages permissions for this event type
  option (eventbus.owner.ldap_group) = "team-amazing-cool-people";

  string id = 1;
  string garply = 2;
}
```

{{% notice note %}}
Event types not annotated with an LDAP group will default to being owned by `team-eventbus`.
{{% /notice %}}

## Managing an Owned Event Type {#event-type-management}

Owned event types will show up on the [Event Catalog](https://eventbus.xarth.tv/events) in the left column as part of `My Events`. A gear cog button will take you to the management page for that event. Here, you may grant permissions for onboarded IAM roles to publish the event or access its authorized fields. This is primarily used to grant access to other services owned by other LDAP groups.